/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.CodePosition;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CodeWriter.class);
    private static final int MAX_FILENAME_LENGTH = 128;
    public static final String NL = System.getProperty("line.separator");
    public static final String INDENT = "    ";
    private static final boolean ADD_LINE_NUMBERS = false;
    private static final String[] INDENT_CACHE = new String[]{"", "    ", "        ", "            ", "                ", "                    "};
    private final StringBuilder buf = new StringBuilder();
    private String indentStr = "";
    private int indent = 0;
    private int line = 1;
    private int offset = 0;
    private Map<CodePosition, Object> annotations = Collections.emptyMap();
    private Map<Integer, Integer> lineMap = Collections.emptyMap();

    public CodeWriter startLine() {
        this.addLine();
        this.addLineIndent();
        return this;
    }

    public CodeWriter startLine(char c) {
        this.addLine();
        this.addLineIndent();
        this.add(c);
        return this;
    }

    public CodeWriter startLine(String str) {
        this.addLine();
        this.addLineIndent();
        this.add(str);
        return this;
    }

    public CodeWriter startLineWithNum(int sourceLine) {
        if (sourceLine == 0) {
            this.startLine();
            return this;
        }
        this.startLine();
        this.attachSourceLine(sourceLine);
        return this;
    }

    public CodeWriter add(String str) {
        this.buf.append(str);
        this.offset += str.length();
        return this;
    }

    public CodeWriter add(char c) {
        this.buf.append(c);
        ++this.offset;
        return this;
    }

    CodeWriter add(CodeWriter code) {
        --this.line;
        for (Map.Entry<CodePosition, Object> entry : code.annotations.entrySet()) {
            CodePosition pos = entry.getKey();
            this.attachAnnotation(entry.getValue(), new CodePosition(this.line + pos.getLine(), pos.getOffset()));
        }
        for (Map.Entry<Object, Object> entry : code.lineMap.entrySet()) {
            this.attachSourceLine(this.line + (Integer)entry.getKey(), (Integer)entry.getValue());
        }
        this.line += code.line;
        this.offset = code.offset;
        this.buf.append(code);
        return this;
    }

    public CodeWriter newLine() {
        this.addLine();
        return this;
    }

    public CodeWriter addIndent() {
        this.add(INDENT);
        return this;
    }

    private void addLine() {
        this.buf.append(NL);
        ++this.line;
        this.offset = 0;
    }

    private CodeWriter addLineIndent() {
        this.buf.append(this.indentStr);
        this.offset += this.indentStr.length();
        return this;
    }

    private void updateIndent() {
        int curIndent = this.indent;
        if (curIndent < INDENT_CACHE.length) {
            this.indentStr = INDENT_CACHE[curIndent];
        } else {
            StringBuilder s = new StringBuilder(curIndent * INDENT.length());
            for (int i = 0; i < curIndent; ++i) {
                s.append(INDENT);
            }
            this.indentStr = s.toString();
        }
    }

    public void incIndent() {
        this.incIndent(1);
    }

    public void decIndent() {
        this.decIndent(1);
    }

    public void incIndent(int c) {
        this.indent += c;
        this.updateIndent();
    }

    public void decIndent(int c) {
        this.indent -= c;
        if (this.indent < 0) {
            LOG.warn("Indent < 0");
            this.indent = 0;
        }
        this.updateIndent();
    }

    public int getLine() {
        return this.line;
    }

    public Object attachDefinition(LineAttrNode obj) {
        return this.attachAnnotation(new DefinitionWrapper(obj), new CodePosition(this.line, this.offset));
    }

    public Object attachAnnotation(Object obj) {
        return this.attachAnnotation(obj, new CodePosition(this.line, this.offset + 1));
    }

    private Object attachAnnotation(Object obj, CodePosition pos) {
        if (this.annotations.isEmpty()) {
            this.annotations = new HashMap<CodePosition, Object>();
        }
        return this.annotations.put(pos, obj);
    }

    public Map<CodePosition, Object> getAnnotations() {
        return this.annotations;
    }

    public void attachSourceLine(int sourceLine) {
        if (sourceLine == 0) {
            return;
        }
        this.attachSourceLine(this.line, sourceLine);
    }

    private void attachSourceLine(int decompiledLine, int sourceLine) {
        if (this.lineMap.isEmpty()) {
            this.lineMap = new TreeMap<Integer, Integer>();
        }
        this.lineMap.put(decompiledLine, sourceLine);
    }

    public Map<Integer, Integer> getLineMapping() {
        return this.lineMap;
    }

    public void finish() {
        this.buf.trimToSize();
        Iterator<Map.Entry<CodePosition, Object>> it = this.annotations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<CodePosition, Object> entry = it.next();
            Object v = entry.getValue();
            if (!(v instanceof DefinitionWrapper)) continue;
            LineAttrNode l = ((DefinitionWrapper)v).getNode();
            l.setDecompiledLine(entry.getKey().getLine());
            it.remove();
        }
    }

    private static String removeFirstEmptyLine(String str) {
        if (str.startsWith(NL)) {
            return str.substring(NL.length());
        }
        return str;
    }

    public int length() {
        return this.buf.length();
    }

    public boolean isEmpty() {
        return this.buf.length() == 0;
    }

    public boolean notEmpty() {
        return this.buf.length() != 0;
    }

    public String toString() {
        return this.buf.toString();
    }

    public void save(File dir, String subDir, String fileName) {
        this.save(dir, new File(subDir, fileName).getPath());
    }

    public void save(File dir, String fileName) {
        this.save(new File(dir, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        String name = file.getName();
        if (name.length() > 128) {
            int dotIndex = name.indexOf(46);
            int cutAt = 128 - name.length() + dotIndex - 1;
            name = cutAt <= 0 ? name.substring(0, 127) : name.substring(0, cutAt) + name.substring(dotIndex);
            file = new File(file.getParentFile(), name);
        }
        PrintWriter out = null;
        try {
            FileUtils.makeDirsForFile(file);
            out = new PrintWriter(file, "UTF-8");
            String code = this.buf.toString();
            code = CodeWriter.removeFirstEmptyLine(code);
            out.println(code);
        }
        catch (Exception e) {
            LOG.error("Save file error", (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public int hashCode() {
        return this.buf.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CodeWriter)) {
            return false;
        }
        CodeWriter that = (CodeWriter)o;
        return this.buf.toString().equals(that.buf.toString());
    }

    private static class DefinitionWrapper {
        private final LineAttrNode node;

        private DefinitionWrapper(LineAttrNode node) {
            this.node = node;
        }

        public LineAttrNode getNode() {
            return this.node;
        }
    }
}

