/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnumClassAttr
implements IAttribute {
    private final List<EnumField> fields;
    private MethodNode staticMethod;

    public EnumClassAttr(int fieldsCount) {
        this.fields = new ArrayList<EnumField>(fieldsCount);
    }

    public List<EnumField> getFields() {
        return this.fields;
    }

    public MethodNode getStaticMethod() {
        return this.staticMethod;
    }

    public void setStaticMethod(MethodNode staticMethod) {
        this.staticMethod = staticMethod;
    }

    public AType<EnumClassAttr> getType() {
        return AType.ENUM_CLASS;
    }

    public String toString() {
        return "Enum fields: " + this.fields;
    }

    public static class EnumField {
        private final String name;
        private final List<InsnArg> args;
        private ClassNode cls;

        public EnumField(String name, int argsCount) {
            this.name = name;
            this.args = argsCount != 0 ? new ArrayList<InsnArg>(argsCount) : Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public List<InsnArg> getArgs() {
            return this.args;
        }

        public ClassNode getCls() {
            return this.cls;
        }

        public void setCls(ClassNode cls) {
            this.cls = cls;
        }

        public String toString() {
            return this.name + "(" + Utils.listToString(this.args) + ") " + this.cls;
        }
    }
}

