/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.clsp.ClspGraph;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public abstract class ArgType {
    public static final ArgType INT = ArgType.primitive(PrimitiveType.INT);
    public static final ArgType BOOLEAN = ArgType.primitive(PrimitiveType.BOOLEAN);
    public static final ArgType BYTE = ArgType.primitive(PrimitiveType.BYTE);
    public static final ArgType SHORT = ArgType.primitive(PrimitiveType.SHORT);
    public static final ArgType CHAR = ArgType.primitive(PrimitiveType.CHAR);
    public static final ArgType FLOAT = ArgType.primitive(PrimitiveType.FLOAT);
    public static final ArgType DOUBLE = ArgType.primitive(PrimitiveType.DOUBLE);
    public static final ArgType LONG = ArgType.primitive(PrimitiveType.LONG);
    public static final ArgType VOID = ArgType.primitive(PrimitiveType.VOID);
    public static final ArgType OBJECT = ArgType.object("java.lang.Object");
    public static final ArgType CLASS = ArgType.object("java.lang.Class");
    public static final ArgType STRING = ArgType.object("java.lang.String");
    public static final ArgType THROWABLE = ArgType.object("java.lang.Throwable");
    public static final ArgType UNKNOWN = ArgType.unknown(PrimitiveType.values());
    public static final ArgType UNKNOWN_OBJECT = ArgType.unknown(PrimitiveType.OBJECT, PrimitiveType.ARRAY);
    public static final ArgType NARROW = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.BOOLEAN, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR, PrimitiveType.OBJECT, PrimitiveType.ARRAY);
    public static final ArgType NARROW_NUMBERS = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.BOOLEAN, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR);
    public static final ArgType WIDE = ArgType.unknown(PrimitiveType.LONG, PrimitiveType.DOUBLE);
    protected int hash;
    private static ClspGraph clsp;

    public static void setClsp(ClspGraph clsp) {
        ArgType.clsp = clsp;
    }

    public static boolean isClspSet() {
        return clsp != null;
    }

    private static ArgType primitive(PrimitiveType stype) {
        return new PrimitiveArg(stype);
    }

    public static ArgType object(String obj) {
        return new ObjectType(obj);
    }

    public static ArgType genericType(String type) {
        return new GenericType(type);
    }

    public static ArgType wildcard() {
        return new WildcardType(OBJECT, 0);
    }

    public static ArgType wildcard(ArgType obj, int bound) {
        return new WildcardType(obj, bound);
    }

    public static ArgType generic(String sign) {
        return new SignatureParser(sign).consumeType();
    }

    public static ArgType generic(String obj, ArgType[] generics) {
        return new GenericObject(obj, generics);
    }

    public static ArgType genericInner(ArgType genericType, String innerName, ArgType[] generics) {
        return new GenericObject((GenericObject)genericType, innerName, generics);
    }

    public static ArgType array(ArgType vtype) {
        return new ArrayArg(vtype);
    }

    public static ArgType unknown(PrimitiveType ... types) {
        return new UnknownArg(types);
    }

    public boolean isTypeKnown() {
        return false;
    }

    public PrimitiveType getPrimitiveType() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public String getObject() {
        throw new UnsupportedOperationException("ArgType.getObject(), call class: " + this.getClass());
    }

    public boolean isObject() {
        return false;
    }

    public boolean isGeneric() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public ArgType[] getGenericTypes() {
        return null;
    }

    public ArgType getWildcardType() {
        return null;
    }

    public int getWildcardBounds() {
        return 0;
    }

    public ArgType getOuterType() {
        return null;
    }

    public boolean isArray() {
        return false;
    }

    public int getArrayDimension() {
        return 0;
    }

    public ArgType getArrayElement() {
        return null;
    }

    public ArgType getArrayRootElement() {
        return this;
    }

    public abstract boolean contains(PrimitiveType var1);

    public abstract ArgType selectFirst();

    public abstract PrimitiveType[] getPossibleTypes();

    @Nullable
    public static ArgType merge(ArgType a, ArgType b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.equals(b)) {
            return a;
        }
        ArgType res = ArgType.mergeInternal(a, b);
        if (res == null) {
            res = ArgType.mergeInternal(b, a);
        }
        return res;
    }

    private static ArgType mergeInternal(ArgType a, ArgType b) {
        if (a == UNKNOWN) {
            return b;
        }
        if (a.isArray()) {
            return ArgType.mergeArrays((ArrayArg)a, b);
        }
        if (b.isArray()) {
            return ArgType.mergeArrays((ArrayArg)b, a);
        }
        if (!a.isTypeKnown()) {
            if (b.isTypeKnown()) {
                if (a.contains(b.getPrimitiveType())) {
                    return b;
                }
                return null;
            }
            ArrayList<PrimitiveType> types = new ArrayList<PrimitiveType>();
            for (PrimitiveType type : a.getPossibleTypes()) {
                if (!b.contains(type)) continue;
                types.add(type);
            }
            if (types.isEmpty()) {
                return null;
            }
            if (types.size() == 1) {
                PrimitiveType nt = (PrimitiveType)((Object)types.get(0));
                if (nt == PrimitiveType.OBJECT || nt == PrimitiveType.ARRAY) {
                    return ArgType.unknown(nt);
                }
                return ArgType.primitive(nt);
            }
            return ArgType.unknown(types.toArray(new PrimitiveType[types.size()]));
        }
        if (a.isGenericType()) {
            return a;
        }
        if (b.isGenericType()) {
            return b;
        }
        if (a.isObject() && b.isObject()) {
            String bObj;
            String aObj = a.getObject();
            if (aObj.equals(bObj = b.getObject())) {
                return a.getGenericTypes() != null ? a : b;
            }
            if (aObj.equals("java.lang.Object")) {
                return b;
            }
            if (bObj.equals("java.lang.Object")) {
                return a;
            }
            String obj = clsp.getCommonAncestor(aObj, bObj);
            return obj == null ? null : ArgType.object(obj);
        }
        if (a.isPrimitive() && b.isPrimitive() && a.getRegCount() == b.getRegCount()) {
            return ArgType.primitive(PrimitiveType.getSmaller(a.getPrimitiveType(), b.getPrimitiveType()));
        }
        return null;
    }

    private static ArgType mergeArrays(ArrayArg array, ArgType b) {
        if (b.isArray()) {
            ArgType ea = array.getArrayElement();
            ArgType eb = b.getArrayElement();
            if (ea.isPrimitive() && eb.isPrimitive()) {
                return OBJECT;
            }
            ArgType res = ArgType.merge(ea, eb);
            return res == null ? null : ArgType.array(res);
        }
        if (b.contains(PrimitiveType.ARRAY)) {
            return array;
        }
        if (b.equals(OBJECT)) {
            return OBJECT;
        }
        return null;
    }

    public static boolean isCastNeeded(ArgType from, ArgType to) {
        if (from.equals(to)) {
            return false;
        }
        return !from.isObject() || !to.isObject() || !clsp.isImplements(from.getObject(), to.getObject());
    }

    public static boolean isInstanceOf(ArgType type, ArgType of) {
        if (type.equals(of)) {
            return true;
        }
        if (!type.isObject() || !of.isObject()) {
            return false;
        }
        return clsp.isImplements(type.getObject(), of.getObject());
    }

    public static ArgType parse(String type) {
        char f = type.charAt(0);
        switch (f) {
            case 'L': {
                return ArgType.object(type);
            }
            case 'T': {
                return ArgType.genericType(type.substring(1, type.length() - 1));
            }
            case '[': {
                return ArgType.array(ArgType.parse(type.substring(1)));
            }
        }
        return ArgType.parse(f);
    }

    public static ArgType parse(char f) {
        switch (f) {
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'J': {
                return LONG;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                return VOID;
            }
        }
        return null;
    }

    public int getRegCount() {
        if (this.isPrimitive()) {
            PrimitiveType type = this.getPrimitiveType();
            if (type == PrimitiveType.LONG || type == PrimitiveType.DOUBLE) {
                return 2;
            }
            return 1;
        }
        if (!this.isTypeKnown()) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "ARG_TYPE";
    }

    public int hashCode() {
        return this.hash;
    }

    abstract boolean internalEquals(Object var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.hash != obj.hashCode()) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.internalEquals(obj);
    }

    private static final class UnknownArg
    extends ArgType {
        private final PrimitiveType[] possibleTypes;

        public UnknownArg(PrimitiveType[] types) {
            this.possibleTypes = types;
            this.hash = Arrays.hashCode((Object[])this.possibleTypes);
        }

        @Override
        public PrimitiveType[] getPossibleTypes() {
            return this.possibleTypes;
        }

        @Override
        public boolean isTypeKnown() {
            return false;
        }

        @Override
        public boolean contains(PrimitiveType type) {
            for (PrimitiveType t : this.possibleTypes) {
                if (t != type) continue;
                return true;
            }
            return false;
        }

        @Override
        public ArgType selectFirst() {
            PrimitiveType f = this.possibleTypes[0];
            if (this.contains(PrimitiveType.OBJECT)) {
                return OBJECT;
            }
            if (this.contains(PrimitiveType.ARRAY)) {
                return UnknownArg.array(OBJECT);
            }
            return ArgType.primitive(f);
        }

        @Override
        boolean internalEquals(Object obj) {
            return Arrays.equals((Object[])this.possibleTypes, (Object[])((UnknownArg)obj).possibleTypes);
        }

        @Override
        public String toString() {
            if (this.possibleTypes.length == PrimitiveType.values().length) {
                return "?";
            }
            return "?" + Arrays.toString((Object[])this.possibleTypes);
        }
    }

    private static final class ArrayArg
    extends KnownType {
        public static final PrimitiveType[] ARRAY_POSSIBLES = new PrimitiveType[]{PrimitiveType.ARRAY};
        private final ArgType arrayElement;

        public ArrayArg(ArgType arrayElement) {
            this.arrayElement = arrayElement;
            this.hash = arrayElement.hashCode();
        }

        @Override
        public ArgType getArrayElement() {
            return this.arrayElement;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            return PrimitiveType.ARRAY;
        }

        @Override
        public boolean isTypeKnown() {
            return this.arrayElement.isTypeKnown();
        }

        @Override
        public ArgType selectFirst() {
            return ArrayArg.array(this.arrayElement.selectFirst());
        }

        @Override
        public PrimitiveType[] getPossibleTypes() {
            return ARRAY_POSSIBLES;
        }

        @Override
        public int getArrayDimension() {
            return 1 + this.arrayElement.getArrayDimension();
        }

        @Override
        public ArgType getArrayRootElement() {
            return this.arrayElement.getArrayRootElement();
        }

        @Override
        boolean internalEquals(Object obj) {
            return this.arrayElement.equals(((ArrayArg)obj).arrayElement);
        }

        @Override
        public String toString() {
            return this.arrayElement + "[]";
        }
    }

    private static class GenericObject
    extends ObjectType {
        private final ArgType[] generics;
        private final GenericObject outerType;

        public GenericObject(String obj, ArgType[] generics) {
            super(obj);
            this.outerType = null;
            this.generics = generics;
            this.hash = obj.hashCode() + 31 * Arrays.hashCode(generics);
        }

        public GenericObject(GenericObject outerType, String innerName, ArgType[] generics) {
            super(outerType.getObject() + "$" + innerName);
            this.outerType = outerType;
            this.generics = generics;
            this.hash = outerType.hashCode() + 31 * innerName.hashCode() + 961 * Arrays.hashCode(generics);
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public ArgType[] getGenericTypes() {
            return this.generics;
        }

        @Override
        public ArgType getOuterType() {
            return this.outerType;
        }

        @Override
        boolean internalEquals(Object obj) {
            return super.internalEquals(obj) && Arrays.equals(this.generics, ((GenericObject)obj).generics);
        }

        @Override
        public String toString() {
            return super.toString() + "<" + Utils.arrayToString(this.generics) + ">";
        }
    }

    private static final class WildcardType
    extends ObjectType {
        private final ArgType type;
        private final int bounds;

        public WildcardType(ArgType obj, int bound) {
            super(OBJECT.getObject());
            this.type = obj;
            this.bounds = bound;
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public ArgType getWildcardType() {
            return this.type;
        }

        @Override
        public int getWildcardBounds() {
            return this.bounds;
        }

        @Override
        boolean internalEquals(Object obj) {
            return super.internalEquals(obj) && this.bounds == ((WildcardType)obj).bounds && this.type.equals(((WildcardType)obj).type);
        }

        @Override
        public String toString() {
            if (this.bounds == 0) {
                return "?";
            }
            return "? " + (this.bounds == -1 ? "super" : "extends") + " " + this.type;
        }
    }

    private static final class GenericType
    extends ObjectType {
        public GenericType(String obj) {
            super(obj);
        }

        @Override
        public boolean isGenericType() {
            return true;
        }
    }

    private static class ObjectType
    extends KnownType {
        private final String object;

        public ObjectType(String obj) {
            this.object = Utils.cleanObjectName(obj);
            this.hash = this.object.hashCode();
        }

        @Override
        public String getObject() {
            return this.object;
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            return PrimitiveType.OBJECT;
        }

        @Override
        boolean internalEquals(Object obj) {
            return this.object.equals(((ObjectType)obj).object);
        }

        @Override
        public String toString() {
            return this.object;
        }
    }

    private static final class PrimitiveArg
    extends KnownType {
        private final PrimitiveType type;

        public PrimitiveArg(PrimitiveType type) {
            this.type = type;
            this.hash = type.hashCode();
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            return this.type;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        boolean internalEquals(Object obj) {
            return this.type == ((PrimitiveArg)obj).type;
        }

        @Override
        public String toString() {
            return this.type.toString();
        }
    }

    private static abstract class KnownType
    extends ArgType {
        private static final PrimitiveType[] EMPTY_POSSIBLES = new PrimitiveType[0];

        private KnownType() {
        }

        @Override
        public boolean isTypeKnown() {
            return true;
        }

        @Override
        public boolean contains(PrimitiveType type) {
            return this.getPrimitiveType() == type;
        }

        @Override
        public ArgType selectFirst() {
            return null;
        }

        @Override
        public PrimitiveType[] getPossibleTypes() {
            return EMPTY_POSSIBLES;
        }
    }
}

