/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.parser.FieldValueAttr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterArg
extends InsnArg
implements Named {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterArg.class);
    protected final int regNum;
    private SSAVar sVar;

    public RegisterArg(int rn) {
        this.regNum = rn;
    }

    public RegisterArg(int rn, ArgType type) {
        this.type = type;
        this.regNum = rn;
    }

    public int getRegNum() {
        return this.regNum;
    }

    @Override
    public boolean isRegister() {
        return true;
    }

    public SSAVar getSVar() {
        return this.sVar;
    }

    void setSVar(SSAVar sVar) {
        this.sVar = sVar;
    }

    @Override
    public String getName() {
        if (this.sVar == null) {
            return null;
        }
        return this.sVar.getName();
    }

    @Override
    public void setName(String name) {
        if (this.sVar != null) {
            this.sVar.setName(name);
        }
    }

    public boolean isNameEquals(InsnArg arg) {
        String n = this.getName();
        if (n == null || !(arg instanceof Named)) {
            return false;
        }
        return n.equals(((Named)((Object)arg)).getName());
    }

    @Override
    public void setType(ArgType type) {
        if (this.sVar != null) {
            this.sVar.setType(type);
        }
    }

    public void mergeDebugInfo(ArgType type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public RegisterArg duplicate() {
        RegisterArg dup = new RegisterArg(this.getRegNum(), this.getType());
        dup.setSVar(this.sVar);
        return dup;
    }

    public Object getConstValue(DexNode dex) {
        InsnNode parInsn = this.getAssignInsn();
        if (parInsn == null) {
            return null;
        }
        InsnType insnType = parInsn.getType();
        switch (insnType) {
            case CONST: {
                return parInsn.getArg(0);
            }
            case CONST_STR: {
                return ((ConstStringNode)parInsn).getString();
            }
            case CONST_CLASS: {
                return ((ConstClassNode)parInsn).getClsType();
            }
            case SGET: {
                FieldInfo f = (FieldInfo)((IndexInsnNode)parInsn).getIndex();
                FieldNode fieldNode = dex.resolveField(f);
                if (fieldNode != null) {
                    FieldValueAttr attr = fieldNode.get(AType.FIELD_VALUE);
                    if (attr == null) break;
                    return attr.getValue();
                }
                LOG.warn("Field {} not found in dex {}", (Object)f, (Object)dex);
            }
        }
        return null;
    }

    @Override
    public boolean isThis() {
        InsnArg arg;
        if ("this".equals(this.getName())) {
            return true;
        }
        InsnNode ai = this.getAssignInsn();
        if (ai != null && ai.getType() == InsnType.MOVE && (arg = ai.getArg(0)) != this) {
            return arg.isThis();
        }
        return false;
    }

    public InsnNode getAssignInsn() {
        if (this.sVar == null) {
            return null;
        }
        return this.sVar.getAssign().getParentInsn();
    }

    public InsnNode getPhiAssignInsn() {
        PhiInsn usePhi = this.sVar.getUsedInPhi();
        if (usePhi != null) {
            return usePhi;
        }
        InsnNode parent = this.sVar.getAssign().getParentInsn();
        if (parent != null && parent.getType() == InsnType.PHI) {
            return parent;
        }
        return null;
    }

    public boolean equalRegisterAndType(RegisterArg arg) {
        return this.regNum == arg.regNum && this.type.equals(arg.type);
    }

    public int hashCode() {
        return (this.regNum * 31 + this.type.hashCode()) * 31 + (this.sVar != null ? this.sVar.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterArg)) {
            return false;
        }
        RegisterArg other = (RegisterArg)obj;
        if (this.regNum != other.regNum) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.sVar == null || this.sVar.equals(other.getSVar());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(r");
        sb.append(this.regNum);
        if (this.sVar != null) {
            sb.append("_").append(this.sVar.getVersion());
        }
        if (this.getName() != null) {
            sb.append(" '").append(this.getName()).append("'");
        }
        sb.append(" ");
        sb.append(this.type);
        sb.append(")");
        return sb.toString();
    }
}

