/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.regions.AbstractRegion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SwitchRegion
extends AbstractRegion {
    private final BlockNode header;
    private final List<List<Object>> keys;
    private final List<IContainer> cases;
    private IContainer defCase;

    public SwitchRegion(IRegion parent, BlockNode header) {
        super(parent);
        this.header = header;
        this.keys = new ArrayList<List<Object>>();
        this.cases = new ArrayList<IContainer>();
    }

    public BlockNode getHeader() {
        return this.header;
    }

    public void addCase(List<Object> keysList, IContainer c) {
        this.keys.add(keysList);
        this.cases.add(c);
    }

    public void setDefaultCase(IContainer block) {
        this.defCase = block;
    }

    public IContainer getDefaultCase() {
        return this.defCase;
    }

    public List<List<Object>> getKeys() {
        return this.keys;
    }

    public List<IContainer> getCases() {
        return this.cases;
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(this.cases.size() + 2);
        all.add(this.header);
        all.addAll(this.cases);
        if (this.defCase != null) {
            all.add(this.defCase);
        }
        return Collections.unmodifiableList(all);
    }

    @Override
    public String baseString() {
        return this.header.baseString();
    }

    public String toString() {
        return "Switch: " + this.cases.size() + ", default: " + this.defCase;
    }
}

