/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanRegions {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRegions.class);

    private CleanRegions() {
    }

    public static void process(MethodNode mth) {
        if (mth.isNoCode() || mth.getBasicBlocks().isEmpty()) {
            return;
        }
        AbstractRegionVisitor removeEmptyBlocks = new AbstractRegionVisitor(){

            @Override
            public void enterRegion(MethodNode mth, IRegion region) {
                if (!(region instanceof Region)) {
                    return;
                }
                Iterator<IContainer> it = region.getSubBlocks().iterator();
                while (it.hasNext()) {
                    BlockNode block;
                    IContainer container = it.next();
                    if (!(container instanceof BlockNode) || !(block = (BlockNode)container).getInstructions().isEmpty()) continue;
                    try {
                        it.remove();
                    }
                    catch (UnsupportedOperationException e) {
                        LOG.warn("Can't remove block: {} from: {}, mth: {}", new Object[]{block, region, mth});
                    }
                }
            }
        };
        DepthRegionTraversal.traverseAll(mth, removeEmptyBlocks);
    }
}

