/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import com.android.dx.io.instructions.DecodedInstruction;
import jadx.core.dex.instructions.InsnType;
import jadx.core.utils.exceptions.JadxRuntimeException;

public class InsnUtils {
    private InsnUtils() {
    }

    public static int getArg(DecodedInstruction insn, int arg) {
        switch (arg) {
            case 0: {
                return insn.getA();
            }
            case 1: {
                return insn.getB();
            }
            case 2: {
                return insn.getC();
            }
            case 3: {
                return insn.getD();
            }
            case 4: {
                return insn.getE();
            }
        }
        throw new JadxRuntimeException("Wrong argument number: " + arg);
    }

    public static String formatOffset(int offset) {
        if (offset < 0) {
            return "?";
        }
        return String.format("0x%04x", offset);
    }

    public static String insnTypeToString(InsnType type) {
        return type.toString() + "  ";
    }

    public static String indexToString(Object index) {
        if (index == null) {
            return "";
        }
        if (index instanceof String) {
            return "\"" + index + "\"";
        }
        return index.toString();
    }
}

