/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Link
extends JLabel
implements MouseListener {
    private static final Logger LOG = LoggerFactory.getLogger(JLabel.class);
    private String url;

    public Link(String text, String url) {
        super(text);
        this.url = url;
        this.setToolTipText("Open " + url + " in your browser");
        this.addMouseListener(this);
        this.setForeground(Color.BLUE);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.browse();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void browse() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(this.url));
                return;
            }
            catch (IOException e) {
                LOG.debug("Open url error", (Throwable)e);
            }
            catch (URISyntaxException e) {
                LOG.debug("Open url error", (Throwable)e);
            }
        }
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + this.url);
                return;
            }
            if (os.contains("mac")) {
                Runtime.getRuntime().exec("open " + this.url);
                return;
            }
            Map<String, String> env = System.getenv();
            if (env.get("BROWSER") != null) {
                Runtime.getRuntime().exec(env.get("BROWSER") + " " + this.url);
                return;
            }
        }
        catch (Exception e) {
            LOG.debug("Open url error", (Throwable)e);
        }
        this.showUrlDialog();
    }

    private void showUrlDialog() {
        JTextArea urlArea = new JTextArea("Can't open browser. Please browse to:\n" + this.url);
        JOptionPane.showMessageDialog(null, urlArea);
    }
}

