/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.mods;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;

public class ConstructorInsn
extends InsnNode {
    private final MethodInfo callMth;
    private final CallType callType;
    private final RegisterArg instanceArg;

    public ConstructorInsn(MethodNode mth, InvokeNode invoke) {
        super(InsnType.CONSTRUCTOR, invoke.getArgsCount() - 1);
        this.callMth = invoke.getCallMth();
        ClassInfo classType = this.callMth.getDeclClass();
        this.instanceArg = (RegisterArg)invoke.getArg(0);
        if (this.instanceArg.isThis()) {
            this.callType = classType.equals(mth.getParentClass().getClassInfo()) ? (this.callMth.getShortId().equals(mth.getMethodInfo().getShortId()) ? CallType.SELF : CallType.THIS) : CallType.SUPER;
        } else {
            this.callType = CallType.CONSTRUCTOR;
            this.setResult(this.instanceArg);
            this.instanceArg.getSVar().setAssign(this.instanceArg);
        }
        this.instanceArg.getSVar().removeUse(this.instanceArg);
        for (int i = 1; i < invoke.getArgsCount(); ++i) {
            this.addArg(invoke.getArg(i));
        }
        this.offset = invoke.getOffset();
        this.setSourceLine(invoke.getSourceLine());
    }

    public ConstructorInsn(MethodInfo callMth, CallType callType, RegisterArg instanceArg) {
        super(InsnType.CONSTRUCTOR, callMth.getArgsCount());
        this.callMth = callMth;
        this.callType = callType;
        this.instanceArg = instanceArg;
    }

    public MethodInfo getCallMth() {
        return this.callMth;
    }

    public RegisterArg getInstanceArg() {
        return this.instanceArg;
    }

    public ClassInfo getClassType() {
        return this.callMth.getDeclClass();
    }

    public CallType getCallType() {
        return this.callType;
    }

    public boolean isNewInstance() {
        return this.callType == CallType.CONSTRUCTOR;
    }

    public boolean isSuper() {
        return this.callType == CallType.SUPER;
    }

    public boolean isThis() {
        return this.callType == CallType.THIS;
    }

    public boolean isSelf() {
        return this.callType == CallType.SELF;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructorInsn) || !super.equals(o)) {
            return false;
        }
        ConstructorInsn that = (ConstructorInsn)o;
        return this.callMth.equals(that.callMth) && this.callType == that.callType && this.instanceArg.equals(that.instanceArg);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.callMth.hashCode();
        result = 31 * result + this.callType.hashCode();
        result = 31 * result + this.instanceArg.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.callMth + " " + (Object)((Object)this.callType);
    }

    private static enum CallType {
        CONSTRUCTOR,
        SUPER,
        THIS,
        SELF;

    }
}

