/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;

public class FieldNode
extends LineAttrNode {
    private final ClassNode parent;
    private final FieldInfo fieldInfo;
    private final AccessInfo accFlags;
    private ArgType type;

    public FieldNode(ClassNode cls, ClassData.Field field) {
        this.parent = cls;
        this.fieldInfo = FieldInfo.fromDex(cls.dex(), field.getFieldIndex());
        this.type = this.fieldInfo.getType();
        this.accFlags = new AccessInfo(field.getAccessFlags(), AccessInfo.AFType.FIELD);
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public AccessInfo getAccessFlags() {
        return this.accFlags;
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public ArgType getType() {
        return this.type;
    }

    public void setType(ArgType type) {
        this.type = type;
    }

    public ClassNode getParentClass() {
        return this.parent;
    }

    public int hashCode() {
        return this.fieldInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldNode other = (FieldNode)obj;
        return this.fieldInfo.equals(other.fieldInfo);
    }

    public String toString() {
        return this.fieldInfo.getDeclClass() + "." + this.fieldInfo.getName() + " :" + this.type;
    }
}

