/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

public class StringUtils {
    private StringUtils() {
    }

    public static String unescapeString(String str) {
        int len = str.length();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i) & 0xFFFF;
            StringUtils.processChar(c, res);
        }
        return '\"' + res.toString() + '\"';
    }

    public static String unescapeChar(char ch) {
        if (ch == '\'') {
            return "'\\''";
        }
        StringBuilder res = new StringBuilder();
        StringUtils.processChar(ch, res);
        return '\'' + res.toString() + '\'';
    }

    private static void processChar(int c, StringBuilder res) {
        switch (c) {
            case 10: {
                res.append("\\n");
                break;
            }
            case 13: {
                res.append("\\r");
                break;
            }
            case 9: {
                res.append("\\t");
                break;
            }
            case 8: {
                res.append("\\b");
                break;
            }
            case 12: {
                res.append("\\f");
                break;
            }
            case 39: {
                res.append('\'');
                break;
            }
            case 34: {
                res.append("\\\"");
                break;
            }
            case 92: {
                res.append("\\\\");
                break;
            }
            default: {
                if (32 <= c && c <= 126) {
                    res.append((char)c);
                    break;
                }
                res.append("\\u").append(String.format("%04x", c));
            }
        }
    }
}

