/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;

public class Utils {
    private Utils() {
    }

    public static String cleanObjectName(String obj) {
        int last = obj.length() - 1;
        if (obj.charAt(0) == 'L' && obj.charAt(last) == ';') {
            return obj.substring(1, last).replace('/', '.');
        }
        return obj;
    }

    public static String makeQualifiedObjectName(String obj) {
        return 'L' + obj.replace('.', '/') + ';';
    }

    public static String escape(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '<': {
                    sb.append('_');
                    continue block5;
                }
                case '[': {
                    sb.append('A');
                    continue block5;
                }
                case '*': 
                case '>': 
                case '?': 
                case ']': {
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String listToString(Iterable<?> list) {
        if (list == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            str.append(o);
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        return str.toString();
    }

    public static String arrayToString(Object[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

