/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class GraphPanel
extends Panel
implements MouseMotionListener,
MouseListener,
ActionListener {
    protected final int topBorder = 10;
    protected final int bottomBorder = 45;
    protected final int leftBorder = 55;
    protected final int rightBorder = 20;
    protected int width;
    protected int height;
    protected Color grayShade = new Color(235, 235, 235);
    protected Vector logdata = new Vector();
    protected long mintime;
    protected long maxtime;
    protected double minrate;
    protected double maxrate;
    protected double totalkeys;
    protected long rangestart = -1L;
    protected long rangeend = -1L;
    protected final int nologloaded = 0;
    protected final int lognotfound = 1;
    protected final int loadinprogress = 2;
    protected final int logloaded = 3;
    protected int loggerstate = 0;
    public File currentLogFile;
    private static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private int startx = -1;
    private int endx = -1;
    Image img;
    int iwidth = -1;
    int iheight = -1;

    public GraphPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.lightGray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Date date;
        if (actionEvent.getActionCommand() == "complete") {
            this.setRange(-1L, -1L);
            this.startx = -1;
            this.endx = -1;
            this.repaint();
        }
        if (actionEvent.getActionCommand() == "today") {
            date = new Date();
            this.setRange(Date.UTC(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0) / 100L, Date.UTC(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0) / 100L + 864000L);
            this.startx = -1;
            this.endx = -1;
            this.repaint();
        }
        if (actionEvent.getActionCommand() == "yesterday") {
            date = new Date();
            this.setRange(Date.UTC(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0) / 100L - 864000L, Date.UTC(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0) / 100L);
            this.startx = -1;
            this.endx = -1;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            PopupMenu popupMenu = new PopupMenu("Zoom");
            MenuItem menuItem = new MenuItem("complete");
            menuItem.addActionListener(this);
            popupMenu.add(menuItem);
            this.add(popupMenu);
            popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.startx = mouseEvent.getX();
            this.endx = mouseEvent.getX() + 1;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            PopupMenu popupMenu = new PopupMenu("Zoom");
            MenuItem menuItem = new MenuItem("complete");
            menuItem.addActionListener(this);
            popupMenu.add(menuItem);
            this.add(popupMenu);
            popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        } else {
            if (Math.abs(this.startx - this.endx) < 10) {
                this.startx = -1;
                this.endx = -1;
            }
            if (this.startx != -1 && this.endx != -1) {
                if (this.startx < this.endx) {
                    this.setRange(this.rangestart + (long)(this.startx - 55) * (this.rangeend - this.rangestart) / (long)this.width, this.rangestart + (long)(this.endx - 55) * (this.rangeend - this.rangestart) / (long)this.width);
                }
                if (this.startx > this.endx) {
                    this.setRange(this.rangestart + (long)(this.endx - 55) * (this.rangeend - this.rangestart) / (long)this.width, this.rangestart + (long)(this.startx - 55) * (this.rangeend - this.rangestart) / (long)this.width);
                }
            }
            this.startx = -1;
            this.endx = -1;
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.endx = mouseEvent.getX();
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    void getDataRange(long l, long l2) {
        l = this.mintime;
        l2 = this.maxtime;
    }

    void getRange(long l, long l2) {
        l = this.rangestart;
        l2 = this.rangeend;
    }

    void setRange(long l, long l2) {
        this.rangestart = l;
        this.rangeend = l2;
    }

    boolean isDataAvailable() {
        return this.loggerstate == 3 && !this.logdata.isEmpty() && this.minrate < this.maxrate && this.mintime < this.maxtime;
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }

    public synchronized void paint(Graphics graphics) {
        Cloneable cloneable;
        Dimension dimension = this.getSize();
        if (this.img == null || dimension.width != this.iwidth || dimension.height != this.iheight) {
            this.img = null;
            this.img = this.createImage(dimension.width, dimension.height);
            this.iwidth = dimension.width;
            this.iheight = dimension.height;
        }
        Graphics graphics2 = this.img.getGraphics();
        graphics2.clearRect(0, 0, this.iwidth, this.iheight);
        if (this.loggerstate == 2) {
            graphics2.drawString("Please wait, currently reloading log file.", 55, 10);
            return;
        }
        if (this.loggerstate == 1) {
            graphics2.drawString("Could not load any data for graphing.  This may indicate that there was a problem opening the log file.", 55, 10);
            return;
        }
        if (this.loggerstate == 0) {
            graphics2.drawString("You must specify a log file to be used for graph visualization.", 55, 10);
            return;
        }
        if (this.logdata.isEmpty() || this.minrate >= this.maxrate || this.mintime >= this.maxtime) {
            graphics2.drawString("Could not load any data for graphing.  This may indicate that there was no graphable data inside of the specified log file", 55, 10);
            return;
        }
        this.width = dimension.width - 75;
        this.height = dimension.height - 55;
        if (this.width < 0 || this.height < 0) {
            return;
        }
        long l = this.rangestart == -1L ? this.mintime : this.rangestart;
        long l2 = this.rangeend == -1L ? this.maxtime : this.rangeend;
        this.setRange(l, l2);
        if (l2 <= l) {
            return;
        }
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        double d = (this.maxrate - this.minrate) / (double)this.height * (double)(fontMetrics.getHeight() * 4);
        long l3 = (l2 - l) / (long)this.width * (long)(fontMetrics.charWidth('A') * 10);
        graphics2.setColor(Color.white);
        graphics2.fillRect(55, 10, this.width, this.height);
        graphics2.setColor(this.grayShade);
        int n = 0;
        while (n < this.width) {
            if (n + 50 > this.width) {
                graphics2.fillRect(55 + n, 10, this.width - n, this.height);
            } else {
                graphics2.fillRect(55 + n, 10, 50, this.height);
            }
            n += 100;
        }
        int n2 = fontMetrics.getHeight();
        graphics2.setColor(Color.black);
        int n3 = 0;
        while (n3 < this.width) {
            cloneable = new Date(100L * (l + (long)n3 * (l2 - l) / (long)this.width));
            String string = String.valueOf(months[((Date)cloneable).getMonth()]) + " " + ((Date)cloneable).getDate();
            int n4 = fontMetrics.stringWidth(string) / 2;
            graphics2.drawString(string, 55 + n3 - n4, 10 + this.height + 5 + n2);
            string = String.valueOf(((Date)cloneable).getHours()) + ":";
            string = ((Date)cloneable).getMinutes() < 10 ? String.valueOf(string) + "0" + ((Date)cloneable).getMinutes() : String.valueOf(string) + ((Date)cloneable).getMinutes();
            n4 = fontMetrics.stringWidth(string) / 2;
            graphics2.drawString(string, 55 + n3 - n4, 10 + this.height + 5 + 2 * n2);
            graphics2.drawLine(55 + n3, 10 + this.height, 55 + n3, 10 + this.height + 5);
            n3 += 50;
        }
        cloneable = NumberFormat.getInstance();
        ((NumberFormat)cloneable).setMinimumFractionDigits(2);
        ((NumberFormat)cloneable).setMaximumFractionDigits(2);
        n2 /= 2;
        double d2 = this.minrate + d;
        while (d2 < this.maxrate) {
            int n5 = 10 + (int)((float)this.height * (float)(d2 - this.minrate) / (float)(this.maxrate - this.minrate));
            int n6 = 0;
            while (n6 < this.width - 3) {
                graphics2.drawLine(55 + n6, n5, 55 + n6 + 3, n5);
                n6 += 6;
            }
            double d3 = (this.maxrate - d2) / 1000.0;
            String string = ((NumberFormat)cloneable).format(d3);
            int n7 = fontMetrics.stringWidth(string);
            graphics2.drawString(string, 50 - n7, n5 + n2);
            graphics2.drawLine(50, n5, 55, n5);
            d2 += d;
        }
        double d4 = this.maxrate / 1000.0;
        String string = ((NumberFormat)cloneable).format(d4);
        int n8 = fontMetrics.stringWidth(string);
        graphics2.drawString(string, 50 - n8, 10 + n2);
        graphics2.setColor(Color.red);
        graphics2.setClip(55, 10, this.width, this.height);
        try {
            boolean bl = true;
            long l4 = 0L;
            int n9 = 0;
            int n10 = 0;
            Enumeration enumeration = this.logdata.elements();
            while (enumeration.hasMoreElements()) {
                GraphEntry graphEntry = (GraphEntry)enumeration.nextElement();
                int n11 = 55 + (int)((float)this.width * (float)(graphEntry.timestamp - l) / (float)(l2 - l));
                int n12 = 10 + this.height - (int)((float)this.height * (float)((double)graphEntry.rate - this.minrate) / (float)(this.maxrate - this.minrate));
                if (n11 < 55 || n11 > this.width + 55) continue;
                if (!bl) {
                    if ((double)(graphEntry.timestamp - l4) > 300.0 + 1.25 * (double)graphEntry.duration * 10.0) {
                        graphics2.drawLine(n9, n10, n9, 10 + this.height);
                        graphics2.drawLine(n9, 10 + this.height, n11, 10 + this.height);
                        graphics2.drawLine(n11, 10 + this.height, n11, n12);
                    } else {
                        graphics2.drawLine(n9, n10, n11, n12);
                    }
                }
                n9 = n11;
                n10 = n12;
                l4 = graphEntry.timestamp;
                bl = false;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        graphics2.setClip(null);
        if (this.startx > 0) {
            graphics2.setXORMode(Color.black);
            if (this.startx < this.endx) {
                if (this.endx > this.width + 55) {
                    this.endx = this.width + 55;
                }
                graphics2.fillRect(this.startx, 10, this.endx - this.startx, this.height);
            }
            if (this.endx < this.startx) {
                if (this.startx > this.width + 55) {
                    this.startx = this.width + 55;
                }
                graphics2.fillRect(this.endx, 10, this.startx - this.endx, this.height);
            }
        }
        graphics2.finalize();
        graphics.drawImage(this.img, 0, 0, null);
        this.img = null;
    }

    void readLogData() {
        BufferedReader bufferedReader;
        this.logdata.removeAllElements();
        this.maxtime = 0L;
        this.mintime = 0L;
        this.maxrate = 0.0;
        this.minrate = 0.0;
        this.totalkeys = 0.0;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.currentLogFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + fileNotFoundException);
            this.loggerstate = 1;
            return;
        }
        WorkerThread workerThread = new WorkerThread(bufferedReader);
        workerThread.start();
        try {
            workerThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.setRange(-1L, -1L);
        this.repaint();
    }

    final class WorkerThread
    extends Thread {
        LogParser parser = null;

        WorkerThread(BufferedReader bufferedReader) {
            this.parser = new LogParser(bufferedReader, GraphPanel.this.logdata);
            GraphPanel.this.loggerstate = 2;
        }

        public void run() {
            System.out.println("load in progress");
            this.parser.run();
            GraphPanel.this.maxtime = 0L;
            GraphPanel.this.mintime = 0L;
            GraphPanel.this.maxrate = 0.0;
            GraphPanel.this.minrate = 0.0;
            GraphPanel.this.totalkeys = 0.0;
            try {
                Enumeration enumeration = GraphPanel.this.logdata.elements();
                while (enumeration.hasMoreElements()) {
                    GraphEntry graphEntry = (GraphEntry)enumeration.nextElement();
                    if (GraphPanel.this.mintime == 0L || graphEntry.timestamp < GraphPanel.this.mintime) {
                        GraphPanel.this.mintime = graphEntry.timestamp;
                    }
                    if (GraphPanel.this.maxtime == 0L || graphEntry.timestamp > GraphPanel.this.maxtime) {
                        GraphPanel.this.maxtime = graphEntry.timestamp;
                    }
                    if (GraphPanel.this.minrate == 0.0 || (double)graphEntry.rate < GraphPanel.this.minrate) {
                        GraphPanel.this.minrate = graphEntry.rate;
                    }
                    if (GraphPanel.this.maxrate == 0.0 || (double)graphEntry.rate > GraphPanel.this.maxrate) {
                        GraphPanel.this.maxrate = graphEntry.rate;
                    }
                    GraphPanel.this.totalkeys += (double)graphEntry.keycount;
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            GraphPanel.this.loggerstate = 3;
            GraphPanel.this.repaint();
        }
    }
}

