// Copyright distributed.net 1997-1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.

// $Log: clirate.cpp,v $
// Revision 1.15.2.2  1998/11/08 11:50:35  remi
// Lots of $Log tags.
//

// ======================================================================

#include "cputypes.h" //for u64 define
#include "problem.h"  //uses Problem and RC5Result class definitions 
#include "clicdata.h" //Cli[Add|Get]ContestInfoSummaryData, CliGetContestInfoBaseData
#include "clitime.h"  //CliTimerDiff
#include "clirate.h"  //keep the prototypes in sync.
#include "network.h"  // for ntohl and timeval

// ---------------------------------------------------------------------------

#define LASTDONE_LIST_SIZE (16) //the number of block id's we cache 
                                //to see if we've already added them

// ---------------------------------------------------------------------------

// return (cumulative) keyrate for a particular contest
double CliGetKeyrateForContest( int contestid )
{
  struct timeval totaltime;
  double totaliter;

  if (CliGetContestInfoSummaryData( contestid, NULL, &totaliter, &totaltime))
    return ((double)(0));  //clicdata.cpp says no such contest
  if (!totaltime.tv_sec && !totaltime.tv_usec)
    return ((double)(0));

  return ((double)(totaliter))/
      (((double)(totaltime.tv_sec))+
     (((double)(totaltime.tv_usec))/((double)(1000000L))));
}

// ---------------------------------------------------------------------------

//internal - see CliGetKeyrateForProblem() for description
static double __CliGetKeyrateForProblem( Problem *prob, int doSave )
{
  static struct { u64 key; signed char contest; } last_done_list[LASTDONE_LIST_SIZE];
  static int last_done_pos = -1;

  RC5Result rc5result;
  unsigned int count;
  struct timeval tv;
  int contestid, additive;
  double keys;

  if (!prob)
    return ((double)(-1));
  if ((!(prob->finished)) || (!(prob->started)) || (!(prob->IsInitialized())))
    return ((double)(-2));

  tv.tv_usec = prob->timelo;
  tv.tv_sec = prob->timehi;
  CliTimerDiff( &tv, &tv, NULL ); //get time difference as tv
  if (!tv.tv_sec && !tv.tv_usec)
    tv.tv_usec = 1; //don't divide by zero

  contestid = prob->GetResult( &rc5result );
  if (CliGetContestInfoBaseData( contestid, NULL, &count )) //clicdata.cpp
    return ((double)(0));   //clicdata.cpp says no such contest

  keys = U64TODOUBLE(ntohl(rc5result.keysdone.hi),ntohl(rc5result.keysdone.lo));
  if (count>1) //iteration-to-keycount-multiplication-factor
    keys = (keys)*((double)(count));
  if (prob->startpercent) //slight misnomer. factor is *100000 not *100
    keys = (keys)*(((double)(100000L-(prob->startpercent)))/((double)(100000L)));
  if (keys==((double)(0))) //no keys done? should never happen.
    return ((double)(0));

  additive = 1;
  for (int i = 0; i < (LASTDONE_LIST_SIZE); i++)
  {
    if (last_done_pos==-1)
    {
      last_done_list[i].key.lo = last_done_list[i].key.hi = 0;
      last_done_list[i].contest = -1;
      if (i == ((LASTDONE_LIST_SIZE)-1)) last_done_pos = 0;
    }
    else if (last_done_list[i].key.hi == rc5result.key.hi &&
        last_done_list[i].key.lo == rc5result.key.lo &&
        last_done_list[i].contest == contestid )
    {
      additive=0;
      break;
    }
  }

  if (additive && doSave)
  {
    last_done_list[last_done_pos].key.hi = rc5result.key.hi;
    last_done_list[last_done_pos].key.lo = rc5result.key.lo;
    last_done_list[last_done_pos].contest = (u8) contestid;
    if ((++last_done_pos) >= (LASTDONE_LIST_SIZE))
      last_done_pos=0;

    count = 1; //number of blocks to add to clicdata.cpp information
    CliAddContestInfoSummaryData( contestid, &count, &keys, &tv );
  }

  return ((double)(keys))/
       (((double)(tv.tv_sec))+(((double)(tv.tv_usec))/((double)(1000000L))));
}

// return keyrate for a single problem. Problem must be finished.
double CliGetKeyrateForProblem( Problem *prob )
{  return __CliGetKeyrateForProblem( prob, 1 ); }

double CliGetKeyrateForProblemNoSave( Problem *prob )
{  return __CliGetKeyrateForProblem( prob, 0 ); }

// ---------------------------------------------------------------------------

