// Hey, Emacs, this a -*-C++-*- file !

// Copyright distributed.net 1997-1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
// 
// $Log: clidos.cpp,v $
// Revision 1.3  1998/07/17 05:34:18  cyruspatel
// Latest DOS stuff - Changes are so that win16 and dos can be made from the
// same if (CLIENT_OS == OS_DOS) source
//
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "clidos.h" //just for keeping prototypes in sync

#if (defined(__WINDOWS__))

void dosCliClearScreen(void) { return; /* nothing */ }
unsigned int dosCliGetTimeslice(void) { return 1024; }
void dosCliYieldControl(void) { delay(1); }
void dosCliCheckPlatform(void) { return; /* nothing */ }

#else

extern "C" void __clearscreen(void); //in clearscreen.asm
void dosCliClearScreen(void) { __clearscreen(); }
unsigned int dosCliGetTimeslice(void) { return 0xFFFF; }
void dosCliYieldControl(void) { return; /* nothing */ }

void dosCliCheckPlatform(void)
{
  #pragma pack(1);
  union { struct { unsigned char lsb,msb; } c; unsigned short s; } 
      version, wversion;
  #pragma pack();
  unsigned short sversion;
  char *envp;
  const char *msg1="\nWarning: this is a DOS client running in ";
  const char *msg2="\nPlease use a client built specifically for that platform.\n\n\b";

  _asm  mov ax, 3306h
  _asm  mov bx, 0ffffh
  _asm  int 21h
  _asm  mov sversion, bx
  version.s = sversion;

  if (((((envp = getenv("OS"))!=NULL) && (stricmp( envp, "Windows_NT" )==0)) ||
    (version.c.lsb == 5 && version.c.msb==50)))
    {
    printf( "%sa Windows NT/NTAS VDM.%s", msg1, msg2 );
    return;
    }

  if (version.c.msb <=100 && (version.c.lsb == 10 || version.c.lsb==20))
    {
    printf( "%san OS/2 %d.x DOS VM.%s", msg1,
            ((version.c.lsb==20)?((version.c.msb==30)?(3):(2)):(1)), 
            msg2 );
    return;
    }

  _asm  mov ax, 1600h
  _asm  int 2fh
  _asm  mov sversion, ax
  wversion.s = sversion;
  
  if (((wversion.c.lsb)!=0) && ((wversion.c.lsb & 0x7F)!=0x0))
    {
    printf( "%sa %s v%d.%d DOS Box.%s", msg1,
         ((wversion.c.lsb >= 4)?("Win32"):("Windows")),
         wversion.c.lsb, wversion.c.msb, msg2 );
    return;
    }
  return;
}      

#endif //!defined(__WINDOWS__)

