// Copyright distributed.net 1997-1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: w32cons.cpp,v $
// Revision 1.18  1998/11/10 10:51:10  silby
// RC5 benchmark was being triggered instead of DES benchmark; fixed.
//
// Revision 1.17  1998/11/08 20:11:07  cyp
// Added w32ConGetSize()
//
// Revision 1.16  1998/11/02 06:10:36  cyp
// urgh! 'fixed' the debug functions I had left in.
//
// Revision 1.15  1998/11/02 05:33:39  cyp
// win32 creation/message-loop now runs on its own thread; iconize-before-close
// problem resolved; color problem fixed; added a pop up menu (primarily for
// win16 that can do these things only with progman's/fileman's run command);
// mutex creation for win32 moved to WinMain()/realmain(); window title is
// standardized so that a gui controller can find it; Client is now restartable.
//
// Revision 1.14  1998/10/26 04:32:58  cyp
// Both win16 and win32 work fine. Some speed tweaking in w16Yield() is
// needed.
//
// Revision 1.11  1998/10/20 07:41:16  silby
// Changed win32 to use win32 sleeping and yielding instead of win16 equiv of those two.
//
// Revision 1.10  1998/10/19 13:21:12  cyp
// win16 changes
//
// Revision 1.9  1998/10/11 05:50:42  cyp
// Lots of fixes.
//
// Revision 1.8  1998/10/11 00:34:15  cyp
// Added cowie's console emu functions. 
//
// Revision 1.7  1998/10/08 00:02:30  silby
// Commented out some code called only for the gui that was setting console attributes
//
// Revision 1.6  1998/10/07 18:19:27  silby
// Finished AutoClose support.  Seems to work well.
//
// Revision 1.5  1998/10/07 12:45:45  silby
// Added in microsoft prescribed delay so that hwnd could be properly determined (we weren't waiting long enough for the title to change.)
//
// Revision 1.4  1998/10/05 05:11:35  cyp
// Implemented: (a) conditional destruction, ala Press any key..., of the
// client's window on deinit (b) to activate the client's window from WinMain.
//
// Revision 1.3  1998/10/04 17:53:50  silby
// Reinits signal handlers now when console is created.
//
// Revision 1.2  1998/10/04 01:31:33  silby
// Removed direct paths to platforms/win32cli, letting makefile handle it
//
// Revision 1.1  1998/10/03 12:24:43  cyp
// Created.
//
#if (!defined(lint) && defined(__showids__))
const char *w32cons_cpp(void) {
return "@(#)$Id: w32cons.cpp,v 1.18 1998/11/10 10:51:10 silby Exp $"; }
#endif

#include "cputypes.h"
#include "baseincs.h"
#include "w32svc.h"   //win9x win32CliInitializeService()
#include "w32cons.h"  //ourselves
#include "console.h"  //for CLICONS_[SHORT|LONG]NAME, ConOut, ConInKey
#include "triggers.h" // for clisetupsignals
#include "modereq.h"  // menu

/* ---------------------------------------------------- */
#define SLEEP_FACTOR 1

//define this for win32 native console i/o
//#define USE_NATIVE_CONSOLEIO


// define to the dimensions of the virtual screen
#define W16CONS_WIDTH       80
#define W16CONS_HEIGHT      25

// undefine the following to allow the window to be resized
//#define W16CONS_FIXEDSIZE

// define to the font type (must be fixed width)
#define W16CONS_FONT        ANSI_FIXED_FONT //OEM_FIXED_FONT, SYSTEM_FIXED_FONT

// define to maximum keyboard buffer size
#define W16CONS_KEYBUFF     16

// command message constants
#define W16CONS_CMD_CLEARSCREEN 0x01
#define W16CONS_CMD_PRINTSTR    0x02
#define W16CONS_CMD_ISKBHIT     0x03
#define W16CONS_CMD_GETCH       0x04
#define W16CONS_CMD_SETPOS      0x05

#if 0
#ifndef WM_SIZING /* not available in win16 headers. but is called under w32 */
#define WM_SIZING      0x0214  /* real win32 message number */
#define WMSZ_LEFT           1  /*  wParam for WM_SIZING message  */
#define WMSZ_RIGHT          2
#define WMSZ_TOP            3
#define WMSZ_TOPLEFT        4
#define WMSZ_TOPRIGHT       5
#define WMSZ_BOTTOM         6
#define WMSZ_BOTTOMLEFT     7
#define WMSZ_BOTTOMRIGHT    8
#endif
#endif

/* ---------------------------------------------------- */

//#if (!defined(__LARGE__) && !defined(__FLAT__))
//  #error memory model must be large or flat
//#endif
#if (CLIENT_OS != OS_WIN32) && defined(USE_NATIVE_CONSOLEIO)
  #undef USE_NATIVE_CONSOLEIO
#endif

/* ---------------------------------------------------- */

// data structure associated with the window
struct W16ConsoleStruc
{
  HWND hwnd;
  char buff[W16CONS_HEIGHT][W16CONS_WIDTH];
  int currow, curcol;
  int keybuff[W16CONS_KEYBUFF];
  int keycount;
  HFONT hfont;
  int fontisstock;
  int fontx, fonty;
  int indentx, indenty;
  int dispcols, disprows;
  int painting;
  int smoothsizing;
  int closeposted;
};

static char szClassName[32] = {0};
static unsigned int openWinCount = 0;
static HWND hwndList[1];

static struct
{
int     versionmajor;  // > 20 for winNT
int     versionminor;
HWND    hwnd;
W16ConsoleStruc *console;
FILE    *fstdout;
FILE    *fstdin;
int     hidden;
HICON   hIcon;     
int     iconisstock;
int     createflag;
int     asthread;
} constatics = {NULL,NULL,NULL,NULL,0,0,NULL,0,0};

typedef struct W16ConsoleStruc * W16CONP;

/* ---------------------------------------------------- */

#if (CLIENT_OS == OS_WIN32)
void __w16showerror(const char *caption)
{
  LPVOID lpMsgBuf;
  FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | 
     FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,
     GetLastError(),  0 /*MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT)*/, 
     (LPTSTR) &lpMsgBuf, 0, NULL );// Process any inserts in lpMsgBuf.
  MessageBox( NULL, (LPCTSTR)lpMsgBuf, caption, MB_OK | MB_ICONINFORMATION | MB_TASKMODAL );
  LocalFree( lpMsgBuf );
  return;
}  
#endif

void __w16writelog( const char *format, ... )
{
  va_list argptr;
  va_start(argptr, format);
  char buffer[128];
  vsprintf( buffer, format, argptr );
  va_end(argptr);
  FILE *f = fopen("debug.log","a+");
  if (!f) f = fopen("debug.log","w");
  if (f)
    {
    strcat(buffer,"\n");
    fwrite(buffer,strlen(buffer),1,f);
    fflush(f);
    fclose(f);
    }
  return;
}  

/* ---------------------------------------------------- */


static W16CONP __win16GetHwndConsole( HWND hwnd )
{
  #if (CLIENT_OS == OS_WIN32) || (CLIENT_OS == OS_WIN32S)
  return (W16CONP)GetWindowLong(hwnd, GWL_USERDATA);
  #else
  return (W16CONP)GetWindowLong(hwnd, 0);
  #endif
}

static W16CONP __win16SetHwndConsole( HWND hwnd, W16CONP console )
{
  #if (CLIENT_OS == OS_WIN32) || (CLIENT_OS == OS_WIN32S)
  return (W16CONP)SetWindowLong(hwnd, GWL_USERDATA, (LONG)console);
  #else
  return (W16CONP)SetWindowLong(hwnd, 0, (LONG)console);
  #endif
}

/* ---------------------------------------------------- */

#define __win16AssertHidden(x) (0)

#if 0
static int __win16AssertHidden(HWND hwnd)
{
  if (constatics.hidden && (IsWindowVisible(hwnd) || IsWindowEnabled(hwnd)))
    {
    SetWindowPos(hwnd,HWND_BOTTOM,0,0,0,0,
        (SWP_HIDEWINDOW|SWP_NOREDRAW|SWP_NOACTIVATE));
    RECT rect;
    GetWindowRect(hwnd,&rect);
    rect.right-=rect.left;
    rect.bottom-=rect.top;
    SetWindowPos(hwnd, NULL,-rect.right, -rect.bottom, 
       rect.right, rect.bottom, SWP_NOZORDER|SWP_NOACTIVATE|SWP_NOREDRAW);
    #if 0
    hwnd = GetTopWindow(GetDesktopWindow());
    if (hwnd) 
      {
      EnableWindow(hwnd,1);
      SetActiveWindow(hwnd);
      }
    #endif
    return 1;
    }
  return 0;
}
#endif

/* ---------------------------------------------------- */

static LRESULT __w16AdjustRect( W16CONP console, HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  int width = LOWORD(lParam);  //assume this is a WM_SIZE message
  int height = HIWORD(lParam);
  int adjx = (GetSystemMetrics(SM_CXFRAME) << 1);
  int adjy = (GetSystemMetrics(SM_CYFRAME) << 1) + 
              GetSystemMetrics(SM_CYCAPTION);

  console->disprows = W16CONS_HEIGHT;
  console->dispcols = W16CONS_WIDTH;
  wParam = wParam; //not used if not WM_SIZING

  #if defined(WM_SIZING)
  RECT *rectp = NULL;
  if (message == WM_SIZING)
    {
    rectp  = (RECT *) lParam;
    height = (rectp->bottom - rectp->top) - adjy;
    width  = (rectp->right - rectp->left) - adjx;

    message = WM_SIZE;
    //wParam specifies the edge of window being sized 
    }
  #endif

  if (message == WM_CREATE)
    {
    width = console->fontx * console->dispcols;
    height = console->fonty * console->disprows;
    }
    
  if (message == WM_SIZE || message == WM_PAINT || message == WM_CREATE)
    {
    RECT rect;
    GetWindowRect(hwnd, &rect);

    if (message == WM_PAINT) //dummy meaning wParam and lParam are invalid
      {                      
      width = (rect.right-rect.left) - adjx;
      height = (rect.bottom-rect.top) - adjy;
      }

    if (console->fontisstock == 0 || console->hfont == NULL) //_can_ adjust size
      {
      int newfonty  = ((height + (W16CONS_HEIGHT/2))/W16CONS_HEIGHT);
      int newfontx  = ((width + (W16CONS_WIDTH/2))/W16CONS_WIDTH);

      if (console->smoothsizing)
        {
        if ((newfonty * W16CONS_HEIGHT) != height)
          newfonty  = ((height+W16CONS_HEIGHT)/W16CONS_HEIGHT);
        if ((newfontx * W16CONS_WIDTH) != width)
          newfontx  = ((width+W16CONS_WIDTH)/W16CONS_WIDTH);
        }

      //if (console->hfont == NULL || newfontx != console->fontx || newfonty == console->fontx)
        {
        SIZE size;
        HFONT hfont = NULL;
        int isstock = 0;
        int i;
      
        for (i=0; (hfont == NULL && i<=5); i++)
          {
          if (i==0) //try to avoid a change of typeface if we can help it
            {
            if (console->hfont)
              {
              LOGFONT lfont;
              GetObject( console->hfont, sizeof(LOGFONT), (LPSTR) &lfont);
              lfont.lfHeight = newfonty; 
              lfont.lfWidth = newfontx;
              hfont = CreateFontIndirect(&lfont);
              isstock = 0;
              }
            }
          else if (i<4)
            {
            hfont = CreateFont( newfonty, newfontx, 0,0,300,0,0,0, 0, 
              ((i==3)?(0):(OUT_TT_PRECIS)), 
              ((i==2 || i==3)?(0):(CLIP_CHARACTER_PRECIS)), 
              ((i==1)?(PROOF_QUALITY):(0)), 
              FIXED_PITCH|FF_MODERN, "Courier New" );
            isstock = 0;
            }
          else if (i==4)
            {
            hfont = CreateFont( newfonty, newfontx,  0,0,0,0,0,0, 0, 
                            0, 0, 0, FIXED_PITCH|FF_MODERN, NULL );
            isstock = 0;
            }
          else //if (i==5) 
            {
            if (console->hfont == NULL)
              {
              hfont = (HFONT)GetStockObject(W16CONS_FONT);
              isstock = 1;
              }
            }
          if (hfont != NULL)
            {
            HDC hdc = GetDC(hwnd);
            HFONT hOldfont = SelectObject(hdc, hfont);
            GetTextExtentPoint(hdc, "X", 1, &size);
            SelectObject(hdc,hOldfont);
            ReleaseDC(hwnd, hdc);
            if (size.cx != newfontx || size.cy != newfonty)
              {
              if (!isstock)
                DeleteObject(hfont);
              hfont = NULL;
              }
            else
              {
              if (console->hfont && !console->fontisstock)
                DeleteObject(console->hfont);
              console->fontisstock = isstock;
              console->hfont = hfont;
              console->fontx = size.cx;
              console->fonty = size.cy;
              }
            }
          } /* for (i=0; (hfont == NULL && i<=5); i++) */
        }

      }
    if (console->hfont == NULL)
      return FALSE;

    //make width and height the adjusted window (not client) dimensions
    width  = console->dispcols * console->fontx + adjx;
    height = console->disprows * console->fonty + adjy;

    //if (__win16AssertHidden(hwnd))
    //  return TRUE;

    InvalidateRect(hwnd,NULL,TRUE);
 
    //if this a WM_SIZING message, then adjust the new size and return
    #if defined(WM_SIZING) 
    if (rectp != NULL && console->smoothsizing == 0) 
      {
      if (wParam == WMSZ_TOP || wParam == WMSZ_TOPRIGHT || wParam == WMSZ_TOPLEFT)
        rectp->top = rectp->bottom - height;
      if (wParam == WMSZ_BOTTOM || wParam == WMSZ_BOTTOMRIGHT || wParam == WMSZ_BOTTOMLEFT)
        rectp->bottom = rectp->top + height;
      if (wParam == WMSZ_TOPRIGHT || wParam == WMSZ_BOTTOMRIGHT || wParam == WMSZ_RIGHT)
        rectp->right = rectp->left + width;
      if (wParam == WMSZ_TOPLEFT || wParam == WMSZ_BOTTOMLEFT || wParam == WMSZ_LEFT)
        rectp->left = rectp->right - width;
      return TRUE;
      }
    #endif

    if (message == WM_CREATE || console->smoothsizing == 0)
      MoveWindow(hwnd, rect.left, rect.top, width, height, TRUE );

    if (message != WM_PAINT)
      UpdateWindow( hwnd );

    return TRUE;
    }
  return FALSE;
}    

/* ---------------------------------------------------- */

int __win16AdjustCaret(HWND hwnd, W16CONP console, int destroy_first )
{
  //if (hwnd == GetFocus())
    {
    if (destroy_first)
      DestroyCaret();

    if (console->smoothsizing == 0)
      {
      CreateCaret( hwnd, NULL, console->fontx, console->fonty / 6);
      SetCaretPos( console->indentx + console->curcol * console->fontx,
        console->indenty + (console->currow + 1) * console->fonty -(console->fonty / 6) );
      ShowCaret( hwnd );
      }
    else
      {
      RECT clirect;
      GetClientRect( hwnd, &clirect );
    
      int col = ( ((unsigned long)(clirect.right-clirect.left)) *
          ((unsigned long)(console->curcol)) ) / console->dispcols;
      int row = ( ((unsigned long)(clirect.bottom-clirect.top)) *
          ((unsigned long)(console->currow)) ) / console->disprows;
      int cwidth = (clirect.right-clirect.left) / console->dispcols;
      int cheight = (clirect.bottom-clirect.top) / console->disprows;
    
      CreateCaret( hwnd, NULL, cwidth, cheight / 6);
      SetCaretPos( col, row+(cheight-cheight/6) );
      ShowCaret( hwnd );
      }
    }
  return 0;
}

/* ---------------------------------------------------- */

LRESULT CALLBACK __w16WindowFunc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) 
{
  W16CONP console = __win16GetHwndConsole( hwnd );

  switch (message)
    {
    case WM_CREATE:
      {
      console = new W16ConsoleStruc;
      if (console)
        {
        // initialize our private structure
        memset((void *)console, 0, sizeof(W16ConsoleStruc));
        memset((void *)(&(console->buff[0][0])),' ',sizeof(console->buff));

        console->hwnd = hwnd;
        console->disprows = W16CONS_HEIGHT;
        console->dispcols = W16CONS_WIDTH;
        console->smoothsizing = 1;
        
        if ((constatics.versionmajor % 20) <= 3)
          console->smoothsizing = 0;

        #ifdef DEBUG_SIZING
        console->smoothsizing = 0;
        #endif

        console->fontx = (int)GetSystemMetrics(SM_CXFULLSCREEN);
        if (console->fontx < 700) /* 640x480 */ 
          { console->fontx =  6; console->fonty = 12; }
        else if (console->fontx < 900) /* 800x600 */  
          { console->fontx =  7; console->fonty = 15; }
        else                                 
          { console->fontx =  8; console->fonty = 18; }

        __w16AdjustRect( console, hwnd, WM_CREATE, 0, 0 );

        if (console->hfont == NULL)
          {
          delete console;
          constatics.createflag = 0;
          return -1;
          }

        __win16SetHwndConsole( hwnd, console );

        constatics.createflag = 1;
        break;
        }
      else
        {
        constatics.createflag = 0;
        // fail to create
        return -1;
        }
      }
    case WM_CLOSE:
      {
      SendMessage( hwnd, WM_CHAR, 0x03, 0 );
      break;
      }
    case WM_QUERYENDSESSION:
      {
      return TRUE; /* yes, we can terminate */
      }
    case WM_ENDSESSION:
      {
      if (wParam) /* yes, we are terminating */
        SendMessage( hwnd, WM_CHAR, 0x03, 0 );
      break;
      }
    case WM_DESTROY:
      {
      if (console)
        {
        if (console->hfont && !console->fontisstock)
          DeleteObject(console->hfont);
        delete console;
        }
      __win16SetHwndConsole( hwnd, NULL );
      PostQuitMessage(0);
      break;
      }
    case WM_ERASEBKGND:
      return 0; /* do it in WM_PAINT */
    case WM_PAINT:
      {
      if (IsIconic(hwnd) || !IsWindowVisible(hwnd))
        return DefWindowProc(hwnd, message, wParam, lParam);
      int done_paint=0;
      if (console)
        __w16AdjustRect( console, hwnd, WM_PAINT, 0, 0);
      if (IsWindowVisible(hwnd) && console && console->hfont)
        {
        PAINTSTRUCT ps;
        HDC paintdc = BeginPaint(hwnd, &ps);
        if (paintdc)
          {
          HDC hdc = paintdc;
          if (console->smoothsizing)
            hdc = CreateCompatibleDC( paintdc );
          if (hdc)
            {
            HFONT oldFont = (HFONT)SelectObject(hdc, console->hfont);
 
            RECT clirect, workrect;
            GetClientRect(hwnd, &clirect);
        
            SIZE size;
            GetTextExtentPoint(hdc, "X", 1, &size);
            console->fontx = size.cx;
            console->fonty = size.cy;
            workrect.top = workrect.left = 0;
            workrect.right = console->fontx * console->dispcols;
            workrect.bottom = console->fonty * console->disprows;

            HBITMAP newbmp = NULL;
            
            if (console->smoothsizing)
              newbmp = CreateCompatibleBitmap( hdc, 
                       workrect.right, workrect.bottom );
            if (console->smoothsizing == 0 || newbmp)
              {
              HBITMAP oldbmp = NULL;
              if (console->smoothsizing)
                oldbmp = SelectObject( hdc, newbmp );

             #define W16CONS_FORECOLOR RGB( 255,255,255 ) //GetSysColor(COLOR_HIGHLIGHTTEXT)
             #define W16CONS_BACKCOLOR RGB(   0,  0,127 ) //GetSysColor(COLOR_HIGHLIGHT)

              COLORREF oldTClr = SetTextColor(hdc, W16CONS_FORECOLOR );
              COLORREF oldBClr = SetBkColor(hdc, W16CONS_BACKCOLOR );
              int offsetrow = GetScrollPos(hwnd, SB_VERT);
              int offsetcol = GetScrollPos(hwnd, SB_HORZ);
              int row;
              for (row = 0; row < console->disprows; row++)
                {
                TextOut(hdc, console->indentx,
                             console->indenty + row * console->fonty,
                             &console->buff[offsetrow + row][offsetcol],
                             console->dispcols);
                }
              SetBkColor  ( hdc, oldBClr );
              SetTextColor( hdc, oldTClr );

              if (console->smoothsizing)
                {
                oldTClr = SetTextColor(paintdc, W16CONS_BACKCOLOR);
                oldBClr = SetBkColor(paintdc, W16CONS_FORECOLOR);
                if (clirect.right == workrect.right && 
                    clirect.bottom == workrect.bottom)
                  {
                  BitBlt(paintdc, 0, 0, clirect.right, clirect.bottom, 
                                              hdc, 0, 0, SRCCOPY);
                  }
                else
                  {
                  int oldbltmode = SetStretchBltMode( paintdc, STRETCH_ORSCANS );
                  StretchBlt( paintdc, 0, 0, clirect.right, clirect.bottom, 
                           hdc, 0, 0, workrect.right, workrect.bottom, SRCCOPY );
                  SetStretchBltMode( paintdc, oldbltmode );
                  }
                SetBkColor  ( paintdc, oldBClr );
                SetTextColor( paintdc, oldTClr );

                SelectObject( hdc, oldbmp );
                DeleteObject( newbmp );
                }
              done_paint = 1;
              }
            SelectObject( hdc, oldFont );
            if (console->smoothsizing)
              DeleteDC( hdc );
            }
          EndPaint(hwnd, &ps);
          }
        if (hwnd == GetFocus())
          __win16AdjustCaret(hwnd, console, 1);
        } /* if (console && console->hfont) */
      if (!done_paint) /* don't send more paint msgs if paint fails */
        ValidateRect(hwnd, NULL); 
      break;
      }
    case WM_GETMINMAXINFO:
      {
        {
        MINMAXINFO FAR * lpmmi = (MINMAXINFO FAR *) lParam;
        #if defined(__WINDOWS_386__) /* convert 16:16 pointer to 16:32 */
           lpmmi = (MINMAXINFO FAR *)MK_FP32( (void *)lpmmi ); 
        #endif
        
        lpmmi->ptMinTrackSize.x = (W16CONS_WIDTH * 2 +
                                  2 * GetSystemMetrics(SM_CXFRAME));
        lpmmi->ptMinTrackSize.y = (W16CONS_HEIGHT * 4 +
                                  2 * GetSystemMetrics(SM_CYFRAME) + 
                                  GetSystemMetrics(SM_CYCAPTION));
        lpmmi->ptMaxSize.x = 
        lpmmi->ptMaxTrackSize.x = (W16CONS_WIDTH * 12 +
                                  2 * GetSystemMetrics(SM_CXFRAME));
        lpmmi->ptMaxSize.y = 
        lpmmi->ptMaxTrackSize.y = (W16CONS_HEIGHT * 29 +
                                  2 * GetSystemMetrics(SM_CYFRAME) + 
                                  GetSystemMetrics(SM_CYCAPTION));
        }
      //InvalidateRect(hwnd, NULL, FALSE);
      break;
      }
    case WM_WINDOWPOSCHANGED:
    case WM_WINDOWPOSCHANGING:
      {
      WINDOWPOS FAR *pwp = (WINDOWPOS FAR *)lParam;
      #if defined(__WINDOWS_386__)
        pwp = (WINDOWPOS FAR *)(MK_FP32((void *)pwp));
      #endif
      if (constatics.hidden && (pwp->flags & SWP_SHOWWINDOW)!=0) 
        { 
        if (message == WM_WINDOWPOSCHANGING)
          {
          pwp->flags ^= SWP_SHOWWINDOW; 
          pwp->flags |= SWP_HIDEWINDOW; 
          }
        else
          ShowWindow(hwnd, SW_HIDE);
        return 0;
        }
      if (message == WM_WINDOWPOSCHANGING && console && 
        console->closeposted && !constatics.hidden)
        /*
        (pwp->cx < (W16CONS_WIDTH * 2 + 2 * GetSystemMetrics(SM_CXFRAME)) ||
         pwp->cy < (W16CONS_HEIGHT * 4 + 2 * GetSystemMetrics(SM_CYFRAME) 
                          + GetSystemMetrics(SM_CYCAPTION)) ) ) */
        {
        pwp->flags |= (SWP_NOMOVE|SWP_NOSIZE|SWP_NOREPOSITION|SWP_NOZORDER);
        return 0;
        }
      return DefWindowProc(hwnd, message, wParam, lParam);
      }
    #ifdef WM_SIZING
    case WM_SIZING:
    #endif
    case WM_SIZE:
      {
      if (console)
        {
        #if defined(WM_SIZING) && defined(__WINDOWS_386__)
        if (message == WM_SIZING)
          lParam = (LPARAM)(MK_FP32((void *)lParam));
        #endif
        //if (message == WM_SIZE && wParam == SIZE_MINIMIZED && 
        //  console->closeposted && !constatics.hidden)
        //  ShowWindow(hwnd,SW_RESTORE);
        return __w16AdjustRect( console, hwnd, message, wParam, lParam);
        }
      break;
      }
    case WM_RBUTTONUP:
      {
      if (!CheckExitRequestTriggerNoIO())
        {
        HMENU hmenu = CreatePopupMenu();
        POINT ptPos; ptPos.x = LOWORD(lParam); ptPos.y = HIWORD(lParam);
        if (hmenu)
          {
          #define IDM_SHUTDOWN 1
          #define IDM_RESTART  2
          #define IDM_PAUSE    3
          #define IDM_CONFIG   4
          #define IDM_FETCH    5
          #define IDM_FLUSH    6
          #define IDM_UPDATE   7
          #define IDM_BENCHRC5 8
          #define IDM_BENCHDES 9
          
          UINT showmode = ((CheckPauseRequestTrigger())?(MF_GRAYED):(MF_ENABLED));

          AppendMenu(hmenu, (ModeReqIsSet(MODEREQ_FLUSH)?(MF_GRAYED):(showmode)),
                            IDM_FLUSH, "Flush Blocks" );
          AppendMenu(hmenu, (ModeReqIsSet(MODEREQ_FETCH)?(MF_GRAYED):(showmode)),
                            IDM_FETCH, "Fetch Blocks" );
          AppendMenu(hmenu, (ModeReqIsSet(MODEREQ_FETCH|MODEREQ_FLUSH)?(MF_GRAYED):(showmode)),
                            IDM_FETCH, "Update Buffers (Fetch and Flush)" );
          AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
          AppendMenu(hmenu, (ModeReqIsSet(MODEREQ_CONFIG)?(MF_GRAYED):(showmode)),
                            IDM_CONFIG, "Configure" );
          AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
          AppendMenu(hmenu, (ModeReqIsSet(MODEREQ_BENCHMARK_RC5)?(MF_GRAYED):(showmode)),
                            IDM_BENCHRC5, "Benchmark RC5 core" );
          AppendMenu(hmenu, (ModeReqIsSet(MODEREQ_BENCHMARK_DES)?(MF_GRAYED):(showmode)),
                            IDM_BENCHDES, "Benchmark DES core" );
          AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
          AppendMenu(hmenu, MF_ENABLED, IDM_PAUSE, 
                 ((CheckPauseRequestTriggerNoIO())?("Continue"):("Pause")));
          AppendMenu(hmenu, MF_ENABLED, IDM_RESTART, "Restart");
          AppendMenu(hmenu, MF_ENABLED, IDM_SHUTDOWN, "Shutdown");
          ClientToScreen(hwnd, &ptPos);
          TrackPopupMenu(hmenu, TPM_LEFTALIGN, ptPos.x, ptPos.y, 0, hwnd, NULL);
          DestroyMenu(hmenu);
          }
        }
      break;
      }
    case WM_COMMAND:
      {
      if (wParam == IDM_CONFIG)
        ModeReqSet(MODEREQ_CONFIG | MODEREQ_CONFRESTART);
      else if (wParam == IDM_FETCH)
        ModeReqSet(MODEREQ_FETCH|MODEREQ_FFORCE);
      else if (wParam == IDM_FLUSH)
        ModeReqSet(MODEREQ_FLUSH|MODEREQ_FFORCE);
      else if (wParam == IDM_UPDATE)
        ModeReqSet(MODEREQ_FETCH|MODEREQ_FLUSH|MODEREQ_FFORCE);
      else if (wParam == IDM_BENCHRC5)
        ModeReqSet(MODEREQ_BENCHMARK_RC5|MODEREQ_BENCHMARK_QUICK);
      else if (wParam == IDM_BENCHDES)
        ModeReqSet(MODEREQ_BENCHMARK_DES|MODEREQ_BENCHMARK_QUICK);
      else if (wParam == IDM_SHUTDOWN)
        PostMessage( hwnd, WM_CHAR, 0x03, 0 );
      else if (wParam == IDM_RESTART)
        RaiseRestartRequestTrigger();
      else if (wParam == IDM_PAUSE)
        {
        if (CheckPauseRequestTriggerNoIO())
          ClearPauseRequestTrigger();
        else
          RaisePauseRequestTrigger();
        }
      break;
      }
    case WM_CHAR:
      {
      if (console)
        {
        if (((int)(wParam)) == 0x03)
          {
          if (console->keycount >= W16CONS_KEYBUFF)
            console->keycount = W16CONS_KEYBUFF - 1;
          if (console->keycount > 0)
            memmove(&console->keybuff[1], &console->keybuff[0],
              console->keycount * sizeof(int));
          console->keybuff[0] = (int) wParam;
          console->closeposted = 1;
          }
        else if (console->keycount < W16CONS_KEYBUFF)
          {
          console->keybuff[console->keycount++] = (int) wParam;
          }
        else
          {
          // beep, keyboard buffer full
          MessageBeep(MB_OK);
          }
        }
      break;
      }
    case WM_SETFOCUS:
      {
      if (console)
        {
        __win16AdjustCaret(console->hwnd, console, 0 );
        InvalidateRect(hwnd, NULL, FALSE);
        }
      break;
      }
    case WM_KILLFOCUS:
      {
      if (console)
        DestroyCaret();
      break;
      }
    case WM_USER:
      {
      if (!console)
        {
        //__w16writelog("WM_USER 0x%04x called when no console.", (int)wParam);
        return -1;
        }
      switch (wParam)
        {
        case W16CONS_CMD_CLEARSCREEN:
          {
          memset((void *)(&(console->buff[0][0])),' ',sizeof(console->buff));
          console->currow = 0;
          console->curcol = 0;
   
          InvalidateRect(hwnd, NULL, TRUE);
          UpdateWindow(hwnd);
          break;
          }
        case W16CONS_CMD_PRINTSTR:
          {
          char ch;
          const char *text = (const char *)lParam;
            
          do{
            // check the validity of the current
            // cursor position, scrolling the window if necessary.
    
            if (console->currow < 0)
              console->currow = console->curcol = 0;
            else if (console->curcol < 0)
              console->curcol = 0;
            if (console->curcol >= W16CONS_WIDTH)
              {
              console->curcol = 0;
              console->currow++;
              }
            if (console->currow >= W16CONS_HEIGHT)
              {
              memmove( &(console->buff[0][0]), 
                      (&(console->buff[0][0])) + W16CONS_WIDTH, 
                        sizeof(console->buff) - W16CONS_WIDTH );
              //for (len = 0; len < W16CONS_HEIGHT - 1; len++)
              //  memmove(console->buff[len], console->buff[len+1], W16CONS_WIDTH);
              memset( &(console->buff[W16CONS_HEIGHT-1][0]),' ',W16CONS_WIDTH);
              console->currow = W16CONS_HEIGHT - 1;
              console->curcol = 0;
              }
                
            //update the screen buffer
              
            ch = *text++;
            if (!ch)
              break;
            if (ch == 0x0A)         /* \n  new-line */
              { console->currow++; console->curcol = 0; }
            else if (ch == 0x0D)   /* \r    carriage return */
              console->curcol = 0;
            else if (ch == '\t')   /* \t    horizontal tab  */
              console->curcol += (console->curcol%8);
            else if (ch == '\a')   /* \a  bell (alert)      */
              MessageBeep(MB_OK);
            else if (ch == '\f')   /* \f    form-feed       */
              {
              memset((void *)(&(console->buff[0][0])),' ',sizeof(console->buff));
              console->currow = 0;
              console->curcol = 0;
              }
            else if (ch == '\b')   /* \b  backspace         */
              { if (console->curcol > 0) console->curcol--; }
            else if (ch == '\v')   /* \v  vertical tab      */
              console->currow++;
            else if (ch <= 26  )   /* don't print other ctrl-chars */
              ;
            else
              {
              console->buff[console->currow][console->curcol++] = ch;
              }
            } while (ch); /* always true */
  
          // force repaint
          InvalidateRect(hwnd, NULL, TRUE);
          UpdateWindow(hwnd);
          break;
          }
        case W16CONS_CMD_ISKBHIT:
          {
          return ((console->keycount > 0)?(1):(0));
          }
        case W16CONS_CMD_SETPOS:
          {
          int row = LOWORD(lParam);
          int col = HIWORD(lParam);
    
          if (row < 0)                       
            row = 0;
          else if (row >= W16CONS_HEIGHT)    
            row = W16CONS_HEIGHT;
          if (col < 0)                       
            col = 0;
          else if (col >= W16CONS_WIDTH)     
            col = W16CONS_WIDTH;

          console->currow = row;
          console->curcol = col;
          
          if (hwnd == GetFocus())
            __win16AdjustCaret(hwnd, console, 1 );
          break;
          }
        case W16CONS_CMD_GETCH:
          {
          LRESULT keyval = 0;
          if (console->keycount > 0)
            {
            keyval = (LRESULT)console->keybuff[0];
            if ((--console->keycount) > 0)
            memmove(&console->keybuff[0], &console->keybuff[1],
                console->keycount * sizeof(console->keybuff[0]));
            }
          return keyval;
          }
        }
      break;
      }
    #if 0
    case WM_NCCALCSIZE:
    case WM_NCPAINT:
    case WM_MOVE:
    #endif
    case WM_NCACTIVATE:
    case WM_ACTIVATE:
      {
      LRESULT x = DefWindowProc(hwnd, message, wParam, lParam);
      InvalidateRect(hwnd, NULL, FALSE);
      UpdateWindow(hwnd);
      return x;
      }
    default:
      {
      return DefWindowProc(hwnd, message, wParam, lParam);
      }
    }
  return 0;
}

/* ------------------------------------------------ */

void w16Yield(void)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.asthread)
    {
    Sleep(SLEEP_FACTOR);
    return;
    }
  #endif

  static int yielding = 0;
  int did_yield = 0, doclose = 0;
  MSG msg;
  ++yielding;
    {
    HWND hwnd = NULL;
    //#if (CLIENT_OS == OS_WIN32)
    //  hwnd = hwndList[0];
    //#endif
    while (openWinCount && PeekMessage(&msg, hwnd, 0, 0, PM_REMOVE ))
      {
      doclose = (msg.message == WM_CLOSE || msg.message == WM_DESTROY || 
                (msg.message == WM_ENDSESSION && msg.wParam!=0) ||
                (msg.message == WM_CHAR && msg.wParam == 0x03));
      if (doclose && yielding==1)
        {
        RaiseExitRequestTrigger();
        CheckExitRequestTrigger();
        }
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      did_yield = 1;
      if (doclose)
        break;
      #if (CLIENT_OS == OS_WIN32)
        Sleep(SLEEP_FACTOR);
      #endif
      }
    }
  --yielding;
  if (!did_yield && !doclose)
    {
    #if (CLIENT_OS == OS_WIN32)
      Sleep(SLEEP_FACTOR);
    #else
      Yield();
    #endif
    }
  return;
}

/* ------------------------------------------------ */

void w16Sleep(unsigned int millisecs)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.asthread)
    {
    Sleep(millisecs);
    return;
    }
  #endif

  DWORD next, diff, last = GetTickCount();
  do{
    w16Yield();
    next = diff = GetTickCount();
    if (next < last)
      diff += -last;
    else
      diff -= last;
    last = next;
    if (diff > millisecs)
      diff = millisecs;
    millisecs -= diff;
    } while (millisecs);
  return;    
}

/* ------------------------------------------------ */

struct helperArg
{
  int nCmdShow;
  int nSuccess;
  int asthread;
  HWND hwnd;
  HINSTANCE hInstance;
};
  
/* ------------------------------------------------ */

static void __win16WinCreateHelper( void *xarg )
{
  struct helperArg *arg = (struct helperArg *)(xarg);

  int nCmdShow = arg->nCmdShow;
  int asthread = arg->asthread;
  HINSTANCE hInstance = arg->hInstance;
  LPCSTR wintitle;
  HWND hwnd;  
  MSG msg;

  wintitle = "console";
  if (winGetInstanceArgv())
    wintitle = (LPCSTR)(winGetInstanceArgv()[0]);

  constatics.createflag = -1;
  /* create a window using that class */
  hwnd = CreateWindowEx( 0, szClassName, wintitle, WS_OVERLAPPEDWINDOW,
         CW_USEDEFAULT, nCmdShow, 0, 0, 
         HWND_DESKTOP, NULL, hInstance, NULL );

  if (hwnd == NULL)
    {
    arg->nSuccess = 0;
    return;
    }

  /* display the window */
  ShowWindow(hwnd, nCmdShow /* SW_SHOW */);
  UpdateWindow(hwnd);

  while (constatics.createflag == -1)
    {
    #if (CLIENT_OS == OS_WIN32)
    Sleep(SLEEP_FACTOR);
    #else
    Yield();
    #endif
    }
    
  if (constatics.createflag == 0)
    {
    DestroyWindow(hwnd);
    arg->nSuccess = 0;
    return;
    }
    
  arg->hwnd = hwnd;
  arg->nSuccess = 1;

  if (asthread)
    {
    #if (CLIENT_OS == OS_WIN32)
      {
      SetPriorityClass( GetCurrentProcess(), NORMAL_PRIORITY_CLASS );
      SetThreadPriority( GetCurrentThread(), THREAD_PRIORITY_NORMAL );
      }
    #endif
    while (GetMessage(&msg, (HWND) NULL, 0, 0)) 
      {
      if ((msg.message == WM_CHAR && msg.wParam == 0x03))
        RaiseExitRequestTrigger();
      else
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
      }
    }

  return;
}

/* ------------------------------------------------ */

int w16ConsoleCreate(int nCmdShow)
{
  struct helperArg arg;
  WNDCLASS wcl;
  
  arg.hInstance = winGetInstanceHandle(); /* w32pre.cpp */

  if (!arg.hInstance)
    return 0;
  if (openWinCount == (sizeof(hwndList)/sizeof(hwndList[0])))
    return 0;

  if (szClassName[0]==0)
    {
    constatics.hIcon = LoadIcon(arg.hInstance, MAKEINTRESOURCE(1));
    constatics.iconisstock = 0;
    if (!constatics.hIcon)
      {
      LoadIcon(arg.hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
      constatics.iconisstock = 1;
      }

    strcpy(szClassName,"DCTICLI");
    //#ifdef __WINDOWS_386__ //win16
    //sprintf( szClassName, "DCTI%u", arg.hInstance );
    //#endif

    /* define a window class */
    wcl.hInstance = arg.hInstance;
    wcl.lpszClassName = szClassName;
    wcl.lpfnWndProc = (WNDPROC)__w16WindowFunc; 
    wcl.style = 0; //( CS_HREDRAW | CS_VREDRAW | CS_SAVEBITS |
                  ///*CS_BYTEALIGNCLIENT |*/ CS_BYTEALIGNWINDOW );
                /*(((constatics.versionmajor%20) >= 4)?(0): */
    wcl.hIcon = constatics.hIcon;
    wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcl.lpszMenuName = NULL;
    wcl.cbClsExtra = 0;
    wcl.cbWndExtra = sizeof(void *); /* we need space for a pointer */
    wcl.hbrBackground = NULL; /* winproc does the background painting */

    /* register the window class */
    if (!RegisterClass(&wcl)) 
      {
      szClassName[0]=0;
      if (!constatics.iconisstock)
        DestroyIcon( constatics.hIcon );
      constatics.hIcon = NULL;
      return 0;
      }
    }
  
  arg.nSuccess = -1;
  arg.nCmdShow = nCmdShow;
  arg.asthread = 0;

  #if (CLIENT_OS == OS_WIN32)
  constatics.asthread = arg.asthread = 1;
  if (_beginthread( __win16WinCreateHelper, 512, (void *)&arg  ) == NULL)
    arg.nSuccess = 0;
  #endif
  if (arg.asthread == 0)
    __win16WinCreateHelper( (void *)&arg );

  while (arg.nSuccess == -1)
    w16Yield();

  if (arg.nSuccess == 0)    
    {
    if (openWinCount == 0 && szClassName[0])
      {
      if (UnregisterClass( szClassName, arg.hInstance ) == 0)
        {
        szClassName[0] = 0;
        if (constatics.hIcon && !constatics.iconisstock)
          DestroyIcon( constatics.hIcon );
        constatics.hIcon = NULL;
        }
      }
    constatics.asthread = 0;
    return 0;
    }

  hwndList[openWinCount++] = arg.hwnd;
  return 1;
}    

/* ------------------------------------------------ */

int w16ConsoleDestroy(void)
{
  HINSTANCE hInstance;
  
  if (openWinCount)
    {
    hInstance = winGetInstanceHandle(); /* w32pre.cpp */
    if (hInstance)
      {
      openWinCount--;
      HWND hwnd = hwndList[openWinCount];
      if (hwnd && szClassName[0])
        {
        hwndList[openWinCount] = NULL;

        if (IsWindow(hwnd))
          ShowWindow( hwnd, SW_HIDE );
        if (IsWindow(hwnd))
          DestroyWindow( hwnd );
    
        #if 0 //this does not work! (and causes a restart to fail)
        if (openWinCount == 0 && szClassName[0])
          {
          if (UnregisterClass( szClassName, hInstance ) == 0)
            {
            szClassName[0] = 0;
            if (constatics.hIcon && !constatics.iconisstock)
              DestroyIcon( constatics.hIcon );
            constatics.hIcon = NULL;
            }
          }
        #endif
        }
      return 1;
      }
    }
  return 0;
}  

/* ------------------------------------------------ */

void w16SetConsoleTitle(const char *name)
{
  w16Yield();
  if (openWinCount == 0 || hwndList[0] == NULL)
    return;

  SetWindowText( hwndList[0], (LPSTR)name );
}  

/* ------------------------------------------------ */

int w16ConsoleClear(void)
{
  w16Yield();
  if (openWinCount == 0 || hwndList[0] == NULL)
    return 0;
  SendMessage( hwndList[0], WM_USER, W16CONS_CMD_CLEARSCREEN, 0 );
  return 1;
}

/* ------------------------------------------------ */

int w16ConsolePrint(const char *text)
{
  unsigned int len;
  w16Yield();
  if (openWinCount == 0 || hwndList[0] == NULL)
    return -1;
  if (!text)
    return -1;
  if ((len = strlen(text)) == 0)
    return 0;
  SendMessage( hwndList[0], WM_USER, W16CONS_CMD_PRINTSTR, (LPARAM)(text) );
  return len;
}  

/* ------------------------------------------------ */

int w16ConSetPos(int col, int row)
{
  w16Yield();
  if (openWinCount == 0 || hwndList[0] == NULL)
    return 0;
  SendMessage( hwndList[0], WM_USER, W16CONS_CMD_SETPOS, MAKELONG(col, row));
  return 0;
}

/* ------------------------------------------------ */

int w16ConGetSize( int *width, int *height)
{
  if (openWinCount == 0 || hwndList[0] == NULL)
    return -1;
  if (height) *height = W16CONS_HEIGHT;
  if (width) *width = W16CONS_WIDTH;
  return 0;
}  

/* ------------------------------------------------ */

int w16ConsoleKbhit(void)
{
  w16Yield();
  if (openWinCount == 0 || hwndList[0] == NULL)
    return 0;
  return SendMessage( hwndList[0], WM_USER, W16CONS_CMD_ISKBHIT, 0 );
}

/* ------------------------------------------------ */

int w16ConsoleGetch(void)
{
  LRESULT keyval = 0; 

  do{
    w16Yield();
    if (openWinCount == 0 || hwndList[0] == NULL) 
      break;
    keyval = SendMessage( hwndList[0], WM_USER, W16CONS_CMD_GETCH, 0 );
    } while (keyval == 0);

  if (keyval == -1) /* no console */
    keyval = 0;
  
  return (int)keyval;
}  
      
/* ===================================================== */

int w32DeinitializeConsole(void)
{
  #if !defined(NEEDVIRTUALMETHODS)
    {
    #ifdef USE_NATIVE_CONSOLEIO
      {
      if (constatics.hwnd)
        FreeConsole();
      constatics.hwnd = NULL;
      if (constatics.fstdout)
        fclose(constatics.fstdout);
      constatics.fstdout = NULL;
      if (constatics.fstdin)
        fclose(constatics.fstdin);
      constatics.fstdin = NULL;
      }
    #else
      {
      if (constatics.hwnd)
        w16ConsoleDestroy();
      constatics.hwnd = NULL;
      }
    #endif
    }
  #endif

  return 0;
}

/* ---------------------------------------------------- */

int w32InitializeConsole(int runhidden)
{
  const char *wintitle = "distributed.net RC5DES client"; //CLICONS_LONGNAME; //we need this often
  int retcode = 0;

  DWORD dwVersion = GetVersion();
  constatics.versionmajor = LOBYTE(LOWORD(dwVersion));
  constatics.versionminor = HIBYTE(LOWORD(dwVersion));  
  //build number in (HIWORD(dwVersion) & 0x7FFF) in all but plain win3x

  if (constatics.versionmajor == 3 && constatics.versionminor >=95)
    {
    constatics.versionmajor = 4;
    constatics.versionminor = 1;
    }
  else if (dwVersion < 0x80000000) //winNT or win3x without win32s
    {
    if ( GetModuleHandle("KERNEL32") )
      constatics.versionmajor += 20;
    }

  // win32 clients have a mutex created/locked in winmain/realmain.
  // so this is only required for win16
  if (constatics.versionmajor < 4)
    {
    if ( FindWindow( NULL, wintitle ) != NULL)
      retcode = -1;
    }

  #if (CLIENT_OS == OS_WIN32)
  if (retcode == 0)
    {
    if (constatics.versionmajor >= 4 && constatics.versionmajor < 20)
      win32CliInitializeService(0,NULL); //initializes if we are a win9x svc
    }
  #endif

  if (retcode == 0)
    {
    constatics.hidden = runhidden;

    //the win32 console client is really a GUI client without a GUI - cyrus
    #ifndef USE_NATIVE_CONSOLEIO
      {
      int nCmdShow = winGetInstanceShowCmd();
      if (runhidden)
        nCmdShow = SW_HIDE | WS_DISABLED;
      if (!w16ConsoleCreate(nCmdShow))
        {
        retcode = -1;
        if (!runhidden)
          MessageBox( NULL, "Unable to create console window.",
                              wintitle, MB_OK | MB_TASKMODAL);
        }
      else
        {
        w16SetConsoleTitle(wintitle);
        constatics.hwnd = FindWindow( NULL, wintitle );
        }
      }
    #elif (!defined(NEEDVIRTUALMETHODS))
      {
      if (runhidden)
        {
        //nothing - console won't be created
        retcode = 0;
        }
      else if (!AllocConsole())
        {
        retcode = -1;
        MessageBox( NULL, "Unable to create console window.",
                              wintitle, MB_OK | MB_TASKMODAL);
        }
      else
        {
        retcode = 0;
        SetConsoleTitle(wintitle);
        Sleep(40); //Delay needed for title to update
        constatics.hwnd = FindWindow( NULL, wintitle );
          
        // Now re-map the C Runtime STDIO handles
        #define _IOINIT_METHOD 2

        #if (_IOINIT_METHOD == 1)
          {
          //microsoft method - 
          //http://support.microsoft.com/support/kb/articles/q105/3/05.asp
          //fails on win98 (_fdopen fails)
   
          int hCrt = _open_osfhandle((long)GetStdHandle(STD_OUTPUT_HANDLE), _O_TEXT);
          FILE *hf = _fdopen(hCrt, "w");
          *stdout = *hf;
          setvbuf(stdout, NULL, _IONBF, 0);         
          hCrt = _open_osfhandle((long)GetStdHandle(STD_ERROR_HANDLE), _O_TEXT);
          hf = _fdopen(hCrt, "w");
          *stderr = *hf;
          setvbuf(stderr, NULL, _IONBF, 0);         
          hCrt = _open_osfhandle((long)GetStdHandle(STD_INPUT_HANDLE), _O_TEXT);
          hf = _fdopen(hCrt, "r");
          *stdin = *hf;
          setvbuf(stdin, NULL, _IONBF, 0);
          }
        #elif (_IOINIT_METHOD == 2)
          {
          //this is my own pudding - cyrus
          //works on win98 (at least when the compiler is from watcom)
   
          FILE *hf;
          hf = fopen("CONOUT$", "w+t");
          if (!hf)
            {
            MessageBox( NULL, "Unable to open console for write.",
                      wintitle, MB_OK | MB_TASKMODAL | MB_ICONERROR);
            retcode = -1;
            }
          else
            {
            constatics.fstdout = hf;
 
            *stdout = *hf;
            setvbuf(stdout, NULL, _IONBF, 0);
            *stderr = *hf;
            setvbuf(stderr, NULL, _IONBF, 0);
               
            hf = fopen("CONIN$", "rt");
            if (!hf)
              {
              MessageBox( NULL, "Unable to open console for read.",
                 wintitle, MB_OK | MB_TASKMODAL | MB_ICONERROR);
              retcode = -1;
              }
            else
              {
              constatics.fstdin = hf;
 
              *stdin = *hf;
              setvbuf(stdin, NULL, _IONBF, 0);
              }
            } 
          }
        #elif (_IOINIT_METHOD == 3)
          {
          SECURITY_ATTRIBUTES sa;
          sa.nLength      = sizeof(SECURITY_ATTRIBUTES);
          sa.lpSecurityDescriptor = NULL;
          sa.bInheritHandle   = TRUE;
   
          HANDLE hIFile = CreateFile( "CONIN$", GENERIC_READ /*dwDesiredAccess*/, 
          FILE_SHARE_READ /*dwShareMode*/, &sa /*lpSecurityAttributes*/,
          OPEN_EXISTING /*dwCreationDistribution*/, 0 /*dwFlagsAndAttributes*/,
          0 /*hTemplateFile*/ );
          HANDLE hOFile = CreateFile( "CONOUT$", GENERIC_WRITE /*dwDesiredAccess*/, 
          FILE_SHARE_WRITE /*dwShareMode*/, &sa /*lpSecurityAttributes*/,
          OPEN_EXISTING /*dwCreationDistribution*/, 0 /*dwFlagsAndAttributes*/,
          0 /*hTemplateFile*/ );
   
          SetStdHandle( STD_OUTPUT_HANDLE, hOFile );
          SetStdHandle( STD_ERROR_HANDLE, hOFile );
          SetStdHandle( STD_INPUT_HANDLE, hIFile );
          }
        #endif
        } //runhidden or not
      }
    #else // defined(NEEDVIRTUALMETHODS)
      {
      #if 0
      SetConsoleTitle(wintitle);
 
      constatics.hwnd = FindWindow( NULL, wintitle );
           
      if (!runhidden)
        {
        //nothing - screen is already visible
        }
      else if (constatics.hwnd)
        {
        RECT rc;
        GetClientRect( GetDesktopWindow(), &rc );
        SetWindowPos( hwnd, HWND_BOTTOM, 0, 
                             rc.bottom+1, 0, 0, SWP_HIDEWINDOW);
        }
      #endif
      }
    #endif
    } //if (retcode == 0)

  if (retcode == 0)
    CliSetupSignals(); // Need to rehook the console control handler

  return (retcode);
}
 
/* ---------------------------------------------------- */

int w32ConShowWindow(void)  /* activate client window if not -hidden */
{
  if (!constatics.hwnd || constatics.hidden)
    return -1;
  ShowWindow(constatics.hwnd, SW_SHOW);
  return 0;
}

/* ---------------------------------------------------- */

int w32ConKbhit(void)
{
  #ifdef USE_NATIVE_CONSOLEIO
  return (kbhit());
  #else
  return w16ConsoleKbhit();
  #endif
}  

/* ---------------------------------------------------- */

int w32ConGetch(void)
{
  #ifdef USE_NATIVE_CONSOLEIO
  return (kbhit());
  #else
  return w16ConsoleGetch();
  #endif
}

/* ---------------------------------------------------- */

int w32ConOut(const char *text)
{
  #ifdef USE_NATIVE_CONSOLEIO
  int i = fwrite( text, sizeof(char), strlen(text), stdout);
  fflush(stdout);
  return i;
  #else
  return w16ConsolePrint(text);
  #endif
}

/* ---------------------------------------------------- */

int w32ConIsScreen(void)
{
  if (constatics.hwnd && !constatics.hidden)
    {
    #ifdef NEEDVIRTUALMETHODS
    return 1;
    #elif defined(USE_NATIVE_CONSOLEIO)
    return (isatty(fileno(stdout)) && isatty(fileno(stdin)));
    #else
    return 1;
    #endif
    }
  return 0;
}

/* ---------------------------------------------------- */

void w32Yield(void)
{
  #ifdef USE_NATIVE_CONSOLEIO    
    Sleep(SLEEP_FACTOR);
  #else
    w16Yield();
  #endif
  return;
}

/* ---------------------------------------------------- */

void w32Sleep(unsigned int millisecs)
{
  #ifdef USE_NATIVE_CONSOLEIO    
    Sleep(millisecs);
  #else
    w16Sleep(millisecs);
  #endif
}

/* ---------------------------------------------------- */

int w32ConSetPos(int col, int row)
{
  #ifdef USE_NATIVE_CONSOLEIO
    COORD newpos = {col,row};
    SetConsoleCursorPosition( GetStdHandle(STD_OUTPUT_HANDLE), newpos );
  #else
    w16ConSetPos(col,row);    
  #endif
  return 0;
}

/* ---------------------------------------------------- */

int w32ConGetSize( int *width, int *height)
{
  if (!constatics.hwnd || constatics.hidden)
    return -1;

  #ifdef USE_NATIVE_CONSOLEIO
  HANDLE hStdout;
  CONSOLE_SCREEN_BUFFER_INFO csbiInfo;

  hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
  if (hStdout == INVALID_HANDLE_VALUE) return -1;
  if (! GetConsoleScreenBufferInfo(hStdout, &csbiInfo)) return -1;
  if (height) *height = csbiInfo.srWindow.Bottom - csbiInfo.srWindow.Top + 1;
  if (width) *width = csbiInfo.srWindow.Right - csbiInfo.srWindow.Left + 1;
  #else
  if (w16ConGetSize( width, height ))
    return -1;
  #endif
  return 0;
}

/* ---------------------------------------------------- */

int w32ClearScreen(void)
{
  if (!constatics.hwnd || constatics.hidden)
    return -1;
  #ifdef USE_NATIVE_CONSOLEIO    
    {
    HANDLE hStdout;
    CONSOLE_SCREEN_BUFFER_INFO csbiInfo;
    DWORD nLength;
    COORD topleft = {0,0};
    DWORD temp;
    hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
    if (hStdout == INVALID_HANDLE_VALUE) 
      return -1;
    if (! GetConsoleScreenBufferInfo(hStdout, &csbiInfo)) 
      return -1;
    nLength = csbiInfo.dwSize.X * csbiInfo.dwSize.Y;
    SetConsoleCursorPosition(hStdout, topleft);
    FillConsoleOutputCharacter(hStdout, (TCHAR) ' ', nLength, topleft, &temp);
    FillConsoleOutputAttribute(hStdout, csbiInfo.wAttributes, nLength, topleft, &temp);
    SetConsoleCursorPosition(hStdout, topleft);
    }
  #else
    {
    if (!w16ConsoleClear())
      return -1;
    }
  #endif
  return 0;
}

/* ---------------------------------------------------- */
