// Copyright distributed.net 1997-1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: selftest.cpp,v $
// Revision 1.31  1998/10/26 03:14:27  cyp
// Version fun.
//
// Revision 1.3  1998/10/20 07:24:08  silby
// Change an unsigned int to an int so that a type conversion was not necessary on the return.
//
// Revision 1.2  1998/10/11 00:45:31  cyp
// SelfTest() is now standalone. Modified to use the same contest numbering
// conventions used everywhere else, ie 0==RC5, 1==DES.
//
// Revision 1.1  1998/08/28 21:28:59  cyp
// Spun off from client.cpp - this code very rarely changes.
//
//

#if (!defined(lint) && defined(__showids__))
const char *selftest_cpp(void) {
return "@(#)$Id: selftest.cpp,v 1.31 1998/10/26 03:14:27 cyp Exp $"; }
#endif

// --------------------------------------------------------------------------

#include "cputypes.h"
#include "baseincs.h"  // standard #includes
#include "problem.h"   // Problem class
#include "convdes.h"   // convert_key_from_des_to_inc 
#include "triggers.h"  // CheckExitRequestTriggerNoIO()
#include "network.h"   // ntohl()/htonl()
#include "logstuff.h"  // LogScreen()
#include "clicdata.h"  // CliGetContestNameFromID() 

// --------------------------------------------------------------------------

#define TEST_CASE_COUNT 32

// note this is in .lo, .hi, .lo... order...

// RC5-32/12/8 test cases -- generated by gentests64.cpp:
static const u32 rc5_test_cases[TEST_CASE_COUNT][8] = {
  {0x9CC718F9L,0x82E51B9FL,0xF839A5D9L,0xC41F78C1L,0x20656854L,0x6E6B6E75L,0xB74BE041L,0x496DEF29L},
  {0xAD53E9EEL,0x503307FFL,0x801617EFL,0xD692CED8L,0x9E8077E3L,0x0DFB3219L,0x5C3DDEFEL,0x8352F7E8L},
  {0x0DBF2929L,0xE03E6FC8L,0xE7DBE5BFL,0x7B751357L,0xFC2D9B0EL,0xC5EAAA09L,0x376AEAD6L,0x4A7C9366L},
  {0xA17777A1L,0x02C1E29BL,0xF1AA7427L,0xE68AD1B4L,0x1E17F769L,0x39A94DB1L,0x78CFF380L,0x53803F15L},
  {0xD2725B6FL,0xDE74A850L,0x412D03CEL,0x0B4E5828L,0x97EEF36CL,0xD64AC9C5L,0x63B95CC3L,0x317A694BL},
  {0xC96A1F6AL,0x5DD2CB81L,0x3ED3951FL,0xA0FEBBACL,0xC8E05F32L,0xCF4F69ACL,0xFD354429L,0x3B484423L},
  {0x70D8CB2EL,0x28121486L,0x0BC8EB42L,0x1A98CAF8L,0xD6B4200EL,0x5A52D62DL,0x0C108DFAL,0x8586C175L},
  {0x6FF52A11L,0xA82E0B78L,0x8FFA8420L,0xADD71687L,0xA4AAA33AL,0xBB16D7CBL,0x15D7D840L,0xE49390DBL},
  {0x2FBAC32EL,0x07E0FA31L,0x6D15A362L,0x503AF090L,0xC2C33AF0L,0xBB46A730L,0x5CD685C4L,0xEE8923ADL},
  {0xD9E0DF5EL,0x2C9FEA4AL,0x0C864872L,0xB6FD690EL,0x7C11D122L,0xD634A7ADL,0xE61CB70FL,0xF648AB05L},
  {0x56DF8939L,0xC2A5A41AL,0x8F7B3577L,0x541C52B8L,0xDF866B91L,0x8865735EL,0x79744D69L,0x136B18BBL},
  {0x4FF28818L,0x31EBB0BDL,0xDCE0E95CL,0x61563C09L,0x0B72DC92L,0x41E67F05L,0x9A6CE9DCL,0x19501B69L},
  {0x2E106515L,0xA32A5709L,0x9962A7C9L,0xD0277838L,0x980DE39EL,0xA92C58E6L,0x8C51EC30L,0x9E132667L},
  {0x1BF46B08L,0xFFDBA499L,0x296F7027L,0x57CC173FL,0xA3E5327DL,0x35DDB044L,0x573076F0L,0xF5926ACEL},
  {0xFE15A18BL,0xEF365EC6L,0xB233039FL,0x6B43EBD7L,0x7D833BA5L,0xBE32181AL,0xBED66A62L,0x3569D778L},
  {0x83AED0F6L,0xDD360FA8L,0x1A9BE31BL,0x40478379L,0x66DA385EL,0x4FC79A9CL,0x46CF6792L,0x32F61EFDL},
  {0x10B68262L,0xF193FF18L,0x04555142L,0xCC56315EL,0xECB8D9D9L,0xF6D6F5E0L,0x356ACF47L,0x8256B2B6L},
  {0xCFE700A9L,0x14C538B0L,0xD6CD4C7FL,0xC4AE077FL,0xF235A559L,0xA86AA7A7L,0x8FB2C30BL,0x7865C1BDL},
  {0xAABA5363L,0xEF0783C8L,0xB63197FAL,0x9D4BD494L,0x5522F33AL,0xDA7E541AL,0x1A752327L,0x2BC13FEBL},
  {0x496843EAL,0xEC506879L,0x876DB29CL,0x8BE92A18L,0x8DC2F7B0L,0xF6795A2BL,0x5A4092A3L,0x6FC7DBD8L},
  {0x15EA5B56L,0x325A329DL,0xEF2EDE0FL,0x84075B43L,0x26866105L,0xC0F0FB0FL,0x95606F49L,0xD99306DDL},
  {0x37F9E181L,0xAC9FE7CDL,0x53E11DBAL,0x3DE1760DL,0x9B38424DL,0x446F1874L,0xCFE2DCA1L,0xBF02F214L},
  {0x980EE103L,0x02565361L,0xD8B42FC8L,0x2B744E31L,0xC86B006AL,0x95271537L,0xCE92B9F6L,0x34B38F55L},
  {0xE1622235L,0x9D79FD72L,0x64949621L,0x827E7326L,0xB62DCFFBL,0x5550394BL,0x16FFA94FL,0x0F018F39L},
  {0x7CED2D31L,0xA6C12FDAL,0x9A2C916EL,0x387A3526L,0xB72354F0L,0x3FC4695EL,0xED740B75L,0xE509631AL},
  {0x916A4DCFL,0x06A7F131L,0xE0EB2318L,0x02A6A72AL,0xEC04D2B2L,0x874224B3L,0x57FF02F2L,0x09A93B11L},
  {0x095089A9L,0x67640DD0L,0x5BFE0C48L,0x540099ECL,0x7B698791L,0x9D546A5DL,0x1A6D6D0FL,0x927E09F6L},
  {0x8DDAAA17L,0x31F00CD1L,0xF051CEE8L,0x65449CE3L,0x431B87FEL,0x57515625L,0xBA4BEDD5L,0x54E57D62L},
  {0x86FF3B32L,0x8D06370DL,0x4491A8A0L,0x28EE0149L,0x88B5A51EL,0x622E4B51L,0x7DE6E50CL,0xE4FA09AEL},
  {0x1E7983D4L,0x641E961BL,0xBC2B9ED9L,0x523DD916L,0x58EBA9CDL,0xDAC66FDDL,0x674A743EL,0x979ADDF5L},
  {0x3CC18C96L,0x5F70F357L,0x7D4D6EBCL,0x5A2DF505L,0x6B8101BBL,0x7166229BL,0x3D467CB4L,0x8363EB0DL},
  {0x8B101ED0L,0xE8F7D6D7L,0x6DE39B32L,0x737BE68EL,0xF0D36A77L,0xA47FB3F6L,0x85659E76L,0x7BB2E391L}
};

// DES test cases -- key/iv/plain/cypher -- generated by gentestsdes.c
// DES test cases are now true DES keys, and can be checked with any DES package
static const u32 des_test_cases[TEST_CASE_COUNT][8] = {
  {0x54159B85L,0x316B02CEL,0xB401FC0EL,0x737B34C9L,0x96CB8518L,0x4A6649F9L,0x34A74BC8L,0x47EE6EF2L},
  {0x1AD9EA4AL,0x15527592L,0x805A8EF3L,0x21F68C4CL,0xC4B9980EL,0xD5C3BD8AL,0x5AFD5D57L,0x335981ADL},
  {0x5B199D6EL,0x40C40E6DL,0xF5756816L,0x36088043L,0x4EF1DF24L,0x6BF462ECL,0xC657515FL,0xABB6EBB0L},
  {0xAD8C0DECL,0x68385DF1L,0x19FB0D4FL,0x288D2CD6L,0x03FA0F6FL,0x038E92F8L,0x2FA04E4CL,0xBFAB830AL},
  {0xC475C22CL,0xDFE3B67AL,0x5614A37EL,0xD70F8E2DL,0xCA620ACEL,0xA1CF54BBL,0xB5BF73A1L,0xB2BB55BDL},
  {0x2FABC40DL,0xE03B8CE6L,0xF825C0CFL,0x47BDC4A9L,0x639F0904L,0x354EFC8BL,0xC745E11CL,0x698BF15FL},
  {0x80940E61L,0xDCBC7F73L,0xA30685EAL,0x67CDA3FEL,0x6E538AA3L,0xC34993BBL,0xF6DBDCE9L,0x6FCE1832L},
  {0x4A701329L,0x450D5D0BL,0x93D406FAL,0x96C9CD56L,0xAF7D2E73L,0xA1A9F844L,0x9428CB49L,0x1F93460FL},
  {0x2A73B06EL,0x8C855D6BL,0x3FC6F9D5L,0x3F07BC65L,0x9A311C3BL,0x8FC62B22L,0x0E71ECD9L,0x003B4F0BL},
  {0x255DFBB0L,0xB5290115L,0xE4663D24L,0x702B8D86L,0xC082814FL,0x6DFA89ACL,0xB76E630DL,0xF54F4D24L},
  {0xBA1A3B6EL,0x9158E3C4L,0x4C3E8CBCL,0xA19D4133L,0x7F8072ECL,0x6A19424EL,0xE09F06DAL,0x6508CD88L},
  {0xFB32138AL,0xF4F73175L,0x87C55A28L,0xC5FAA7A2L,0xDAE86B44L,0x629B5CAEL,0xAEC607BCL,0x9DD8816DL},
  {0x5B0BDA4FL,0x025B2502L,0x1F6A43E5L,0x0006E17EL,0xB0E11412L,0x64EB87EBL,0x2AED8682L,0x6A8BC154L},
  {0xB05837B3L,0xFBE083AEL,0x3248AE33L,0xD92DDA07L,0xFAF4525FL,0x4E90B16DL,0x6725DBD5L,0x746A4432L},
  {0x76BC4570L,0xBFB5941FL,0x8F2A8068L,0xCE638F26L,0xA21EBDF0L,0x585A6F8AL,0x65A3766EL,0x95B6663AL},
  {0xC7610E85L,0x5DDCBC51L,0xB0747E7FL,0x8A52D246L,0x3825CE90L,0xD70EA566L,0x50BC63A5L,0xDF9DD8FAL},
  {0xB9B02615L,0x017C3745L,0x21BAECACL,0x4771B2AAL,0x32703B09L,0x0CBEF2BCL,0x69907E24L,0x0B3928A6L},
  {0x0D7C8F0DL,0xFDC2DF6EL,0x3BBCE282L,0x7C62A9D8L,0x4E18FA5AL,0x2D942C4EL,0x5BF53685L,0x23E40E20L},
  {0xBAA426B6L,0xAED92F13L,0xC0DAC03CL,0x3382923AL,0x25F6F952L,0x3C691477L,0x49B7862AL,0x6520E509L},
  {0x7C37682AL,0x164A43B3L,0x9D31C0D1L,0x884B1EE5L,0x2DCBB169L,0xB4530B74L,0x3C93D6C3L,0x9A9CE765L},
  {0x79B55B8FL,0x6B8AC2B5L,0xE9545371L,0x004E203EL,0xA3170E57L,0x9F71563DL,0xF5DE356FL,0xBD0191DFL},
  {0xC8F80132L,0xD532972FL,0xBC2145BCL,0x42E174FEL,0xBA4DCA59L,0x6F65FA58L,0xB276ADD5L,0xA0A9F7B1L},
  {0x6E497043L,0x7C402CC2L,0x0039BB42L,0xBD8438A2L,0x508592BFL,0x1A2F40D6L,0x0F1EB5BCL,0x6B0C42E7L},
  {0xB3C4FD31L,0xD619314AL,0x39B2DBF7L,0x0295F93AL,0x4D547967L,0x36149936L,0x44B02FEEL,0xEECC0B2DL},
  {0x7FA12954L,0x08737CA8L,0x8ECDCE90L,0x5DACCF36L,0x7AA693B0L,0x62C8CA9CL,0x948CB25EL,0xF4781028L},
  {0x01BFDC08L,0x7558CD0EL,0x7D6D82DAL,0x19ACD958L,0x1EDF3781L,0x195110A7L,0x021EB315L,0xE2EA34C9L},
  {0x5161A2C4L,0x4F043B43L,0x17D76130L,0xDCB7695CL,0xA70ADBC0L,0x843A8801L,0xAEE16715L,0xE1AF0F07L},
  {0x943DF4E3L,0xB6D6CEF2L,0xC763AAA3L,0xA0179248L,0xEB61626FL,0x1B130032L,0x5630226FL,0x1C9DBFB2L},
  {0xE997049EL,0x37D5E085L,0x07C372A8L,0x3669C801L,0x689B4583L,0xDA05F0A2L,0xFA70DACDL,0x3F031F6CL},
  {0x4C2F1083L,0x5D8A6B32L,0xC38544FAL,0x017883F5L,0xD06D9EAAL,0xEE0DFBF6L,0xB1A728B7L,0x12C311C4L},
  {0x5225BCB0L,0xE51C98B6L,0x2B7ABF2DL,0xD714717EL,0xC867B0B7L,0xF24322B6L,0x0A6BF211L,0xB0B7C1CAL},
  {0xCE6823E9L,0x16A8A476L,0xCDC4DBA4L,0xD93B6603L,0xC6E231B9L,0xD84C2204L,0xDB623F7CL,0x3477E4B2L},
};

// ---------------------------------------------------------------------------

int SelfTest( unsigned int contest, int cputype )
{
  s32 run;
  unsigned int testnum;
  const u32 (*test_cases)[TEST_CASE_COUNT][8];
  Problem problem;
  ContestWork contestwork;
  RC5Result rc5result;
  u64 expectedsolution;
  int successes = 0;
  
  if (contest == 0)
    {
    test_cases = (const u32 (*)[TEST_CASE_COUNT][8])&rc5_test_cases[0][0];
    LogScreen("Beginning RC5 Self-test.\n");
    }
  else if (contest == 1)
    {
    test_cases = (const u32 (*)[TEST_CASE_COUNT][8])&des_test_cases[0][0];
    LogScreen("Beginning DES Self-test.\n");
    }
  else
    return 0;

  for ( testnum = 0 ; testnum < TEST_CASE_COUNT ; testnum++ )
    {
    // load test case
    if (contest == 0) 
      {
      // RC5-64
      expectedsolution.lo = (*test_cases)[testnum][0];
      expectedsolution.hi = (*test_cases)[testnum][1];
      } 
    else //if (contest == 1) 
      {
      // DES
      expectedsolution.lo = (*test_cases)[testnum][0];
      expectedsolution.hi = (*test_cases)[testnum][1];

      convert_key_from_des_to_inc ( (u32 *) &expectedsolution.hi, 
                                    (u32 *) &expectedsolution.lo);

      // to test also success on complementary keys
      if (expectedsolution.hi & 0x00800000L)
        {
        expectedsolution.hi ^= 0x00FFFFFFL;
        expectedsolution.lo = ~expectedsolution.lo;
        }
      }
    contestwork.key.lo = htonl( expectedsolution.lo & 0xFFFF0000L);
    contestwork.key.hi = htonl( expectedsolution.hi );
    contestwork.iv.lo = htonl( (*test_cases)[testnum][2] );
    contestwork.iv.hi = htonl( (*test_cases)[testnum][3] );
    contestwork.plain.lo = htonl( (*test_cases)[testnum][4] );
    contestwork.plain.hi = htonl( (*test_cases)[testnum][5] );
    contestwork.cypher.lo = htonl( (*test_cases)[testnum][6] );
    contestwork.cypher.hi = htonl( (*test_cases)[testnum][7] );
    contestwork.keysdone.lo = htonl( 0 );
    contestwork.keysdone.hi = htonl( 0 );
    contestwork.iterations.lo = htonl( 0x00010000L );  // only need xDEEO
    contestwork.iterations.hi = htonl( 0 );

    problem.LoadState( &contestwork, contest, 0x1000, cputype);
    while ( ( run = problem.Run( 0 ) ) == 0 ) //threadnum
      {
      #if (CLIENT_OS == OS_WIN16) || (CLIENT_OS == OS_WIN32S)
      Yield();
      #elif (CLIENT_OS == OS_NETWARE)
      nwCliThreadSwitchLowPriority();
      #endif

      problem.GetResult( &rc5result );
      }

    if ( CheckExitRequestTriggerNoIO() ) return 0;

    if ( run == 1 )  // switch on value of run
      {
      s32 tmpcontest = (u32) problem.GetResult( &rc5result );
      successes++;

      if ( rc5result.result == RESULT_FOUND )
        {
        if ( (ntohl( rc5result.key.hi ) + 
              ntohl( rc5result.keysdone.hi ) ) != expectedsolution.hi
          || (ntohl( rc5result.key.lo ) + 
              ntohl( rc5result.keysdone.lo ) ) != expectedsolution.lo )
          {
          // failure occurred (wrong key)
          LogScreen( "Test %d FAILED: %08X:%08X - %08X:%08X\n", successes,
              (ntohl( rc5result.key.hi ) + ntohl( rc5result.keysdone.hi ) ),
              (ntohl( rc5result.key.lo ) + ntohl( rc5result.keysdone.lo ) ),
              expectedsolution.hi, expectedsolution.lo );
          return ( -successes );
          } 
        else 
          {
          // match found
          if (tmpcontest == 1)
            {
            // DES...
            u32 hi = (*test_cases)[testnum][1];
            u32 lo = (*test_cases)[testnum][0];

            u32 hi2 = ntohl( rc5result.key.hi ) + 
                (u32) ntohl( rc5result.keysdone.hi );
            u32 lo2 = ntohl( rc5result.key.lo ) + 
                (u32) ntohl( rc5result.keysdone.lo );
            convert_key_from_inc_to_des (&hi2, &lo2);

            LogScreen("Test %02d Passed: %08X:%08X - %08X:%08X\n",successes,
              (u32) hi2, (u32) lo2, (u32) hi, (u32) lo);
            } 
          else 
            {
            // RC5...
            LogScreen( "Test %02d Passed: %08X:%08X\n", successes,
              (u32) ntohl( rc5result.key.hi ) + 
              (u32) ntohl( rc5result.keysdone.hi ),
              (u32) ntohl( rc5result.key.lo ) + 
              (u32) ntohl( rc5result.keysdone.lo ));
            }
          }
        }
      else
        {
        // failure occurred (no solution)
        LogScreen( "Test %d FAILED: %08X:%08X - %08X:%08X\n", successes,
              0, 0, expectedsolution.hi, expectedsolution.lo );
        return( -successes );
        }
      }
    }
  LogScreen( "\n%d/%d %s Tests Passed\n", 
      (int) successes, (int) TEST_CASE_COUNT, 
      CliGetContestNameFromID( contest ) );

  return (successes);
}

// ---------------------------------------------------------------------------
