// Hey, Emacs, this a -*-C++-*- file !

// Copyright distributed.net 1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.

// $Log: sleepdef.h,v $
// Revision 1.17.2.2  1998/11/08 11:52:01  remi
// Lots of $Log tags.
//

// Synchronized with official 1.17

#ifndef __SLEEPDEF_H__
#define __SLEEPDEF_H__

#include "cputypes.h"

#if (CLIENT_OS == OS_WIN32)
  #define WIN32_LEAN_AND_MEAN
  #include <windows.h>
  #ifdef sleep
    #undef sleep
  #endif
  #define sleep(x) Sleep(1000*(x))
  #define usleep(x) Sleep((x)/1000)
#elif (CLIENT_OS == OS_WIN16) || (CLIENT_OS == OS_WIN32S)
  // Win16 has Yield(), but we have a gui, so pump messages instead
  #include "w32cons.h"
  #define sleep(x)  w32Sleep((x)*1000)
  #define usleep(x) w32Sleep((x)/1000)
#elif (CLIENT_OS == OS_DOS)
  //thats a wrapper around a dpmi yield
  #include "platforms/dos/clidos.h"
  #define sleep(x) dosCliSleep((x))
  #define usleep(x) dosCliUSleep((x))
#elif (CLIENT_OS == OS_OS2)
  #include "platforms/os2cli/os2defs.h"
  #ifdef sleep
  #undef sleep    // gets rid of warning messages
  #endif
  #define sleep(x) DosSleep(1000*(x))
  #define usleep(x) DosSleep((x)/1000)
#elif (CLIENT_OS == OS_NETWARE)
  extern "C" void delay(unsigned int msecs);
  #define sleep(x)  delay((x)*1000)
  #define usleep(x) delay((x)/1000)
#elif (CLIENT_OS == OS_BEOS)
  #include <unistd.h>
  #define usleep(x) snooze((x))
#elif (CLIENT_OS == OS_DEC_UNIX)
  #include <unistd.h>
  #include <sys/types.h>
  // found in <unistd.h>, but requires _XOPEN_SOURCE_EXTENDED,
  // which causes more trouble...
  extern "C" int usleep(useconds_t);
#elif ((CLIENT_OS == OS_SUNOS) && (CLIENT_CPU == CPU_68K))
  #include <unistd.h>
  extern "C" void usleep(unsigned int);
#elif (CLIENT_OS == OS_HPUX)
  #include <unistd.h>
  #include <sys/time.h>
  #ifdef _STRUCT_TIMESPEC
     // HP-UX 10.x has nanosleep() rather than usleep()
     #define usleep(x) { \
       struct timespec interval, remainder; \
       interval.tv_sec = 0; interval.tv_nsec = (x)*100; \
       nanosleep(&interval, &remainder); }
  #else // HP-UX 9.x doesn't have nanosleep() or usleep()
    #define usleep(x) sleep(1)
    #define USLEEP_IS_SLEEP
  #endif
#elif (CLIENT_OS == OS_IRIX)
  #include <unistd.h>
  #if 1
    #ifndef usleep
      #include <limits.h>
      #define usleep(x) sginap((x)*(CLK_TCK/1000000L))
    #endif
  #else
    #ifdef _irix5_
      #define usleep(x) sleep(1) //will use nanosleep() in next revision
      #define USLEEP_IS_SLEEP
    #endif
  #endif
#elif (CLIENT_OS == OS_AMIGAOS)
  extern "C" {
  #ifdef sleep
  #undef sleep
  #endif
  #ifdef sleep
  #undef usleep
  #endif
  #define sleep(n) Delay(n*TICKS_PER_SECOND);
  #define usleep(n) Delay(n*TICKS_PER_SECOND/1000000);
  }
#elif (CLIENT_OS == OS_RISCOS)
  extern "C" {
  #include <unistd.h>
  }
#elif (CLIENT_OS == OS_DYNIX)
  // DYNIX doesn't have nanosleep() or usleep()
  #define usleep(x) sleep(1)
  #define USLEEP_IS_SLEEP
#elif (CLIENT_OS == OS_ULTRIX)
  #define usleep(x) { struct timeval tv = {0,(x)}; \
                      select(0,NULL,NULL,NULL,&tv); }
#else
  #include <unistd.h> //gcc has both sleep() and usleep()
#endif


#endif /* __SLEEPDEF_H__ */
