
.macro  adrli   dest, addr, a, b, c
        .set    \a, \addr-.-8
        .set    \b, (( \a+256 )>>9)<<9
        add     \dest, pc, #\b
        .set    \c, \a-\b
        add     \dest, \dest, #\c
.endm

.macro  adrl    dest, addr
        adrli   \dest, \addr, "adrla\@", "adrlb\@", "adrlc\@"
.endm

	.text
	.global _convert_key_from_des_to_inc__FPUlT0
	.global _convert_key_from_inc_to_des__FPUlT0
	.global _des_unit_func_strongarm

_convert_key_from_des_to_inc__FPUlT0:
	STMDB   R13!,{R4,R14}
	LDR     R2,[R0,#0]
	AND     R3,R2,#0xFE         
	MOV     R3,R3,LSR #1
	AND     R12,R2,#0xFE00
	ORR     R3,R3,R12,LSR #2
	AND     R12,R2,#0x00FE0000
	ORR     R3,R3,R12,LSR #3
	AND     R2,R2,#0xFE000000
	ORR     R2,R3,R2,LSR #4
	STR     R2,[R0,#0]
	LDR     R2,[R1,#0]
	AND     R3,R2,#0xFE         
	MOV     R12,R3,LSR #1
	AND     R3,R2,#0xFE00
	ORR     R12,R12,R3,LSR #2
	AND     R3,R2,#0x00FE0000
	ORR     R3,R12,R3,LSR #3
	AND     R2,R2,#0xFE000000
	ORR     R2,R3,R2,LSR #4
	STR     R2,[R1,#0]
	AND     R3,R2,#8
	MOV     R3,R3,LSR #3
	AND     R12,R2,#0x20        
	ORR     R12,R3,R12,LSR #4
	AND     R3,R2,#0x0100       
	ORR     R3,R12,R3,LSR #6
	AND     R12,R2,#0x1C00      
	ORR     R12,R3,R12,LSR #7
	AND     R3,R2,#0x8000
	ORR     R12,R12,R3,LSR #9
	AND     R3,R2,#0x00040000
	ORR     R14,R12,R3,LSR #11
	LDR     R3,[R0,#0]
	AND     R12,R3,#0xF000
	ORR     R12,R14,R12,LSR #4
	AND     R14,R3,#0x00060000
	ORR     R14,R12,R14,LSR #5
	AND     R12,R3,#0x00600000
	ORR     R14,R14,R12,LSR #7
	AND     R12,R2,#7
	ORR     R14,R14,R12,LSL #16
	AND     R12,R2,#0x10        
	ORR     R14,R14,R12,LSL #15
	AND     R12,R2,#0xC0        
	ORR     R12,R14,R12,LSL #14
	AND     R14,R2,#0x0200      
	ORR     R12,R12,R14,LSL #13
	AND     R14,R2,#0x6000
	ORR     R12,R12,R14,LSL #10
	AND     R14,R2,#0x00030000
	ORR     R14,R12,R14,LSL #9
	AND     R12,R2,#0x00080000
	ORR     R12,R14,R12,LSL #8
	MOV     R14,R3,LSL #20
	MOV     R14,R14,LSR #20
	MOV     R14,R14,LSL #8
	AND     R4,R3,#0x00010000
	ORR     R14,R14,R4,LSL #4
	AND     R4,R3,#0x00180000
	ORR     R14,R14,R4,LSL #2
	AND     R3,R3,#0x0F800000
	ORR     R3,R14,R3
	AND     R2,R2,#0x0FF00000
	ORR     R2,R3,R2,LSR #20
	STR     R2,[R0,#0]
	STR     R12,[R1,#0]
	LDR     R2,[R0,#0]
	AND     R2,R2,#0x0F         
	ORR     R2,R12,R2,LSL #28
	STR     R2,[R1,#0]
	LDR     R1,[R0,#0]
	MOV     R1,R1,LSR #4
	STR     R1,[R0,#0]
	LDMIA   R13!,{R4,PC}^
_convert_key_from_inc_to_des__FPUlT0:	
	STMDB   R13!,{R4,R14}
	LDR     R2,[R1,#0]
	MOV     R2,R2,LSR #28
	LDR     R3,[R0,#0]
	ORR     R2,R2,R3,LSL #4
	STR     R2,[R0,#0]
	LDR     R2,[R1,#0]
	BIC     R2,R2,#0xF0000000
	STR     R2,[R1,#0]
	AND     R3,R2,#1
	MOV     R3,R3,LSL #3
	AND     R12,R2,#2
	ORR     R12,R3,R12,LSL #4
	AND     R3,R2,#4
	ORR     R12,R12,R3,LSL #6
	AND     R3,R2,#0x38         
	ORR     R12,R12,R3,LSL #7
	AND     R3,R2,#0x40         
	ORR     R12,R12,R3,LSL #9
	AND     R3,R2,#0x80         
	ORR     R12,R12,R3,LSL #11
	AND     R3,R2,#0x00070000
	ORR     R3,R12,R3,LSR #16
	AND     R12,R2,#0x00080000
	ORR     R12,R3,R12,LSR #15
	AND     R3,R2,#0x00300000
	ORR     R12,R12,R3,LSR #14
	AND     R3,R2,#0x00400000
	ORR     R12,R12,R3,LSR #13
	AND     R3,R2,#0x01800000
	ORR     R3,R12,R3,LSR #10
	AND     R12,R2,#0x06000000
	ORR     R12,R3,R12,LSR #9
	AND     R3,R2,#0x08000000
	ORR     R12,R12,R3,LSR #8
	LDR     R3,[R0,#0]
	AND     R14,R3,#0xFF        
	ORR     R12,R12,R14,LSL #20
	MOV     R14,R3,LSL #12
	MOV     R14,R14,LSR #12
	BIC     R14,R14,#0xFF       
	MOV     R4,R14,LSR #8
	AND     R14,R3,#0x00100000
	ORR     R4,R4,R14,LSR #4
	AND     R14,R3,#0x00600000
	ORR     R14,R4,R14,LSR #2
	AND     R3,R3,#0x0F800000
	ORR     R3,R14,R3
	AND     R14,R2,#0x0F00      
	ORR     R14,R3,R14,LSL #4
	AND     R3,R2,#0x3000
	ORR     R3,R14,R3,LSL #5
	AND     R2,R2,#0xC000
	ORR     R2,R3,R2,LSL #7
	STR     R2,[R0,#0]
	STR     R12,[R1,#0]
	LDR     R3,[R0,#0]
	AND     R12,R3,#0x7F
	adrl	r2,odd_parity
	/*
	ADR     R2,0x00000704
	ADD     R2,R2,#0x01EC
	*/
	LDRB    R14,[R2,R12,LSL #1]
	AND     R12,R3,#0x3F80
	LDRB    R12,[R2,R12,LSR #6]
	ORR     R14,R14,R12,LSL #8
	AND     R12,R3,#0x001FC000
	LDRB    R12,[R2,R12,LSR #13]
	ORR     R12,R14,R12,LSL #16
	AND     R3,R3,#0x0FE00000
	LDRB    R3,[R2,R3,LSR #20]
	ORR     R3,R12,R3,LSL #24
	STR     R3,[R0,#0]
	LDR     R0,[R1,#0]
	AND     R3,R0,#0x7F         
	LDRB    R12,[R2,R3,LSL #1]
	AND     R3,R0,#0x3F80
	LDRB    R3,[R2,R3,LSR #6]
	ORR     R12,R12,R3,LSL #8
	AND     R3,R0,#0x001FC000
	LDRB    R3,[R2,R3,LSR #13]
	ORR     R3,R12,R3,LSL #16
	AND     R0,R0,#0x0FE00000
	LDRB    R0,[R2,R0,LSR #20]
	ORR     R0,R3,R0,LSL #24
	STR     R0,[R1,#0]
	LDMIA   R13!,{R4,PC}^
	
lowbits:	
	.word	0xAAAAAAAA
	.word	0xCCCCCCCC
	.word	0xF0F0F0F0
	.word	0xFF00FF00
	.word	0xFFFF0000

_des_unit_func_strongarm:
	
	MOV     R12,R13
	STMDB   R13!,{R0,R1,R4-R9,R11,R12,R14,PC}
	SUB     R11,R12,#4
	SUB     R12,R13,#0x0400     
	/*
	CMP     R12,R10
	BLMI    0x000000A8
	*/
	MOV     R4,R0
	SUB     R13,R13,#0x02E8     
	LDR     R0,[R0,#16]
	STR     R0,[R13,#4]
	LDR     R0,[R4,#20]
	STR     R0,[R13,#0]
	MOV     R1,R13
	ADD     R0,R13,#4
	BL      _convert_key_from_inc_to_des__FPUlT0
	MOV     R5,#1
	MOV     R6,#0
	LDMIA   R13,{R7,R8}
L000048J5:
	MOV     R0,R6
	MOV     R1,#7
	BL      ___umodsi3
	CMP     R0,#0
	MOVEQ   R5,R5,LSL #1
	ANDS    R1,R7,R5
	MVNNE   R1,#0
	ADD     R0,R13,#0x0208      
	STR     R1,[R0,R6,LSL #2]
	MOVS    R5,R5,LSL #1
	MOVEQ   R7,R8
	MOVEQ   R5,#1
	ADD     R6,R6,#1
	CMP     R6,#0x38            
	BCC     L000048J5
	
	MOV     R5,#0
	MOV     R6,#0
	MOV     R1,#0x20            
	ADD     R12,R13,#0x0208     
clearbits:
	STMDB   R12!,{R5,R6}
	STMDB   R12!,{R5,R6}
	SUBS    R1,R1,#1
	BNE     clearbits
	LDR     R2,[R4,#12]
	LDR     R3,[R4,#8]
	ADD     R12,R13,#8
	MVN     R7,#0
	TST     R2,#0x20            
	STRNE   R7,[R12,#252]
	TST     R2,#8
	STRNE   R7,[R12,#248]
	TST     R3,#0x00080000
	STRNE   R7,[R12,#244]
	TST     R3,#0x00020000
	STRNE   R7,[R12,#240]
	TST     R3,#0x20            
	STRNE   R7,[R12,#236]
	TST     R2,#0x02000000
	STRNE   R7,[R12,#232]
	TST     R2,#0x8000
	STRNE   R7,[R12,#228]
	TST     R2,#0x0800          
	STRNE   R7,[R12,#224]
	TST     R3,#0x08000000
	STRNE   R7,[R12,#220]
	TST     R3,#0x20000000
	STRNE   R7,[R12,#216]
	TST     R3,#0x0200          
	STRNE   R7,[R12,#212]
	TST     R3,#0x8000
	STRNE   R7,[R12,#208]
	TST     R2,#0x0200          
	STRNE   R7,[R12,#204]
	TST     R2,#0x08000000
	STRNE   R7,[R12,#200]
	TST     R2,#0x2000
	STRNE   R7,[R12,#196]
	TST     R2,#0x80            
	STRNE   R7,[R12,#192]
	TST     R3,#0x80000000
	STRNE   R7,[R12,#188]
	TST     R3,#0x2000
	STRNE   R7,[R12,#184]
	TST     R2,#2
	STRNE   R7,[R12,#180]
	TST     R2,#0x00800000
	STRNE   R7,[R12,#176]
	TST     R2,#0x80000000
	STRNE   R7,[R12,#172]
	TST     R3,#2
	STRNE   R7,[R12,#168]
	TST     R2,#0x00200000
	STRNE   R7,[R12,#164]
	TST     R2,#0x00080000
	STRNE   R7,[R12,#160]
	TST     R3,#0x02000000
	STRNE   R7,[R12,#156]
	TST     R2,#0x20000000
	STRNE   R7,[R12,#152]
	TST     R3,#0x0800          
	STRNE   R7,[R12,#148]
	TST     R3,#0x00800000
	STRNE   R7,[R12,#144]
	TST     R3,#0x80            
	STRNE   R7,[R12,#140]
	TST     R2,#0x00020000
	STRNE   R7,[R12,#136]
	TST     R3,#0x00200000
	STRNE   R7,[R12,#132]
	TST     R3,#8
	STRNE   R7,[R12,#128]
	TST     R2,#0x10            
	STRNE   R7,[R12,#124]
	TST     R2,#4
	STRNE   R7,[R12,#120]
	TST     R3,#0x00040000
	STRNE   R7,[R12,#116]
	TST     R3,#0x00010000
	STRNE   R7,[R12,#112]
	TST     R3,#0x10            
	STRNE   R7,[R12,#108]
	TST     R2,#0x01000000
	STRNE   R7,[R12,#104]
	TST     R2,#0x4000
	STRNE   R7,[R12,#100]
	TST     R2,#0x0400          
	STRNE   R7,[R12,#96]
	TST     R3,#0x04000000
	STRNE   R7,[R12,#92]
	TST     R3,#0x10000000
	STRNE   R7,[R12,#88]
	TST     R3,#0x0100          
	STRNE   R7,[R12,#84]
	TST     R3,#0x4000
	STRNE   R7,[R12,#80]
	TST     R2,#0x0100          
	STRNE   R7,[R12,#76]
	TST     R2,#0x04000000
	STRNE   R7,[R12,#72]
	TST     R2,#0x1000          
	STRNE   R7,[R12,#68]
	TST     R2,#0x40            
	STRNE   R7,[R12,#64]
	TST     R3,#0x40000000
	STRNE   R7,[R12,#60]
	TST     R3,#0x1000          
	STRNE   R7,[R12,#56]
	TST     R2,#1
	STRNE   R7,[R12,#52]
	TST     R2,#0x00400000
	STRNE   R7,[R12,#48]
	TST     R2,#0x40000000
	STRNE   R7,[R12,#44]
	TST     R3,#1
	STRNE   R7,[R12,#40]
	TST     R2,#0x00100000
	STRNE   R7,[R12,#36]
	TST     R2,#0x00040000
	STRNE   R7,[R12,#32]
	TST     R3,#0x01000000
	STRNE   R7,[R12,#28]
	TST     R2,#0x10000000
	STRNE   R7,[R12,#24]
	TST     R3,#0x0400          
	STRNE   R7,[R12,#20]
	TST     R3,#0x00400000
	STRNE   R7,[R12,#16]
	TST     R3,#0x40            
	STRNE   R7,[R12,#12]
	TST     R2,#0x00010000
	STRNE   R7,[R12,#8]
	TST     R3,#0x00100000
	STRNE   R7,[R12,#4]
	TST     R3,#4
	STRNE   R7,[R12,#0]
	LDR     R2,[R4,#4]
	LDR     R3,[R4,#0]
	ADD     R12,R13,#0x0108     
	TST     R3,#0x02000000
	STRNE   R7,[R12,#252]
	TST     R3,#0x00020000
	STRNE   R7,[R12,#248]
	TST     R3,#0x0200          
	STRNE   R7,[R12,#244]
	TST     R3,#2
	STRNE   R7,[R12,#240]
	TST     R2,#0x02000000
	STRNE   R7,[R12,#236]
	TST     R2,#0x00020000
	STRNE   R7,[R12,#232]
	TST     R2,#0x0200          
	STRNE   R7,[R12,#228]
	TST     R2,#2
	STRNE   R7,[R12,#224]
	TST     R3,#0x08000000
	STRNE   R7,[R12,#220]
	TST     R3,#0x00080000
	STRNE   R7,[R12,#216]
	TST     R3,#0x0800          
	STRNE   R7,[R12,#212]
	TST     R3,#8
	STRNE   R7,[R12,#208]
	TST     R2,#0x08000000
	STRNE   R7,[R12,#204]
	TST     R2,#0x00080000
	STRNE   R7,[R12,#200]
	TST     R2,#0x0800          
	STRNE   R7,[R12,#196]
	TST     R2,#8
	STRNE   R7,[R12,#192]
	TST     R3,#0x20000000
	STRNE   R7,[R12,#188]
	TST     R3,#0x00200000
	STRNE   R7,[R12,#184]
	TST     R3,#0x2000
	STRNE   R7,[R12,#180]
	TST     R3,#0x20            
	STRNE   R7,[R12,#176]
	TST     R2,#0x20000000
	STRNE   R7,[R12,#172]
	TST     R2,#0x00200000
	STRNE   R7,[R12,#168]
	TST     R2,#0x2000
	STRNE   R7,[R12,#164]
	TST     R2,#0x20            
	STRNE   R7,[R12,#160]
	TST     R3,#0x80000000
	STRNE   R7,[R12,#156]
	TST     R3,#0x00800000
	STRNE   R7,[R12,#152]
	TST     R3,#0x8000
	STRNE   R7,[R12,#148]
	TST     R3,#0x80            
	STRNE   R7,[R12,#144]
	TST     R2,#0x80000000
	STRNE   R7,[R12,#140]
	TST     R2,#0x00800000
	STRNE   R7,[R12,#136]
	TST     R2,#0x8000
	STRNE   R7,[R12,#132]
	TST     R2,#0x80            
	STRNE   R7,[R12,#128]
	TST     R3,#0x01000000
	STRNE   R7,[R12,#124]
	TST     R3,#0x00010000
	STRNE   R7,[R12,#120]
	TST     R3,#0x0100          
	STRNE   R7,[R12,#116]
	TST     R3,#1
	STRNE   R7,[R12,#112]
	TST     R2,#0x01000000
	STRNE   R7,[R12,#108]
	TST     R2,#0x00010000
	STRNE   R7,[R12,#104]
	TST     R2,#0x0100          
	STRNE   R7,[R12,#100]
	TST     R2,#1
	STRNE   R7,[R12,#96]
	TST     R3,#0x04000000
	STRNE   R7,[R12,#92]
	TST     R3,#0x00040000
	STRNE   R7,[R12,#88]
	TST     R3,#0x0400          
	STRNE   R7,[R12,#84]
	TST     R3,#4
	STRNE   R7,[R12,#80]
	TST     R2,#0x04000000
	STRNE   R7,[R12,#76]
	TST     R2,#0x00040000
	STRNE   R7,[R12,#72]
	TST     R2,#0x0400          
	STRNE   R7,[R12,#68]
	TST     R2,#4
	STRNE   R7,[R12,#64]
	TST     R3,#0x10000000
	STRNE   R7,[R12,#60]
	TST     R3,#0x00100000
	STRNE   R7,[R12,#56]
	TST     R3,#0x1000          
	STRNE   R7,[R12,#52]
	TST     R3,#0x10            
	STRNE   R7,[R12,#48]
	TST     R2,#0x10000000
	STRNE   R7,[R12,#44]
	TST     R2,#0x00100000
	STRNE   R7,[R12,#40]
	TST     R2,#0x1000          
	STRNE   R7,[R12,#36]
	TST     R2,#0x10            
	STRNE   R7,[R12,#32]
	TST     R3,#0x40000000
	STRNE   R7,[R12,#28]
	TST     R3,#0x00400000
	STRNE   R7,[R12,#24]
	TST     R3,#0x4000
	STRNE   R7,[R12,#20]
	TST     R3,#0x40            
	STRNE   R7,[R12,#16]
	TST     R2,#0x40000000
	STRNE   R7,[R12,#12]
	TST     R2,#0x00400000
	STRNE   R7,[R12,#8]
	TST     R2,#0x4000
	STRNE   R7,[R12,#4]
	TST     R2,#0x40            
	STRNE   R7,[R12,#0]
	
	adrl	r0,lowbits
	/*
	ADR     R0,0x00000444
	SUB     R0,R0,#0x37,ROR #30
	*/
	LDMIA   R0,{R5-R9}
	STR     R5,[R13,#532]
	STR     R6,[R13,#540]
	STR     R7,[R13,#552]
	STR     R8,[R13,#560]
	STR     R9,[R13,#564]
	LDR     R0,[R11,#-40]
	SUB     R5,R0,#5
	MOV     R8,#0
	MOV     R7,#0
	MOV     R6,#0
	MOV     R0,#1
	MOV     R9,R0,LSL R5
resettwiddles:
	MOV     R0,#0
	MOV     R12,#0
	ADR     R3,twiddles
	ADD     R2,R13,#0x0208      
resettwiddleloop:
	LDRB    R1,[R3,R0]
	STR     R12,[R2,R1,LSL #2]
	ADD     R0,R0,#1
	CMP     R0,R5
	BCC     resettwiddleloop
	B       deseval
half_keys_done:
	CMP     R8,#0
	BNE     inc_then_exit
	MOV     R8,#1
	MOV     R6,#0
	MOV     R7,R6
	MOV     R0,#0x38            
	ADD     R1,R13,#0x0208      
invertloop:
	LDR     R2,[R1,#0]
	SUBS    R0,R0,#1
	MVN     R2,R2
	STR     R2,[R1],#4
	BNE     invertloop
	B       resettwiddles
inc_then_exit:
	LDR     R1,[R4,#20]
	MOV     R2,#1
	LDR     R0,[R11,#-40]
	MOV     R0,R2,LSL R0
	ADD     R1,R1,R0
	STR     R1,[R4,#20]
	LDMDB   R11,{R4-R9,R11,R13,PC}^
	
odd_parity:	
	.word	0x02020101
	.word	0x07070404
	.word	0x0B0B0808
	.word	0x0E0E0D0D
	.word	0x13131010
	.word	0x16161515
	.word	0x1A1A1919
	.word	0x1F1F1C1C
	.word	0x23232020
	.word	0x26262525
	.word	0x2A2A2929
	.word	0x2F2F2C2C
	.word	0x32323131
	.word	0x37373434
	.word	0x3B3B3838
	.word	0x3E3E3D3D
	.word	0x43434040
	.word	0x46464545
	.word	0x4A4A4949
	.word	0x4F4F4C4C
	.word	0x52525151
	.word	0x57575454
	.word	0x5B5B5858
	.word	0x5E5E5D5D
	.word	0x62626161
	.word	0x67676464
	.word	0x6B6B6868
	.word	0x6E6E6D6D
	.word	0x73737070
	.word	0x76767575
	.word	0x7A7A7979
	.word	0x7F7F7C7C
	.word	0x83838080
	.word	0x86868585
	.word	0x8A8A8989
	.word	0x8F8F8C8C
	.word	0x92929191
	.word	0x97979494
	.word	0x9B9B9898
	.word	0x9E9E9D9D
	.word	0xA2A2A1A1
	.word	0xA7A7A4A4
	.word	0xABABA8A8
	.word	0xAEAEADAD
	.word	0xB3B3B0B0
	.word	0xB6B6B5B5
	.word	0xBABAB9B9
	.word	0xBFBFBCBC
	.word	0xC2C2C1C1
	.word	0xC7C7C4C4
	.word	0xCBCBC8C8
	.word	0xCECECDCD
	.word	0xD3D3D0D0
	.word	0xD6D6D5D5
	.word	0xDADAD9D9
	.word	0xDFDFDCDC
	.word	0xE3E3E0E0
	.word	0xE6E6E5E5
	.word	0xEAEAE9E9
	.word	0xEFEFECEC
	.word	0xF2F2F1F1
	.word	0xF7F7F4F4
	.word	0xFBFBF8F8
	.word	0xFEFEFDFD
	
twiddles:	
	.word	0x28120F0C
	.word	0x2D2B2A29
	.word	0x0032312E
	.word	0x06040201
	.word	0x000D0907

foundkey:
	MVN     R5,#0
	MOV     R1,#0
	MOV     R2,#1
L000228J51:	
	TST     R0,R2,LSL R1
	MOVNE   R5,R1
	ADD     R1,R1,#1
	CMP     R1,#0x20            
	BCC     L000228J51
	MOV     R0,#0
	STR     R0,[R13,#4]
	MOV     R6,#0x31            
	STR     R0,[R13,#0]
	ADR     R9,odd_parity
L000250J55:
	ADD     R0,R13,#0x0208      
	ADD     R0,R0,R6,LSL #2
	LDR     R1,[R0,#24]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	MOV     R2,R1,LSL #7
	LDR     R1,[R0,#20]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #6
	LDR     R1,[R0,#16]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #5
	LDR     R1,[R0,#12]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #4
	LDR     R1,[R0,#8]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #3
	LDR     R1,[R0,#4]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R1,R2,R1,LSL #2
	LDR     R0,[R0,#0]
	MOV     R0,R0,LSR R5
	AND     R0,R0,#1
	ORR     R0,R1,R0,LSL #1
	LDRB    R7,[R9,R0]
	ADD     R0,R6,#7
	MOV     R1,#7
	BL      ___divsi3
	SUB     R0,R0,#1
	CMP     R0,#4
	BLT     L000300J58
	MVN     R1,#0x1F            
	ADD     R0,R1,R0,LSL #3
	LDR     R1,[R13,#4]
	ORR     R0,R1,R7,LSL R0
	STR     R0,[R13,#4]
	B       L000310J60
	
L000300J58:
	MOV     R0,R0,LSL #3
	LDR     R1,[R13,#0]
	ORR     R0,R1,R7,LSL R0
	STR     R0,[R13,#0]
L000310J60:
	SUB     R6,R6,#7
	CMP     R6,#0
	BGE     L000250J55
	CMP     R8,#0
	BEQ     L00033cJ62
	LDR     R0,[R13,#4]
	MVN     R0,R0
	STR     R0,[R13,#4]
	LDR     R0,[R13,#0]
	MVN     R0,R0
	STR     R0,[R13,#0]
L00033cJ62:	
	MOV     R1,R13
	ADD     R0,R13,#4
	BL      _convert_key_from_des_to_inc__FPUlT0
	LDR     R0,[R4,#20]
	LDR     R1,[R13,#0]
	SUB     R0,R1,R0
	STR     R1,[R4,#20]
	LDR     R1,[R13,#4]
	STR     R1,[R4,#16]
	LDMDB   R11,{R4-R9,R11,R13,PC}^
s1:	
	STMDB   R13!,{R10,R14}
	LDR     R6,[R12,#124]
	LDMIA   R12,{R7-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	BIC     R10,R2,R4
	EOR     R7,R10,R3
	BIC     R9,R2,R3
	ORR     R8,R9,R4
	AND     R6,R5,R8
	EOR     R12,R2,R3
	EOR     R14,R4,R6
	AND     R14,R14,R12
	EOR     R8,R9,R14
	ORR     R8,R5,R8
	BIC     R11,R4,R3
	EOR     R8,R8,R11
	ORR     R11,R1,R8
	EOR     R11,R11,R14
	AND     R11,R0,R11
	ORR     R10,R10,R6
	EOR     R10,R10,R12
	EOR     R14,R7,R6
	BIC     R7,R8,R7
	BIC     R12,R5,R12
	BIC     R3,R3,R4
	EOR     R6,R3,R12
	ORR     R6,R1,R6
	EOR     R6,R6,R14
	EOR     R6,R6,R11
	LDR     R11,[R13,#0]
	ORR     R14,R14,R3
	LDR     R3,[R11,#64]
	MVN     R6,R6
	EOR     R3,R3,R6
	EOR     R6,R10,R12
	STR     R3,[R11,#64]
	BIC     R6,R8,R6
	AND     R11,R1,R6
	EOR     R11,R14,R11
	EOR     R11,R7,R11
	AND     R14,R2,R14
	BIC     R7,R1,R7
	EOR     R7,R10,R7
	BIC     R3,R8,R14
	BIC     R10,R10,R3
	ORR     R10,R10,R9
	BIC     R12,R11,R12
	AND     R11,R0,R11
	EOR     R7,R7,R11
	ORR     R11,R1,R9
	EOR     R11,R11,R3
	MVN     R11,R11
	ORR     R6,R2,R6
	BIC     R3,R10,R1
	EOR     R6,R6,R3
	BIC     R6,R0,R6
	EOR     R6,R6,R11
	LDR     R3,[R13],#4
	ORR     R8,R10,R8
	LDR     R10,[R3,#32]
	EOR     R8,R8,R4
	EOR     R6,R10,R6
	ORR     R9,R9,R4
	AND     R10,R5,R9
	STR     R6,[R3,#32]
	EOR     R9,R9,R14
	BIC     R9,R9,R10
	BIC     R8,R1,R8
	EOR     R8,R8,R9
	ORR     R8,R0,R8
	EOR     R8,R8,R11
	EOR     R8,R8,R12
	LDR     R12,[R3,#88]
	LDR     R9,[R3,#120]
	EOR     R8,R8,R12
	EOR     R9,R7,R9
	STR     R8,[R3,#88]
	STR     R9,[R3,#120]
	LDR     PC,[R13],#4
s2:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	EOR     R7,R0,R5
	EOR     R8,R7,R4
	AND     R9,R5,R4
	BIC     R10,R0,R9
	BIC     R11,R1,R10
	EOR     R12,R8,R11
	ORR     R11,R9,R11
	BIC     R7,R11,R7
	BIC     R11,R4,R10
	EOR     R4,R4,R1
	BIC     R5,R5,R10
	ORR     R0,R12,R0
	EOR     R0,R0,R1
	ORR     R14,R2,R7
	EOR     R14,R12,R14
	EOR     R12,R12,R11
	AND     R12,R1,R12
	ORR     R11,R11,R1
	BIC     R7,R4,R7
	ORR     R6,R0,R12
	AND     R4,R4,R6
	BIC     R4,R11,R4
	ORR     R4,R3,R4
	MVN     R14,R14
	AND     R11,R3,R11
	EOR     R11,R14,R11
	AND     R6,R2,R6
	EOR     R6,R6,R4
	BIC     R0,R2,R0
	EOR     R0,R7,R0
	ORR     R7,R7,R5
	EOR     R7,R7,R14
	EOR     R4,R1,R8
	AND     R14,R4,R7
	EOR     R14,R14,R0
	BIC     R14,R2,R14
	EOR     R14,R4,R14
	ORR     R4,R9,R12
	AND     R9,R2,R9
	EOR     R9,R9,R4
	BIC     R9,R3,R9
	EOR     R9,R9,R14
	EOR     R10,R10,R11
	BIC     R10,R10,R1
	EOR     R10,R8,R10
	EOR     R12,R12,R5
	AND     R12,R2,R12
	ORR     R8,R3,R0
	EOR     R8,R8,R12
	LDR     R12,[R13],#4
	EOR     R8,R10,R8
	LDR     R14,[R12,#48]
	EOR     R10,R7,R6
	LDR     R7,[R12,#108]
	EOR     R6,R14,R11
	LDR     R14,[R12,#4]
	MVN     R9,R9
	STR     R6,[R12,#48]
	EOR     R7,R7,R9
	LDR     R9,[R12,#68]
	EOR     R8,R14,R8
	STR     R7,[R12,#108]
	EOR     R9,R9,R10
	STR     R8,[R12,#4]
	STR     R9,[R12,#68]
	LDR     PC,[R13],#4
s3:	
	STR     R14,[R13,#-4]!
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	EOR     R9,R1,R2
	EOR     R9,R9,R5
	AND     R7,R1,R9
	EOR     R11,R2,R7
	BIC     R12,R11,R4
	ORR     R8,R4,R7
	EOR     R6,R9,R8
	ORR     R14,R0,R12
	EOR     R14,R6,R14
	BIC     R7,R5,R7
	EOR     R6,R7,R4
	AND     R7,R0,R6
	EOR     R7,R4,R7
	ORR     R7,R3,R7
	EOR     R7,R14,R7
	LDR     R14,[R10,#20]
	STR     R10,[R13,#-4]!
	EOR     R14,R14,R7
	AND     R7,R5,R7
	STR     R14,[R10,#20]
	EOR     R7,R7,R11
	BIC     R7,R7,R0
	BIC     R10,R12,R2
	ORR     R10,R0,R10
	EOR     R10,R9,R10
	AND     R11,R2,R4
	EOR     R10,R11,R10
	AND     R2,R2,R5
	BIC     R11,R9,R12
	ORR     R12,R1,R12
	ORR     R14,R1,R11
	EOR     R14,R14,R7
	AND     R1,R1,R9
	EOR     R9,R9,R8
	EOR     R8,R8,R12
	ORR     R6,R6,R11
	EOR     R11,R11,R2
	ORR     R11,R0,R11
	ORR     R2,R2,R1
	EOR     R6,R6,R2
	EOR     R4,R2,R4
	MVN     R4,R4
	EOR     R14,R14,R4
	EOR     R11,R11,R4
	BIC     R1,R5,R1
	ORR     R1,R1,R6
	EOR     R2,R5,R2
	BIC     R2,R2,R9
	AND     R2,R2,R0
	EOR     R9,R1,R2
	AND     R9,R3,R9
	EOR     R9,R10,R9
	BIC     R12,R9,R12
	ORR     R12,R0,R12
	EOR     R10,R7,R12
	AND     R10,R3,R10
	EOR     R10,R14,R10
	ORR     R6,R0,R6
	EOR     R6,R8,R6
	LDR     R12,[R13],#4
	BIC     R6,R3,R6
	LDR     R7,[R12,#60]
	EOR     R6,R11,R6
	LDR     R8,[R12,#116]
	EOR     R7,R7,R9
	LDR     R9,[R12,#92]
	EOR     R8,R8,R6
	STR     R7,[R12,#60]
	EOR     R6,R9,R10
	STR     R8,[R12,#116]
	STR     R6,[R12,#92]
	LDR     PC,[R13],#4
s4:	
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	ORR     R6,R0,R2
	AND     R6,R4,R6
	EOR     R9,R0,R6
	EOR     R12,R2,R6
	BIC     R6,R2,R0
	ORR     R6,R6,R9
	AND     R11,R1,R6
	BIC     R8,R1,R12
	EOR     R6,R6,R8
	ORR     R0,R12,R9
	EOR     R12,R4,R11
	AND     R8,R3,R12
	EOR     R9,R9,R8
	ORR     R8,R1,R2
	EOR     R9,R9,R8
	EOR     R8,R2,R4
	BIC     R8,R8,R1
	EOR     R11,R11,R8
	EOR     R11,R2,R11
	BIC     R11,R3,R11
	EOR     R11,R0,R11
	AND     R12,R1,R12
	EOR     R11,R11,R12
	EOR     R12,R0,R8
	ORR     R12,R3,R12
	EOR     R8,R6,R12
	ORR     R12,R5,R8
	EOR     R12,R9,R12
	LDR     R6,[R10,#100]
	AND     R8,R5,R8
	EOR     R6,R6,R12
	EOR     R0,R9,R11
	STR     R6,[R10,#100]
	BIC     R7,R1,R0
	BIC     R0,R0,R3
	EOR     R7,R7,R0
	EOR     R7,R7,R12
	ORR     R12,R5,R7
	EOR     R12,R12,R11
	MVN     R12,R12
	MVN     R9,R9
	EOR     R0,R8,R9
	EOR     R11,R8,R7
	LDR     R7,[R10,#76]
	EOR     R11,R11,R12
	LDR     R8,[R10,#36]
	EOR     R7,R7,R0
	LDR     R9,[R10,#0]
	EOR     R8,R8,R12
	STR     R7,[R10,#76]
	EOR     R9,R9,R11
	STR     R8,[R10,#36]
	STR     R9,[R10,#0]
	MOV     PC,R14
s5:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	BIC     R10,R0,R2
	ORR     R6,R5,R10
	EOR     R11,R3,R10
	ORR     R11,R5,R11
	BIC     R12,R2,R3
	EOR     R14,R3,R0
	ORR     R8,R12,R14
	BIC     R5,R8,R5
	EOR     R12,R12,R0
	AND     R7,R2,R8
	EOR     R7,R7,R3
	BIC     R10,R7,R10
	EOR     R10,R10,R11
	ORR     R11,R7,R11
	ORR     R14,R4,R10
	EOR     R7,R7,R14
	EOR     R14,R12,R6
	AND     R6,R3,R6
	EOR     R6,R6,R10
	AND     R10,R10,R14
	BIC     R8,R8,R10
	EOR     R9,R2,R5
	BIC     R5,R5,R3
	EOR     R5,R5,R2
	EOR     R10,R9,R10
	ORR     R2,R4,R9
	EOR     R14,R14,R2
	BIC     R2,R7,R1
	EOR     R14,R14,R2
	EOR     R9,R0,R9
	AND     R12,R12,R9
	BIC     R12,R4,R12
	EOR     R6,R6,R12
	BIC     R7,R7,R8
	AND     R12,R4,R5
	EOR     R8,R8,R12
	ORR     R12,R4,R10
	EOR     R11,R11,R12
	ORR     R11,R1,R11
	EOR     R8,R8,R11
	ORR     R11,R6,R7
	EOR     R12,R3,R0
	EOR     R11,R11,R12
	BIC     R11,R4,R11
	EOR     R11,R9,R11
	EOR     R7,R7,R11
	AND     R12,R12,R10
	EOR     R12,R12,R5
	ORR     R9,R3,R9
	EOR     R10,R14,R10
	BIC     R10,R9,R10
	AND     R10,R4,R10
	EOR     R10,R12,R10
	ORR     R10,R1,R10
	EOR     R10,R7,R10
	BIC     R7,R9,R1
	LDR     R12,[R13],#4
	EOR     R7,R6,R7
	LDR     R6,[R12,#28]
	MVN     R8,R8
	LDR     R11,[R12,#52]
	EOR     R6,R6,R10
	LDR     R10,[R12,#96]
	EOR     R7,R11,R7
	LDR     R11,[R12,#8]
	EOR     R8,R10,R8
	STR     R6,[R12,#28]
	EOR     R9,R11,R14
	STR     R7,[R12,#52]
	STR     R8,[R12,#96]
	STR     R9,[R12,#8]
	LDR     PC,[R13],#4
s6:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	MVN     R2,R2
	EOR     R7,R4,R0
	EOR     R8,R7,R5
	AND     R9,R0,R5
	BIC     R6,R9,R4
	BIC     R11,R3,R6
	EOR     R12,R5,R9
	ORR     R14,R6,R12
	BIC     R14,R14,R3
	EOR     R14,R12,R14
	AND     R12,R4,R12
	BIC     R12,R3,R12
	ORR     R12,R1,R12
	ORR     R6,R6,R14
	EOR     R0,R8,R11
	EOR     R9,R9,R0
	BIC     R9,R9,R14
	AND     R14,R1,R14
	EOR     R14,R0,R14
	ORR     R3,R5,R0
	BIC     R3,R3,R4
	BIC     R8,R1,R6
	EOR     R8,R3,R8
	AND     R8,R8,R2
	LDR     R3,[R10,#12]
	EOR     R8,R8,R14
	MVN     R8,R8
	EOR     R3,R3,R8
	BIC     R8,R8,R7
	STR     R3,[R10,#12]
	EOR     R8,R8,R6
	BIC     R10,R5,R8
	EOR     R10,R10,R0
	BIC     R6,R1,R10
	ORR     R14,R4,R5
	BIC     R0,R14,R7
	EOR     R7,R7,R5
	BIC     R3,R1,R6
	EOR     R0,R0,R3
	ORR     R0,R2,R0
	EOR     R6,R8,R6
	EOR     R0,R6,R0
	EOR     R6,R5,R6
	BIC     R6,R4,R6
	ORR     R10,R10,R6
	EOR     R10,R10,R11
	ORR     R11,R6,R7
	EOR     R11,R11,R12
	AND     R14,R14,R9
	EOR     R7,R14,R7
	AND     R7,R1,R7
	EOR     R7,R10,R7
	ORR     R7,R2,R7
	EOR     R7,R11,R7
	BIC     R12,R8,R4
	BIC     R12,R2,R12
	BIC     R11,R1,R6
	LDR     R10,[R13],#4
	EOR     R12,R12,R11
	LDR     R11,[R10,#112]
	EOR     R12,R12,R9
	LDR     R9,[R10,#72]
	EOR     R7,R7,R11
	LDR     R8,[R10,#40]
	EOR     R9,R9,R0
	STR     R7,[R10,#112]
	EOR     R8,R8,R12
	STR     R9,[R10,#72]
	STR     R8,[R10,#40]
	LDR     PC,[R13],#4
s7:	
	STR     R14,[R13,#-4]!
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	AND     R7,R1,R3
	EOR     R7,R7,R4
	AND     R8,R3,R7
	EOR     R9,R8,R1
	BIC     R6,R2,R9
	EOR     R7,R7,R6
	EOR     R11,R2,R6
	ORR     R6,R1,R3
	ORR     R6,R6,R4
	BIC     R12,R4,R1
	ORR     R12,R2,R12
	EOR     R6,R6,R12
	BIC     R12,R5,R11
	EOR     R12,R7,R12
	EOR     R7,R8,R7
	ORR     R14,R5,R7
	EOR     R6,R6,R14
	AND     R14,R0,R6
	LDR     R6,[R10,#124]
	EOR     R14,R12,R14
	EOR     R6,R6,R14
	EOR     R9,R3,R9
	STR     R6,[R10,#124]
	ORR     R6,R1,R9
	EOR     R6,R6,R14
	BIC     R6,R6,R5
	ORR     R14,R2,R8
	EOR     R14,R9,R14
	EOR     R8,R2,R8
	AND     R8,R8,R1
	BIC     R8,R5,R8
	EOR     R8,R14,R8
	EOR     R11,R11,R8
	EOR     R7,R1,R7
	BIC     R7,R9,R7
	AND     R7,R5,R7
	ORR     R9,R0,R8
	EOR     R9,R12,R9
	BIC     R14,R14,R2
	ORR     R8,R14,R8
	BIC     R8,R8,R0
	EOR     R8,R6,R8
	EOR     R12,R11,R8
	BIC     R6,R3,R2
	ORR     R8,R4,R6
	EOR     R11,R11,R8
	EOR     R11,R11,R7
	BIC     R6,R1,R6
	AND     R6,R5,R6
	AND     R8,R2,R6
	EOR     R8,R8,R7
	ORR     R8,R0,R8
	EOR     R11,R11,R8
	EOR     R7,R6,R9
	LDR     R9,[R10,#44]
	MVN     R7,R7
	EOR     R7,R9,R7
	LDR     R9,[R10,#24]
	STR     R7,[R10,#44]
	LDR     R8,[R10,#84]
	EOR     R9,R9,R11
	EOR     R8,R8,R12
	STR     R9,[R10,#24]
	STR     R8,[R10,#84]
	LDR     PC,[R13],#4
s8:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11}
	LDR     R12,[R12,#-108]
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	BIC     R7,R0,R2
	EOR     R8,R7,R3
	EOR     R6,R0,R2
	ORR     R11,R4,R8
	EOR     R11,R6,R11
	BIC     R12,R11,R0
	ORR     R14,R12,R3
	EOR     R14,R14,R6
	EOR     R14,R14,R4
	BIC     R6,R6,R4
	ORR     R6,R6,R3
	BIC     R10,R7,R14
	EOR     R9,R4,R10
	EOR     R9,R2,R9
	BIC     R9,R9,R1
	EOR     R9,R6,R9
	AND     R9,R5,R9
	EOR     R6,R12,R2
	BIC     R8,R8,R14
	EOR     R8,R8,R6
	BIC     R6,R6,R4
	EOR     R6,R3,R6
	BIC     R2,R2,R8
	ORR     R2,R6,R2
	ORR     R12,R1,R12
	EOR     R12,R2,R12
	BIC     R8,R1,R8
	EOR     R8,R14,R8
	ORR     R8,R5,R8
	BIC     R6,R1,R6
	EOR     R14,R11,R6
	MVN     R14,R14
	ORR     R11,R11,R4
	EOR     R6,R14,R8
	EOR     R9,R14,R9
	ORR     R14,R14,R3
	EOR     R8,R7,R3
	EOR     R8,R8,R11
	AND     R7,R4,R7
	EOR     R7,R7,R14
	BIC     R7,R1,R7
	AND     R11,R0,R11
	EOR     R11,R11,R7
	BIC     R11,R11,R5
	AND     R14,R1,R14
	EOR     R14,R8,R14
	EOR     R11,R14,R11
	ORR     R7,R8,R11
	BIC     R7,R1,R7
	EOR     R7,R10,R7
	ORR     R7,R5,R7
	LDR     R10,[R13],#4
	EOR     R7,R12,R7
	LDR     R8,[R10,#56]
	MVN     R7,R7
	LDR     R12,[R10,#80]
	EOR     R8,R8,R11
	LDR     R11,[R10,#104]
	EOR     R9,R12,R9
	STR     R8,[R10,#56]
	LDR     R12,[R10,#16]
	EOR     R7,R11,R7
	STR     R9,[R10,#80]
	EOR     R6,R12,R6
	STR     R7,[R10,#104]
	STR     R6,[R10,#16]
	LDR     PC,[R13],#4
timingloop:
	ADD     R2,R13,#0x0208      
	LDR     R0,[R2,R1,LSL #2]
	MVN     R0,R0
	STR     R0,[R2,R1,LSL #2]
deseval:
	ADD     R1,R13,#8
	MVN     R3,#0
	STMDB   R13!,{R1-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#188]
	LDR     R1,[R14,#44]
	LDR     R2,[R14,#104]
	LDR     R3,[R14,#12]
	LDR     R4,[R14,#52]
	LDR     R5,[R14,#164]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#108]
	LDR     R1,[R14,#24]
	LDR     R2,[R14,#216]
	LDR     R3,[R14,#192]
	LDR     R4,[R14,#156]
	LDR     R5,[R14,#76]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#212]
	LDR     R1,[R14,#100]
	LDR     R2,[R14,#132]
	LDR     R3,[R14,#136]
	LDR     R4,[R14,#68]
	LDR     R5,[R14,#20]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#16]
	LDR     R1,[R14,#220]
	LDR     R2,[R14,#96]
	LDR     R3,[R14,#128]
	LDR     R4,[R14,#160]
	LDR     R5,[R14,#80]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#144]
	LDR     R1,[R14,#124]
	LDR     R2,[R14,#84]
	LDR     R3,[R14,#32]
	LDR     R4,[R14,#92]
	LDR     R5,[R14,#208]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#56]
	LDR     R1,[R14,#116]
	LDR     R2,[R14,#204]
	LDR     R3,[R14,#36]
	LDR     R4,[R14,#140]
	LDR     R5,[R14,#120]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#8]
	LDR     R1,[R14,#148]
	LDR     R2,[R14,#88]
	LDR     R3,[R14,#0]
	LDR     R4,[R14,#168]
	LDR     R5,[R14,#152]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#64]
	LDR     R1,[R14,#172]
	LDR     R2,[R14,#176]
	LDR     R3,[R14,#4]
	LDR     R4,[R14,#28]
	LDR     R5,[R14,#112]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#216]
	LDR     R1,[R14,#72]
	LDR     R2,[R14,#132]
	LDR     R3,[R14,#40]
	LDR     R4,[R14,#80]
	LDR     R5,[R14,#192]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#136]
	LDR     R1,[R14,#52]
	LDR     R2,[R14,#16]
	LDR     R3,[R14,#220]
	LDR     R4,[R14,#184]
	LDR     R5,[R14,#104]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#12]
	LDR     R1,[R14,#128]
	LDR     R2,[R14,#160]
	LDR     R3,[R14,#164]
	LDR     R4,[R14,#96]
	LDR     R5,[R14,#48]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#44]
	LDR     R1,[R14,#20]
	LDR     R2,[R14,#24]
	LDR     R3,[R14,#156]
	LDR     R4,[R14,#188]
	LDR     R5,[R14,#108]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#172]
	LDR     R1,[R14,#152]
	LDR     R2,[R14,#112]
	LDR     R3,[R14,#60]
	LDR     R4,[R14,#120]
	LDR     R5,[R14,#0]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#84]
	LDR     R1,[R14,#144]
	LDR     R2,[R14,#124]
	LDR     R3,[R14,#64]
	LDR     R4,[R14,#168]
	LDR     R5,[R14,#148]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#36]
	LDR     R1,[R14,#176]
	LDR     R2,[R14,#116]
	LDR     R3,[R14,#28]
	LDR     R4,[R14,#196]
	LDR     R5,[R14,#180]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#92]
	LDR     R1,[R14,#200]
	LDR     R2,[R14,#204]
	LDR     R3,[R14,#32]
	LDR     R4,[R14,#56]
	LDR     R5,[R14,#140]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#44]
	LDR     R1,[R14,#128]
	LDR     R2,[R14,#188]
	LDR     R3,[R14,#96]
	LDR     R4,[R14,#136]
	LDR     R5,[R14,#20]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#192]
	LDR     R1,[R14,#108]
	LDR     R2,[R14,#72]
	LDR     R3,[R14,#48]
	LDR     R4,[R14,#12]
	LDR     R5,[R14,#160]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#68]
	LDR     R1,[R14,#184]
	LDR     R2,[R14,#216]
	LDR     R3,[R14,#220]
	LDR     R4,[R14,#52]
	LDR     R5,[R14,#104]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#100]
	LDR     R1,[R14,#76]
	LDR     R2,[R14,#80]
	LDR     R3,[R14,#212]
	LDR     R4,[R14,#16]
	LDR     R5,[R14,#164]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#8]
	LDR     R1,[R14,#208]
	LDR     R2,[R14,#168]
	LDR     R3,[R14,#116]
	LDR     R4,[R14,#176]
	LDR     R5,[R14,#56]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#140]
	LDR     R1,[R14,#200]
	LDR     R2,[R14,#180]
	LDR     R3,[R14,#120]
	LDR     R4,[R14,#4]
	LDR     R5,[R14,#204]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#92]
	LDR     R1,[R14,#124]
	LDR     R2,[R14,#172]
	LDR     R3,[R14,#84]
	LDR     R4,[R14,#32]
	LDR     R5,[R14,#0]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#148]
	LDR     R1,[R14,#36]
	LDR     R2,[R14,#152]
	LDR     R3,[R14,#88]
	LDR     R4,[R14,#112]
	LDR     R5,[R14,#196]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#100]
	LDR     R1,[R14,#184]
	LDR     R2,[R14,#16]
	LDR     R3,[R14,#52]
	LDR     R4,[R14,#192]
	LDR     R5,[R14,#76]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#20]
	LDR     R1,[R14,#164]
	LDR     R2,[R14,#128]
	LDR     R3,[R14,#104]
	LDR     R4,[R14,#68]
	LDR     R5,[R14,#216]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#24]
	LDR     R1,[R14,#12]
	LDR     R2,[R14,#44]
	LDR     R3,[R14,#48]
	LDR     R4,[R14,#108]
	LDR     R5,[R14,#160]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#156]
	LDR     R1,[R14,#132]
	LDR     R2,[R14,#136]
	LDR     R3,[R14,#40]
	LDR     R4,[R14,#72]
	LDR     R5,[R14,#220]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#64]
	LDR     R1,[R14,#28]
	LDR     R2,[R14,#4]
	LDR     R3,[R14,#172]
	LDR     R4,[R14,#124]
	LDR     R5,[R14,#112]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#196]
	LDR     R1,[R14,#36]
	LDR     R2,[R14,#0]
	LDR     R3,[R14,#176]
	LDR     R4,[R14,#60]
	LDR     R5,[R14,#152]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#148]
	LDR     R1,[R14,#180]
	LDR     R2,[R14,#8]
	LDR     R3,[R14,#140]
	LDR     R4,[R14,#88]
	LDR     R5,[R14,#56]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#204]
	LDR     R1,[R14,#92]
	LDR     R2,[R14,#208]
	LDR     R3,[R14,#144]
	LDR     R4,[R14,#168]
	LDR     R5,[R14,#32]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#156]
	LDR     R1,[R14,#12]
	LDR     R2,[R14,#72]
	LDR     R3,[R14,#108]
	LDR     R4,[R14,#20]
	LDR     R5,[R14,#132]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#76]
	LDR     R1,[R14,#220]
	LDR     R2,[R14,#184]
	LDR     R3,[R14,#160]
	LDR     R4,[R14,#24]
	LDR     R5,[R14,#44]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#80]
	LDR     R1,[R14,#68]
	LDR     R2,[R14,#100]
	LDR     R3,[R14,#104]
	LDR     R4,[R14,#164]
	LDR     R5,[R14,#216]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#212]
	LDR     R1,[R14,#188]
	LDR     R2,[R14,#192]
	LDR     R3,[R14,#96]
	LDR     R4,[R14,#128]
	LDR     R5,[R14,#48]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#120]
	LDR     R1,[R14,#84]
	LDR     R2,[R14,#60]
	LDR     R3,[R14,#8]
	LDR     R4,[R14,#180]
	LDR     R5,[R14,#168]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#32]
	LDR     R1,[R14,#92]
	LDR     R2,[R14,#56]
	LDR     R3,[R14,#124]
	LDR     R4,[R14,#116]
	LDR     R5,[R14,#208]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#204]
	LDR     R1,[R14,#0]
	LDR     R2,[R14,#64]
	LDR     R3,[R14,#196]
	LDR     R4,[R14,#144]
	LDR     R5,[R14,#112]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#152]
	LDR     R1,[R14,#148]
	LDR     R2,[R14,#28]
	LDR     R3,[R14,#200]
	LDR     R4,[R14,#4]
	LDR     R5,[R14,#88]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#212]
	LDR     R1,[R14,#68]
	LDR     R2,[R14,#128]
	LDR     R3,[R14,#164]
	LDR     R4,[R14,#76]
	LDR     R5,[R14,#188]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#132]
	LDR     R1,[R14,#48]
	LDR     R2,[R14,#12]
	LDR     R3,[R14,#216]
	LDR     R4,[R14,#80]
	LDR     R5,[R14,#100]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#136]
	LDR     R1,[R14,#24]
	LDR     R2,[R14,#156]
	LDR     R3,[R14,#160]
	LDR     R4,[R14,#220]
	LDR     R5,[R14,#44]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#40]
	LDR     R1,[R14,#16]
	LDR     R2,[R14,#20]
	LDR     R3,[R14,#52]
	LDR     R4,[R14,#184]
	LDR     R5,[R14,#104]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#176]
	LDR     R1,[R14,#140]
	LDR     R2,[R14,#116]
	LDR     R3,[R14,#64]
	LDR     R4,[R14,#0]
	LDR     R5,[R14,#4]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#88]
	LDR     R1,[R14,#148]
	LDR     R2,[R14,#112]
	LDR     R3,[R14,#180]
	LDR     R4,[R14,#172]
	LDR     R5,[R14,#28]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#152]
	LDR     R1,[R14,#56]
	LDR     R2,[R14,#120]
	LDR     R3,[R14,#32]
	LDR     R4,[R14,#200]
	LDR     R5,[R14,#168]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#208]
	LDR     R1,[R14,#204]
	LDR     R2,[R14,#84]
	LDR     R3,[R14,#36]
	LDR     R4,[R14,#60]
	LDR     R5,[R14,#144]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#40]
	LDR     R1,[R14,#24]
	LDR     R2,[R14,#184]
	LDR     R3,[R14,#220]
	LDR     R4,[R14,#132]
	LDR     R5,[R14,#16]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#188]
	LDR     R1,[R14,#104]
	LDR     R2,[R14,#68]
	LDR     R3,[R14,#44]
	LDR     R4,[R14,#136]
	LDR     R5,[R14,#156]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#192]
	LDR     R1,[R14,#80]
	LDR     R2,[R14,#212]
	LDR     R3,[R14,#216]
	LDR     R4,[R14,#48]
	LDR     R5,[R14,#100]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#96]
	LDR     R1,[R14,#72]
	LDR     R2,[R14,#76]
	LDR     R3,[R14,#108]
	LDR     R4,[R14,#12]
	LDR     R5,[R14,#160]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#124]
	LDR     R1,[R14,#196]
	LDR     R2,[R14,#172]
	LDR     R3,[R14,#120]
	LDR     R4,[R14,#56]
	LDR     R5,[R14,#60]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#144]
	LDR     R1,[R14,#204]
	LDR     R2,[R14,#168]
	LDR     R3,[R14,#0]
	LDR     R4,[R14,#8]
	LDR     R5,[R14,#84]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#208]
	LDR     R1,[R14,#112]
	LDR     R2,[R14,#176]
	LDR     R3,[R14,#88]
	LDR     R4,[R14,#36]
	LDR     R5,[R14,#4]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#28]
	LDR     R1,[R14,#152]
	LDR     R2,[R14,#140]
	LDR     R3,[R14,#92]
	LDR     R4,[R14,#116]
	LDR     R5,[R14,#200]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#96]
	LDR     R1,[R14,#80]
	LDR     R2,[R14,#12]
	LDR     R3,[R14,#48]
	LDR     R4,[R14,#188]
	LDR     R5,[R14,#72]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#16]
	LDR     R1,[R14,#160]
	LDR     R2,[R14,#24]
	LDR     R3,[R14,#100]
	LDR     R4,[R14,#192]
	LDR     R5,[R14,#212]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#20]
	LDR     R1,[R14,#136]
	LDR     R2,[R14,#40]
	LDR     R3,[R14,#44]
	LDR     R4,[R14,#104]
	LDR     R5,[R14,#156]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#52]
	LDR     R1,[R14,#128]
	LDR     R2,[R14,#132]
	LDR     R3,[R14,#164]
	LDR     R4,[R14,#68]
	LDR     R5,[R14,#216]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#180]
	LDR     R1,[R14,#32]
	LDR     R2,[R14,#8]
	LDR     R3,[R14,#176]
	LDR     R4,[R14,#112]
	LDR     R5,[R14,#116]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#200]
	LDR     R1,[R14,#152]
	LDR     R2,[R14,#4]
	LDR     R3,[R14,#56]
	LDR     R4,[R14,#64]
	LDR     R5,[R14,#140]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#28]
	LDR     R1,[R14,#168]
	LDR     R2,[R14,#124]
	LDR     R3,[R14,#144]
	LDR     R4,[R14,#92]
	LDR     R5,[R14,#60]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#84]
	LDR     R1,[R14,#208]
	LDR     R2,[R14,#196]
	LDR     R3,[R14,#148]
	LDR     R4,[R14,#172]
	LDR     R5,[R14,#36]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#24]
	LDR     R1,[R14,#108]
	LDR     R2,[R14,#40]
	LDR     R3,[R14,#76]
	LDR     R4,[R14,#216]
	LDR     R5,[R14,#100]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#44]
	LDR     R1,[R14,#188]
	LDR     R2,[R14,#52]
	LDR     R3,[R14,#128]
	LDR     R4,[R14,#220]
	LDR     R5,[R14,#12]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#48]
	LDR     R1,[R14,#164]
	LDR     R2,[R14,#68]
	LDR     R3,[R14,#72]
	LDR     R4,[R14,#132]
	LDR     R5,[R14,#184]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#80]
	LDR     R1,[R14,#156]
	LDR     R2,[R14,#160]
	LDR     R3,[R14,#192]
	LDR     R4,[R14,#96]
	LDR     R5,[R14,#16]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#208]
	LDR     R1,[R14,#60]
	LDR     R2,[R14,#36]
	LDR     R3,[R14,#204]
	LDR     R4,[R14,#140]
	LDR     R5,[R14,#144]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#8]
	LDR     R1,[R14,#180]
	LDR     R2,[R14,#32]
	LDR     R3,[R14,#84]
	LDR     R4,[R14,#92]
	LDR     R5,[R14,#168]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#56]
	LDR     R1,[R14,#196]
	LDR     R2,[R14,#152]
	LDR     R3,[R14,#172]
	LDR     R4,[R14,#120]
	LDR     R5,[R14,#88]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#112]
	LDR     R1,[R14,#0]
	LDR     R2,[R14,#4]
	LDR     R3,[R14,#176]
	LDR     R4,[R14,#200]
	LDR     R5,[R14,#64]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#80]
	LDR     R1,[R14,#164]
	LDR     R2,[R14,#96]
	LDR     R3,[R14,#132]
	LDR     R4,[R14,#44]
	LDR     R5,[R14,#156]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#100]
	LDR     R1,[R14,#16]
	LDR     R2,[R14,#108]
	LDR     R3,[R14,#184]
	LDR     R4,[R14,#48]
	LDR     R5,[R14,#68]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#104]
	LDR     R1,[R14,#220]
	LDR     R2,[R14,#24]
	LDR     R3,[R14,#128]
	LDR     R4,[R14,#188]
	LDR     R5,[R14,#12]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#136]
	LDR     R1,[R14,#212]
	LDR     R2,[R14,#216]
	LDR     R3,[R14,#20]
	LDR     R4,[R14,#52]
	LDR     R5,[R14,#72]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#28]
	LDR     R1,[R14,#116]
	LDR     R2,[R14,#92]
	LDR     R3,[R14,#152]
	LDR     R4,[R14,#196]
	LDR     R5,[R14,#200]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#64]
	LDR     R1,[R14,#0]
	LDR     R2,[R14,#88]
	LDR     R3,[R14,#140]
	LDR     R4,[R14,#148]
	LDR     R5,[R14,#4]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#112]
	LDR     R1,[R14,#32]
	LDR     R2,[R14,#208]
	LDR     R3,[R14,#8]
	LDR     R4,[R14,#176]
	LDR     R5,[R14,#144]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#168]
	LDR     R1,[R14,#56]
	LDR     R2,[R14,#60]
	LDR     R3,[R14,#124]
	LDR     R4,[R14,#36]
	LDR     R5,[R14,#120]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#136]
	LDR     R1,[R14,#220]
	LDR     R2,[R14,#52]
	LDR     R3,[R14,#188]
	LDR     R4,[R14,#100]
	LDR     R5,[R14,#212]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#156]
	LDR     R1,[R14,#72]
	LDR     R2,[R14,#164]
	LDR     R3,[R14,#12]
	LDR     R4,[R14,#104]
	LDR     R5,[R14,#24]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#160]
	LDR     R1,[R14,#48]
	LDR     R2,[R14,#80]
	LDR     R3,[R14,#184]
	LDR     R4,[R14,#16]
	LDR     R5,[R14,#68]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#192]
	LDR     R1,[R14,#40]
	LDR     R2,[R14,#44]
	LDR     R3,[R14,#76]
	LDR     R4,[R14,#108]
	LDR     R5,[R14,#128]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#84]
	LDR     R1,[R14,#172]
	LDR     R2,[R14,#148]
	LDR     R3,[R14,#208]
	LDR     R4,[R14,#32]
	LDR     R5,[R14,#36]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#120]
	LDR     R1,[R14,#56]
	LDR     R2,[R14,#144]
	LDR     R3,[R14,#196]
	LDR     R4,[R14,#204]
	LDR     R5,[R14,#60]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#168]
	LDR     R1,[R14,#88]
	LDR     R2,[R14,#28]
	LDR     R3,[R14,#64]
	LDR     R4,[R14,#124]
	LDR     R5,[R14,#200]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#4]
	LDR     R1,[R14,#112]
	LDR     R2,[R14,#116]
	LDR     R3,[R14,#180]
	LDR     R4,[R14,#92]
	LDR     R5,[R14,#176]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#192]
	LDR     R1,[R14,#48]
	LDR     R2,[R14,#108]
	LDR     R3,[R14,#16]
	LDR     R4,[R14,#156]
	LDR     R5,[R14,#40]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#212]
	LDR     R1,[R14,#128]
	LDR     R2,[R14,#220]
	LDR     R3,[R14,#68]
	LDR     R4,[R14,#160]
	LDR     R5,[R14,#80]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#216]
	LDR     R1,[R14,#104]
	LDR     R2,[R14,#136]
	LDR     R3,[R14,#12]
	LDR     R4,[R14,#72]
	LDR     R5,[R14,#24]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#20]
	LDR     R1,[R14,#96]
	LDR     R2,[R14,#100]
	LDR     R3,[R14,#132]
	LDR     R4,[R14,#164]
	LDR     R5,[R14,#184]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#140]
	LDR     R1,[R14,#8]
	LDR     R2,[R14,#204]
	LDR     R3,[R14,#28]
	LDR     R4,[R14,#88]
	LDR     R5,[R14,#92]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#176]
	LDR     R1,[R14,#112]
	LDR     R2,[R14,#200]
	LDR     R3,[R14,#32]
	LDR     R4,[R14,#152]
	LDR     R5,[R14,#116]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#4]
	LDR     R1,[R14,#144]
	LDR     R2,[R14,#84]
	LDR     R3,[R14,#120]
	LDR     R4,[R14,#180]
	LDR     R5,[R14,#36]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#60]
	LDR     R1,[R14,#168]
	LDR     R2,[R14,#172]
	LDR     R3,[R14,#0]
	LDR     R4,[R14,#148]
	LDR     R5,[R14,#124]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#20]
	LDR     R1,[R14,#104]
	LDR     R2,[R14,#164]
	LDR     R3,[R14,#72]
	LDR     R4,[R14,#212]
	LDR     R5,[R14,#96]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#40]
	LDR     R1,[R14,#184]
	LDR     R2,[R14,#48]
	LDR     R3,[R14,#24]
	LDR     R4,[R14,#216]
	LDR     R5,[R14,#136]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#44]
	LDR     R1,[R14,#160]
	LDR     R2,[R14,#192]
	LDR     R3,[R14,#68]
	LDR     R4,[R14,#128]
	LDR     R5,[R14,#80]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#76]
	LDR     R1,[R14,#52]
	LDR     R2,[R14,#156]
	LDR     R3,[R14,#188]
	LDR     R4,[R14,#220]
	LDR     R5,[R14,#12]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#196]
	LDR     R1,[R14,#64]
	LDR     R2,[R14,#152]
	LDR     R3,[R14,#84]
	LDR     R4,[R14,#144]
	LDR     R5,[R14,#148]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#124]
	LDR     R1,[R14,#168]
	LDR     R2,[R14,#36]
	LDR     R3,[R14,#88]
	LDR     R4,[R14,#208]
	LDR     R5,[R14,#172]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#60]
	LDR     R1,[R14,#200]
	LDR     R2,[R14,#140]
	LDR     R3,[R14,#176]
	LDR     R4,[R14,#0]
	LDR     R5,[R14,#92]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#116]
	LDR     R1,[R14,#4]
	LDR     R2,[R14,#8]
	LDR     R3,[R14,#56]
	LDR     R4,[R14,#204]
	LDR     R5,[R14,#180]
	BL      s8
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#76]
	LDR     R1,[R14,#160]
	LDR     R2,[R14,#220]
	LDR     R3,[R14,#128]
	LDR     R4,[R14,#40]
	LDR     R5,[R14,#52]
	BL      s1
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#96]
	LDR     R1,[R14,#12]
	LDR     R2,[R14,#104]
	LDR     R3,[R14,#80]
	LDR     R4,[R14,#44]
	LDR     R5,[R14,#192]
	BL      s2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#100]
	LDR     R1,[R14,#216]
	LDR     R2,[R14,#20]
	LDR     R3,[R14,#24]
	LDR     R4,[R14,#184]
	LDR     R5,[R14,#136]
	BL      s3
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#132]
	LDR     R1,[R14,#108]
	LDR     R2,[R14,#212]
	LDR     R3,[R14,#16]
	LDR     R4,[R14,#48]
	LDR     R5,[R14,#68]
	BL      s4
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#32]
	LDR     R1,[R14,#120]
	LDR     R2,[R14,#208]
	LDR     R3,[R14,#140]
	LDR     R4,[R14,#200]
	LDR     R5,[R14,#204]
	BL      s5
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#180]
	LDR     R1,[R14,#4]
	LDR     R2,[R14,#92]
	LDR     R3,[R14,#144]
	LDR     R4,[R14,#28]
	LDR     R5,[R14,#8]
	BL      s6
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#116]
	LDR     R1,[R14,#36]
	LDR     R2,[R14,#196]
	LDR     R3,[R14,#124]
	LDR     R4,[R14,#56]
	LDR     R5,[R14,#148]
	BL      s7
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#172]
	LDR     R1,[R14,#60]
	LDR     R2,[R14,#64]
	LDR     R3,[R14,#112]
	LDR     R4,[R14,#152]
	LDR     R5,[R14,#0]
	BL      s8
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xAC       
	MOV     R10,R13
	LDR     R0,[R14,#188]
	LDR     R1,[R14,#164]
	LDR     R2,[R14,#40]
	LDR     R3,[R14,#72]
	LDR     R4,[R14,#104]
	LDR     R5,[R14,#24]
	BL      s4
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0xC0         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xDC       
	MOV     R10,R13
	LDR     R0,[R14,#172]
	LDR     R1,[R14,#92]
	LDR     R2,[R14,#32]
	LDR     R3,[R14,#180]
	LDR     R4,[R14,#112]
	LDR     R5,[R14,#204]
	BL      s7
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R6,[R13,#124]
	ADD     R1,R1,#0x90         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x8C       
	MOV     R10,R13
	LDR     R0,[R14,#52]
	LDR     R1,[R14,#68]
	LDR     R2,[R14,#160]
	LDR     R3,[R14,#136]
	LDR     R4,[R14,#100]
	LDR     R5,[R14,#20]
	BL      s2
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0xE0         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xEC       
	MOV     R10,R13
	LDR     R0,[R14,#8]
	LDR     R1,[R14,#116]
	LDR     R2,[R14,#120]
	LDR     R3,[R14,#168]
	LDR     R4,[R14,#208]
	LDR     R5,[R14,#56]
	BL      s8
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0x80         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xCC       
	MOV     R10,R13
	LDR     R0,[R14,#0]
	LDR     R1,[R14,#60]
	LDR     R2,[R14,#148]
	LDR     R3,[R14,#200]
	LDR     R4,[R14,#84]
	LDR     R5,[R14,#64]
	BL      s6
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R6,[R13,#12]
	ADD     R1,R1,#0xA0         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x9C       
	MOV     R10,R13
	LDR     R0,[R14,#156]
	LDR     R1,[R14,#44]
	LDR     R2,[R14,#76]
	LDR     R3,[R14,#80]
	LDR     R4,[R14,#12]
	LDR     R5,[R14,#192]
	BL      s3
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R9,[R13,#20]
	ADD     R1,R1,#0xD0         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0xBC       
	MOV     R10,R13
	LDR     R0,[R14,#88]
	LDR     R1,[R14,#176]
	LDR     R2,[R14,#28]
	LDR     R3,[R14,#196]
	LDR     R4,[R14,#36]
	LDR     R5,[R14,#152]
	BL      s5
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0xB0         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x80       
	MOV     R10,R13
	LDR     R0,[R14,#132]
	LDR     R1,[R14,#216]
	LDR     R2,[R14,#48]
	LDR     R3,[R14,#184]
	LDR     R4,[R14,#96]
	LDR     R5,[R14,#108]
	BL      s1
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R7,[R13,#64]
	ADD     R1,R1,#0xF0         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x2C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#216]
	LDR     R1,[R14,#192]
	LDR     R2,[R14,#68]
	LDR     R3,[R14,#100]
	LDR     R4,[R14,#132]
	LDR     R5,[R14,#52]
	BL      s4
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0x40         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x5C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#200]
	LDR     R1,[R14,#120]
	LDR     R2,[R14,#60]
	LDR     R3,[R14,#208]
	LDR     R4,[R14,#140]
	LDR     R5,[R14,#124]
	BL      s7
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R6,[R13,#252]
	ADD     R1,R1,#0x10         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x0C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#80]
	LDR     R1,[R14,#96]
	LDR     R2,[R14,#188]
	LDR     R3,[R14,#164]
	LDR     R4,[R14,#128]
	LDR     R5,[R14,#48]
	BL      s2
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0x60         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x6C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#36]
	LDR     R1,[R14,#144]
	LDR     R2,[R14,#148]
	LDR     R3,[R14,#196]
	LDR     R4,[R14,#0]
	LDR     R5,[R14,#84]
	BL      s8
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x4C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#28]
	LDR     R1,[R14,#88]
	LDR     R2,[R14,#176]
	LDR     R3,[R14,#8]
	LDR     R4,[R14,#112]
	LDR     R5,[R14,#92]
	BL      s6
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R6,[R13,#140]
	ADD     R1,R1,#0x20         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x1C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#184]
	LDR     R1,[R14,#72]
	LDR     R2,[R14,#104]
	LDR     R3,[R14,#108]
	LDR     R4,[R14,#40]
	LDR     R5,[R14,#220]
	BL      s3
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R9,[R13,#148]
	ADD     R1,R1,#0x50         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	ADD     R12,R13,#0x3C       
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#116]
	LDR     R1,[R14,#204]
	LDR     R2,[R14,#56]
	LDR     R3,[R14,#4]
	LDR     R4,[R14,#64]
	LDR     R5,[R14,#180]
	BL      s5
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	ADD     R1,R1,#0x30         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R14,[R13,#260]
	MOV     R12,R13
	ADD     R10,R13,#0x80       
	LDR     R0,[R14,#160]
	LDR     R1,[R14,#16]
	LDR     R2,[R14,#76]
	LDR     R3,[R14,#212]
	LDR     R4,[R14,#24]
	LDR     R5,[R14,#136]
	BL      s1
	LDR     R1,[R13,#256]
	LDR     R0,[R13,#264]
	LDR     R7,[R13,#192]
	ADD     R1,R1,#0x70         
	LDMIA   R1,{R10-R12,R14}
	EOR     R2,R9,R10
	BIC     R0,R0,R2
	EOR     R2,R8,R11
	BIC     R0,R0,R2
	EOR     R2,R7,R12
	BIC     R0,R0,R2
	EOR     R2,R6,R14
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
gotresult:
	ADD     R13,R13,#0x010C     
	LDMIA   R13!,{R4-R11}
deseval_end:
	BNE     foundkey
	EOR     R6,R7,R7,LSR #1
	ADD     R7,R7,#1
	CMP     R7,R9
	BCS     half_keys_done
	EOR     R1,R7,R7,LSR #1
	EOR     R1,R1,R6
	TST     R1,#1
	MOVNE   R1,#0x0C            
	BNE     timingloop
	TST     R1,#2
	MOVNE   R1,#0x0F            
	BNE     timingloop
	TST     R1,#4
	MOVNE   R1,#0x12            
	BNE     timingloop
	TST     R1,#8
	MOVNE   R1,#0x28            
	BNE     timingloop
	TST     R1,#0x10            
	MOVNE   R1,#0x29            
	BNE     timingloop
	TST     R1,#0x20            
	MOVNE   R1,#0x2A            
	BNE     timingloop
	TST     R1,#0x40            
	MOVNE   R1,#0x2B            
	BNE     timingloop
	TST     R1,#0x80            
	MOVNE   R1,#0x2D            
	BNE     timingloop
	TST     R1,#0x0100          
	MOVNE   R1,#0x2E            
	BNE     timingloop
	TST     R1,#0x0200          
	MOVNE   R1,#0x31            
	BNE     timingloop
	TST     R1,#0x0400          
	MOVNE   R1,#0x32            
	BNE     timingloop
	TST     R1,#0x0800          
	MOVNE   R1,#0
	BNE     timingloop
	TST     R1,#0x1000          
	MOVNE   R1,#1
	BNE     timingloop
	TST     R1,#0x2000
	MOVNE   R1,#2
	BNE     timingloop
	TST     R1,#0x4000
	MOVNE   R1,#4
	BNE     timingloop
	TST     R1,#0x8000
	MOVNE   R1,#6
	BNE     timingloop
	TST     R1,#0x00010000
	MOVNE   R1,#7
	BNE     timingloop
	TST     R1,#0x00020000
	MOVNE   R1,#9
	BNE     timingloop
	TST     R1,#0x00040000
	MOVNE   R1,#0x0D            
	BNE     timingloop

	.word	0xE6000010

this_shouldnt_happen:
	b	this_shouldnt_happen
