// Copyright distributed.net 1997-1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
/*
**  This is the "prelude" module for the win32/win16 console client.
**  win32GUI shims are elsewhere.
**
**  "prelude" serves as a shim between WinMain() [in client.cpp] and
**  realmain() [also in client.cpp]
*/
//
// $Log: w32pre.cpp,v $
// Revision 1.3  1998/11/14 13:46:58  cyp
// Disabled previous instance check to allow multiple win16 instances (for
// modes).
//
// Revision 1.2  1998/10/19 13:21:15  cyp
// win16 changes
//
// Revision 1.1  1998/10/11 00:27:12  cyp
// Created.
//
//
//
#if (!defined(lint) && defined(__showids__))
const char *w32pre_cpp(void) {
return "@(#)$Id: w32pre.cpp,v 1.3 1998/11/14 13:46:58 cyp Exp $"; }
#endif

#include "baseincs.h" 

static struct 
{
  HINSTANCE hInstance;
  int nCmdShow;
  int argc;
  char **argv;
} prestatics = {NULL,0,0,NULL};


HINSTANCE winGetInstanceHandle(void)
{
  return prestatics.hInstance;
}

/* ----------------------------------- */

int winGetInstanceShowCmd(void)
{
  return prestatics.nCmdShow;
}

/* ----------------------------------- */

int winGetInstanceArgc(void)
{
  return prestatics.argc;
}

/* ----------------------------------- */

char **winGetInstanceArgv(void)
{
  return prestatics.argv;
}

/* ----------------------------------- */

static char **parseCmdLine(HINSTANCE hInstance, LPSTR lpszCmdLine, int *argcP )
{
  static char *argv[64];
  static char argbuff[512];

  int argc=0, quotes;
  LPSTR start;
  char *aptr = &argbuff[0];

  argv[argc++] = &argbuff[0];
  GetModuleFileName(hInstance, argbuff, sizeof(argbuff));
  aptr = &argbuff[strlen(argbuff)+1];
  
  while (*lpszCmdLine)
    {
    quotes = 0;
    while (*lpszCmdLine==' ' || *lpszCmdLine=='\t')
      lpszCmdLine++;
    if (*lpszCmdLine == '\"' || *lpszCmdLine == '\'')
      quotes = *lpszCmdLine++;
    start = lpszCmdLine;
    while (*lpszCmdLine && ((quotes)?(*lpszCmdLine!=quotes):
                           (*lpszCmdLine!=' ' && *lpszCmdLine!='\t')))
      lpszCmdLine++;
    if (aptr + ((lpszCmdLine-start)+1) >= &argbuff[sizeof(argbuff)-1])
      break;
    argv[argc++] = aptr;
    while (start<lpszCmdLine)
      *aptr++ = *start++;
    *aptr++ = 0;
    if (quotes)
      lpszCmdLine++;
    if (argc+1 == (sizeof(argv)/sizeof(argv[1])))
      break;
    }
  argv[argc]=NULL;
  
  *argcP = argc;
  return argv;
}      
      
/* ----------------------------------- */

int winClientPrelude(HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow, int (*realmain)(int, char **))
{
  int argc = (hPrevInstance != NULL); //use up argument
  char **argv;

  //if (hPrevInstance)
  //  {
  //  w32ConShowWindow(); //show window if not -runhidden
  //  return 0;
  //  }

  prestatics.hInstance = hInstance;
  prestatics.nCmdShow = nCmdShow;
  argv = parseCmdLine(hInstance, lpszCmdLine, &argc );
  prestatics.argc = argc;
  prestatics.argv = argv;

  #if (CLIENT_OS == OS_WIN32)
  if (win32CliGetVersion() >= 20) /* DOS style version # (>= 20 for NT) */
    {
    if (argc == 1) /* possibly old style NT service (no cmdline options) */
      {            
      if ( win32CliOldStyleInitializeService() == 0 ) /* started ok */
        return 0;  /* service started (or errors handled) so quit here */
      }
    if (argc >= 2 && strcmp( argv[1], "-svcrun" ) == 0) 
      {                                     
      if ( win32CliInitializeService(argc,argv) == 0) /* started ok */
        return 0;  /* service started so quit here */
      /*inappropriate "-svcrun". fall through and let the cmdline parser puke*/
      }
    } /* if (VER_PLATFORM_WIN32_NT == osver.dwPlatformId) */
  #endif //#if (CLIENT_OS == OS_WIN32)   

  return (*realmain)( argc, argv );
}
