/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version
2 of the License, or (at your option) any later version.

A non-transferrable, royalty free license to this code
is granted to distributed.net for use exclusively in the DES Challenge II.

Copyright Biel/Switzerland, 21. Janaury 1999 by Christoph Dworzak

The s-boxes are based on the work of Matthew Kwan.

Version 3 (7.8MKey/s on PC164@500MHz)

*/

	.set noat
	.set noreorder
.text

	.align 5
	.globl checkKey
	.ent checkKey
checkKey:
	ldgp $29,0($27)
	lda $30,-88($30)
	stq $26,0($30)
	stq $9, 8($30)

	stq $10,16($30)
	stq $11,24($30)
	stq $12,32($30)
	stq $13,40($30)

	stq $14,48($30)
	stq $15,56($30)
	stq $17,64($30)
	bis $16,$16,$9
	
/*
    s1 (K[47],K[11],K[26],K[ 3],K[13],K[41]) ;
    s2 (K[27],K[ 6],K[54],K[48],K[39],K[19]) ;
    s3 (K[53],K[25],K[33],K[34],K[17],K[ 5]) ;
    s4 (K[ 4],K[55],K[24],K[32],K[40],K[20]) ;
    s5 (K[36],K[31],K[21],K[ 8],K[23],K[52]) ;
    s6 (K[14],K[29],K[51],K[ 9],K[35],K[30]) ;
    s7 (K[ 2],K[37],K[22],K[ 0],K[42],K[38]) ;
    s8 (K[16],K[43],K[44],K[ 1],K[ 7],K[28]) ;

	[..]
*/

	srl $17,12,$0
	lda $1,pt
	sll $0,9,$0
	addq $0,$1,$1
	stq $1,72($30)
	addq $1,8,$2
	stq $2,80($30)

round1:
	blbc $17,round2

	lda $13,PT+8
	ldq $16,376($9)
	lda $14,PT
	ldq $17,88($9)
	ldq $15,72($30)
	ldq $18,208($9)
	ldq $19,24($9)
	ldq $20,104($9)
	ldq $21,328($9)
	bsr $26,s1
	ldq $16,216($9)
	ldq $17,48($9)
	ldq $18,432($9)
	ldq $19,384($9)
	ldq $20,312($9)
	ldq $21,152($9)
	bsr $26,s2
	ldq $16,424($9)
	ldq $17,200($9)
	ldq $18,264($9)
	ldq $19,272($9)
	ldq $20,136($9)
	ldq $21,40($9)
	bsr $26,s3
	ldq $16,32($9)
	ldq $17,440($9)
	ldq $18,192($9)
	ldq $19,256($9)
	ldq $20,320($9)
	ldq $21,160($9)
	bsr $26,s4
	ldq $16,288($9)
	ldq $17,248($9)
	ldq $18,168($9)
	ldq $19,64($9)
	ldq $20,184($9)
	ldq $21,416($9)
	bsr $26,s5
	ldq $16,112($9)
	ldq $17,232($9)
	ldq $18,408($9)
	ldq $19,72($9)
	ldq $20,280($9)
	ldq $21,240($9)
	bsr $26,s6
	ldq $16,16($9)
	ldq $17,296($9)
	ldq $18,176($9)
	ldq $19,0($9)
	ldq $20,336($9)
	ldq $21,304($9)
	bsr $26,s7
	ldq $16,128($9)
	ldq $17,344($9)
	ldq $18,352($9)
	ldq $19,8($9)
	ldq $20,56($9)
	ldq $21,224($9)
	bsr $26,s8

round2:
	ldq $13,72($30)
	lda $14,PT+8
	ldq $15,80($30)

	ldq $17,64($30)
	blbc $17,round2.1

	ldq $16,88($9)
	ldq $17,40($9)
	ldq $18,48($9)
	ldq $19,312($9)
	ldq $20,376($9)
	ldq $21,216($9)
	bsr $26,s4
	ldq $16,168($9)
	ldq $17,288($9)
	ldq $18,248($9)
	ldq $19,128($9)
	ldq $20,336($9)
	ldq $21,296($9)
	bsr $26,s6

round2.1:
	ldq $17,64($30)
	and $17,2,$0
	beq $0,round2.2

	ldq $16,432($9)
	ldq $17,144($9)
	ldq $18,264($9)
	ldq $19,80($9)
	ldq $20,160($9)
	ldq $21,384($9)
	bsr $26,s1

round2.2:
	ldq $17,64($30)
	and $17,4,$0
	beq $0,round2.3

	ldq $16,272($9)
	ldq $17,104($9)
	ldq $18,32($9)
	ldq $19,440($9)
	ldq $20,368($9)
	ldq $21,208($9)
	bsr $26,s2

round2.3:
	ldq $17,64($30)
	and $17,8,$0
	beq $0,round2.4

	ldq $16,24($9)
	ldq $17,256($9)
	ldq $18,320($9)
	ldq $19,328($9)
	ldq $20,192($9)
	ldq $21,96($9)
	bsr $26,s3

round2.4:
	ldq $17,64($30)
	and $17,16,$0
	beq $0,round2.5

	ldq $16,344($9)
	ldq $17,304($9)
	ldq $18,224($9)
	ldq $19,120($9)
	ldq $20,240($9)
	ldq $21,0($9)
	bsr $26,s5

round2.5:
	ldq $17,64($30)
	and $17,32,$0
	beq $0,round2.6

	ldq $16,72($9)
	ldq $17,352($9)
	ldq $18,232($9)
	ldq $19,56($9)
	ldq $20,392($9)
	ldq $21,360($9)
	bsr $26,s7

round2.6:
	ldq $17,64($30)
	and $17,64,$0
	beq $0,round16

	ldq $16,184($9)
	ldq $17,400($9)
	ldq $18,408($9)
	ldq $19,64($9)
	ldq $20,112($9)
	ldq $21,280($9)
	bsr $26,s8

round16:
	ldq $17,64($30)
	and $17,128,$0
	beq	$0,round15

	lda $13,CT+8
	ldq $16,320($9)
	lda $14,CT
	ldq $17,32($9)
	lda $15,ct
	ldq $18,152($9)
	ldq $19,424($9)
	ldq $20,48($9)
	ldq $21,272($9)
	bsr $26,s1
	ldq $16,160($9)
	ldq $17,192($9)
	ldq $18,376($9)
	ldq $19,328($9)
	ldq $20,256($9)
	ldq $21,96($9)
	bsr $26,s2
	ldq $16,368($9)
	ldq $17,144($9)
	ldq $18,208($9)
	ldq $19,216($9)
	ldq $20,80($9)
	ldq $21,440($9)
	bsr $26,s3
	ldq $16,432($9)
	ldq $17,384($9)
	ldq $18,136($9)
	ldq $19,200($9)
	ldq $20,264($9)
	ldq $21,104($9)
	bsr $26,s4
	ldq $16,232($9)
	ldq $17,408($9)
	ldq $18,112($9)
	ldq $19,8($9)
	ldq $20,128($9)
	ldq $21,360($9)
	bsr $26,s5
	ldq $16,56($9)
	ldq $17,176($9)
	ldq $18,352($9)
	ldq $19,16($9)
	ldq $20,224($9)
	ldq $21,184($9)
	bsr $26,s6
	ldq $16,400($9)
	ldq $17,240($9)
	ldq $18,120($9)
	ldq $19,416($9)
	ldq $20,280($9)
	ldq $21,248($9)
	bsr $26,s7
	ldq $16,72($9)
	ldq $17,288($9)
	ldq $18,296($9)
	ldq $19,392($9)
	ldq $20,0($9)
	ldq $21,168($9)
	bsr $26,s8

round15:
	lda $13,ct
	lda $14,CT+8
	lda $15,ct+8

	ldq $17,64($30)
	and $17,128,$0
	beq	$0,round15.1

	ldq $16,264($9)
	ldq $17,432($9)
	ldq $18,96($9)
	ldq $19,368($9)
	ldq $20,192($9)
	ldq $21,216($9)
	bsr $26,s1
	ldq $16,376($9)
	ldq $17,328($9)
	ldq $18,80($9)
	ldq $19,144($9)
	ldq $20,208($9)
	ldq $21,48($9)
	bsr $26,s4
	ldq $16,176($9)
	ldq $17,352($9)
	ldq $18,56($9)
	ldq $19,392($9)
	ldq $20,72($9)
	ldq $21,304($9)
	bsr $26,s5
	ldq $16,0($9)
	ldq $17,120($9)
	ldq $18,296($9)
	ldq $19,400($9)
	ldq $20,168($9)
	ldq $21,128($9)
	bsr $26,s6

round15.1:
	ldq $17,64($30)
	srl $17,8,$0
	blbc $0,round15.2

	ldq $16,104($9)
	ldq $17,136($9)
	ldq $18,320($9)
	ldq $19,272($9)
	ldq $20,200($9)
	ldq $21,40($9)
	bsr $26,s2

round15.2:
	ldq $17,64($30)
	srl $17,9,$0
	blbc $0,round15.3

	ldq $16,312($9)
	ldq $17,88($9)
	ldq $18,152($9)
	ldq $19,160($9)
	ldq $20,24($9)
	ldq $21,384($9)
	bsr $26,s3

round15.3:
	ldq $17,64($30)
	srl $17,10,$0
	blbc $0,round15.4

	ldq $16,344($9)
	ldq $17,184($9)
	ldq $18,64($9)
	ldq $19,360($9)
	ldq $20,224($9)
	ldq $21,408($9)
	bsr $26,s7

round15.4:
	ldq $17,64($30)
	srl $17,11,$0
	blbc $0,round14

	ldq $16,16($9)
	ldq $17,232($9)
	ldq $18,240($9)
	ldq $19,336($9)
	ldq $20,416($9)
	ldq $21,112($9)
	bsr $26,s8

round14:
	lda $13,ct+8
	ldq $16,152($9)
	lda $14,ct
	ldq $17,320($9)
	lda $15,t+8
	ldq $18,440($9)
	ldq $19,256($9)
	ldq $20,80($9)
	ldq $21,104($9)
	bsr $26,s1
	ldq $16,192($9)
	ldq $17,24($9)
	ldq $18,208($9)
	ldq $19,160($9)
	ldq $20,88($9)
	ldq $21,384($9)
	bsr $26,s2
	ldq $16,200($9)
	ldq $17,432($9)
	ldq $18,40($9)
	ldq $19,48($9)
	ldq $20,368($9)
	ldq $21,272($9)
	bsr $26,s3
	ldq $16,264($9)
	ldq $17,216($9)
	ldq $18,424($9)
	ldq $19,32($9)
	ldq $20,96($9)
	ldq $21,136($9)
	bsr $26,s4
	ldq $16,64($9)
	ldq $17,240($9)
	ldq $18,416($9)
	ldq $19,280($9)
	ldq $20,400($9)
	ldq $21,408($9)
	bsr $26,s5
	ldq $16,360($9)
	ldq $17,8($9)
	ldq $18,184($9)
	ldq $19,288($9)
	ldq $20,56($9)
	ldq $21,16($9)
	bsr $26,s6
	ldq $16,232($9)
	ldq $17,72($9)
	ldq $18,392($9)
	ldq $19,248($9)
	ldq $20,112($9)
	ldq $21,296($9)
	bsr $26,s7
	ldq $16,344($9)
	ldq $17,120($9)
	ldq $18,128($9)
	ldq $19,224($9)
	ldq $20,304($9)
	ldq $21,0($9)
	bsr $26,s8

round13:
	lda $13,t+8
	ldq $16,40($9)
	lda $14,ct+8
	ldq $17,208($9)
	lda $15,t
	ldq $18,328($9)
	ldq $19,144($9)
	ldq $20,424($9)
	ldq $21,192($9)
	bsr $26,s1
	ldq $16,80($9)
	ldq $17,368($9)
	ldq $18,96($9)
	ldq $19,48($9)
	ldq $20,432($9)
	ldq $21,272($9)
	bsr $26,s2
	ldq $16,88($9)
	ldq $17,320($9)
	ldq $18,384($9)
	ldq $19,136($9)
	ldq $20,256($9)
	ldq $21,160($9)
	bsr $26,s3
	ldq $16,152($9)
	ldq $17,104($9)
	ldq $18,312($9)
	ldq $19,376($9)
	ldq $20,440($9)
	ldq $21,24($9)
	bsr $26,s4
	ldq $16,392($9)
	ldq $17,128($9)
	ldq $18,304($9)
	ldq $19,168($9)
	ldq $20,288($9)
	ldq $21,296($9)
	bsr $26,s5
	ldq $16,248($9)
	ldq $17,336($9)
	ldq $18,72($9)
	ldq $19,176($9)
	ldq $20,416($9)
	ldq $21,344($9)
	bsr $26,s6
	ldq $16,120($9)
	ldq $17,400($9)
	ldq $18,280($9)
	ldq $19,352($9)
	ldq $20,0($9)
	ldq $21,184($9)
	bsr $26,s7
	ldq $16,232($9)
	ldq $17,8($9)
	ldq $18,16($9)
	ldq $19,112($9)
	ldq $20,408($9)
	ldq $21,360($9)
	bsr $26,s8

round12:
	lda $13,t
	ldq $16,384($9)
	lda $14,t+8
	ldq $17,96($9)
	lda $15,t+8
	ldq $18,216($9)
	ldq $19,32($9)
	ldq $20,312($9)
	ldq $21,80($9)
	bsr $26,s1
	ldq $16,424($9)
	ldq $17,256($9)
	ldq $18,440($9)
	ldq $19,136($9)
	ldq $20,320($9)
	ldq $21,160($9)
	bsr $26,s2
	ldq $16,432($9)
	ldq $17,208($9)
	ldq $18,272($9)
	ldq $19,24($9)
	ldq $20,144($9)
	ldq $21,48($9)
	bsr $26,s3
	ldq $16,40($9)
	ldq $17,192($9)
	ldq $18,200($9)
	ldq $19,264($9)
	ldq $20,328($9)
	ldq $21,368($9)
	bsr $26,s4
	ldq $16,280($9)
	ldq $17,16($9)
	ldq $18,408($9)
	ldq $19,56($9)
	ldq $20,176($9)
	ldq $21,184($9)
	bsr $26,s5
	ldq $16,352($9)
	ldq $17,224($9)
	ldq $18,400($9)
	ldq $19,64($9)
	ldq $20,304($9)
	ldq $21,232($9)
	bsr $26,s6
	ldq $16,8($9)
	ldq $17,288($9)
	ldq $18,168($9)
	ldq $19,240($9)
	ldq $20,360($9)
	ldq $21,72($9)
	bsr $26,s7
	ldq $16,120($9)
	ldq $17,336($9)
	ldq $18,344($9)
	ldq $19,0($9)
	ldq $20,296($9)
	ldq $21,248($9)
	bsr $26,s8

round11:
	lda $13,t+8
	ldq $16,272($9)
	lda $14,t
	ldq $17,440($9)
	lda $15,t
	ldq $18,104($9)
	ldq $19,376($9)
	ldq $20,200($9)
	ldq $21,424($9)
	bsr $26,s1
	ldq $16,312($9)
	ldq $17,144($9)
	ldq $18,328($9)
	ldq $19,24($9)
	ldq $20,208($9)
	ldq $21,48($9)
	bsr $26,s2
	ldq $16,320($9)
	ldq $17,96($9)
	ldq $18,160($9)
	ldq $19,368($9)
	ldq $20,32($9)
	ldq $21,136($9)
	bsr $26,s3
	ldq $16,384($9)
	ldq $17,80($9)
	ldq $18,88($9)
	ldq $19,152($9)
	ldq $20,216($9)
	ldq $21,256($9)
	bsr $26,s4
	ldq $16,168($9)
	ldq $17,344($9)
	ldq $18,296($9)
	ldq $19,416($9)
	ldq $20,64($9)
	ldq $21,72($9)
	bsr $26,s5
	ldq $16,240($9)
	ldq $17,112($9)
	ldq $18,288($9)
	ldq $19,392($9)
	ldq $20,408($9)
	ldq $21,120($9)
	bsr $26,s6
	ldq $16,336($9)
	ldq $17,176($9)
	ldq $18,56($9)
	ldq $19,128($9)
	ldq $20,248($9)
	ldq $21,400($9)
	bsr $26,s7
	ldq $16,8($9)
	ldq $17,224($9)
	ldq $18,232($9)
	ldq $19,360($9)
	ldq $20,184($9)
	ldq $21,352($9)
	bsr $26,s8

round10:
	lda $13,t
	ldq $16,160($9)
	lda $14,t+8
	ldq $17,328($9)
	lda $15,t+8
	ldq $18,192($9)
	ldq $19,264($9)
	ldq $20,88($9)
	ldq $21,312($9)
	bsr $26,s1
	ldq $16,200($9)
	ldq $17,32($9)
	ldq $18,216($9)
	ldq $19,368($9)
	ldq $20,96($9)
	ldq $21,136($9)
	bsr $26,s2
	ldq $16,208($9)
	ldq $17,440($9)
	ldq $18,48($9)
	ldq $19,256($9)
	ldq $20,376($9)
	ldq $21,24($9)
	bsr $26,s3
	ldq $16,272($9)
	ldq $17,424($9)
	ldq $18,432($9)
	ldq $19,40($9)
	ldq $20,104($9)
	ldq $21,144($9)
	bsr $26,s4
	ldq $16,56($9)
	ldq $17,232($9)
	ldq $18,184($9)
	ldq $19,304($9)
	ldq $20,392($9)
	ldq $21,400($9)
	bsr $26,s5
	ldq $16,128($9)
	ldq $17,0($9)
	ldq $18,176($9)
	ldq $19,280($9)
	ldq $20,296($9)
	ldq $21,8($9)
	bsr $26,s6
	ldq $16,224($9)
	ldq $17,64($9)
	ldq $18,416($9)
	ldq $19,16($9)
	ldq $20,352($9)
	ldq $21,288($9)
	bsr $26,s7
	ldq $16,336($9)
	ldq $17,112($9)
	ldq $18,120($9)
	ldq $19,248($9)
	ldq $20,72($9)
	ldq $21,240($9)
	bsr $26,s8

round9:
	lda $13,t+8
	ldq $16,48($9)
	lda $14,t
	ldq $17,216($9)
	lda $15,t
	ldq $18,80($9)
	ldq $19,152($9)
	ldq $20,432($9)
	ldq $21,200($9)
	bsr $26,s1
	ldq $16,88($9)
	ldq $17,376($9)
	ldq $18,104($9)
	ldq $19,256($9)
	ldq $20,440($9)
	ldq $21,24($9)
	bsr $26,s2
	ldq $16,96($9)
	ldq $17,328($9)
	ldq $18,136($9)
	ldq $19,144($9)
	ldq $20,264($9)
	ldq $21,368($9)
	bsr $26,s3
	ldq $16,160($9)
	ldq $17,312($9)
	ldq $18,320($9)
	ldq $19,384($9)
	ldq $20,192($9)
	ldq $21,32($9)
	bsr $26,s4
	ldq $16,416($9)
	ldq $17,120($9)
	ldq $18,72($9)
	ldq $19,408($9)
	ldq $20,280($9)
	ldq $21,288($9)
	bsr $26,s5
	ldq $16,16($9)
	ldq $17,360($9)
	ldq $18,64($9)
	ldq $19,168($9)
	ldq $20,184($9)
	ldq $21,336($9)
	bsr $26,s6
	ldq $16,112($9)
	ldq $17,392($9)
	ldq $18,304($9)
	ldq $19,344($9)
	ldq $20,240($9)
	ldq $21,176($9)
	bsr $26,s7
	ldq $16,224($9)
	ldq $17,0($9)
	ldq $18,8($9)
	ldq $19,352($9)
	ldq $20,400($9)
	ldq $21,128($9)
	bsr $26,s8

round8:
	lda $13,t
	ldq $16,192($9)
	lda $14,t+8
	ldq $17,160($9)
	lda $15,t+8
	ldq $18,24($9)
	ldq $19,96($9)
	ldq $20,376($9)
	ldq $21,144($9)
	bsr $26,s1
	ldq $16,32($9)
	ldq $17,320($9)
	ldq $18,48($9)
	ldq $19,200($9)
	ldq $20,384($9)
	ldq $21,424($9)
	bsr $26,s2
	ldq $16,40($9)
	ldq $17,272($9)
	ldq $18,80($9)
	ldq $19,88($9)
	ldq $20,208($9)
	ldq $21,312($9)
	bsr $26,s3
	ldq $16,104($9)
	ldq $17,256($9)
	ldq $18,264($9)
	ldq $19,328($9)
	ldq $20,136($9)
	ldq $21,432($9)
	bsr $26,s4
	ldq $16,360($9)
	ldq $17,64($9)
	ldq $18,16($9)
	ldq $19,352($9)
	ldq $20,224($9)
	ldq $21,232($9)
	bsr $26,s5
	ldq $16,400($9)
	ldq $17,304($9)
	ldq $18,8($9)
	ldq $19,112($9)
	ldq $20,128($9)
	ldq $21,280($9)
	bsr $26,s6
	ldq $16,56($9)
	ldq $17,336($9)
	ldq $18,248($9)
	ldq $19,288($9)
	ldq $20,184($9)
	ldq $21,120($9)
	bsr $26,s7
	ldq $16,168($9)
	ldq $17,416($9)
	ldq $18,392($9)
	ldq $19,296($9)
	ldq $20,344($9)
	ldq $21,72($9)
	bsr $26,s8

round7:
	lda $13,t+8
	ldq $16,80($9)
	lda $14,t
	ldq $17,48($9)
	lda $15,t
	ldq $18,368($9)
	ldq $19,440($9)
	ldq $20,264($9)
	ldq $21,32($9)
	bsr $26,s1
	ldq $16,376($9)
	ldq $17,208($9)
	ldq $18,136($9)
	ldq $19,88($9)
	ldq $20,272($9)
	ldq $21,312($9)
	bsr $26,s2
	ldq $16,384($9)
	ldq $17,160($9)
	ldq $18,424($9)
	ldq $19,432($9)
	ldq $20,96($9)
	ldq $21,200($9)
	bsr $26,s3
	ldq $16,192($9)
	ldq $17,144($9)
	ldq $18,152($9)
	ldq $19,216($9)
	ldq $20,24($9)
	ldq $21,320($9)
	bsr $26,s4
	ldq $16,248($9)
	ldq $17,392($9)
	ldq $18,344($9)
	ldq $19,240($9)
	ldq $20,112($9)
	ldq $21,120($9)
	bsr $26,s5
	ldq $16,288($9)
	ldq $17,408($9)
	ldq $18,336($9)
	ldq $19,0($9)
	ldq $20,16($9)
	ldq $21,168($9)
	bsr $26,s6
	ldq $16,416($9)
	ldq $17,224($9)
	ldq $18,352($9)
	ldq $19,176($9)
	ldq $20,72($9)
	ldq $21,8($9)
	bsr $26,s7
	ldq $16,56($9)
	ldq $17,304($9)
	ldq $18,280($9)
	ldq $19,184($9)
	ldq $20,232($9)
	ldq $21,400($9)
	bsr $26,s8

round6:
	lda $13,t
	ldq $16,424($9)
	lda $14,t+8
	ldq $17,136($9)
	lda $15,t+8
	ldq $18,256($9)
	ldq $19,328($9)
	ldq $20,152($9)
	ldq $21,376($9)
	bsr $26,s1
	ldq $16,264($9)
	ldq $17,96($9)
	ldq $18,24($9)
	ldq $19,432($9)
	ldq $20,160($9)
	ldq $21,200($9)
	bsr $26,s2
	ldq $16,272($9)
	ldq $17,48($9)
	ldq $18,312($9)
	ldq $19,320($9)
	ldq $20,440($9)
	ldq $21,88($9)
	bsr $26,s3
	ldq $16,80($9)
	ldq $17,32($9)
	ldq $18,40($9)
	ldq $19,104($9)
	ldq $20,368($9)
	ldq $21,208($9)
	bsr $26,s4
	ldq $16,352($9)
	ldq $17,280($9)
	ldq $18,232($9)
	ldq $19,128($9)
	ldq $20,0($9)
	ldq $21,8($9)
	bsr $26,s5
	ldq $16,176($9)
	ldq $17,296($9)
	ldq $18,224($9)
	ldq $19,360($9)
	ldq $20,344($9)
	ldq $21,56($9)
	bsr $26,s6
	ldq $16,304($9)
	ldq $17,112($9)
	ldq $18,240($9)
	ldq $19,64($9)
	ldq $20,400($9)
	ldq $21,336($9)
	bsr $26,s7
	ldq $16,416($9)
	ldq $17,408($9)
	ldq $18,168($9)
	ldq $19,72($9)
	ldq $20,120($9)
	ldq $21,288($9)
	bsr $26,s8

round5:
	lda $13,t+8
	ldq $16,312($9)
	lda $14,t
	ldq $17,24($9)
	lda $15,t
	ldq $18,144($9)
	ldq $19,216($9)
	ldq $20,40($9)
	ldq $21,264($9)
	bsr $26,s1
	ldq $16,152($9)
	ldq $17,440($9)
	ldq $18,368($9)
	ldq $19,320($9)
	ldq $20,48($9)
	ldq $21,88($9)
	bsr $26,s2
	ldq $16,160($9)
	ldq $17,136($9)
	ldq $18,200($9)
	ldq $19,208($9)
	ldq $20,328($9)
	ldq $21,432($9)
	bsr $26,s3
	ldq $16,424($9)
	ldq $17,376($9)
	ldq $18,384($9)
	ldq $19,192($9)
	ldq $20,256($9)
	ldq $21,96($9)
	bsr $26,s4
	ldq $16,240($9)
	ldq $17,168($9)
	ldq $18,120($9)
	ldq $19,16($9)
	ldq $20,360($9)
	ldq $21,336($9)
	bsr $26,s5
	ldq $16,64($9)
	ldq $17,184($9)
	ldq $18,112($9)
	ldq $19,248($9)
	ldq $20,232($9)
	ldq $21,416($9)
	bsr $26,s6
	ldq $16,408($9)
	ldq $17,0($9)
	ldq $18,128($9)
	ldq $19,392($9)
	ldq $20,288($9)
	ldq $21,224($9)
	bsr $26,s7
	ldq $16,304($9)
	ldq $17,296($9)
	ldq $18,56($9)
	ldq $19,400($9)
	ldq $20,8($9)
	ldq $21,176($9)
	bsr $26,s8

round4:
	lda $13,t
	ldq $16,200($9)
	lda $14,t+8
	ldq $17,368($9)
	lda $15,t+8
	ldq $18,32($9)
	ldq $19,104($9)
	ldq $20,384($9)
	ldq $21,152($9)
	bsr $26,s1
	ldq $10,80($30)
	ornot $31,$31,$0
	ldq $1, 2*8($10)
	ldq $2, 2*8($15)
	ldq $3,48*8($10)
	ldq $4,48*8($15)
	ldq $5, 4*8($10)
	eqv $1,$2,$1
	ldq $6, 4*8($15)
	eqv $3,$4,$3
	ldq $7,50*8($10)
	ldq $8,50*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,40($9)
	ldq $17,328($9)
	ldq $18,256($9)
	ldq $19,208($9)
	ldq $20,136($9)
	ldq $21,432($9)
	bsr $26,s2
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1,36*8($10)
	ldq $2,36*8($15)
	ldq $3,14*8($10)
	ldq $4,14*8($15)
	ldq $5,10*8($10)
	eqv $1,$2,$1
	ldq $6,10*8($15)
	eqv $3,$4,$3
	ldq $7,24*8($10)
	ldq $8,24*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,48($9)
	ldq $17,24($9)
	ldq $18,88($9)
	ldq $19,96($9)
	ldq $20,216($9)
	ldq $21,320($9)
	bsr $26,s3
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1,46*8($10)
	ldq $2,46*8($15)
	ldq $3,40*8($10)
	ldq $4,40*8($15)
	ldq $5,60*8($10)
	eqv $1,$2,$1
	ldq $6,60*8($15)
	eqv $3,$4,$3
	ldq $7,58*8($10)
	ldq $8,58*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,312($9)
	ldq $17,264($9)
	ldq $18,272($9)
	ldq $19,80($9)
	ldq $20,144($9)
	ldq $21,440($9)
	bsr $26,s4
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1, 8*8($10)
	ldq $2, 8*8($15)
	ldq $3,26*8($10)
	ldq $4,26*8($15)
	ldq $5,12*8($10)
	eqv $1,$2,$1
	ldq $6,12*8($15)
	eqv $3,$4,$3
	ldq $7, 6*8($10)
	ldq $8, 6*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,128($9)
	ldq $17,56($9)
	ldq $18,8($9)
	ldq $19,344($9)
	ldq $20,248($9)
	ldq $21,224($9)
	bsr $26,s5
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1,22*8($10)
	ldq $2,22*8($15)
	ldq $3,44*8($10)
	ldq $4,44*8($15)
	ldq $5, 0*8($10)
	eqv $1,$2,$1
	ldq $6, 0*8($15)
	eqv $3,$4,$3
	ldq $7,62*8($10)
	ldq $8,62*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,392($9)
	ldq $17,72($9)
	ldq $18,0($9)
	ldq $19,352($9)
	ldq $20,120($9)
	ldq $21,304($9)
	bsr $26,s6
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1,30*8($10)
	ldq $2,30*8($15)
	ldq $3,18*8($10)
	ldq $4,18*8($15)
	ldq $5,20*8($10)
	eqv $1,$2,$1
	ldq $6,20*8($15)
	eqv $3,$4,$3
	ldq $7,32*8($10)
	ldq $8,32*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,296($9)
	ldq $17,360($9)
	ldq $18,16($9)
	ldq $19,280($9)
	ldq $20,176($9)
	ldq $21,112($9)
	bsr $26,s7
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1,56*8($10)
	ldq $2,56*8($15)
	ldq $3,28*8($10)
	ldq $4,28*8($15)
	ldq $5,42*8($10)
	eqv $1,$2,$1
	ldq $6,42*8($15)
	eqv $3,$4,$3
	ldq $7,54*8($10)
	ldq $8,54*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,408($9)
	ldq $17,184($9)
	ldq $18,416($9)
	ldq $19,288($9)
	ldq $20,336($9)
	ldq $21,64($9)
	bsr $26,s8
	ldq $10,80($30)
	ldq $0,64($30)
	ldq $1,38*8($10)
	ldq $2,38*8($15)
	ldq $3,52*8($10)
	ldq $4,52*8($15)
	ldq $5,16*8($10)
	eqv $1,$2,$1
	ldq $6,16*8($15)
	eqv $3,$4,$3
	ldq $7,34*8($10)
	ldq $8,34*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

round3:
	lda $13,t+8
	ldq $16,88($9)
	lda $14,t
	ldq $17,256($9)
	lda $15,t
	ldq $18,376($9)
	ldq $19,192($9)
	ldq $20,272($9)
	ldq $21,40($9)
	bsr $26,s1
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1, 2*8($10)
	ldq $2, 2*8($15)
	ldq $3,48*8($10)
	ldq $4,48*8($15)
	ldq $5, 4*8($10)
	eqv $1,$2,$1
	ldq $6, 4*8($15)
	eqv $3,$4,$3
	ldq $7,50*8($10)
	ldq $8,50*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,384($9)
	ldq $17,216($9)
	ldq $18,144($9)
	ldq $19,96($9)
	ldq $20,24($9)
	ldq $21,320($9)
	bsr $26,s2
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1,36*8($10)
	ldq $2,36*8($15)
	ldq $3,14*8($10)
	ldq $4,14*8($15)
	ldq $5,10*8($10)
	eqv $1,$2,$1
	ldq $6,10*8($15)
	eqv $3,$4,$3
	ldq $7,24*8($10)
	ldq $8,24*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,136($9)
	ldq $17,368($9)
	ldq $18,432($9)
	ldq $19,440($9)
	ldq $20,104($9)
	ldq $21,208($9)
	bsr $26,s3
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1,46*8($10)
	ldq $2,46*8($15)
	ldq $3,40*8($10)
	ldq $4,40*8($15)
	ldq $5,60*8($10)
	eqv $1,$2,$1
	ldq $6,60*8($15)
	eqv $3,$4,$3
	ldq $7,58*8($10)
	ldq $8,58*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,200($9)
	ldq $17,152($9)
	ldq $18,160($9)
	ldq $19,424($9)
	ldq $20,32($9)
	ldq $21,328($9)
	bsr $26,s4
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1, 8*8($10)
	ldq $2, 8*8($15)
	ldq $3,26*8($10)
	ldq $4,26*8($15)
	ldq $5,12*8($10)
	eqv $1,$2,$1
	ldq $6,12*8($15)
	eqv $3,$4,$3
	ldq $7, 6*8($10)
	ldq $8, 6*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,16($9)
	ldq $17,416($9)
	ldq $18,336($9)
	ldq $19,232($9)
	ldq $20,352($9)
	ldq $21,112($9)
	bsr $26,s5
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1,22*8($10)
	ldq $2,22*8($15)
	ldq $3,44*8($10)
	ldq $4,44*8($15)
	ldq $5, 0*8($10)
	eqv $1,$2,$1
	ldq $6, 0*8($15)
	eqv $3,$4,$3
	ldq $7,62*8($10)
	ldq $8,62*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,280($9)
	ldq $17,400($9)
	ldq $18,360($9)
	ldq $19,240($9)
	ldq $20,8($9)
	ldq $21,408($9)
	bsr $26,s6
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1,30*8($10)
	ldq $2,30*8($15)
	ldq $3,18*8($10)
	ldq $4,18*8($15)
	ldq $5,20*8($10)
	eqv $1,$2,$1
	ldq $6,20*8($15)
	eqv $3,$4,$3
	ldq $7,32*8($10)
	ldq $8,32*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,184($9)
	ldq $17,248($9)
	ldq $18,344($9)
	ldq $19,168($9)
	ldq $20,64($9)
	ldq $21,0($9)
	bsr $26,s7
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1,56*8($10)
	ldq $2,56*8($15)
	ldq $3,28*8($10)
	ldq $4,28*8($15)
	ldq $5,42*8($10)
	eqv $1,$2,$1
	ldq $6,42*8($15)
	eqv $3,$4,$3
	ldq $7,54*8($10)
	ldq $8,54*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0
	beq $0,$return
	stq $0,64($30)

	ldq $16,296($9)
	ldq $17,72($9)
	ldq $18,304($9)
	ldq $19,176($9)
	ldq $20,224($9)
	ldq $21,392($9)
	bsr $26,s8
	ldq $10,72($30)
	ldq $0,64($30)
	ldq $1,38*8($10)
	ldq $2,38*8($15)
	ldq $3,52*8($10)
	ldq $4,52*8($15)
	ldq $5,16*8($10)
	eqv $1,$2,$1
	ldq $6,16*8($15)
	eqv $3,$4,$3
	ldq $7,34*8($10)
	ldq $8,34*8($15)
	eqv $5,$6,$5
	and $1,$3,$1
	eqv $7,$8,$7
	and $1,$0,$0
	and $5,$7,$5
	and $5,$0,$0

$return:
	ldq $26,0($30)
	ldq $9, 8($30)
	ldq $10,16($30)
	ldq $11,24($30)
	ldq $12,32($30)
	ldq $13,40($30)
	ldq $14,48($30)
	ldq $15,56($30)
	lda $30,88($30)
	ret $31,($26),1
	.end checkKey



	.align 9
	.ent s1
s1:
/* 66 + 14 ok ? */
	ldq $3,48($13)
	ldq $2,448($13)
	ldq $5,176($13)
	ldq $4,112($13)
	xor $17,$3,$17
	xor $16,$2,$16
	ldq $7,304($13)
	ldq $6,240($13)
	xor $19,$5,$19
	xor $18,$4,$18
	xor $21,$7,$21
	xor $20,$6,$20
	bic $18,$19,$25
	bic $18,$20,$5
	bis $25,$20,$0
	bic $19,$20,$22
	and $21,$0,$24
	xor $5,$19,$6
	xor $18,$19,$10
	xor $20,$24,$4
	and $4,$10,$4
	bic $20,$19,$27
	xor $25,$4,$7
	bic $21,$10,$28
	bis $7,$21,$7
	xor $22,$28,$3
	xor $7,$27,$7
	bis $3,$17,$3
	bis $17,$7,$2
	xor $6,$24,$8
	xor $2,$4,$2
	bis $5,$24,$5
	and $2,$16,$2
	ldq $4,16($14)
	xor $2,$3,$2
	xor $5,$10,$5
	eqv $8,$2,$2
	bic $7,$6,$6
	xor $2,$4,$2
	bis $8,$22,$8
	eqv $5,$28,$4
	stq $2,16($15)
	and $4,$7,$4
	ldq $3,384($14)
	and $17,$4,$22
	ldq $11,32($14)
	xor $22,$8,$22
	and $18,$8,$8
	xor $22,$6,$22
	bic $7,$8,$23
	and $16,$22,$2
	bic $17,$6,$6
	xor $6,$2,$6
	bis $18,$4,$18
	xor $6,$5,$6
	bis $17,$25,$1
	bic $5,$23,$5
	xor $6,$3,$6
	bis $5,$25,$5
	xor $0,$8,$0
	ornot $17,$5,$2
	eqv $1,$23,$3
	bis $5,$7,$8
	xor $18,$2,$18
	eqv $8,$20,$5
	and $18,$16,$18
	and $5,$17,$5
	bic $0,$24,$24
	xor $18,$3,$18
	xor $5,$24,$5
	xor $18,$11,$18
	bis $5,$16,$5
	bic $22,$28,$28
	ldq $12,400($14)
	xor $5,$28,$5
	stq $6,384($15)
	xor $5,$3,$5
	stq $18,32($15)
	xor $5,$12,$5
	stq $5,400($15) 
	ret $31,($26),1
	.end s1

	.align 6
	.ent s2
s2:
/* 60 + 14 */
	ldq $2,240($13)
	ldq $3,304($13)
	ldq $4,368($13)
	ldq $5,432($13)
	xor $17,$3,$17
	xor $16,$2,$16
	ldq $0,496($13)
	ldq $1,32($13)
	xor $18,$4,$18
	xor $19,$5,$19
	xor $20,$0,$20
	xor $21,$1,$21
	and $21,$20,$22
	xor $16,$21,$8
	bic $16,$22,$23
	xor $8,$20,$25
	bic $17,$23,$2
	bic $20,$23,$7
	xor $25,$2,$5
	bis $7,$17,$28
	bis $22,$2,$2
	and $19,$28,$3
	bic $2,$8,$8
	xor $5,$7,$7
	bis $18,$8,$24
	ldq $2,288($14)
	xor $24,$5,$24
	and $7,$17,$7
	eqv $24,$3,$3
	bis $5,$16,$5
	xor $3,$2,$2
	bic $21,$23,$21
	xor $20,$17,$20
	xor $5,$17,$5
	stq $2,288($15)
	bic $20,$8,$8
	bic $18,$5,$6
	xor $21,$7,$2
	xor $23,$3,$23
	xor $6,$8,$6
	bic $23,$17,$23
	bis $5,$7,$5
	and $2,$18,$2
	bis $19,$6,$3
	xor $2,$23,$2
	and $20,$5,$20
	ldq $4,112($14)
	xor $2,$3,$2
	bic $28,$20,$20
	xor $2,$25,$2
	bis $21,$8,$21
	bis $20,$19,$20
	and $18,$5,$5
	xor $2,$4,$2
	eqv $21,$24,$21
	xor $20,$5,$20
	xor $17,$25,$17
	bis $22,$7,$7
	stq $2,112($15)
	xor $20,$21,$20
	ldq $2,80($14)
	and $17,$21,$21
	and $18,$22,$22
	eqv $6,$21,$6
	eqv $22,$7,$22
	xor $20,$2,$20
	and $22,$19,$22
	and $6,$18,$6
	ldq $2,192($14)
	xor $22,$6,$22
	eqv $17,$22,$17
	stq $20,80($15)
	xor $17,$2,$17
	stq $17,192($15)
	ret $31,($26),1
	.end s2

	.align 5
	.ent s3
s3:
/* 63 + 14 */
	ldq $3,32($13)
	ldq $2,496($13)
	ldq $4,160($13)
	ldq $5,96($13)
	xor $17,$3,$17
	xor $16,$2,$16
	ldq $0,288($13)
	ldq $1,224($13)
	xor $19,$4,$19
	xor $18,$5,$18
	xor $21,$0,$21
	xor $17,$18,$25
	xor $20,$1,$20
	xor $25,$21,$25
	and $17,$25,$7
	and $18,$21,$6
	bic $21,$7,$24
	xor $18,$7,$27
	xor $24,$20,$22
	bic $27,$20,$23
	and $16,$22,$8
	bic $25,$23,$28
	xor $8,$20,$8
	bis $20,$7,$5
	bis $16,$23,$3
	bis $8,$19,$8
	xor $25,$5,$4
	bis $6,$7,$7
	ldq $2,368($14)
	xor $8,$3,$8
	bis $22,$28,$22
	xor $8,$4,$8
	xor $7,$20,$0
	xor $22,$7,$22
	xor $8,$2,$2
	xor $21,$7,$7
	stq $2,368($15)
	bic $7,$4,$4
	bis $17,$23,$3
	bis $16,$22,$2
	and $4,$16,$4
	bis $24,$22,$24
	xor $2,$3,$2
	xor $4,$24,$4
	bic $23,$18,$23
	eqv $5,$2,$5
	xor $28,$6,$6
	and $4,$19,$4
	bis $23,$16,$23
	and $5,$19,$5
	bis $6,$16,$6
	xor $4,$23,$4
	and $18,$20,$18
	ldq $2,320($14)
	xor $5,$6,$5
	xor $4,$18,$4
	xor $4,$25,$4
	eqv $0,$5,$5
	and $21,$8,$21
	xor $5,$2,$5
	xor $21,$27,$21
	bic $4,$3,$3
	ldq $2,480($14)
	bic $21,$16,$21
	bis $3,$16,$3
	bis $17,$28,$17
	xor $3,$21,$3
	ldq $6,464($14)
	xor $4,$2,$2
	and $3,$19,$3
	stq $2,480($15)
	xor $3,$17,$3
	xor $3,$0,$3
	xor $21,$6,$21
	stq $5,320($15)
	eqv $21,$3,$21
	stq $21,464($15)
	ret $31,($26),1
	.end s3

	.align 5
	.ent s4
s4:
/* 49 + 14 ok ? */
	ldq $2,224($13)
	ldq $3,288($13)
	ldq $4,352($13)
	ldq $5,416($13)
	xor $16,$2,$16
	xor $17,$3,$17
	ldq $0,480($13)
	ldq $1,16($13)
	xor $18,$4,$18
	xor $19,$5,$19
	bis $16,$18,$5
	xor $20,$0,$20
	bis $17,$18,$6
	and $5,$20,$5
	xor $21,$1,$21
	xor $16,$5,$8
	bic $18,$16,$16
	xor $18,$5,$5
	bis $16,$8,$16
	ldq $0,64($14)
	and $17,$16,$23
	ldq $1,208($14)
	xor $20,$23,$22
	ldq $10,96($14)
	and $19,$22,$2
	xor $18,$20,$20
	xor $6,$2,$6
	bic $20,$17,$20
	xor $6,$8,$6
	xor $18,$23,$18
	bis $5,$8,$8
	ldq $11,48($14)
	xor $8,$20,$4
	bic $17,$5,$5
	bis $4,$19,$4
	eqv $20,$18,$20
	xor $4,$5,$4
	and $17,$22,$22
	xor $4,$16,$4
	and $20,$19,$20
	bis $21,$4,$7
	xor $20,$22,$20
	xor $7,$6,$7
	and $21,$4,$4
	xor $7,$0,$0
	eqv $6,$4,$3
	xor $20,$8,$20
	stq $0,64($15)
	xor $6,$20,$6
	xor $3,$1,$3
	bic $17,$6,$17
	bic $6,$19,$19
	xor $17,$19,$17
	stq $3,208($15)
	xor $17,$7,$17
	bis $21,$17,$21	//
	xor $4,$17,$4
	eqv $20,$21,$20
	xor $20,$10,$10
	xor $4,$20,$4
	stq $10,96($15)
	xor $4,$11,$4
	stq $4,48($15)
	ret $31,($26),1		
	.end s4

	.align 5
	.ent s5
s5:
/* 66 + 14 */
	ldq $2,480($13)
	ldq $3,16($13)
	ldq $4,80($13)
	ldq $5,144($13)
	xor $16,$2,$16
	xor $17,$3,$17
	xor $18,$4,$18
	xor $19,$5,$19
	xor $19,$16,$28
	bic $18,$19,$23
	ldq $3,272($13)
	xor $23,$16,$8
	bic $16,$18,$7
	bis $28,$23,$23
	xor $21,$3,$21
	and $18,$23,$5
	bis $21,$7,$0
	xor $5,$19,$5
	ldq $2,208($13)
	xor $19,$7,$27
	bic $23,$21,$25
	bis $27,$21,$27
	bic $5,$7,$7
	xor $20,$2,$20
	xor $7,$27,$7
	xor $18,$25,$22
	bis $20,$7,$24
	xor $8,$0,$11
	xor $24,$5,$24
	xor $16,$22,$16
	bic $24,$17,$4
	bis $20,$22,$3
	ldq $2,176($14)
	xor $3,$4,$3
	and $8,$16,$8
	xor $3,$11,$3
	and $19,$0,$0
	bic $20,$8,$8
	xor $3,$2,$2
	xor $8,$0,$8
	xor $8,$7,$8
	bis $19,$16,$10
	stq $2,176($15)
	and $7,$11,$7
	ldq $2,352($14)
	bic $10,$17,$6
	xor $22,$7,$22
	xor $6,$8,$6
	xor $6,$2,$6
	eqv $22,$3,$3
	bis $20,$22,$2
	ornot $7,$23,$23
	bic $25,$19,$25
	bis $5,$27,$5
	and $3,$20,$3
	xor $25,$18,$25
	and $24,$23,$24
	and $28,$22,$22
	xor $5,$2,$5
	and $3,$10,$3
	bis $5,$17,$5
	and $20,$25,$4
	xor $3,$22,$3
	bis $8,$24,$8
	ldq $2,0($14)
	xor $5,$4,$5
	xor $3,$25,$3
	eqv $28,$8,$28
	xor $5,$23,$5
	bis $3,$17,$3
	and $28,$20,$28
	xor $5,$2,$5
	xor $3,$28,$3
	ldq $2,496($14)
	xor $3,$24,$3
	xor $3,$16,$3
	xor $3,$2,$3
	stq $6,352($15)
	stq $5,0($15)
	stq $3,496($15)
	ret $31,($26),1
	.end s5

	.align 5
	.ent s6
s6:
/* 63 + 14 */
	ldq $2,208($13)
	ldq $3,272($13)
	ldq $4,336($13)
	ldq $5,400($13)
	xor $16,$2,$16
	xor $17,$3,$17
	ldq $0,464($13)
	ldq $1,0($13)
	xor $18,$4,$18
	xor $19,$5,$19
	xor $20,$0,$20
	xor $21,$1,$21
	xor $20,$16,$5
	and $16,$21,$16
	xor $5,$21,$28
	bic $16,$20,$6
	xor $21,$16,$25
	bic $19,$6,$8
	bis $6,$25,$7
	xor $28,$8,$23
	bic $7,$19,$7
	bis $21,$23,$3
	xor $7,$25,$7
	bic $3,$20,$3
	bis $6,$7,$6
	and $17,$7,$4
	bic $17,$6,$2
	xor $16,$23,$16
	xor $3,$2,$3
	xor $23,$4,$10
	ldq $2,240($14)
	bic $3,$18,$3
	bic $16,$7,$7
	eqv $10,$3,$3
	xor $3,$2,$2
	bic $3,$5,$3
	stq $2,240($15)
	xor $3,$6,$3
	bic $21,$3,$22
	bis $20,$21,$6
	xor $22,$23,$22
	bic $6,$5,$5
	bic $17,$22,$4
	and $6,$7,$6
	ornot $4,$17,$2
	xor $6,$28,$6
	eqv $3,$4,$4
	xor $5,$2,$5
	xor $21,$4,$21
	ldq $2,144($14)
	and $20,$21,$21
	and $5,$18,$5
	bis $22,$21,$22
	xor $5,$4,$5
	and $6,$17,$6
	xor $5,$2,$5
	bic $3,$20,$3
	xor $6,$22,$6
	and $20,$25,$20
	bic $17,$21,$2
	bis $3,$18,$3
	eqv $8,$6,$8
	ornot $20,$19,$20
	xor $3,$2,$3
	and $8,$18,$8
	bic $20,$17,$20
	ldq $4,160($14)
	ldq $2,256($14)
	xor $8,$20,$8
	bis $21,$28,$21
	eqv $7,$3,$3
	xor $8,$21,$8
	xor $3,$4,$3
	xor $8,$2,$8
	stq $5,144($15)
	stq $3,160($15)
	stq $8,256($15)
	ret $31,($26),1
	.end s6

	.align 5
	.ent s7
s7:
/* 61 + 14 */
	ldq $2,464($13)
	ldq $3,0($13)
	ldq $4,64($13)
	ldq $5,128($13)
	xor $16,$2,$16
	xor $17,$3,$17
	ldq $0,192($13)
	ldq $1,256($13)
	xor $18,$4,$18
	xor $19,$5,$19
	xor $20,$0,$20
	and $17,$19,$6
	xor $21,$1,$21
	xor $6,$20,$6
	bis $17,$19,$5
	and $19,$6,$7
	bic $20,$17,$2
	xor $7,$17,$25
	bis $2,$18,$2
	bic $18,$25,$8
	bis $5,$20,$5
	xor $6,$8,$6
	xor $5,$2,$5
	xor $18,$8,$8
	bis $18,$7,$4
	bic $21,$8,$22
	bic $19,$18,$28
	xor $22,$6,$22
	ldq $2,448($14)
	xor $7,$6,$6
	xor $19,$25,$19
	bis $21,$6,$3
	xor $18,$7,$7
	xor $5,$3,$5
	and $7,$17,$7
	and $5,$16,$5
	xor $4,$19,$4
	xor $5,$22,$5
	bic $21,$7,$7
	xor $5,$2,$2
	xor $7,$4,$7
	and $17,$21,$23
	bic $23,$28,$23
	stq $2,448($15)
	bis $16,$7,$2
	xor $23,$22,$0
	ldq $3,224($14)
	eqv $0,$2,$2
	bic $4,$18,$4
	eqv $6,$17,$6
	xor $2,$3,$2
	bis $17,$19,$3
	bis $4,$7,$4
	and $6,$19,$6
	xor $3,$5,$3
	and $6,$21,$6
	stq $2,224($15)
	bic $3,$21,$3
	bic $4,$16,$4
	and $18,$23,$18
	ldq $2,336($14)
	xor $8,$7,$8
	xor $3,$4,$3
	xor $18,$6,$18
	xor $3,$8,$3
	bis $18,$16,$18
	bis $20,$28,$20
	xor $18,$6,$18
	ldq $0,432($14)
	xor $18,$8,$18
	xor $3,$2,$3
	xor $18,$20,$18
	stq $3,336($15)
	xor $18,$0,$18
	stq $18,432($15)
	ret $31,($26),1
	.end s7

	.align 5
	.ent s8
s8:
/* 60 + 14 */
	ldq $2,192($13)
	ldq $3,256($13)
	ldq $4,320($13)
	ldq $5,384($13)
	xor $16,$2,$16
	xor $17,$3,$17
	ldq $0,448($13)
	ldq $1,48($13)
	xor $18,$4,$18
	xor $19,$5,$19
	xor $20,$0,$20
	bic $16,$18,$25
	xor $21,$1,$21
	xor $25,$19,$4
	xor $18,$16,$8
	bis $20,$4,$7
	xor $7,$8,$7
	bic $7,$16,$22	//
	bis $22,$19,$3
	xor $22,$18,$24
	xor $3,$8,$3
	bic $24,$20,$23
	xor $3,$20,$3
	xor $23,$19,$23
	bic $17,$23,$5
	bic $4,$3,$6
	xor $5,$7,$5
	eqv $6,$24,$6
	bis $7,$20,$7
	and $17,$6,$2
	xor $2,$3,$2
	bic $5,$19,$24
	ldq $28,304($14)
	bis $2,$21,$2
	eqv $2,$5,$2
	and $16,$7,$16
	xor $2,$28,$2
	xor $7,$4,$4
	and $20,$25,$28
	stq $2,304($15)
	xor $28,$24,$28
	ldq $2,416($14)
	and $28,$17,$28
	bic $17,$24,$24
	xor $28,$16,$28
	bic $25,$3,$25
	bic $28,$21,$28
	and $18,$6,$6
	xor $28,$24,$28
	bis $17,$22,$22
	xor $28,$4,$28
	bis $6,$23,$6
	bis $4,$28,$4
	xor $28,$2,$2
	bic $17,$4,$4
	stq $2,416($15)
	xor $4,$25,$4
	xor $18,$20,$18
	ldq $2,128($14)
	xor $6,$22,$6
	bis $4,$21,$4
	xor $18,$25,$18
	bic $8,$20,$8
	eqv $4,$6,$4
	bic $18,$17,$17
	bis $8,$19,$8
	xor $4,$2,$4
	xor $17,$8,$17
	ldq $2,272($14)
	and $17,$21,$17
	eqv $17,$5,$17
	stq $4,128($15)
	xor $17,$2,$17	//
	stq $17,272($15)
	ret $31,($26),1
	.end s8

	.align	7
	.comm	t,512,8
	.comm	CT,512,8
	.comm	ct,512,8
	.comm	PT,512,8
	.comm	pt,512*64,8
