
.macro  adrli   dest, addr, a, b, c
        .set    \a, \addr-.-8
        .set    \b, (( \a+256 )>>9)<<9
        add     \dest, pc, #\b
        .set    \c, \a-\b
        add     \dest, \dest, #\c
.endm

.macro  adrl    dest, addr
        adrli   \dest, \addr, "adrla\@", "adrlb\@", "adrlc\@"
.endm
	.text
	.global	_des_unit_func_arm

lowbits:
	.word	0xAAAAAAAA
	.word	0xCCCCCCCC
	.word	0xF0F0F0F0
	.word	0xFF00FF00
	.word	0xFFFF0000

_des_unit_func_arm:
	MOV     R12,R13
	STMDB   R13!,{R0,R1,R4-R9,R11,R12,R14,PC}
	SUB     R11,R12,#4
	SUB     R12,R13,#0x0400     
	/*
	CMP     R12,R10
	BLMI    0x000000A8
	*/
	MOV     R4,R0
	SUB     R13,R13,#0x02E8     
	LDR     R0,[R0,#16]
	STR     R0,[R13,#4]
	LDR     R0,[R4,#20]
	STR     R0,[R13,#0]
	MOV     R1,R13
	ADD     R0,R13,#4
	BL      _convert_key_from_inc_to_des__FPUiT0
	MOV     R5,#1
	MOV     R6,#0
	LDMIA   R13,{R7,R8}
L000048J5:
	MOV     R0,R6
	MOV     R1,#7
	BL      ___umodsi3
	CMP     R0,#0
	MOVEQ   R5,R5,LSL #1
	ANDS    R1,R7,R5
	MVNNE   R1,#0
	ADD     R0,R13,#0x0208      
	STR     R1,[R0,R6,LSL #2]
	MOVS    R5,R5,LSL #1
	MOVEQ   R7,R8
	MOVEQ   R5,#1
	ADD     R6,R6,#1
	CMP     R6,#0x38            
	BCC     L000048J5
	MOV     R5,#0
	MOV     R6,#0
	MOV     R1,#0x20            
	ADD     R12,R13,#0x0208     
clearbits:	
	STMDB   R12!,{R5,R6}
	STMDB   R12!,{R5,R6}
	SUBS    R1,R1,#1
	BNE     clearbits
	LDR     R2,[R4,#12]
	LDR     R3,[R4,#8]
	ADD     R12,R13,#8
	MVN     R7,#0
	TST     R2,#0x20            
	STRNE   R7,[R12,#252]
	TST     R2,#8
	STRNE   R7,[R12,#248]
	TST     R3,#0x00080000
	STRNE   R7,[R12,#244]
	TST     R3,#0x00020000
	STRNE   R7,[R12,#240]
	TST     R3,#0x20            
	STRNE   R7,[R12,#236]
	TST     R2,#0x02000000
	STRNE   R7,[R12,#232]
	TST     R2,#0x8000
	STRNE   R7,[R12,#228]
	TST     R2,#0x0800          
	STRNE   R7,[R12,#224]
	TST     R3,#0x08000000
	STRNE   R7,[R12,#220]
	TST     R3,#0x20000000
	STRNE   R7,[R12,#216]
	TST     R3,#0x0200          
	STRNE   R7,[R12,#212]
	TST     R3,#0x8000
	STRNE   R7,[R12,#208]
	TST     R2,#0x0200          
	STRNE   R7,[R12,#204]
	TST     R2,#0x08000000
	STRNE   R7,[R12,#200]
	TST     R2,#0x2000
	STRNE   R7,[R12,#196]
	TST     R2,#0x80            
	STRNE   R7,[R12,#192]
	TST     R3,#0x80000000
	STRNE   R7,[R12,#188]
	TST     R3,#0x2000
	STRNE   R7,[R12,#184]
	TST     R2,#2
	STRNE   R7,[R12,#180]
	TST     R2,#0x00800000
	STRNE   R7,[R12,#176]
	TST     R2,#0x80000000
	STRNE   R7,[R12,#172]
	TST     R3,#2
	STRNE   R7,[R12,#168]
	TST     R2,#0x00200000
	STRNE   R7,[R12,#164]
	TST     R2,#0x00080000
	STRNE   R7,[R12,#160]
	TST     R3,#0x02000000
	STRNE   R7,[R12,#156]
	TST     R2,#0x20000000
	STRNE   R7,[R12,#152]
	TST     R3,#0x0800          
	STRNE   R7,[R12,#148]
	TST     R3,#0x00800000
	STRNE   R7,[R12,#144]
	TST     R3,#0x80            
	STRNE   R7,[R12,#140]
	TST     R2,#0x00020000
	STRNE   R7,[R12,#136]
	TST     R3,#0x00200000
	STRNE   R7,[R12,#132]
	TST     R3,#8
	STRNE   R7,[R12,#128]
	TST     R2,#0x10            
	STRNE   R7,[R12,#124]
	TST     R2,#4
	STRNE   R7,[R12,#120]
	TST     R3,#0x00040000
	STRNE   R7,[R12,#116]
	TST     R3,#0x00010000
	STRNE   R7,[R12,#112]
	TST     R3,#0x10            
	STRNE   R7,[R12,#108]
	TST     R2,#0x01000000
	STRNE   R7,[R12,#104]
	TST     R2,#0x4000
	STRNE   R7,[R12,#100]
	TST     R2,#0x0400          
	STRNE   R7,[R12,#96]
	TST     R3,#0x04000000
	STRNE   R7,[R12,#92]
	TST     R3,#0x10000000
	STRNE   R7,[R12,#88]
	TST     R3,#0x0100          
	STRNE   R7,[R12,#84]
	TST     R3,#0x4000
	STRNE   R7,[R12,#80]
	TST     R2,#0x0100          
	STRNE   R7,[R12,#76]
	TST     R2,#0x04000000
	STRNE   R7,[R12,#72]
	TST     R2,#0x1000          
	STRNE   R7,[R12,#68]
	TST     R2,#0x40            
	STRNE   R7,[R12,#64]
	TST     R3,#0x40000000
	STRNE   R7,[R12,#60]
	TST     R3,#0x1000          
	STRNE   R7,[R12,#56]
	TST     R2,#1
	STRNE   R7,[R12,#52]
	TST     R2,#0x00400000
	STRNE   R7,[R12,#48]
	TST     R2,#0x40000000
	STRNE   R7,[R12,#44]
	TST     R3,#1
	STRNE   R7,[R12,#40]
	TST     R2,#0x00100000
	STRNE   R7,[R12,#36]
	TST     R2,#0x00040000
	STRNE   R7,[R12,#32]
	TST     R3,#0x01000000
	STRNE   R7,[R12,#28]
	TST     R2,#0x10000000
	STRNE   R7,[R12,#24]
	TST     R3,#0x0400          
	STRNE   R7,[R12,#20]
	TST     R3,#0x00400000
	STRNE   R7,[R12,#16]
	TST     R3,#0x40            
	STRNE   R7,[R12,#12]
	TST     R2,#0x00010000
	STRNE   R7,[R12,#8]
	TST     R3,#0x00100000
	STRNE   R7,[R12,#4]
	TST     R3,#4
	STRNE   R7,[R12,#0]
	LDR     R2,[R4,#4]
	LDR     R3,[R4,#0]
	ADD     R12,R13,#0x0108     
	TST     R3,#0x02000000
	STRNE   R7,[R12,#252]
	TST     R3,#0x00020000
	STRNE   R7,[R12,#248]
	TST     R3,#0x0200          
	STRNE   R7,[R12,#244]
	TST     R3,#2
	STRNE   R7,[R12,#240]
	TST     R2,#0x02000000
	STRNE   R7,[R12,#236]
	TST     R2,#0x00020000
	STRNE   R7,[R12,#232]
	TST     R2,#0x0200          
	STRNE   R7,[R12,#228]
	TST     R2,#2
	STRNE   R7,[R12,#224]
	TST     R3,#0x08000000
	STRNE   R7,[R12,#220]
	TST     R3,#0x00080000
	STRNE   R7,[R12,#216]
	TST     R3,#0x0800          
	STRNE   R7,[R12,#212]
	TST     R3,#8
	STRNE   R7,[R12,#208]
	TST     R2,#0x08000000
	STRNE   R7,[R12,#204]
	TST     R2,#0x00080000
	STRNE   R7,[R12,#200]
	TST     R2,#0x0800          
	STRNE   R7,[R12,#196]
	TST     R2,#8
	STRNE   R7,[R12,#192]
	TST     R3,#0x20000000
	STRNE   R7,[R12,#188]
	TST     R3,#0x00200000
	STRNE   R7,[R12,#184]
	TST     R3,#0x2000
	STRNE   R7,[R12,#180]
	TST     R3,#0x20            
	STRNE   R7,[R12,#176]
	TST     R2,#0x20000000
	STRNE   R7,[R12,#172]
	TST     R2,#0x00200000
	STRNE   R7,[R12,#168]
	TST     R2,#0x2000
	STRNE   R7,[R12,#164]
	TST     R2,#0x20            
	STRNE   R7,[R12,#160]
	TST     R3,#0x80000000
	STRNE   R7,[R12,#156]
	TST     R3,#0x00800000
	STRNE   R7,[R12,#152]
	TST     R3,#0x8000
	STRNE   R7,[R12,#148]
	TST     R3,#0x80            
	STRNE   R7,[R12,#144]
	TST     R2,#0x80000000
	STRNE   R7,[R12,#140]
	TST     R2,#0x00800000
	STRNE   R7,[R12,#136]
	TST     R2,#0x8000
	STRNE   R7,[R12,#132]
	TST     R2,#0x80            
	STRNE   R7,[R12,#128]
	TST     R3,#0x01000000
	STRNE   R7,[R12,#124]
	TST     R3,#0x00010000
	STRNE   R7,[R12,#120]
	TST     R3,#0x0100          
	STRNE   R7,[R12,#116]
	TST     R3,#1
	STRNE   R7,[R12,#112]
	TST     R2,#0x01000000
	STRNE   R7,[R12,#108]
	TST     R2,#0x00010000
	STRNE   R7,[R12,#104]
	TST     R2,#0x0100          
	STRNE   R7,[R12,#100]
	TST     R2,#1
	STRNE   R7,[R12,#96]
	TST     R3,#0x04000000
	STRNE   R7,[R12,#92]
	TST     R3,#0x00040000
	STRNE   R7,[R12,#88]
	TST     R3,#0x0400          
	STRNE   R7,[R12,#84]
	TST     R3,#4
	STRNE   R7,[R12,#80]
	TST     R2,#0x04000000
	STRNE   R7,[R12,#76]
	TST     R2,#0x00040000
	STRNE   R7,[R12,#72]
	TST     R2,#0x0400          
	STRNE   R7,[R12,#68]
	TST     R2,#4
	STRNE   R7,[R12,#64]
	TST     R3,#0x10000000
	STRNE   R7,[R12,#60]
	TST     R3,#0x00100000
	STRNE   R7,[R12,#56]
	TST     R3,#0x1000          
	STRNE   R7,[R12,#52]
	TST     R3,#0x10            
	STRNE   R7,[R12,#48]
	TST     R2,#0x10000000
	STRNE   R7,[R12,#44]
	TST     R2,#0x00100000
	STRNE   R7,[R12,#40]
	TST     R2,#0x1000          
	STRNE   R7,[R12,#36]
	TST     R2,#0x10            
	STRNE   R7,[R12,#32]
	TST     R3,#0x40000000
	STRNE   R7,[R12,#28]
	TST     R3,#0x00400000
	STRNE   R7,[R12,#24]
	TST     R3,#0x4000
	STRNE   R7,[R12,#20]
	TST     R3,#0x40            
	STRNE   R7,[R12,#16]
	TST     R2,#0x40000000
	STRNE   R7,[R12,#12]
	TST     R2,#0x00400000
	STRNE   R7,[R12,#8]
	TST     R2,#0x4000
	STRNE   R7,[R12,#4]
	TST     R2,#0x40            
	STRNE   R7,[R12,#0]
	adrl	r0,lowbits
	/*
	ADR     R0,0x000001C8
	SUB     R0,R0,#0x37,ROR #30
	*/
	LDMIA   R0,{R5-R9}
	STR     R5,[R13,#532]
	STR     R6,[R13,#540]
	STR     R7,[R13,#552]
	STR     R8,[R13,#560]
	STR     R9,[R13,#564]
	LDR     R0,[R11,#-40]
	SUB     R5,R0,#5
	MOV     R8,#0
	MOV     R7,#0
	MOV     R6,#0
	MOV     R0,#1
	MOV     R9,R0,LSL R5
resettwiddles:
	MOV     R0,#0
	MOV     R12,#0
	ADR     R3,twiddles
	ADD     R2,R13,#0x0208      
resettwiddleloop:
	LDRB    R1,[R3,R0]
	STR     R12,[R2,R1,LSL #2]
	ADD     R0,R0,#1
	CMP     R0,R5
	BCC     resettwiddleloop
	B       deseval
half_keys_done:
	CMP     R8,#0
	BNE     inc_then_exit
	MOV     R8,#1
	MOV     R6,#0
	MOV     R7,R6
	MOV     R0,#0x38            
	ADD     R1,R13,#0x0208      
invertloop:
	LDR     R2,[R1,#0]
	SUBS    R0,R0,#1
	MVN     R2,R2
	STR     R2,[R1],#4
	BNE     invertloop
	B       resettwiddles
inc_then_exit:	
	LDR     R1,[R4,#20]
	MOV     R2,#1
	LDR     R0,[R11,#-40]
	MOV     R0,R2,LSL R0
	ADD     R1,R1,R0
	STR     R1,[R4,#20]
	LDMDB   R11,{R4-R9,R11,R13,PC}^

odd_parity:	
	.word	0x02020101
	.word	0x07070404
	.word	0x0B0B0808
	.word	0x0E0E0D0D
	.word	0x13131010
	.word	0x16161515
	.word	0x1A1A1919
	.word	0x1F1F1C1C
	.word	0x23232020
	.word	0x26262525
	.word	0x2A2A2929
	.word	0x2F2F2C2C
	.word	0x32323131
	.word	0x37373434
	.word	0x3B3B3838
	.word	0x3E3E3D3D
	.word	0x43434040
	.word	0x46464545
	.word	0x4A4A4949
	.word	0x4F4F4C4C
	.word	0x52525151
	.word	0x57575454
	.word	0x5B5B5858
	.word	0x5E5E5D5D
	.word	0x62626161
	.word	0x67676464
	.word	0x6B6B6868
	.word	0x6E6E6D6D
	.word	0x73737070
	.word	0x76767575
	.word	0x7A7A7979
	.word	0x7F7F7C7C
	.word	0x83838080
	.word	0x86868585
	.word	0x8A8A8989
	.word	0x8F8F8C8C
	.word	0x92929191
	.word	0x97979494
	.word	0x9B9B9898
	.word	0x9E9E9D9D
	.word	0xA2A2A1A1
	.word	0xA7A7A4A4
	.word	0xABABA8A8
	.word	0xAEAEADAD
	.word	0xB3B3B0B0
	.word	0xB6B6B5B5
	.word	0xBABAB9B9
	.word	0xBFBFBCBC
	.word	0xC2C2C1C1
	.word	0xC7C7C4C4
	.word	0xCBCBC8C8
	.word	0xCECECDCD
	.word	0xD3D3D0D0
	.word	0xD6D6D5D5
	.word	0xDADAD9D9
	.word	0xDFDFDCDC
	.word	0xE3E3E0E0
	.word	0xE6E6E5E5
	.word	0xEAEAE9E9
	.word	0xEFEFECEC
	.word	0xF2F2F1F1
	.word	0xF7F7F4F4
	.word	0xFBFBF8F8
	.word	0xFEFEFDFD
twiddles:
	.word	0x28120F0C
	.word	0x2D2B2A29
	.word	0x0032312E
	.word	0x06040201
	.word	0x000D0907

foundkey:
	MVN     R5,#0
	MOV     R1,#0
	MOV     R2,#1
L000200J55:	
	TST     R0,R2,LSL R1
	MOVNE   R5,R1
	ADD     R1,R1,#1
	CMP     R1,#0x20            
	BCC     L000200J55
	MOV     R0,#0
	STR     R0,[R13,#4]
	MOV     R6,#0x31            
	STR     R0,[R13,#0]
	ADR     R9,odd_parity
L000250J55:
	ADD     R0,R13,#0x0208      
	ADD     R0,R0,R6,LSL #2
	LDR     R1,[R0,#24]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	MOV     R2,R1,LSL #7
	LDR     R1,[R0,#20]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #6
	LDR     R1,[R0,#16]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #5
	LDR     R1,[R0,#12]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #4
	LDR     R1,[R0,#8]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R2,R2,R1,LSL #3
	LDR     R1,[R0,#4]
	MOV     R1,R1,LSR R5
	AND     R1,R1,#1
	ORR     R1,R2,R1,LSL #2
	LDR     R0,[R0,#0]
	MOV     R0,R0,LSR R5
	AND     R0,R0,#1
	ORR     R0,R1,R0,LSL #1
	LDRB    R7,[R9,R0]
	ADD     R0,R6,#7
	MOV     R1,#7
	BL      ___divsi3
	SUB     R0,R0,#1
	CMP     R0,#4
	BLT     L000300J58
	MVN     R1,#0x1F            
	ADD     R0,R1,R0,LSL #3
	LDR     R1,[R13,#4]
	ORR     R0,R1,R7,LSL R0
	STR     R0,[R13,#4]
	B       L000310J60
	
L000300J58:
	MOV     R0,R0,LSL #3
	LDR     R1,[R13,#0]
	ORR     R0,R1,R7,LSL R0
	STR     R0,[R13,#0]
L000310J60:
	SUB     R6,R6,#7
	CMP     R6,#0
	BGE     L000250J55
	CMP     R8,#0
	BEQ     L00033cJ62
	LDR     R0,[R13,#4]
	MVN     R0,R0
	STR     R0,[R13,#4]
	LDR     R0,[R13,#0]
	MVN     R0,R0
	STR     R0,[R13,#0]
L00033cJ62:
	MOV     R1,R13
	ADD     R0,R13,#4
	BL      _convert_key_from_des_to_inc__FPUiT0
	LDR     R0,[R4,#20]
	LDR     R1,[R13,#0]
	SUB     R0,R1,R0
	STR     R1,[R4,#20]
	LDR     R1,[R13,#4]
	STR     R1,[R4,#16]
	LDMDB   R11,{R4-R9,R11,R13,PC}^
s1:	
	STMDB   R13!,{R10,R14}
	LDR     R6,[R12,#124]
	LDMIA   R12,{R7-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	BIC     R10,R2,R4
	EOR     R7,R10,R3
	BIC     R9,R2,R3
	ORR     R8,R9,R4
	AND     R6,R5,R8
	EOR     R12,R2,R3
	EOR     R14,R4,R6
	AND     R14,R14,R12
	EOR     R8,R9,R14
	ORR     R8,R5,R8
	BIC     R11,R4,R3
	EOR     R8,R8,R11
	ORR     R11,R1,R8
	EOR     R11,R11,R14
	AND     R11,R0,R11
	ORR     R10,R10,R6
	EOR     R10,R10,R12
	EOR     R14,R7,R6
	BIC     R7,R8,R7
	BIC     R12,R5,R12
	BIC     R3,R3,R4
	EOR     R6,R3,R12
	ORR     R6,R1,R6
	EOR     R6,R6,R14
	EOR     R6,R6,R11
	LDR     R11,[R13,#0]
	ORR     R14,R14,R3
	LDR     R3,[R11,#64]
	MVN     R6,R6
	EOR     R3,R3,R6
	EOR     R6,R10,R12
	STR     R3,[R11,#64]
	BIC     R6,R8,R6
	AND     R11,R1,R6
	EOR     R11,R14,R11
	EOR     R11,R7,R11
	AND     R14,R2,R14
	BIC     R7,R1,R7
	EOR     R7,R10,R7
	BIC     R3,R8,R14
	BIC     R10,R10,R3
	ORR     R10,R10,R9
	BIC     R12,R11,R12
	AND     R11,R0,R11
	EOR     R7,R7,R11
	ORR     R11,R1,R9
	EOR     R11,R11,R3
	MVN     R11,R11
	ORR     R6,R2,R6
	BIC     R3,R10,R1
	EOR     R6,R6,R3
	BIC     R6,R0,R6
	EOR     R6,R6,R11
	LDR     R3,[R13],#4
	ORR     R8,R10,R8
	LDR     R10,[R3,#32]
	EOR     R8,R8,R4
	EOR     R6,R10,R6
	ORR     R9,R9,R4
	AND     R10,R5,R9
	STR     R6,[R3,#32]
	EOR     R9,R9,R14
	BIC     R9,R9,R10
	BIC     R8,R1,R8
	EOR     R8,R8,R9
	ORR     R8,R0,R8
	EOR     R8,R8,R11
	EOR     R8,R8,R12
	LDR     R12,[R3,#88]
	LDR     R9,[R3,#120]
	EOR     R8,R8,R12
	EOR     R9,R7,R9
	STR     R8,[R3,#88]
	STR     R9,[R3,#120]
	LDR     R14,[R13],#4
	B       s_call_loop
s2:
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	EOR     R7,R0,R5
	EOR     R8,R7,R4
	AND     R9,R5,R4
	BIC     R10,R0,R9
	BIC     R11,R1,R10
	EOR     R12,R8,R11
	ORR     R11,R9,R11
	BIC     R7,R11,R7
	BIC     R11,R4,R10
	EOR     R4,R4,R1
	BIC     R5,R5,R10
	ORR     R0,R12,R0
	EOR     R0,R0,R1
	ORR     R14,R2,R7
	EOR     R14,R12,R14
	EOR     R12,R12,R11
	AND     R12,R1,R12
	ORR     R11,R11,R1
	BIC     R7,R4,R7
	ORR     R6,R0,R12
	AND     R4,R4,R6
	BIC     R4,R11,R4
	ORR     R4,R3,R4
	MVN     R14,R14
	AND     R11,R3,R11
	EOR     R11,R14,R11
	AND     R6,R2,R6
	EOR     R6,R6,R4
	BIC     R0,R2,R0
	EOR     R0,R7,R0
	ORR     R7,R7,R5
	EOR     R7,R7,R14
	EOR     R4,R1,R8
	AND     R14,R4,R7
	EOR     R14,R14,R0
	BIC     R14,R2,R14
	EOR     R14,R4,R14
	ORR     R4,R9,R12
	AND     R9,R2,R9
	EOR     R9,R9,R4
	BIC     R9,R3,R9
	EOR     R9,R9,R14
	EOR     R10,R10,R11
	BIC     R10,R10,R1
	EOR     R10,R8,R10
	EOR     R12,R12,R5
	AND     R12,R2,R12
	ORR     R8,R3,R0
	EOR     R8,R8,R12
	LDR     R12,[R13],#4
	EOR     R8,R10,R8
	LDR     R14,[R12,#48]
	EOR     R10,R7,R6
	LDR     R7,[R12,#108]
	EOR     R6,R14,R11
	LDR     R14,[R12,#4]
	MVN     R9,R9
	STR     R6,[R12,#48]
	EOR     R7,R7,R9
	LDR     R9,[R12,#68]
	EOR     R8,R14,R8
	STR     R7,[R12,#108]
	EOR     R9,R9,R10
	STR     R8,[R12,#4]
	STR     R9,[R12,#68]
	LDR     R14,[R13],#4
	B       s_call_loop
s3:	
	STR     R14,[R13,#-4]!
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	EOR     R9,R1,R2
	EOR     R9,R9,R5
	AND     R7,R1,R9
	EOR     R11,R2,R7
	BIC     R12,R11,R4
	ORR     R8,R4,R7
	EOR     R6,R9,R8
	ORR     R14,R0,R12
	EOR     R14,R6,R14
	BIC     R7,R5,R7
	EOR     R6,R7,R4
	AND     R7,R0,R6
	EOR     R7,R4,R7
	ORR     R7,R3,R7
	EOR     R7,R14,R7
	LDR     R14,[R10,#20]
	STR     R10,[R13,#-4]!
	EOR     R14,R14,R7
	AND     R7,R5,R7
	STR     R14,[R10,#20]
	EOR     R7,R7,R11
	BIC     R7,R7,R0
	BIC     R10,R12,R2
	ORR     R10,R0,R10
	EOR     R10,R9,R10
	AND     R11,R2,R4
	EOR     R10,R11,R10
	AND     R2,R2,R5
	BIC     R11,R9,R12
	ORR     R12,R1,R12
	ORR     R14,R1,R11
	EOR     R14,R14,R7
	AND     R1,R1,R9
	EOR     R9,R9,R8
	EOR     R8,R8,R12
	ORR     R6,R6,R11
	EOR     R11,R11,R2
	ORR     R11,R0,R11
	ORR     R2,R2,R1
	EOR     R6,R6,R2
	EOR     R4,R2,R4
	MVN     R4,R4
	EOR     R14,R14,R4
	EOR     R11,R11,R4
	BIC     R1,R5,R1
	ORR     R1,R1,R6
	EOR     R2,R5,R2
	BIC     R2,R2,R9
	AND     R2,R2,R0
	EOR     R9,R1,R2
	AND     R9,R3,R9
	EOR     R9,R10,R9
	BIC     R12,R9,R12
	ORR     R12,R0,R12
	EOR     R10,R7,R12
	AND     R10,R3,R10
	EOR     R10,R14,R10
	ORR     R6,R0,R6
	EOR     R6,R8,R6
	LDR     R12,[R13],#4
	BIC     R6,R3,R6
	LDR     R7,[R12,#60]
	EOR     R6,R11,R6
	LDR     R8,[R12,#116]
	EOR     R7,R7,R9
	LDR     R9,[R12,#92]
	EOR     R8,R8,R6
	STR     R7,[R12,#60]
	EOR     R6,R9,R10
	STR     R8,[R12,#116]
	STR     R6,[R12,#92]
	LDR     R14,[R13],#4
	B       s_call_loop
s4:
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	ORR     R6,R0,R2
	AND     R6,R4,R6
	EOR     R9,R0,R6
	EOR     R12,R2,R6
	BIC     R6,R2,R0
	ORR     R6,R6,R9
	AND     R11,R1,R6
	BIC     R8,R1,R12
	EOR     R6,R6,R8
	ORR     R0,R12,R9
	EOR     R12,R4,R11
	AND     R8,R3,R12
	EOR     R9,R9,R8
	ORR     R8,R1,R2
	EOR     R9,R9,R8
	EOR     R8,R2,R4
	BIC     R8,R8,R1
	EOR     R11,R11,R8
	EOR     R11,R2,R11
	BIC     R11,R3,R11
	EOR     R11,R0,R11
	AND     R12,R1,R12
	EOR     R11,R11,R12
	EOR     R12,R0,R8
	ORR     R12,R3,R12
	EOR     R8,R6,R12
	ORR     R12,R5,R8
	EOR     R12,R9,R12
	LDR     R6,[R10,#100]
	AND     R8,R5,R8
	EOR     R6,R6,R12
	EOR     R0,R9,R11
	STR     R6,[R10,#100]
	BIC     R7,R1,R0
	BIC     R0,R0,R3
	EOR     R7,R7,R0
	EOR     R7,R7,R12
	ORR     R12,R5,R7
	EOR     R12,R12,R11
	MVN     R12,R12
	MVN     R9,R9
	EOR     R0,R8,R9
	EOR     R11,R8,R7
	LDR     R7,[R10,#76]
	EOR     R11,R11,R12
	LDR     R8,[R10,#36]
	EOR     R7,R7,R0
	LDR     R9,[R10,#0]
	EOR     R8,R8,R12
	STR     R7,[R10,#76]
	EOR     R9,R9,R11
	STR     R8,[R10,#36]
	STR     R9,[R10,#0]
	B       s_call_loop
s5:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	BIC     R10,R0,R2
	ORR     R6,R5,R10
	EOR     R11,R3,R10
	ORR     R11,R5,R11
	BIC     R12,R2,R3
	EOR     R14,R3,R0
	ORR     R8,R12,R14
	BIC     R5,R8,R5
	EOR     R12,R12,R0
	AND     R7,R2,R8
	EOR     R7,R7,R3
	BIC     R10,R7,R10
	EOR     R10,R10,R11
	ORR     R11,R7,R11
	ORR     R14,R4,R10
	EOR     R7,R7,R14
	EOR     R14,R12,R6
	AND     R6,R3,R6
	EOR     R6,R6,R10
	AND     R10,R10,R14
	BIC     R8,R8,R10
	EOR     R9,R2,R5
	BIC     R5,R5,R3
	EOR     R5,R5,R2
	EOR     R10,R9,R10
	ORR     R2,R4,R9
	EOR     R14,R14,R2
	BIC     R2,R7,R1
	EOR     R14,R14,R2
	EOR     R9,R0,R9
	AND     R12,R12,R9
	BIC     R12,R4,R12
	EOR     R6,R6,R12
	BIC     R7,R7,R8
	AND     R12,R4,R5
	EOR     R8,R8,R12
	ORR     R12,R4,R10
	EOR     R11,R11,R12
	ORR     R11,R1,R11
	EOR     R8,R8,R11
	ORR     R11,R6,R7
	EOR     R12,R3,R0
	EOR     R11,R11,R12
	BIC     R11,R4,R11
	EOR     R11,R9,R11
	EOR     R7,R7,R11
	AND     R12,R12,R10
	EOR     R12,R12,R5
	ORR     R9,R3,R9
	EOR     R10,R14,R10
	BIC     R10,R9,R10
	AND     R10,R4,R10
	EOR     R10,R12,R10
	ORR     R10,R1,R10
	EOR     R10,R7,R10
	BIC     R7,R9,R1
	LDR     R12,[R13],#4
	EOR     R7,R6,R7
	LDR     R6,[R12,#28]
	MVN     R8,R8
	LDR     R11,[R12,#52]
	EOR     R6,R6,R10
	LDR     R10,[R12,#96]
	EOR     R7,R11,R7
	LDR     R11,[R12,#8]
	EOR     R8,R10,R8
	STR     R6,[R12,#28]
	EOR     R9,R11,R14
	STR     R7,[R12,#52]
	STR     R8,[R12,#96]
	STR     R9,[R12,#8]
	LDR     R14,[R13],#4
	B       s_call_loop
s6:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	MVN     R2,R2
	EOR     R7,R4,R0
	EOR     R8,R7,R5
	AND     R9,R0,R5
	BIC     R6,R9,R4
	BIC     R11,R3,R6
	EOR     R12,R5,R9
	ORR     R14,R6,R12
	BIC     R14,R14,R3
	EOR     R14,R12,R14
	AND     R12,R4,R12
	BIC     R12,R3,R12
	ORR     R12,R1,R12
	ORR     R6,R6,R14
	EOR     R0,R8,R11
	EOR     R9,R9,R0
	BIC     R9,R9,R14
	AND     R14,R1,R14
	EOR     R14,R0,R14
	ORR     R3,R5,R0
	BIC     R3,R3,R4
	BIC     R8,R1,R6
	EOR     R8,R3,R8
	AND     R8,R8,R2
	LDR     R3,[R10,#12]
	EOR     R8,R8,R14
	MVN     R8,R8
	EOR     R3,R3,R8
	BIC     R8,R8,R7
	STR     R3,[R10,#12]
	EOR     R8,R8,R6
	BIC     R10,R5,R8
	EOR     R10,R10,R0
	BIC     R6,R1,R10
	ORR     R14,R4,R5
	BIC     R0,R14,R7
	EOR     R7,R7,R5
	BIC     R3,R1,R6
	EOR     R0,R0,R3
	ORR     R0,R2,R0
	EOR     R6,R8,R6
	EOR     R0,R6,R0
	EOR     R6,R5,R6
	BIC     R6,R4,R6
	ORR     R10,R10,R6
	EOR     R10,R10,R11
	ORR     R11,R6,R7
	EOR     R11,R11,R12
	AND     R14,R14,R9
	EOR     R7,R14,R7
	AND     R7,R1,R7
	EOR     R7,R10,R7
	ORR     R7,R2,R7
	EOR     R7,R11,R7
	BIC     R12,R8,R4
	BIC     R12,R2,R12
	BIC     R11,R1,R6
	LDR     R10,[R13],#4
	EOR     R12,R12,R11
	LDR     R11,[R10,#112]
	EOR     R12,R12,R9
	LDR     R9,[R10,#72]
	EOR     R7,R7,R11
	LDR     R8,[R10,#40]
	EOR     R9,R9,R0
	STR     R7,[R10,#112]
	EOR     R8,R8,R12
	STR     R9,[R10,#72]
	STR     R8,[R10,#40]
	LDR     R14,[R13],#4
	B       s_call_loop
s7:	
	STR     R14,[R13,#-4]!
	LDMIA   R12,{R6-R9,R11,R12}
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	AND     R7,R1,R3
	EOR     R7,R7,R4
	AND     R8,R3,R7
	EOR     R9,R8,R1
	BIC     R6,R2,R9
	EOR     R7,R7,R6
	EOR     R11,R2,R6
	ORR     R6,R1,R3
	ORR     R6,R6,R4
	BIC     R12,R4,R1
	ORR     R12,R2,R12
	EOR     R6,R6,R12
	BIC     R12,R5,R11
	EOR     R12,R7,R12
	EOR     R7,R8,R7
	ORR     R14,R5,R7
	EOR     R6,R6,R14
	AND     R14,R0,R6
	LDR     R6,[R10,#124]
	EOR     R14,R12,R14
	EOR     R6,R6,R14
	EOR     R9,R3,R9
	STR     R6,[R10,#124]
	ORR     R6,R1,R9
	EOR     R6,R6,R14
	BIC     R6,R6,R5
	ORR     R14,R2,R8
	EOR     R14,R9,R14
	EOR     R8,R2,R8
	AND     R8,R8,R1
	BIC     R8,R5,R8
	EOR     R8,R14,R8
	EOR     R11,R11,R8
	EOR     R7,R1,R7
	BIC     R7,R9,R7
	AND     R7,R5,R7
	ORR     R9,R0,R8
	EOR     R9,R12,R9
	BIC     R14,R14,R2
	ORR     R8,R14,R8
	BIC     R8,R8,R0
	EOR     R8,R6,R8
	EOR     R12,R11,R8
	BIC     R6,R3,R2
	ORR     R8,R4,R6
	EOR     R11,R11,R8
	EOR     R11,R11,R7
	BIC     R6,R1,R6
	AND     R6,R5,R6
	AND     R8,R2,R6
	EOR     R8,R8,R7
	ORR     R8,R0,R8
	EOR     R11,R11,R8
	EOR     R7,R6,R9
	LDR     R9,[R10,#44]
	MVN     R7,R7
	EOR     R7,R9,R7
	LDR     R9,[R10,#24]
	STR     R7,[R10,#44]
	LDR     R8,[R10,#84]
	EOR     R9,R9,R11
	EOR     R8,R8,R12
	STR     R9,[R10,#24]
	STR     R8,[R10,#84]
	LDR     R14,[R13],#4
	B       s_call_loop
s8:	
	STMDB   R13!,{R10,R14}
	LDMIA   R12,{R6-R9,R11}
	LDR     R12,[R12,#-108]
	EOR     R0,R0,R6
	EOR     R1,R1,R7
	EOR     R2,R2,R8
	EOR     R3,R3,R9
	EOR     R4,R4,R11
	EOR     R5,R5,R12
	BIC     R7,R0,R2
	EOR     R8,R7,R3
	EOR     R6,R0,R2
	ORR     R11,R4,R8
	EOR     R11,R6,R11
	BIC     R12,R11,R0
	ORR     R14,R12,R3
	EOR     R14,R14,R6
	EOR     R14,R14,R4
	BIC     R6,R6,R4
	ORR     R6,R6,R3
	BIC     R10,R7,R14
	EOR     R9,R4,R10
	EOR     R9,R2,R9
	BIC     R9,R9,R1
	EOR     R9,R6,R9
	AND     R9,R5,R9
	EOR     R6,R12,R2
	BIC     R8,R8,R14
	EOR     R8,R8,R6
	BIC     R6,R6,R4
	EOR     R6,R3,R6
	BIC     R2,R2,R8
	ORR     R2,R6,R2
	ORR     R12,R1,R12
	EOR     R12,R2,R12
	BIC     R8,R1,R8
	EOR     R8,R14,R8
	ORR     R8,R5,R8
	BIC     R6,R1,R6
	EOR     R14,R11,R6
	MVN     R14,R14
	ORR     R11,R11,R4
	EOR     R6,R14,R8
	EOR     R9,R14,R9
	ORR     R14,R14,R3
	EOR     R8,R7,R3
	EOR     R8,R8,R11
	AND     R7,R4,R7
	EOR     R7,R7,R14
	BIC     R7,R1,R7
	AND     R11,R0,R11
	EOR     R11,R11,R7
	BIC     R11,R11,R5
	AND     R14,R1,R14
	EOR     R14,R8,R14
	EOR     R11,R14,R11
	ORR     R7,R8,R11
	BIC     R7,R1,R7
	EOR     R7,R10,R7
	ORR     R7,R5,R7
	LDR     R10,[R13],#4
	EOR     R7,R12,R7
	LDR     R8,[R10,#56]
	MVN     R7,R7
	LDR     R12,[R10,#80]
	EOR     R8,R8,R11
	LDR     R11,[R10,#104]
	EOR     R9,R12,R9
	STR     R8,[R10,#56]
	LDR     R12,[R10,#16]
	EOR     R7,R11,R7
	STR     R9,[R10,#80]
	EOR     R6,R12,R6
	STR     R7,[R10,#104]
	STR     R6,[R10,#16]
	LDR     R14,[R13],#4
	B       s_call_loop
	
timingloop:
	ADD     R2,R13,#0x0208      
	LDR     R0,[R2,R1,LSL #2]
	MVN     R0,R0
	STR     R0,[R2,R1,LSL #2]
deseval:
	ADD     R1,R13,#8
	MVN     R3,#0
	STMDB   R13!,{R1-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}
	LDMDB   R2!,{R4-R11}
	STMDB   R13!,{R4-R11}	
	ADR     R14,s_param_table
s_call_loop:
	LDR     R11,[R14],#4
	TST     R11,#1
	BNE     do_check
donecheck:
	LDR     R9,[R13,#260]
	LDR     R6,[R14],#4
	LDR     R0,[R9,R11,LSR #24]
	BIC     R11,R11,#0xFF000000
	LDR     R1,[R9,R11,LSR #16]
	BIC     R11,R11,#0x00FF0000
	LDR     R2,[R9,R11,LSR #8]
	BIC     R11,R11,#0xFF00
	LDR     R3,[R9,R11]
	LDR     R4,[R9,R6,LSR #24]
	BIC     R6,R6,#0xFF000000
	LDR     R5,[R9,R6,LSR #16]
	BIC     R6,R6,#0x00FF0000
	ADD     R12,R13,R6,LSR #8
	AND     R10,R6,#1
	ADD     R10,R13,R10,LSL #7
	AND     R6,R6,#0x70         
	LDR     PC,[PC,R6,LSR #2]

	.word	0x12345678
	.word	s1
	.word	s2
	.word	s3
	.word	s4
	.word	s5
	.word	s6
	.word	s7
	.word	s8
	
do_check:	
	AND     R5,R11,#2
	SUB     R5,R13,R5,LSL #6
	ANDS    R4,R11,#0x03F00000
	LDRNE   R6,[R5,R4,LSR #18]
	ANDS    R4,R11,#0x000FC000
	LDRNE   R7,[R5,R4,LSR #12]
	ANDS    R4,R11,#0x3F00
	LDRNE   R8,[R5,R4,LSR #6]
	ANDS    R4,R11,#0xFC        
	LDRNE   R9,[R5,R4]
	LDR     R1,[R13,#256]
	AND     R4,R11,#0x78000000
	ADD     R1,R1,R4,LSR #23
	LDMIA   R1,{R2-R5}
	LDR     R0,[R13,#264]
	EOR     R5,R5,R6
	BIC     R0,R0,R5
	EOR     R4,R4,R7
	BIC     R0,R0,R4
	EOR     R3,R3,R8
	BIC     R0,R0,R3
	EOR     R2,R2,R9
	BICS    R0,R0,R2
	BEQ     gotresult
	STR     R0,[R13,#264]
	LDR     R11,[R14],#4
	TST     R11,#1
	BEQ     donecheck
gotresult:
	ADD     R13,R13,#0x010C     
	LDMIA   R13!,{R4-R11}
deseval_end:
	BNE     foundkey
	EOR     R6,R7,R7,LSR #1
	ADD     R7,R7,#1
	CMP     R7,R9
	BCS     half_keys_done
	EOR     R1,R7,R7,LSR #1
	EOR     R1,R1,R6
	TST     R1,#1
	MOVNE   R1,#0x0C            
	BNE     timingloop
	TST     R1,#2
	MOVNE   R1,#0x0F            
	BNE     timingloop
	TST     R1,#4
	MOVNE   R1,#0x12            
	BNE     timingloop
	TST     R1,#8
	MOVNE   R1,#0x28            
	BNE     timingloop
	TST     R1,#0x10            
	MOVNE   R1,#0x29            
	BNE     timingloop
	TST     R1,#0x20            
	MOVNE   R1,#0x2A            
	BNE     timingloop
	TST     R1,#0x40            
	MOVNE   R1,#0x2B            
	BNE     timingloop
	TST     R1,#0x80            
	MOVNE   R1,#0x2D            
	BNE     timingloop
	TST     R1,#0x0100          
	MOVNE   R1,#0x2E            
	BNE     timingloop
	TST     R1,#0x0200          
	MOVNE   R1,#0x31            
	BNE     timingloop
	TST     R1,#0x0400          
	MOVNE   R1,#0x32            
	BNE     timingloop
	TST     R1,#0x0800          
	MOVNE   R1,#0
	BNE     timingloop
	TST     R1,#0x1000          
	MOVNE   R1,#1
	BNE     timingloop
	TST     R1,#0x2000
	MOVNE   R1,#2
	BNE     timingloop
	TST     R1,#0x4000
	MOVNE   R1,#4
	BNE     timingloop
	TST     R1,#0x8000
	MOVNE   R1,#6
	BNE     timingloop
	TST     R1,#0x00010000
	MOVNE   R1,#7
	BNE     timingloop
	TST     R1,#0x00020000
	MOVNE   R1,#9
	BNE     timingloop
	TST     R1,#0x00040000
	MOVNE   R1,#0x0D            
	BNE     timingloop

	.word	0xE6000010
this_shouldnt_happen:
	b	this_shouldnt_happen
s_param_table:
	.word	0xBC2C680C
	.word	0x34A48000
	.word	0x6C18D8C0
	.word	0x9C4C8C10
	.word	0xD4648488
	.word	0x44149C20
	.word	0x10DC6080
	.word	0xA050AC30
	.word	0x907C5420
	.word	0x5CD0BC40
	.word	0x3874CC24
	.word	0x8C78CC50
	.word	0x08945800
	.word	0xA898DC60
	.word	0x40ACB004
	.word	0x1C70EC70
	.word	0xD8488428
	.word	0x50C00001
	.word	0x883410DC
	.word	0xB8680C11
	.word	0x0C80A0A4
	.word	0x60301C21
	.word	0x2C14189C
	.word	0xBC6C2C31
	.word	0xAC98703C
	.word	0x78003C41
	.word	0x54907C40
	.word	0xA8944C51
	.word	0x24B0741C
	.word	0xC4B45C61
	.word	0x5CC8CC20
	.word	0x388C6C71
	.word	0x2C80BC60
	.word	0x88148000
	.word	0xC06C4830
	.word	0x0CA08C10
	.word	0x44B8D8DC
	.word	0x34689C20
	.word	0x644C50D4
	.word	0x10A4AC30
	.word	0x08D0A874
	.word	0xB038BC40
	.word	0x8CC8B478
	.word	0x04CCCC50
	.word	0x5C7CAC54
	.word	0x2000DC60
	.word	0x94249858
	.word	0x70C4EC70
	.word	0x64B81034
	.word	0xC04C0001
	.word	0x14A48068
	.word	0x44D80C11
	.word	0x180C2C30
	.word	0x6CA01C21
	.word	0x9C848828
	.word	0x48DC2C31
	.word	0x401C04AC
	.word	0x7C703C41
	.word	0xC42400B0
	.word	0x3C984C51
	.word	0x94B4088C
	.word	0x58385C61
	.word	0xCC5CD090
	.word	0xA8206C71
	.word	0x9C0C486C
	.word	0x14848000
	.word	0x4CDCB8A0
	.word	0x182C8C10
	.word	0x50446468
	.word	0xA4D89C20
	.word	0xD4BCC060
	.word	0x8030AC30
	.word	0x78543C08
	.word	0xB4A8BC40
	.word	0x205C387C
	.word	0x74D0CC50
	.word	0xCC0040C4
	.word	0x9070DC60
	.word	0x98941CC8
	.word	0x0458EC70
	.word	0xD44480A4
	.word	0x4CBC0001
	.word	0x84300CD8
	.word	0x50640C11
	.word	0x88189CA0
	.word	0xDC2C1C21
	.word	0x28101434
	.word	0xB8682C31
	.word	0xB08C7440
	.word	0x00043C41
	.word	0x589470B4
	.word	0xAC1C4C51
	.word	0x98387820
	.word	0xC8A85C61
	.word	0xD0CC5424
	.word	0x3C906C71
	.word	0x2818B8DC
	.word	0x84108000
	.word	0xBC68442C
	.word	0x889C8C10
	.word	0xC050D4D8
	.word	0x30649C20
	.word	0x60484C6C
	.word	0x0CA0AC30
	.word	0x7CC4AC78
	.word	0x383CBC40
	.word	0x90CCA800
	.word	0x0854CC50
	.word	0xD070B058
	.word	0x2404DC60
	.word	0x1C988C5C
	.word	0x74C8EC70
	.word	0x60500C30
	.word	0xBC480001
	.word	0x10A01864
	.word	0xC0D40C11
	.word	0x1488282C
	.word	0x689C1C21
	.word	0x348084A4
	.word	0x44D82C31
	.word	0xB42008B0
	.word	0x70743C41
	.word	0xC8980438
	.word	0x408C4C51
	.word	0x1CA87C90
	.word	0x5C3C5C61
	.word	0x54D0C494
	.word	0xAC246C71
	.word	0x186C284C
	.word	0xD8648000
	.word	0x2CBC3480
	.word	0xDC0C8C10
	.word	0x30A44448
	.word	0x84B89C20
	.word	0x509CA0C0
	.word	0x6010AC30
	.word	0xD03C24CC
	.word	0x8C90BC40
	.word	0x08B42054
	.word	0x5CA8CC50
	.word	0x38C498AC
	.word	0x7858DC60
	.word	0x700004B0
	.word	0xC840EC70
	.word	0x50A46084
	.word	0x2C9C0001
	.word	0x64106CB8
	.word	0x30440C11
	.word	0x68DC1880
	.word	0xBC0C1C21
	.word	0x88D4D814
	.word	0x34482C31
	.word	0x1C745C98
	.word	0xC4C83C41
	.word	0x4000588C
	.word	0x94044C51
	.word	0x7020D008
	.word	0xB0905C61
	.word	0xA8383C7C
	.word	0x24786C71
	.word	0x88DC34BC
	.word	0x64D48000
	.word	0x9C48A40C
	.word	0x68188C10
	.word	0xA03050B8
	.word	0x10449C20
	.word	0xC0282C4C
	.word	0x6C80AC30
	.word	0x54AC94D0
	.word	0x2024BC40
	.word	0x783890C4
	.word	0xCC3CCC50
	.word	0xA8581C40
	.word	0x7CC8DC60
	.word	0x047074B4
	.word	0x5CB0EC70
	.word	0xC0306C10
	.word	0x9C280001
	.word	0xD480DC44
	.word	0xA0500C11
	.word	0xD868880C
	.word	0x48181C21
	.word	0x14606484
	.word	0xA4B82C31
	.word	0x8C08CC1C
	.word	0x585C3C41
	.word	0xB070C820
	.word	0x98744C51
	.word	0x04905478
	.word	0xB4245C61
	.word	0x3CA8AC00
	.word	0x947C6C71
	.word	0x1468A448
	.word	0xD4608000
	.word	0x28B83018
	.word	0xD8888C10
	.word	0x2CA0C044
	.word	0x80509C20
	.word	0x4C349CBC
	.word	0xDC0CAC30
	.word	0xC4409854
	.word	0x9094BC40
	.word	0x7CA82458
	.word	0xD0ACCC50
	.word	0x3CC88CB0
	.word	0x005CDC60
	.word	0x74040838
	.word	0xCCB4EC70
	.word	0x4CA0DC80
	.word	0x28340001
	.word	0x600C6850
	.word	0x2CC00C11
	.word	0x64D81418
	.word	0xB8881C21
	.word	0x846CD410
	.word	0x30442C31
	.word	0x2078D08C
	.word	0xC8CC3C41
	.word	0xB4045C90
	.word	0x1C084C51
	.word	0x7424C47C
	.word	0x38945C61
	.word	0xAC3C4070
	.word	0x98006C71
	.word	0xBCA42848
	.word	0x6818AC30
	.word	0x60000003
	.word	0xAC5C20B4
	.word	0x70CCDC60
	.word	0x4BF00003
	.word	0x3444A088
	.word	0x64148C10
	.word	0x70000003
	.word	0x087478A8
	.word	0xD038EC70
	.word	0x40000003
	.word	0x003C94C8
	.word	0x5440CC50
	.word	0x52300003
	.word	0x9C2C4C50
	.word	0x0CC09C20
	.word	0x68000097
	.word	0x58B01CC4
	.word	0x2498BC40
	.word	0x58000003
	.word	0x84D830B8
	.word	0x606C8000
	.word	0x780C0003
	.word	0xD8C04464
	.word	0x84342C31
	.word	0x20000001
	.word	0xC8783CD0
	.word	0x8C7C5C61
	.word	0x0BF00001
	.word	0x5060BCA4
	.word	0x80300C11
	.word	0x30000001
	.word	0x249094C4
	.word	0x00546C71
	.word	0x00000001
	.word	0x1C58B008
	.word	0x705C4C51
	.word	0x12300001
	.word	0xB848686C
	.word	0x28DC1C21
	.word	0x28000095
	.word	0x74CC3804
	.word	0x40B43C41
	.word	0x18000001
	.word	0xA0104CD4
	.word	0x18880001
	.word	0x380C0001
	.word	0xFFFFFFFF
