/* 
 * Created 03.Oct.98 by Cyrus Patel <cyp@fb14.uni-mainz.de>
 * Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
*/
const char *w32cons_cpp(void) {
return "@(#)$Id: w32cons.cpp,v 1.51.2.27 1999/11/16 21:05:36 cyp Exp $"; }

//#define PIPE_DEBUG

#include "cputypes.h"
#include "baseincs.h"
#include "clitime.h"  // CliGetTimeString(&tv,4),GetBuildDate()
#include "console.h"  // for CLICONS_[SHORT|LONG]NAME, ConOut, ConInKey
#include "cliident.h" // CliGetFullVersionDescriptor()
#include "clievent.h" // event handler
#include "triggers.h" // for clisetupsignals
#include "logstuff.h" // Log()
#include "setprio.h"  // SetGlobalPriority();
#include "util.h"     // utilGetAppName()
#include "client.h"   // modereq needs client
#include "probfill.h" //LoadSaveProblems(), PROBFILL_UNLOADALL
#define __w16ClientHardStop() LoadSaveProblems(NULL,0,PROBFILL_UNLOADALL)
#include "modereq.h"  // "modes": options
#include "client.h"   // "modes": CONTEST_COUNT for bench
#include "problem.h"  // "modes": IsProblemLoadPermitted before bench
#include "clicdata.h" // "modes": CliGetContestNameFromID() names for bench
#include "w32svc.h"   // win9x win32CliInitializeService()
#include "w32util.h"  // winGetVersion(), winIsGUIExecutable()
#include "w32cons.h"  // ourselves

/* --------- message extensions (also see .h for public ones) --------- */
#define WM_USER_W16CONS              (WM_USER+0)
   // command message constants
   #define W16CONS_CMD_CLEARSCREEN   0x01
   #define W16CONS_CMD_PRINTSTR      0x02
   #define W16CONS_CMD_ISKBHIT       0x03
   #define W16CONS_CMD_GETCH         0x04
   #define W16CONS_CMD_SETPOS        0x05
   #define W16CONS_CMD_GETPOS        0x06
   #define W16CONS_CMD_GETSIZE       0x07
   #define W16CONS_CMD_INDIRDESTROY  0x08 /* indirect WM_DESTROY */
   #define W16CONS_CMD_ECHOLPARAM    0x09 /* just return LPARAM (to ident)*/
#define WM_USER_SHELLNOTIFYICON      (WM_USER+10) /* for tray icon */
   // internal WM_COMMAND wParams, 
   // public ones are 0.... (DNETC_WCMD_INTERNAL_FIRST-1) 
   // See w32cons.h for list
   #define WMCMD_BENCHMARK            DNETC_WCMD_INTERNAL_FIRST /* 512 */
   #define WMCMD_CONFIG               (WMCMD_BENCHMARK+2+(CONTEST_COUNT*2))
   #define WMCMD_UPDATE               (WMCMD_CONFIG+1)
   #define WMCMD_FETCH                (WMCMD_UPDATE+1)
   #define WMCMD_FLUSH                (WMCMD_FETCH+1)
   #define WMCMD_SVCINSTALL           (WMCMD_FLUSH+1)
   #define WMCMD_LAGGYRESTORE         (WMCMD_SVCINSTALL+1)
   #define WMCMD_PASTE   WM_PASTE     /* 0x0302 */
   #define WMCMD_COPY    WM_COPY
   #define WMCMD_RESTORE SC_RESTORE   /* 0xF120 */
/* these should have been defined in w32cons.h 
#define W32CLI_CONSOLE_NAME "distributed.net client"
#define W32CLI_OLD_CONSOLE_NAME "distributed.net RC5DES client"
#define W32CLI_MUTEX_NAME   "Bovine RC5/DES Win32 Client"
#define W32CLI_SSATOM_NAME   "distributed.net ScreenSaver"
*/
/* ------------------------------------------------------------------ */

//#define USE_NATIVE_CONSOLEIO //define this to force win32 native console i/o

// define to the dimensions of the virtual screen
#define W16CONS_WIDTH       80
#define W16CONS_HEIGHT      25

// undefine the following to allow the window to be resized
//#define W16CONS_FIXEDSIZE

// define to the font type (must be fixed width)
#define W16CONS_FONT        ANSI_FIXED_FONT //OEM_FIXED_FONT, SYSTEM_FIXED_FONT

// define to maximum keyboard buffer size
#define W16CONS_KEYBUFF     128

// smooth font scaling or not (also depends on system capabilities of course)
//#define W16CONS_SMOOTHSIZING

// colors 
#define W16CONS_NATIVECOLORS
#ifdef W16CONS_NATIVECOLORS
#define W16CONS_FORECOLOR GetSysColor(COLOR_WINDOWTEXT)
#define W16CONS_BACKCOLOR GetSysColor(COLOR_WINDOW)
#else
#define W16CONS_FORECOLOR RGB( 255,255,255 )
#define W16CONS_BACKCOLOR RGB(0,0,128 )
#endif

/* --------------------------------------------------------------------- */

#if (CLIENT_OS == OS_WIN16)
  #define SetForegroundWindow BringWindowToTop
#endif  

/* ---------------------------------------------------- */

// data structure associated with the window
struct W16ConsoleStruc
{
  HWND hwnd;
  char buff[W16CONS_HEIGHT][W16CONS_WIDTH];
  int have_marked;
  int mark_down;
  int mark_lastrow;
  char marked_buff[W16CONS_HEIGHT];
  int currow, curcol;
  struct { int shift:1, alt:1, ctrl:1; } kbflags;
  int keybuff[W16CONS_KEYBUFF];
  int keycount;
  HFONT hfont;
  int fontisstock;
  int fontx, fonty;
  int indentx, indenty;
  int dispcols, disprows;
  int painting;
  int smoothsizing;
  UINT ssmessage;
  struct { int intray, verasst; char tip[64]; } traydata;
  struct { int top, left, fx, fy, state; } lastpos;
  UINT dnetc_cmdmsg;
};

static struct
{
HWND    hwndList[1];
char    szClassName[32];
HANDLE  hmutex;
int     hidden;
FILE    *fstdout;
FILE    *fstdin;
int     iconisstock;
HICON   hIcon;     
int     createflag;
int     errorcode;
int     asthread;
int     debugon;
int     nativecons;
int     client_run_startstop_level; //inc on ClientRun start, dec on stop
void   *devpipe;   /* named pipe (r/w) or output end of anon pipe */
void   *devpipein; /* NULL if named pipe or input end of anon pipe */
HWND    shimwatcher;
} constatics = 
{
  {NULL},   //hwndList[1];
  {0},      //szClassName[32];
  NULL,     //hmutex;
  0,        //hidden;
  NULL,     //FILE *fstdout;
  NULL,     //FILE *fstdin;
  0,        //iconisstock;
  NULL,     //hIcon;     
  0,        //createflag;
  0,        //errorcode;
  0,        //asthread;
  0,        //debugon;
  0,        //nativecons;
  0,        //client_run_startstop_level, 
  NULL,     //devpipe;
  NULL,     //devpipein;
  NULL      //shimwatcher;
};

typedef struct W16ConsoleStruc * W16CONP;

#define W16CONS_ERR_CREATETHREAD 1
#define W16CONS_ERR_NOFONT       2
#define W16CONS_ERR_NOMEM        3
#define W16CONS_ERR_CREATEWIN    4
#define W16CONS_ERR_REGCLASS     5
#define W16CONS_ERR_GETINST      6
#define W16CONS_ERR_NOSLOT       7
#define W16CONS_ERR_NCCREATE     8

/* ---------------------------------------------------- */

void __w16writelog( const char *format, ... )
{
  static char *openmode = "w";
  va_list argptr;
  FILE *f;
  va_start(argptr, format);
  if (strlen(format)>=6 && memcmp(format,"callee",6)==0)
  {
    f = fopen("debug.log","a+");
    if (f)
    {
      openmode = "a+";
      fclose(f);
    }
  }
  f = fopen("debug.log",openmode);
  if (f)
  {
    openmode = "a+";
    vfprintf( f, format, argptr );
    if (*format)
      format += (strlen(format)-1);
    if (*format != '\n')
      fwrite("\n",1,1,f);
    fflush(f);
    fclose(f);
  }
  va_end(argptr);
  return;
}  

#if (CLIENT_OS == OS_WIN32)
void __w16showerror(const char *caption)
{
  LPVOID lpMsgBuf;
  FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | 
     FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,
     GetLastError(),  0 /*MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT)*/, 
     (LPTSTR) &lpMsgBuf, 0, NULL );// Process any inserts in lpMsgBuf.
  __w16writelog( "%s: %s\n", caption, lpMsgBuf );
  // w32ConOutModal((const char *)lpMsgBuf );
  LocalFree( lpMsgBuf );
  return;
}  
#endif

/* =============================================================== */

static void __event_handler( int event_id /* all events */, long parm )
{
  //__w16writelog( "saw event: %d, parm: 0x%x", event_id, parm );
  if ( event_id == CLIEVENT_CLIENT_RUNSTARTED)
    constatics.client_run_startstop_level++;
  else if (event_id == CLIEVENT_CLIENT_RUNFINISHED)
    constatics.client_run_startstop_level--;
  parm = parm;
}

/* =============================================================== */

static W16CONP __win16GetHwndConsole( HWND hwnd )
{
  #if (CLIENT_OS == OS_WIN32) || (CLIENT_OS == OS_WIN32S)
  return (W16CONP)GetWindowLong(hwnd, GWL_USERDATA);
  #else
  return (W16CONP)GetWindowLong(hwnd, 0);
  #endif
}

static W16CONP __win16SetHwndConsole( HWND hwnd, W16CONP console )
{
  #if (CLIENT_OS == OS_WIN32) || (CLIENT_OS == OS_WIN32S)
  return (W16CONP)SetWindowLong(hwnd, GWL_USERDATA, (LONG)console);
  #else
  return (W16CONP)SetWindowLong(hwnd, 0, (LONG)console);
  #endif
}

/* ---------------------------------------------------- */

#if 0
static int __win16AssertHidden(HWND hwnd)
{
  if (constatics.hidden && (IsWindowVisible(hwnd) || IsWindowEnabled(hwnd)))
  {
    SetWindowPos(hwnd,HWND_BOTTOM,0,0,0,0,
        (SWP_HIDEWINDOW|SWP_NOREDRAW|SWP_NOACTIVATE));
    RECT rect;
    GetWindowRect(hwnd,&rect);
    rect.right-=rect.left;
    rect.bottom-=rect.top;
    SetWindowPos(hwnd, NULL,-rect.right, -rect.bottom, 
       rect.right, rect.bottom, SWP_NOZORDER|SWP_NOACTIVATE|SWP_NOREDRAW);
    #if 0
    hwnd = GetTopWindow(GetDesktopWindow());
    if (hwnd) 
    {
      EnableWindow(hwnd,1);
      SetActiveWindow(hwnd);
    }
    #endif
    return 1;
  }
  return 0;
}
#endif

/* ---------------------------------------------------------------------- */

#if (CLIENT_OS == OS_WIN32)

#include <shellapi.h>

static int my_Shell_NotifyIcon( DWORD dwMessage, PNOTIFYICONDATA pnid )
{
  static HINSTANCE hinst;
  static BOOL (WINAPI *_Shell_NotifyIcon)(DWORD, PNOTIFYICONDATA) = NULL;
  static int havenotifyiconproc = -1;

  if (havenotifyiconproc < 0)
  {
    if (dwMessage == NIM_DELETE)
      return 1;
    havenotifyiconproc = 0;
    hinst = LoadLibrary( "shell32.dll" );
    if (hinst > (HINSTANCE)32)
    {
      HMODULE hmod = GetModuleHandle("SHELL32");
      if (hmod)
      {
        FARPROC proc = GetProcAddress(hmod, "Shell_NotifyIconA");
        if (proc)
        {
          _Shell_NotifyIcon = (BOOL (WINAPI *)(DWORD, PNOTIFYICONDATA))proc;
          havenotifyiconproc = +1;
        }
      }
    }
  }

  if (havenotifyiconproc > 0)
  {
    /*
    __w16writelog( "sni: msg=%s pnid.hIcon=%d\n", 
         ((dwMessage==NIM_ADD)?("NIM_ADD"):
         ((dwMessage==NIM_DELETE)?("NIM_DELETE"):("NIM_MODIFY"))), 
         pnid->hIcon );
    */         
    if ((*_Shell_NotifyIcon)(dwMessage, pnid ))
    {
      if (dwMessage == NIM_DELETE)
      {
        havenotifyiconproc = -1;
        FreeLibrary(hinst);
      }
      return 1;
    }
  }
  return 0;
}  

static int __DoTrayStuff(W16CONP /*console*/,HWND hwnd, int action)
{
  static int recursive = 0;
  int retcode = -1; /* assume failed */

  if ((++recursive)==1)
  {
    if (!constatics.hidden && !constatics.nativecons && !constatics.devpipe)
    {
      static int intray = 0;
      static HICON hIcon = NULL;
      static int iconavailable = -1;
      NOTIFYICONDATA tnd;

      if (hIcon == NULL && iconavailable < 0)
      {
        iconavailable = 0;
        if ((winGetVersion()%2000) >= 400)
        {
          HINSTANCE hInst = LoadLibrary( "user32.dll" );
          if (hInst > (HINSTANCE)32)
          {
            HMODULE hmod = GetModuleHandle("USER32");
            if (hmod)
            {
              FARPROC proc = GetProcAddress(hmod, "LoadImageA");
              if (proc)
              {
                HANDLE (WINAPI * _LoadImage)(HINSTANCE,LPCTSTR,UINT,int,int,UINT)
                  = (HANDLE (WINAPI *)(HINSTANCE,LPCTSTR,UINT,int,int,UINT))proc;
                hIcon = (HICON)(*_LoadImage)( 
                           (HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE),
                           MAKEINTRESOURCE(1), IMAGE_ICON, 16, 16, 0 );
                if (hIcon)
                  iconavailable = 1;                                     
              }
            }
            FreeLibrary(hInst);
          }
        }
      }
  
      /* construct a default structure */
      memset( (void *)&tnd, 0, sizeof(tnd));
      tnd.cbSize    = sizeof(NOTIFYICONDATA);
      tnd.uCallbackMessage= WM_USER_SHELLNOTIFYICON;
      tnd.hWnd      = hwnd;
      tnd.uID       = 2; /* App-defined id of the taskbar icon */
      tnd.hIcon     = hIcon;
      tnd.uFlags    = NIF_MESSAGE;
      tnd.szTip[0]  = '\0';
      if (IsWindow(hwnd))
      {
        if (!tnd.hIcon)
        {
          tnd.hIcon = (HICON)GetClassLong(hwnd,GCL_HICON);
          tnd.uID   = 1; /* App-defined id of the taskbar icon */
        }  
        GetWindowText( hwnd, tnd.szTip, sizeof(tnd.szTip));
        tnd.szTip[sizeof(tnd.szTip)-1]=0;
      }
      if (tnd.szTip[0]) tnd.uFlags |= NIF_TIP;
      if (tnd.hIcon) tnd.uFlags |= NIF_ICON;

      //__w16writelog( "begin: action=%d, intray=%d\n", action, intray );

      if (action < 0)
      {
        if (intray)
        {
          /* NIM_DELETE fails if explorer just got restarted */
          my_Shell_NotifyIcon(NIM_DELETE, &tnd);
          intray = 0;
          retcode = 0;
          /*
          if (IsWindow(hwnd))
          {
            ShowWindow(hwnd, SW_RESTORE);
            ShowWindow(hwnd, SW_SHOW);
            SetForegroundWindow(hwnd);
          }
          */
        }
      }
      else if (action >= 0) /* refresh or create trayicon */
      {
        if (intray)
        {
          /* NIM_DELETE fails if explorer just got restarted */
          my_Shell_NotifyIcon(NIM_DELETE, &tnd); 
          intray = 0;
        }
        if (!intray && IsWindow(hwnd) && IsIconic(hwnd))
        {
          if (my_Shell_NotifyIcon(NIM_ADD, &tnd))
          {
            intray = 1;
            if (IsIconic(hwnd)) //ShowWindow(hwnd,SW_MINIMIZE);
              ShowWindow(hwnd, SW_HIDE);
            retcode = 0;
          }
        }
      }
      
//    if (!intray && hIcon)
//    {
//      DestroyIcon(hIcon);
//      hIcon = NULL;
//    }
    }          
  }
  --recursive;
  return retcode;
}
#endif

/* ---------------------------------------------------------------------- */

static LRESULT __w16AdjustRect( W16CONP console, HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  if ( message == WM_CREATE ||
       message == WM_PAINT  || 
       #if defined(WM_SIZING)
       message == WM_SIZING ||
       #endif
       message == WM_SIZE )
  {
    RECT rect;
    #if defined(WM_SIZING)
    RECT *wmsizing_rect = NULL;
    #endif
    int top, left, width, height;
    int adjx = (GetSystemMetrics(SM_CXFRAME) << 1);
    int adjy = (GetSystemMetrics(SM_CYFRAME) << 1) + 
                GetSystemMetrics(SM_CYCAPTION) - 1;

    console->disprows = W16CONS_HEIGHT;
    console->dispcols = W16CONS_WIDTH;
    wParam = wParam; //not used if not WM_SIZING

    GetWindowRect(hwnd, &rect);
    top = rect.top;
    left = rect.left;
    width = (rect.right-rect.left) - adjx;
    height = (rect.bottom-rect.top) - adjy;

    if (message == WM_SIZE)
    {
      width = LOWORD(lParam);
      height = HIWORD(lParam);
    }
    else if (message == WM_PAINT) //dummy meaning wParam and lParam are invalid
    {                      
      width = (rect.right-rect.left) - adjx;
      height = (rect.bottom-rect.top) - adjy;
    }
    #if defined(WM_SIZING)
    else if (message == WM_SIZING)
    {
      wmsizing_rect = (RECT *) lParam;
      height = (wmsizing_rect->bottom - wmsizing_rect->top) - adjy;
      width  = (wmsizing_rect->right - wmsizing_rect->left) - adjx;
      message = WM_SIZE;
      //wParam specifies the edge of window being sized 
    }
    #endif
    else if (message == WM_CREATE)
    {
      int x, y;
      y = GetDCTIProfileInt("client", "wtop", top);
      x = GetDCTIProfileInt("client", "wleft", left);
      if (y >= 0 && y < 3000 && x >= 0 && x < 3000)
      {                /* just some basic validation */
        top = y;
        left = x;
      }
      y = GetDCTIProfileInt("client", "fy", console->fonty );
      x = GetDCTIProfileInt("client", "fx", console->fontx );
      if (y > 0 && x < 64 && x > 0 && x < 64)
      {
        console->fonty = y;
        console->fontx = x;
      }
      width = console->fontx * console->dispcols;
      height = console->fonty * console->disprows;
    }

    //if (console->fontisstock == 0 || console->hfont == NULL) //_can_ adjust size
    {
      int newfonty  = ((height + (W16CONS_HEIGHT/2))/W16CONS_HEIGHT);
      int newfontx  = ((width + (W16CONS_WIDTH/2))/W16CONS_WIDTH);
      int turn;

      if (console->smoothsizing)
      {
        if ((newfonty * W16CONS_HEIGHT) != height)
          newfonty  = ((height+W16CONS_HEIGHT)/W16CONS_HEIGHT);
        if ((newfontx * W16CONS_WIDTH) != width)
          newfontx  = ((width+W16CONS_WIDTH)/W16CONS_WIDTH);
      }

      for (turn=0;;turn++)
      {
        HFONT hfont = NULL;
        SIZE size;
        LOGFONT lfont;
        int isstock = 0;

        //how the font mapper works is well (and understandably) documented
        //in http://msdn.microsoft.com/library/techart/msdn_fontmap.htm

        if (turn == 0) //try to avoid a change of typeface if we can help it
        {                 
          if (console->hfont && !console->fontisstock)
          { 
            GetObject( console->hfont, sizeof(LOGFONT), (LPSTR) &lfont);
            lfont.lfHeight = newfonty; 
            lfont.lfWidth = newfontx;
            hfont = CreateFontIndirect(&lfont);
          }
        }
        else if (turn >= 1 && turn <= 7)
        {
          memset(&lfont,0,sizeof(lfont));
          lfont.lfHeight = newfonty; 
          lfont.lfWidth = newfontx;   
          lfont.lfWeight = FW_NORMAL; /* 400 */
          lfont.lfCharSet = ANSI_CHARSET; /* critical */
          lfont.lfOutPrecision = OUT_TT_ONLY_PRECIS;
          lfont.lfClipPrecision = CLIP_DEFAULT_PRECIS; /* not used */
          lfont.lfQuality = PROOF_QUALITY;
          lfont.lfPitchAndFamily = (FIXED_PITCH|FF_MODERN /* monospaced */);
          if (turn == 1) strcpy(lfont.lfFaceName,"Lucida Console");
        
          /* increasingly less nice (2==same as 1, but no name) */
          if (turn >= 3) lfont.lfOutPrecision = OUT_DEVICE_PRECIS; /* no dif */
          if (turn >= 4) lfont.lfWeight = FW_DONTCARE; /* internally == 400 */
          if (turn >= 5) lfont.lfQuality = DRAFT_QUALITY;
          if (turn >= 6) lfont.lfOutPrecision = OUT_DEFAULT_PRECIS; /* don't care */
          if (turn >= 7) lfont.lfQuality = DEFAULT_QUALITY; /* don't care */
          hfont = CreateFontIndirect(&lfont);
        }
        else
        {
          if (console->hfont == NULL)
          {
            hfont = (HFONT)GetStockObject(W16CONS_FONT);
            isstock = 1;
          }
          if (!hfont) /* end of story */
            break;
        }
        if (hfont) 
        {
          HDC hdc = GetDC(hwnd);
          HFONT hOldfont = (HFONT)SelectObject(hdc, hfont);
          GetTextExtentPoint(hdc, "X", 1, &size);
          GetObject( (HFONT)SelectObject(hdc, hfont), 
                    sizeof(LOGFONT), (LPSTR) &lfont);
          SelectObject(hdc,hOldfont);
          ReleaseDC(hwnd, hdc);
          if (!isstock) /* that was our last chance, have to take it */
          {
            if ((message != WM_CREATE && console->hfont != NULL) 
              && (size.cx != newfontx || size.cy != newfonty))
              lfont.lfPitchAndFamily = 0; /* sorry toots */
            if (lfont.lfCharSet != ANSI_CHARSET ||
                (lfont.lfPitchAndFamily & (FIXED_PITCH|FF_MODERN)) != 
                (FIXED_PITCH|FF_MODERN)) // we *must* have a typographic font
            {
              DeleteObject(hfont);
              hfont = NULL;
            }
          }
          if (hfont)
          {
            if (console->hfont && !console->fontisstock)
              DeleteObject(console->hfont);
            console->fontisstock = isstock;
            console->hfont = hfont;
            console->fontx = size.cx;
            console->fonty = size.cy;
            break;
          }
        } 
      } /* for ... */
    }
    if (console->hfont == NULL)
      return FALSE;

    //make width and height the adjusted window (not client) dimensions
    width  = console->dispcols * console->fontx + adjx;
    height = console->disprows * console->fonty + adjy;

    InvalidateRect(hwnd,NULL,TRUE);
 
    //if this a WM_SIZING message, then adjust the new size and return
    #if defined(WM_SIZING) 
    if (wmsizing_rect != NULL && console->smoothsizing == 0) 
    {
      if (wParam == WMSZ_TOP || wParam == WMSZ_TOPRIGHT || wParam == WMSZ_TOPLEFT)
        wmsizing_rect->top = wmsizing_rect->bottom - height;
      if (wParam == WMSZ_BOTTOM || wParam == WMSZ_BOTTOMRIGHT || wParam == WMSZ_BOTTOMLEFT)
        wmsizing_rect->bottom = wmsizing_rect->top + height;
      if (wParam == WMSZ_TOPRIGHT || wParam == WMSZ_BOTTOMRIGHT || wParam == WMSZ_RIGHT)
        wmsizing_rect->right = wmsizing_rect->left + width;
      if (wParam == WMSZ_TOPLEFT || wParam == WMSZ_BOTTOMLEFT || wParam == WMSZ_LEFT)
        wmsizing_rect->left = wmsizing_rect->right - width;
      return TRUE;
    }
    #endif

    if (message == WM_CREATE || console->smoothsizing == 0)
      MoveWindow(hwnd, left, top, width, height, TRUE );
    else if (message != WM_PAINT)
      UpdateWindow( hwnd );

//char tbuf[128];
//sprintf(tbuf,"%d:%d,%d:%d, x:%d y:%d", left,top,width,height,console->fontx, console->fonty );
//SetWindowText(hwnd,tbuf);

    if (IsIconic(hwnd))
      console->lastpos.state = WS_MINIMIZE;
    else if (IsZoomed(hwnd))
      console->lastpos.state = WS_MAXIMIZE;
    else
    {
      console->lastpos.fy = console->fonty;
      console->lastpos.fx = console->fontx;
      console->lastpos.state = 0;
      GetWindowRect(hwnd,&rect);
      console->lastpos.top = rect.top;
      console->lastpos.left = rect.left;
    }

    return TRUE;
  }
  return FALSE;
}    

/* ---------------------------------------------------- */

int __win16AdjustCaret(HWND hwnd, W16CONP console, int destroy_first )
{
  //if (hwnd == GetFocus())
  {
    if (destroy_first)
      DestroyCaret();

    if (console->smoothsizing == 0)
    {
      CreateCaret( hwnd, NULL, console->fontx, console->fonty / 6);
      SetCaretPos( console->indentx + console->curcol * console->fontx,
        console->indenty + (console->currow + 1) * console->fonty -(console->fonty / 6) );
      ShowCaret( hwnd );
    }
    else
    {
      RECT clirect;
      GetClientRect( hwnd, &clirect );
    
      int col = ( ((unsigned long)(clirect.right-clirect.left)) *
          ((unsigned long)(console->curcol)) ) / console->dispcols;
      int row = ( ((unsigned long)(clirect.bottom-clirect.top)) *
          ((unsigned long)(console->currow)) ) / console->disprows;
      int cwidth = (clirect.right-clirect.left) / console->dispcols;
      int cheight = (clirect.bottom-clirect.top) / console->disprows;
    
      CreateCaret( hwnd, NULL, cwidth, cheight / 6);
      SetCaretPos( col, row+(cheight-cheight/6) );
      ShowCaret( hwnd );
    }
  }
  return 0;
}

/* ---------------------------------------------------- */

BOOL CALLBACK __w16AboutBox( HWND dialog, UINT msg, WORD wParam, LONG lParam )
{
  lParam = lParam;
                                           
  if (msg == WM_INITDIALOG)
  {
    HWND hwnd;
    if ((hwnd = GetDlgItem( dialog, 202 )) != NULL)
    {
      SetWindowText( hwnd, "This client is maintained by "
      #if defined(_M_ALPHA)
      "Mike Marcelais <michmarc@microsoft.com>"
      #else
      "Cyrus Patel <cyp@fb14.uni-mainz.de>"
      #endif
      );
    }
    if ((hwnd = GetDlgItem( dialog, 201 )) != NULL)
    {
      #if 0
      char verbuf[132];
      struct timeval tv; 
      tv.tv_usec = 0; 
      tv.tv_sec = CliGetNewestModuleTime();
      sprintf(verbuf,"Version "CLIENT_VERSIONSTRING "-C"
                       #ifdef CLIENT_SUPPORTS_SMP
                       "T" /* threads */
                       #else
                       "P" /* polling */
                       #endif
                       #if (defined(BETA) || defined(BETA_PERIOD))
                       "L" /* limited release */
                       #else
                       "R" /* public release */
                       #endif
                       "-%s " /* date is in bugzilla format yymmddhh */ 
                       , CliGetTimeString(&tv,4) );
      #endif
      SetWindowText( hwnd, CliGetFullVersionDescriptor() );
    }
    return( TRUE );
  }
  else if (msg == WM_CLOSE || (msg == WM_COMMAND && LOWORD(wParam)==IDOK))
  {
    EndDialog( dialog, TRUE );
    return( TRUE );
  }
  return( FALSE );
}

/* ---------------------------------------------------- */

static void __save_conp( W16CONP console )
{
  if (console)
  {
    const char *sect = "client";
    WriteDCTIProfileInt(sect, "fx", console->lastpos.fx );
    WriteDCTIProfileInt(sect, "fy", console->lastpos.fy );
    WriteDCTIProfileInt(sect, "wtop", console->lastpos.top );
    WriteDCTIProfileInt(sect, "wleft", console->lastpos.left );
    WriteDCTIProfileInt(sect, "state", console->lastpos.state );
  }
  return;
}

/* ---------------------------------------------------- */

static void __clear_marked(W16CONP console)    
{
  if (console)
  {
    memset(&(console->marked_buff[0]),0,sizeof(console->marked_buff));
    console->mark_lastrow=console->mark_down=console->have_marked = 0;
  }
  return;
}

/* ---------------------------------------------------- */

static int __w16WindowHandle_DNETC_WCMD(HWND hwnd, UINT message, 
                        WPARAM wParam, LPARAM lParam, LRESULT *lResultP )
{
  int handled = 0;
  hwnd = hwnd; lParam = lParam; // shaddup compiler 

  if (message == WM_COMMAND)
  {
    if (wParam == DNETC_WCMD_SHUTDOWN) // 1
    {
      RaiseExitRequestTrigger();
      CheckExitRequestTrigger();
      handled = 1;
    }
    else if (wParam == DNETC_WCMD_RESTART) // 2
    {
      RaiseRestartRequestTrigger();
      CheckExitRequestTrigger();
      handled = 1;
    }
    else if (wParam == DNETC_WCMD_PAUSE) //3
    {
      RaisePauseRequestTrigger();
      CheckPauseRequestTrigger();
      handled = 1;
    }
    else if (wParam == DNETC_WCMD_UNPAUSE) //13
    {
      ClearPauseRequestTrigger();
      CheckPauseRequestTrigger();
      handled = 1;
    }
  }
  if (handled && lResultP)
    *lResultP = DNETC_WCMD_ACKMAGIC;
  return handled;
}

/* ---------------------------------------------------- */

LRESULT CALLBACK __w16WindowFunc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) 
{
  W16CONP console = __win16GetHwndConsole( hwnd );

  //__w16writelog( "msg: 0x%04x, wParam: 0x%04x, lParam: 0x%08x", message, wParam, lParam );
  
  if (console)
  {
    if (console->ssmessage && console->ssmessage == message)
    {
      message = WM_COMMAND;
      if (wParam == DNETC_WCMD_SHUTDOWN)
        console->ssmessage = 0;
    }
    else if (console->dnetc_cmdmsg && console->dnetc_cmdmsg == message)
      message = WM_COMMAND;
  }
    
  switch (message)
  {
    case WM_LBUTTONUP:
    {
      if (console)
      {
        console->mark_down = 0;
        break;
      }
      return DefWindowProc(hwnd, message, wParam, lParam);
    }
    case WM_MOUSEMOVE:
    {
      if (console)
      {
        if ((wParam & MK_LBUTTON)!=0 && console->mark_down) 
        {
          wParam |= MK_SHIFT; /* additive click */
          message = WM_LBUTTONDOWN; /* fallthrough */
        }
      }
      if (message != WM_LBUTTONDOWN)
        return DefWindowProc(hwnd, message, wParam, lParam);
    }
    case WM_LBUTTONDOWN:
    {
      if (console)
      {
        int i, row = 0;
        while (row <= console->disprows)
        {
          if (HIWORD(lParam) >= (row * console->fonty) && 
              HIWORD(lParam) <  ((row+1) * console->fonty)) 
            break;
          row++;
        }
        if (row < 0 || row >= W16CONS_HEIGHT)
          ; /* nothing */
        else if (!console->have_marked)
        {
          for (i=0;i<W16CONS_HEIGHT;i++)
            console->marked_buff[i] = 0;
          console->marked_buff[row] = 1;
          console->have_marked = 1;
          console->mark_lastrow = row;
          console->mark_down = 1;
        }
        else if ((wParam & MK_SHIFT)!=0)
        {
          for (i=0;i<W16CONS_HEIGHT;i++)
            console->marked_buff[i] = 0;
          console->marked_buff[row] = 1;
          if (console->mark_lastrow < 0 ||
              console->mark_lastrow >= W16CONS_HEIGHT)
            console->mark_lastrow = row;
          else
          {
            i = ((row > console->mark_lastrow) ? -1 : +1 );
            for (;row != console->mark_lastrow;row+=i)
              console->marked_buff[row] = 1;
            console->marked_buff[console->mark_lastrow] = 1;
          }
          console->mark_down = 1;
          console->have_marked = 1;
        }
        else if ((wParam & MK_CONTROL)!=0)
        {
          if (console->marked_buff[row])
          {
            console->marked_buff[row] = 0;
            console->have_marked = 0;
            console->mark_lastrow = -1; /* invalid */
            for (i=0;i<W16CONS_HEIGHT;i++)
            {
              if (console->marked_buff[i])
              {
                console->have_marked = 1;
                break;
              }
            }
            if (!console->have_marked)
            {
              console->mark_lastrow = row;
              console->mark_down = 1;
              console->have_marked = 1;
            }
          }
          else
          {
            console->marked_buff[row] = 1;
            console->mark_lastrow = row;
            console->mark_down = 1;
            console->have_marked = 1;
          }
        }
        else
        {
          for (i=0;i<W16CONS_HEIGHT;i++)
            console->marked_buff[i] = 0;
          console->marked_buff[row] = 1;
          console->mark_lastrow = row;
          console->mark_down = 1;
          console->have_marked = 1;
        }
        InvalidateRect(hwnd, NULL, TRUE);
        break;
      }
      return DefWindowProc(hwnd, message, wParam, lParam);
    }
    case WM_NCCREATE:
    {
      if ( DefWindowProc(hwnd, message, wParam, lParam) != 0)
      {
        constatics.createflag = 0;
        constatics.errorcode = W16CONS_ERR_NCCREATE;
        return -1;
      }
      return 0;
    }
    case WM_SYSCOMMAND:
    {
      if (wParam == 0x1000)
      {
        #ifndef GWL_HINSTANCE
        #define GWL_HINSTANCE (-6)
        #endif
        HINSTANCE hinst = (HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE);
        if ( hinst )
        {
          FARPROC func = MakeProcInstance( (FARPROC)__w16AboutBox, hinst);
          DialogBox( hinst, MAKEINTRESOURCE(1), hwnd, (DLGPROC)func );
          (void)FreeProcInstance( func );
        }
        return 0;
      }
      return DefWindowProc(hwnd, message, wParam, lParam);
    }
    case WM_CREATE:
    {
      #ifndef GWL_HINSTANCE
      #define GWL_HINSTANCE (-6)
      #endif
      HINSTANCE hinst = (HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE);
      if (FindResource( hinst, MAKEINTRESOURCE(1), RT_DIALOG ))
      {
        HMENU hmenu = GetSystemMenu( hwnd, 0);
        if (hmenu)
        {
          AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
          AppendMenu(hmenu, MF_ENABLED, 0x1000, "About..." );
        }
      }
      console = (W16ConsoleStruc *)malloc(sizeof(W16ConsoleStruc));
      if (console)
      {
        // initialize our private structure
        memset((void *)console, 0, sizeof(W16ConsoleStruc));
        memset((void *)(&(console->buff[0][0])),' ',sizeof(console->buff));

        console->hwnd = hwnd;
        console->disprows = W16CONS_HEIGHT;
        console->dispcols = W16CONS_WIDTH;
        console->smoothsizing = 0;
        console->ssmessage = GlobalFindAtom( W32CLI_SSATOM_NAME );
        console->dnetc_cmdmsg = RegisterWindowMessage(W32CLI_CONSOLE_NAME);

        console->fontx = (int)GetSystemMetrics(SM_CXSCREEN);
        if (console->fontx < 700) /* 640x480 */ 
        { console->fontx =  7; console->fonty = 11; }
        else if (console->fontx < 900) /* 800x600 */  
        { console->fontx =  7; console->fonty = 13; }
        else                                 
        { console->fontx =  9; console->fonty = 15; }
        
        #ifdef W16CONS_SMOOTHSIZING
        {
          #if defined(SPI_GETFONTSMOOTHING)
          {
            UINT oldval = 0;
            if (!SystemParametersInfo(SPI_GETFONTSMOOTHING,0,&oldval,0))
              oldval = 0;
            if (oldval)
              console->smoothsizing = 1;
          }
          #endif
          if (console->smoothsizing && (winGetVersion()%2000) < 400)
            console->smoothsizing = 0;
        }
        #endif

        __w16AdjustRect( console, hwnd, WM_CREATE, 0, 0 );
        #if (CLIENT_OS == OS_WIN32)
         //__w16writelog( "psni: WM_CREATE\n");
         __DoTrayStuff(console, hwnd, +1 );
        #endif

        if (console->hfont == NULL)
        {
          free((void *)console);
          constatics.createflag = 0;
          constatics.errorcode = W16CONS_ERR_NOFONT;
          return -1;
        }

        __win16SetHwndConsole( hwnd, console );

        constatics.createflag = 1;
        #if (CLIENT_OS == OS_WIN32)
        PostMessage(hwnd,WM_USER_SHELLNOTIFYICON,1,WM_USER_SHELLNOTIFYICON);
        #endif
        break;
      }
      else
      {
        constatics.createflag = 0;
        constatics.errorcode = W16CONS_ERR_NOMEM;
        // fail to create
        return -1;
      }
    }
    case WM_CLOSE:
    {
      __save_conp(console);
      RaiseExitRequestTrigger();
      return DNETC_WCMD_ACKMAGIC; /* all win cares about is non-zero */
    }
    case WM_QUERYENDSESSION:
    {
      return TRUE; /* yes, we can terminate */
    }
    case WM_ENDSESSION:
    {
       __save_conp(console);
      if (wParam) /* yes, we are terminating */
      {
        /* for the record: 
           a) win95 (only) has a borked service shutdown 
           sequence that permits other threads belonging to the process
           to continue running even when the window thread has died. This 
           often causes a segfault because thread data has disappeared too.
           b) All win32: When *not* running as a service all threads *except* 
           the window thread are suspended once shutdown is in progress. 
           Waiting on a child will thus result in a 'hang' (win will kill
           the process after 10 seconds or so).
         */
        #if (CLIENT_OS == OS_WIN32)
        if (win32CliServiceRunning())
        {
          if (((lParam & ENDSESSION_LOGOFF)!=0)) 
            return 1;  /* if we are running as a service. don't exit */
          else if (constatics.client_run_startstop_level > 0)
          {
            RaiseExitRequestTrigger();
            while (constatics.client_run_startstop_level > 0)
              Sleep(100);
          }
        }
        else
        #endif
        __w16ClientHardStop();
      }
      break;
    }
    case WM_DESTROY:
    {
      __save_conp(console);
      #if (CLIENT_OS == OS_WIN32)
        //__w16writelog( "psni: WM_DESTROY\n");
        __DoTrayStuff(console, hwnd, -1 );
      #endif
      if (console)
      {
        if (console->hfont && !console->fontisstock)
          DeleteObject(console->hfont);
        free((void *)console);
      }
      __win16SetHwndConsole( hwnd, NULL );
      PostQuitMessage(0);
      return DefWindowProc(hwnd,message, wParam,lParam);
    }
    case WM_ERASEBKGND:
      return 0; /* do it in WM_PAINT (sets ps.fErase)  */
    case WM_PAINT:
#if 0 /* testing */
    {
      RECT clirect;
      if (GetUpdateRect(hwnd, &clirect, 1)!= 0) /* something needs updating */
      {
        int done_paint=0;
        #if (CLIENT_OS == OS_WIN32)
          //__w16writelog( "psni: WM_PAINT\n");
          __DoTrayStuff(console, hwnd, +1 );
        #endif
        if (console)
          __w16AdjustRect( console, hwnd, WM_PAINT, 0, 0);
        if (console && console->hfont)
        {
          PAINTSTRUCT ps;
          HDC paintdc = BeginPaint(hwnd, &ps);
          if (paintdc)
          {
            COLORREF oldTClr = SetTextColor(paintdc, W16CONS_FORECOLOR );
            COLORREF oldBClr = SetBkColor(paintdc, W16CONS_BACKCOLOR );

            GetClientRect(hwnd, &clirect);
        
            HFONT oldFont = (HFONT)SelectObject(paintdc, console->hfont);
            RECT workrect;
            SIZE size;
            GetTextExtentPoint(paintdc, "X", 1, &size);
            console->fontx = size.cx;
            console->fonty = size.cy;
            workrect.top = workrect.left = 0;
            workrect.right = console->fontx * console->dispcols;
            workrect.bottom = console->fonty * console->disprows;
            SelectObject(paintdc, oldFont);

            HDC hdc = NULL;
            HBITMAP newbmp = NULL;
            HBITMAP oldbmp = NULL;
            
            if (console->smoothsizing != 0)
            {
              hdc = CreateCompatibleDC( paintdc );
              if (hdc)
              {
                SetTextColor(hdc, W16CONS_FORECOLOR );
                SetBkColor(hdc, W16CONS_BACKCOLOR );

                newbmp = CreateCompatibleBitmap( hdc, 
                         workrect.right, workrect.bottom );
                if (newbmp)
                {
                  oldbmp = (HBITMAP)SelectObject(hdc, newbmp );
                  /*
                  HBRUSH hbrush = CreateSolidBrush( RGB(0,0,0) );
                  if (hbrush)
                  {
                    UnrealizeObject(hbrush);
                    HBRUSH hbrOld = (HBRUSH)SelectObject(hdc, hbrush);
                    Rectangle(hdc, workrect.left, workrect.top,
                                   workrect.right, workrect.bottom);
                    DeleteObject(SelectObject(hdc,hbrOld));
                  }
                  */
                }
                else
                {
                  DeleteDC( hdc );
                  hdc = NULL;
                }
              }
            }
            if (hdc == NULL)
              hdc = paintdc;


            int offsetrow = GetScrollPos(hwnd, SB_VERT);
            int offsetcol = GetScrollPos(hwnd, SB_HORZ);
            int row;
 
            oldFont = (HFONT)SelectObject(hdc, console->hfont);
            for (row = 0; row < console->disprows; row++)
            {
              TextOut(hdc, console->indentx,
                             console->indenty + row * console->fonty,
                             &console->buff[offsetrow + row][offsetcol],
                             console->dispcols);
            }
            SelectObject(hdc, oldFont);


            if (newbmp == NULL) /* paintdc == hdc */
            {
              HPEN hpen = CreatePen(PS_SOLID, 1, GetBkColor(hdc) );
              if (hpen)
              {
                HPEN oldpen = (HPEN)SelectObject( hdc, hpen );
                MoveTo( hdc, workrect.left, workrect.bottom );
                LineTo( hdc, workrect.right, workrect.bottom );
                SelectObject( hdc, oldpen );
                DeleteObject( hpen );
              }
            }
            else
            {
              if (clirect.right == workrect.right && 
                  clirect.bottom == workrect.bottom)
              {
                BitBlt(paintdc, 0, 0, clirect.right, clirect.bottom, 
                                              hdc, 0, 0, SRCCOPY);
              }
              else
              {
                int oldbltmode = STRETCH_ORSCANS;
                #if 0 //defined(STRETCH_HALFTONE)
                oldbltmode = STRETCH_HALFTONE;
                #endif
                oldbltmode = SetStretchBltMode( paintdc, oldbltmode );
                #if 0 //defined(STRETCH_HALFTONE)
                SetBrushOrgEx(paintdc, 0, 0,NULL);
                #endif
                StretchBlt( paintdc, 0, 0, clirect.right, clirect.bottom, 
                      hdc, 0, 0, workrect.right, workrect.bottom, SRCCOPY);
                SetStretchBltMode( paintdc, oldbltmode );
              }
              SelectObject( hdc, oldbmp );
              DeleteObject( newbmp );
              DeleteDC( hdc );
            }

            SetBkColor  ( paintdc, oldBClr );
            SetTextColor( paintdc, oldTClr );

            EndPaint(hwnd, &ps);
            done_paint = 1;
          }
          if (hwnd == GetFocus())
            __win16AdjustCaret(hwnd, console, 1);
        } /* if (console && console->hfont) */
        if (!done_paint) /* don't send more paint msgs if paint fails */
          ValidateRect(hwnd, NULL); 
      }
      break;
    }
#else
    {
      RECT clirect;
      if (GetUpdateRect(hwnd, &clirect, 1)!= 0) /* something needs updating */
      {
        int done_paint=0;
        #if (CLIENT_OS == OS_WIN32)
          //__w16writelog( "psni: WM_PAINT\n");
          __DoTrayStuff(console, hwnd, +1 );
        #endif
        if (console)
          __w16AdjustRect( console, hwnd, WM_PAINT, 0, 0);
        if (console && console->hfont)
        {
          PAINTSTRUCT ps;
          HDC paintdc = BeginPaint(hwnd, &ps);
          if (paintdc)
          {
            HDC hdc = paintdc;
            if (console->smoothsizing)
              hdc = CreateCompatibleDC( paintdc );
            if (hdc)
            {
              HFONT oldFont = (HFONT)SelectObject(hdc, console->hfont);
  
              RECT workrect;
              GetClientRect(hwnd, &clirect);
        
              SIZE size;
              GetTextExtentPoint(hdc, "X", 1, &size);
              console->fontx = size.cx;
              console->fonty = size.cy;
              workrect.top = workrect.left = 0;
              workrect.right = console->fontx * console->dispcols;
              workrect.bottom = console->fonty * console->disprows;
              if (console->smoothsizing == 0)
                workrect.bottom--;
 
              HBITMAP newbmp = NULL;
              
              if (console->smoothsizing)
                newbmp = CreateCompatibleBitmap( hdc, 
                         workrect.right, workrect.bottom );
              if (console->smoothsizing == 0 || newbmp)
              {
                HBITMAP oldbmp = NULL;
                if (console->smoothsizing)
                  oldbmp = (HBITMAP)SelectObject( hdc, newbmp );
 
                COLORREF oldTClr = SetTextColor(hdc, W16CONS_FORECOLOR );
                COLORREF oldBClr = SetBkColor(hdc, W16CONS_BACKCOLOR );
                int inv_color = 0;
                int offsetrow = GetScrollPos(hwnd, SB_VERT);
                int offsetcol = GetScrollPos(hwnd, SB_HORZ);
                int row;
                for (row = 0; row < console->disprows; row++)
                {
                  if (console->marked_buff[row])
                  {
                    if (!inv_color)
                    {
                      SetBkColor(hdc, W16CONS_FORECOLOR );
                      SetTextColor(hdc, W16CONS_BACKCOLOR );
                      inv_color = 1;
                    }
                  }
                  else if (inv_color)
                  {
                    SetTextColor(hdc, W16CONS_FORECOLOR );
                    SetBkColor(hdc, W16CONS_BACKCOLOR );
                    inv_color = 0;
                  }
                  TextOut(hdc, console->indentx,
                             console->indenty + row * console->fonty,
                             &console->buff[offsetrow + row][offsetcol],
                             console->dispcols);
                }

                if (console->smoothsizing == 0)
                {
                  HPEN hpen = CreatePen(PS_SOLID, 1, GetBkColor(hdc) );
                  if (hpen)
                  {
                    HPEN oldpen = (HPEN)SelectObject( hdc, hpen );
                    MoveToEx( hdc, workrect.left, workrect.bottom-1, NULL);
                    LineTo( hdc, workrect.right, workrect.bottom-1 );
                    SelectObject( hdc, oldpen );
                    DeleteObject( hpen );
                  }
                }

                SetBkColor  ( hdc, oldBClr );
                SetTextColor( hdc, oldTClr );

                if (console->smoothsizing)
                {
                  oldTClr = SetTextColor(paintdc, W16CONS_FORECOLOR);
                  oldBClr = SetBkColor(paintdc, W16CONS_BACKCOLOR);
                  if (clirect.right == workrect.right && 
                      clirect.bottom == workrect.bottom)
                  {
                    BitBlt(paintdc, 0, 0, clirect.right, clirect.bottom, 
                                                hdc, 0, 0, SRCCOPY);
                  }
                  else
                  {
                    int oldbltmode = STRETCH_ORSCANS;
                    #if 0 //defined(STRETCH_HALFTONE)
                    oldbltmode = STRETCH_HALFTONE;
                    #endif
                    oldbltmode = SetStretchBltMode( paintdc, oldbltmode );
                    #if 0 //defined(STRETCH_HALFTONE)
                    SetBrushOrgEx(paintdc, 0, 0,NULL);
                    #endif
                    StretchBlt( paintdc, 0, 0, clirect.right, clirect.bottom, 
                             hdc, 0, 0, workrect.right, workrect.bottom, SRCCOPY );
                    SetStretchBltMode( paintdc, oldbltmode );
                  }
                  SetBkColor  ( paintdc, oldBClr );
                  SetTextColor( paintdc, oldTClr );
 
                  SelectObject( hdc, oldbmp );
                  DeleteObject( newbmp );
                }
                done_paint = 1;
              }
              SelectObject( hdc, oldFont );
              if (console->smoothsizing)
                DeleteDC( hdc );
            }
            EndPaint(hwnd, &ps);
          }
          if (hwnd == GetFocus())
            __win16AdjustCaret(hwnd, console, 1);
        } /* if (console && console->hfont) */
        if (!done_paint) /* don't send more paint msgs if paint fails */
          ValidateRect(hwnd, NULL); 
      }
      break;
    }
#endif
    case WM_GETMINMAXINFO:
    {
      MINMAXINFO FAR * lpmmi = (MINMAXINFO FAR *) lParam;
      #if defined(__WINDOWS_386__) /* convert 16:16 pointer to 16:32 */
         lpmmi = (MINMAXINFO FAR *)MK_FP32( (void *)lpmmi ); 
      #endif

#if 0
      if (console && console->smoothsizing == 0)
      {
        lpmmi->ptMaxSize.x = 
        lpmmi->ptMaxTrackSize.x = 
        lpmmi->ptMinTrackSize.x = (W16CONS_WIDTH * console->fontx +
                                  2 * GetSystemMetrics(SM_CXFRAME));
        lpmmi->ptMaxSize.y = 
        lpmmi->ptMaxTrackSize.y = 
        lpmmi->ptMinTrackSize.y = (W16CONS_HEIGHT * console->fonty +
                                  2 * GetSystemMetrics(SM_CYFRAME) + 
                                  GetSystemMetrics(SM_CYCAPTION));
      }
      else
#endif
      {
        lpmmi->ptMinTrackSize.x = (W16CONS_WIDTH * 2 +
                                  2 * GetSystemMetrics(SM_CXFRAME));
        lpmmi->ptMinTrackSize.y = (W16CONS_HEIGHT * 4 +
                                  2 * GetSystemMetrics(SM_CYFRAME) + 
                                  GetSystemMetrics(SM_CYCAPTION));

        lpmmi->ptMaxTrackSize.x = (W16CONS_WIDTH * 12 +
                                  2 * GetSystemMetrics(SM_CXFRAME));
        if (lpmmi->ptMaxTrackSize.x > lpmmi->ptMaxSize.x)
          lpmmi->ptMaxTrackSize.x = lpmmi->ptMaxSize.x;
        else
          lpmmi->ptMaxSize.x = lpmmi->ptMaxTrackSize.x;
                          
        lpmmi->ptMaxTrackSize.y = (W16CONS_HEIGHT * 29 +
                                  2 * GetSystemMetrics(SM_CYFRAME) + 
                                  GetSystemMetrics(SM_CYCAPTION));
        if (lpmmi->ptMaxTrackSize.y > lpmmi->ptMaxSize.y)
          lpmmi->ptMaxTrackSize.y = lpmmi->ptMaxSize.y;
        else
          lpmmi->ptMaxSize.y = lpmmi->ptMaxTrackSize.y;

      }
      break;
    }
    //case WM_WINDOWPOSCHANGED:
    case WM_WINDOWPOSCHANGING:
    {
      WINDOWPOS FAR *pwp = (WINDOWPOS FAR *)lParam;
      #if defined(__WINDOWS_386__) /* convert 16:16 pointer to 16:32 */
        pwp = (WINDOWPOS FAR *)(MK_FP32((void *)pwp));
      #endif
      if (constatics.hidden && (pwp->flags & SWP_SHOWWINDOW)!=0) 
      { 
        if (message == WM_WINDOWPOSCHANGING)
        {
          pwp->flags ^= SWP_SHOWWINDOW; 
          pwp->flags |= SWP_HIDEWINDOW; 
        }
        else
          ShowWindow(hwnd, SW_HIDE);
        return 0;
      }
      return DefWindowProc(hwnd, message, wParam, lParam);
    }
    #if defined(WM_SIZING) && !defined(__WINDOWS_386__) //can't pass 48bit val
    case WM_SIZING:          
    #endif
    case WM_SIZE:
    {
      #if (CLIENT_OS == OS_WIN32)
        //__w16writelog( "psni: WM_SIZE\n");
        __DoTrayStuff(console, hwnd, +1 );
      #endif
      if (message == WM_SIZE && wParam == SIZE_MINIMIZED)
        return DefWindowProc(hwnd, message, wParam, lParam);
      if (console)
      {
        #if defined(WM_SIZING) && defined(__WINDOWS_386__)
        if (message == WM_SIZING)
          lParam = (LPARAM)(MK_FP32((void *)lParam));
        #endif
        return __w16AdjustRect( console, hwnd, message, wParam, lParam);
      }
      break;
    }
    case WM_USER_SHELLNOTIFYICON:
    {
      if (lParam == WM_RBUTTONUP)
      {
        SendMessage(hwnd,WM_RBUTTONUP,0,((LPARAM)0xfedccdefL));
      }
      else if (lParam == WM_LBUTTONDBLCLK)
      {
        PostMessage(hwnd,WM_COMMAND,WMCMD_LAGGYRESTORE,0);
      }                                             //absorb "extra-" click
      else if (lParam == WM_USER_SHELLNOTIFYICON)
      {
        #if (CLIENT_OS == OS_WIN32)
        //__w16writelog( "psni: WM_USER_SHELLNOTIFYICON\n");
        __DoTrayStuff(console, hwnd, +1 /* wParam */ );
        #endif
      }
      break;
    }
    case WM_RBUTTONUP:
    {
      if (!CheckExitRequestTriggerNoIO())
      {
        HMENU hmenu = CreatePopupMenu();
        if (hmenu)
        {
          int modebits = ModeReqIsSet(-1); /* get all */
          int addrestore = 0; /* add "Restore" item */
          HMENU hbench = NULL;
          POINT ptPos; 
          int exiting = CheckExitRequestTrigger();
          int intray = 0;

          ptPos.x = LOWORD(lParam); ptPos.y = HIWORD(lParam);
          if ((lParam==((LPARAM)0xffffffffL)) || (lParam==(LPARAM)0XfedccdefL))
          {
            intray = ((lParam == (LPARAM)0XfedccdefL));
            GetCursorPos(&ptPos);
          }
          else
          {
            ClientToScreen(hwnd, &ptPos);
          }

          if ((modebits & MODEREQ_CONFIG)!=0)
          {
            if (intray)
              addrestore = 1;
            else
            {
              AppendMenu(hmenu, (IsClipboardFormatAvailable(CF_TEXT)?MF_ENABLED:MF_GRAYED),
                                WMCMD_PASTE, "Paste");
              AppendMenu(hmenu, ((console && console->have_marked)?(MF_ENABLED):(MF_GRAYED)),
                                WMCMD_COPY, "Copy" );
            }                                
          }
          else
          {
            int ispaused;
            char oplabel[128];
            const char *oplabelp;
            
            AppendMenu(hmenu, ((console && console->have_marked)?(MF_ENABLED):(MF_GRAYED)),
                              WMCMD_COPY, "Copy" );
            AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
            AppendMenu(hmenu, ((exiting || modebits & (MODEREQ_FLUSH|MODEREQ_CONFIG))?(MF_GRAYED):(MF_ENABLED)),
                              WMCMD_FLUSH, "F&lush Work" );
            AppendMenu(hmenu, ((exiting || modebits & (MODEREQ_FETCH|MODEREQ_CONFIG))?(MF_GRAYED):(MF_ENABLED)),
                              WMCMD_FETCH, "F&etch Work" );
            AppendMenu(hmenu, ((exiting || modebits & (MODEREQ_FETCH|MODEREQ_FLUSH|MODEREQ_CONFIG))?(MF_GRAYED):(MF_ENABLED)),
                              WMCMD_UPDATE, "&Update Buffers (Fetch and Flush)" );
            AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
            AppendMenu(hmenu, ((exiting || intray || (modebits & (MODEREQ_CONFIG)))?(MF_GRAYED):(MF_ENABLED)),
                              WMCMD_CONFIG, "Con&figure" );
            if (!exiting && !intray && (modebits & (MODEREQ_CONFIG|MODEREQ_BENCHMARK)) == 0)
              hbench = CreatePopupMenu();
            if (hbench)
            {
              unsigned int contest;
              int mpos = WMCMD_BENCHMARK;
              AppendMenu(hbench, MF_ENABLED, mpos++, "All long" );
              AppendMenu(hbench, MF_ENABLED, mpos++, "All short" );
              for (contest = 0;contest < CONTEST_COUNT; contest++)
              {
                int ok2bench = (IsProblemLoadPermitted(-1,contest)?(MF_ENABLED):(MF_GRAYED));
                oplabelp = CliGetContestNameFromID(contest);
                sprintf(oplabel,"%s long", oplabelp );
                AppendMenu(hbench, ok2bench, mpos++, oplabel );
                sprintf(oplabel,"%s short", oplabelp );
                AppendMenu(hbench, ok2bench, mpos++, oplabel );
              }
            }
            AppendMenu(hmenu, ((intray || !hbench)?(MF_GRAYED):(MF_POPUP)), 
                                  (UINT)hbench, "&Benchmark" );
            AppendMenu(hmenu, MF_SEPARATOR, 0, "" );

            ispaused = CheckPauseRequestTriggerNoIO();
            oplabelp = ((ispaused)?("Contin&ue"):("&Pause"));
            if (!exiting && modebits)
            {
              sprintf(oplabel,"%s (may be delayed)", oplabelp);
              oplabelp = (const char *)&oplabel[0];
            }
            AppendMenu(hmenu, ((exiting)?(MF_GRAYED):(MF_ENABLED)), 
              ((ispaused)?(DNETC_WCMD_UNPAUSE):(DNETC_WCMD_PAUSE)), oplabelp );
            AppendMenu(hmenu, MF_ENABLED, DNETC_WCMD_RESTART, "&Restart");

            #if 0 //(CLIENT_OS == OS_WIN32)
            if (win32CliIsServiceInstalled()==0) /* <0=err,0==no,>0=yes */
            {
              char buff[64];
              long ver = winGetVersion();
              sprintf(buff, "&Install as %s service", ((ver < 2000) ? "Win9x" : "WinNT"));
              AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
              AppendMenu(hmenu, ((modebits)?(MF_GRAYED):(MF_ENABLED)), 
                               WMCMD_SVCINSTALL, buff );
              AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
            }
            #endif
            AppendMenu(hmenu, ((exiting)?(MF_GRAYED):(MF_ENABLED)), 
                         DNETC_WCMD_SHUTDOWN, 
                         ((exiting)?("Shutdown (is pending)"):("Shutdown")));
            if (intray && !exiting)
            {
              AppendMenu(hmenu, MF_SEPARATOR, 0, "" );
              addrestore = 1;
            }
          }
          if (addrestore && !exiting)
            AppendMenu(hmenu, MF_ENABLED, WMCMD_RESTORE, "Restore");
          SetForegroundWindow(hwnd);  //needed for tray popup
          TrackPopupMenu(hmenu, TPM_LEFTALIGN, ptPos.x, ptPos.y, 0, hwnd, NULL);
          PostMessage(hwnd, WM_NULL, 0, 0);
          if (hbench)
            DestroyMenu(hbench);
          DestroyMenu(hmenu);
        }
      }
      break;
    }
    case WM_COMMAND:
    {
      LRESULT lResult;
      if (__w16WindowHandle_DNETC_WCMD(hwnd,message,wParam,lParam,&lResult))
        return lResult;

      if (wParam == WMCMD_LAGGYRESTORE) /* called from tray */
      {
        #if (CLIENT_OS == OS_WIN32)
        Sleep(300); //absorb "extra-" click
        POINT ptPos; 
        ShowWindow(hwnd,SW_RESTORE);
        SetForegroundWindow(hwnd);
        SetFocus(hwnd);
        GetCursorPos(&ptPos);
        PostMessage( hwnd, WM_SYSCOMMAND, SC_RESTORE, 
             ((LONG)(((WORD)(ptPos.x))|((DWORD)((WORD)(ptPos.y)))<<16)) ); 
        #endif
      }
      else if (wParam == WMCMD_RESTORE)
        ShowWindow(hwnd,SW_RESTORE);
      else if (wParam == WMCMD_PASTE)
        SendMessage( hwnd, WM_CHAR, 22 /* ^V */, 0);
      else if (wParam == WMCMD_COPY)
        SendMessage( hwnd, WM_CHAR, 24 /* ^X */, 0);
      else if (wParam == WMCMD_CONFIG)
      {
        __clear_marked(console);    
        ModeReqSet(MODEREQ_CONFIG | MODEREQ_CONFRESTART);
      }
      else if (wParam == WMCMD_SVCINSTALL)
      {
        __clear_marked(console);    
        #if (CLIENT_OS == OS_WIN32)
        win32CliInstallService(0); // == 0) /* no err */
        {
        /*
          if (IDYES == MessageBox( NULL, 
              "The client is now installed as a service.\n",
               "Would you now like to restart the client to let it run as a service?",
               "distributed.net RC5DES client", MB_YESNO|MB_TASKMODAL ) )
          {
            //what we need to do is start a new process AFTER shutting down
            //the main thread but BEFORE we (the winproc) die. very hairy.
          }     
        */
        }
        #endif
      }
      else if (wParam == WMCMD_FETCH)
      {
        __clear_marked(console);    
        ModeReqSet(MODEREQ_FETCH);
      }
      else if (wParam == WMCMD_FLUSH)
      {
        __clear_marked(console);    
        ModeReqSet(MODEREQ_FLUSH);
      }
      else if (wParam == WMCMD_UPDATE)
      {
        __clear_marked(console);    
        ModeReqSet(MODEREQ_FETCH|MODEREQ_FLUSH);
      }
      else if (wParam >= WMCMD_BENCHMARK &&
               wParam <  (WMCMD_BENCHMARK+2+(CONTEST_COUNT*2)))
      {
        int do_mode = MODEREQ_BENCHMARK;
        if (((wParam - WMCMD_BENCHMARK) & 1) != 0)
          do_mode = MODEREQ_BENCHMARK_QUICK;
        __clear_marked(console);    
        ModeReqSet(do_mode);
        if (wParam >= (WMCMD_BENCHMARK+2))
          ModeReqLimitProject(do_mode, (wParam-(WMCMD_BENCHMARK+2))>>1);
      }
      break;
    }
    case WM_KEYUP:
    {
      if ( console && ((int)(wParam)) == VK_INSERT && 
         ( GetKeyState(VK_SHIFT) & 0x8000 ) !=0 )  //shift-insert
      {
        wParam = 22; //^V
        message = WM_CHAR;
        //fall through!
      }
      else if ( console && ((int)(wParam)) == VK_F1 && ModeReqIsSet(-1)==0 )
      {
        POINT ptPos; RECT rc; 
        GetCursorPos(&ptPos);
        GetWindowRect(hwnd, &rc);
        if ((ptPos.x < rc.left) || (ptPos.x > rc.right) ||
            (ptPos.y < rc.top) || (ptPos.y > rc.bottom)) /*mouse is outside*/
        {
          GetClientRect(hwnd, &rc);
          ptPos.y = rc.top + (rand()%(rc.bottom-rc.top));
          ptPos.x = rc.left + (rand()%(rc.right-rc.left));
        }
        else
          ScreenToClient(hwnd, &ptPos);
        PostMessage(hwnd, WM_RBUTTONUP, 0, (((LPARAM)(ptPos.y))<<16)+ptPos.x);
        break;
      }
      else
      {
        return DefWindowProc(hwnd, message, wParam, lParam);
      }
    }
    case WM_CHAR:
    {
      if (console)
      {
        int kbuffsize = (int)(sizeof(console->keybuff)/sizeof(console->keybuff[0]));
        
        if (((int)(wParam)) == 0x03 /* ^C */ && console->have_marked) 
          wParam = 24; /* convert to ^X since copy accel is usually ^C */
        
        if (((int)(wParam)) == VK_PAUSE && ((lParam & KF_EXTENDED)!=0))
        {
          if (CheckPauseRequestTriggerNoIO())
            ClearPauseRequestTrigger();
          else
            RaisePauseRequestTrigger();
        }
        else if (((int)(wParam)) == ('Q'-'A')) //^Q
        {
          ClearPauseRequestTrigger();
        }
        else if (((int)(wParam)) == ('S'-'A')) //^S
        {
          RaisePauseRequestTrigger();
        }
        else if (((int)(wParam)) == 0x03) //^C
        {
          RaiseExitRequestTrigger();
        }
        else if ( ((int)(wParam)) == 22 ) //^V
        {
          if (ModeReqIsSet(MODEREQ_CONFIG))
          {
            if (IsClipboardFormatAvailable(CF_TEXT))
            {
              if (OpenClipboard(hwnd))
              {
                HGLOBAL hglb = GetClipboardData(CF_TEXT);
                if (hglb != NULL)         
                { 
                  #if defined(__WINDOWS_386__)
                  char far *lptstr = NULL;
                  void *_lptstr = (void *)GlobalLock(hglb);
                  if (_lptstr) lptstr = (char far *)(MK_FP32(_lptstr));
                  #else
                  LPTSTR lptstr = (LPTSTR)GlobalLock(hglb);
                  #endif
                  if (lptstr) 
                  {
                    int len = 0, pos = 0;
                    while (pos < kbuffsize)
                    {
                      char c = lptstr[pos++];
                      if (!c || c=='\r' || c=='\n')
                        break;
                      console->keybuff[len++] = ((int)c) & 0xff;
                    }
                    if (len)
                    {
                      __clear_marked(console);    
                      console->keycount = len;
                    }
                    GlobalUnlock(hglb);
                  }         
                } 
                CloseClipboard(); 
              }
            }
          }
        }
        else if (((int)(wParam)) == 24)   //^X
        {
          if (console->have_marked)
          {
            int pos, copylen = 0;
            char buff[W16CONS_HEIGHT*(W16CONS_WIDTH+2)];
            for (pos = 0; pos < console->disprows; pos++)
            {
              if (console->marked_buff[pos])
              {
                int linelen = W16CONS_WIDTH;
                if (copylen)
                {
                  buff[copylen++]='\r';
                  buff[copylen++]='\n';
                }
                while (linelen>0 && ((console->buff[pos][linelen-1])==0 || 
                                     (console->buff[pos][linelen-1])==' '))
                {
                  linelen--;
                }
                if (linelen)
                {
                  memcpy(&buff[copylen],&(console->buff[pos][0]),linelen);
                  copylen+=linelen;
                }
              }
              console->marked_buff[pos]=0;
            }
            console->mark_lastrow=console->mark_down=console->have_marked = 0;
            
            InvalidateRect(hwnd,NULL,TRUE);
            
            if (OpenClipboard(hwnd))
            {
              HGLOBAL hglb = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE,copylen);
              if (hglb)
              {
                #if defined(__WINDOWS_386__)
                char far *lptstr = NULL;
                void *_lptstr = (void *)GlobalLock(hglb);
                if (_lptstr) lptstr = (char far *)(MK_FP32(_lptstr));
                #else
                LPTSTR lptstr = (LPTSTR)GlobalLock(hglb);
                #endif
                if (lptstr)
                {
                  for (pos=0;pos<copylen;pos++)
                    lptstr[pos] = buff[pos];
                  GlobalUnlock(hglb);
                  EmptyClipboard();
                  SetClipboardData(CF_TEXT,hglb);
                }
              }
              CloseClipboard();
            }
          }
        }
        else if (console->keycount < kbuffsize)
        {
          console->keybuff[console->keycount++] = (int) wParam;
        }
        else
        {
          // beep, keyboard buffer full
          MessageBeep(MB_OK);
        }
      }
      break;
    }
    case WM_SETFOCUS:
    {
      if (console)
      {
        __win16AdjustCaret(console->hwnd, console, 0 );
      }
      break;
    }
    case WM_KILLFOCUS:
    {
      if (console)
        DestroyCaret();
      break;
    }
    case WM_USER_W16CONS:
    {
      if (wParam == W16CONS_CMD_ECHOLPARAM) /* identify me */
        return lParam;
      if (!console)
      {
        //__w16writelog("(WM_USER+0) 0x%04x called when no console.", (int)wParam);
        return -1;
      }
      switch (wParam)
      {
        case W16CONS_CMD_INDIRDESTROY: // we need this because we can't directly
        {                          // send a WM_DESTROY from another thread
          //SendMessage(hwnd, WM_DESTROY, 0, 0 );
          DestroyWindow(hwnd); 
          return 0;
        }
        case W16CONS_CMD_CLEARSCREEN:
        {
          memset((void *)(&(console->buff[0][0])),' ',sizeof(console->buff));
          __clear_marked(console);    
          console->currow = 0;
          console->curcol = 0;
   
          InvalidateRect(hwnd, NULL, TRUE);
          UpdateWindow(hwnd);
          break;
        }
        case W16CONS_CMD_PRINTSTR:
        {
          char ch;
          const char *text = (const char *)lParam;
          
          do{
            // check the validity of the current
            // cursor position, scrolling the window if necessary.
    
            if (console->currow < 0)
              console->currow = console->curcol = 0;
            else if (console->curcol < 0)
              console->curcol = 0;
            if (console->curcol >= W16CONS_WIDTH)
            {
              console->curcol = 0;
              console->currow++;
            }
            if (console->currow >= W16CONS_HEIGHT)
            {
              memmove( &(console->buff[0][0]), 
                      (&(console->buff[0][0])) + W16CONS_WIDTH, 
                        sizeof(console->buff) - W16CONS_WIDTH );
              memset( &(console->buff[W16CONS_HEIGHT-1][0]),' ',W16CONS_WIDTH);
              if (console->have_marked)
              {
                int row;
                if (console->mark_lastrow > 0)
                  --console->mark_lastrow;
                console->have_marked = 0;
                for (row = 0; row < (W16CONS_HEIGHT - 1); row++)
                {
                  console->marked_buff[row] = console->marked_buff[row+1];
                  if (console->marked_buff[row])
                    console->have_marked = 1;
                }
                console->marked_buff[W16CONS_HEIGHT-1]=0;
              }
              console->currow = W16CONS_HEIGHT - 1;
              console->curcol = 0;
            }
                
            //update the screen buffer
              
            ch = *text++;
            if (!ch)
              break;
            if (ch == 0x0A)         /* \n  new-line */
            { console->currow++; console->curcol = 0; }
            else if (ch == 0x0D)   /* \r    carriage return */
              console->curcol = 0;
            else if (ch == '\t')   /* \t    horizontal tab  */
              console->curcol += (console->curcol%8);
            else if (ch == '\a')   /* \a  bell (alert)      */
              MessageBeep(MB_OK);
            else if (ch == '\f')   /* \f    form-feed       */
            {
              memset((void *)(&(console->buff[0][0])),' ',sizeof(console->buff));
              console->currow = 0;
              console->curcol = 0;
            }
            else if (ch == '\b')   /* \b  backspace         */
            { if (console->curcol > 0) console->curcol--; }
            else if (ch == '\v')   /* \v  vertical tab      */
              console->currow++;
            else if (ch <= 26  )   /* don't print other ctrl-chars */
              ;
            else
            {
              console->buff[console->currow][console->curcol++] = ch;
            }
          } while (ch); /* always true */
  
          // force repaint
          InvalidateRect(hwnd, NULL, TRUE);
          UpdateWindow(hwnd);
          break;
        }
        case W16CONS_CMD_ISKBHIT:
        {
          return ((console->keycount > 0)?(1):(0));
        }
        case W16CONS_CMD_GETSIZE:
        {
          return MAKELRESULT(W16CONS_HEIGHT,W16CONS_WIDTH);
        }
        case W16CONS_CMD_GETPOS:
        {
          return MAKELRESULT(console->currow,console->curcol);
        }
        case W16CONS_CMD_SETPOS:
        {
          int row = LOWORD(lParam);
          int col = HIWORD(lParam);
    
          if (row < 0)                       
            row = 0;
          else if (row >= W16CONS_HEIGHT)    
            row = W16CONS_HEIGHT-1;
          if (col < 0)                       
            col = 0;
          else if (col >= W16CONS_WIDTH)     
            col = W16CONS_WIDTH-1;

          console->currow = row;
          console->curcol = col;
          
          if (hwnd == GetFocus())
            __win16AdjustCaret(hwnd, console, 1 );
          break;
        }
        case W16CONS_CMD_GETCH:
        {
          LRESULT keyval = -1L;
          if (console->keycount > 0)
          {
            int c = console->keybuff[0];
            keyval = (LRESULT)(c & 0xff);
            if (!keyval)
              console->keybuff[0] = (((int)(c >> 8)) & 0xff);
            else
            {  
              for (c = 1; c < console->keycount; c++)
                console->keybuff[c-1] = console->keybuff[c];
              --console->keycount;
            }  
          }
          return keyval;
        }
      } /* switch (wParam) */
    }
    default:
    {
      #if (CLIENT_OS == OS_WIN32)
      static UINT taskbarCreatedMsg = WM_USER;
      if (taskbarCreatedMsg == WM_USER)
      {
        taskbarCreatedMsg = 0;
        if ((winGetVersion()%2000)>=400)
          taskbarCreatedMsg = RegisterWindowMessage("TaskbarCreated");
      }
      if (taskbarCreatedMsg && message == taskbarCreatedMsg)
      {
        __DoTrayStuff(console, hwnd, +1 );
        return 0;
      }
      #endif
      return DefWindowProc(hwnd, message, wParam, lParam);
    }
  }
  return 0;
}

/* ------------------------------------------------ */

void w16Yield(void)
{
  MSG msg; 
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.asthread || constatics.devpipe || constatics.nativecons)
  {
    Sleep(1);
    return;
  }
  #endif
  while (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE ))  
  {
    if (!GetMessage(&msg, NULL, 0, 0))
      break;
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return;
}

/* ------------------------------------------------ */

static void w16Sleep(unsigned int millisecs)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.asthread || constatics.devpipe || constatics.nativecons)
  {
    Sleep(millisecs);
    return;
  }
  #endif
  if (millisecs > 50)
  {
    UINT hTimer = (UINT)SetTimer(NULL,0, (UINT)millisecs, NULL);
    if (hTimer)
    {
      MSG msg;
      while (GetMessage(&msg, NULL, 0, 0))
      {
        if (msg.message == WM_TIMER)
          break;
        TranslateMessage(&msg);
        DispatchMessage(&msg);
      }
      KillTimer(NULL,hTimer);
      return;
    }
  }
  {
    DWORD now = 0, last = 0;
    do
    {
      w16Yield();
      if (millisecs)
      {
        now = GetTickCount();
        if (last)
        { 
          DWORD diff = (now>=last)?(now-last):(now+(0xfffffffful-last)+1);
          if (diff >= millisecs)
            millisecs = 0;
          else
            millisecs -= diff;
        }
        last = now;
      }
      #if (CLIENT_OS == OS_WIN32)
      Sleep(50);
      #else
      Yield();
      #endif
    } while (millisecs);
  }
  return;
}

/* ------------------------------------------------ */

struct helperArg
{
  int nCmdShow;
  int nSuccess;
  int asthread;
  HWND hwnd;
  HINSTANCE hInstance;
};
  
/* ------------------------------------------------ */

static void __win16WinCreateHelper( void *xarg )
{
  struct helperArg *arg = (struct helperArg *)(xarg);

  int nCmdShow = arg->nCmdShow;
  int asthread = arg->asthread;
  HINSTANCE hInstance = arg->hInstance;
  LPCSTR wintitle;
  HWND hwnd;  
  MSG msg;

  wintitle = "console";
  if (winGetInstanceArgv())
    wintitle = (LPCSTR)(winGetInstanceArgv()[0]);

  constatics.createflag = -1;
  constatics.errorcode = 0;
  
  /* create a window using that class */
  hwnd = CreateWindow( constatics.szClassName, wintitle, 
         WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, 
         NULL, NULL, hInstance, NULL );

  if (hwnd == NULL)
  {
    if (constatics.errorcode == 0)
      constatics.errorcode = W16CONS_ERR_CREATEWIN;
    arg->nSuccess = 0;
    return;
  }

  /* display the window */
  ShowWindow(hwnd, nCmdShow /* SW_SHOW */);
  UpdateWindow(hwnd);

  while (constatics.createflag == -1)
  {
    #if (CLIENT_OS == OS_WIN32)
    Sleep(1);
    #else
    Yield();
    #endif
  }
    
  if (constatics.createflag == 0)
  {
    DestroyWindow(hwnd);
    arg->nSuccess = 0;
    return;
  }
    
  arg->hwnd = hwnd;
  arg->nSuccess = 1;

  if (asthread)
  {
    #if (CLIENT_OS == OS_WIN32)
    {
      //SetPriorityClass( GetCurrentProcess(), NORMAL_PRIORITY_CLASS );
      //SetThreadPriority( GetCurrentThread(), THREAD_PRIORITY_NORMAL );
      SetGlobalPriority(9);
    }
    #endif
    while (GetMessage(&msg, (HWND) NULL, 0, 0)) 
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }

  return;
}

/* ------------------------------------------------ */

HWND w16ConsoleCreate(int nCmdShow)
{
  struct helperArg arg;
  int newclass = 0;
  WNDCLASS wcl;
  memset((void *)&wcl,0,sizeof(wcl));  
  
  constatics.errorcode = 0;
  arg.hInstance = winGetInstanceHandle(); /* w32pre.cpp */

  if (!arg.hInstance)
  {
    constatics.errorcode = W16CONS_ERR_GETINST;
    return 0;
  }
  if (constatics.hwndList[0])
  {
    constatics.errorcode = W16CONS_ERR_NOSLOT;
    return 0;
  }

  if (constatics.szClassName[0]==0)
  {
    strcpy(constatics.szClassName,"DCTICLI");
    #ifdef __WINDOWS_386__ //win16 pmode - cannot share memory
    sprintf( constatics.szClassName, "DCTI%u", arg.hInstance );
    #endif

    constatics.hIcon = LoadIcon(arg.hInstance, MAKEINTRESOURCE(1));
    constatics.iconisstock = 0;
    if (!constatics.hIcon)
    {
      LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
      constatics.iconisstock = 1;
    }

    /* define a window class */
    wcl.hInstance = arg.hInstance;
    wcl.lpszClassName = constatics.szClassName;
    wcl.lpfnWndProc = (WNDPROC)__w16WindowFunc; 
    wcl.style = (/* CS_HREDRAW | CS_VREDRAW | CS_SAVEBITS | */
                 CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW );
    wcl.hIcon = constatics.hIcon;
    wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcl.lpszMenuName = NULL;
    wcl.cbClsExtra = 0;
    wcl.cbWndExtra = sizeof(void *); /* we need space for a pointer */
    wcl.hbrBackground = NULL; //(HBRUSH)GetStockObject(NULL_BRUSH);

    /* register the window class */
    if (!RegisterClass(&wcl)) 
    {
      constatics.szClassName[0]=0;
      if (!constatics.iconisstock)
        DestroyIcon( constatics.hIcon );
      constatics.hIcon = NULL;
      constatics.errorcode = W16CONS_ERR_REGCLASS;
      return 0;
    }
    newclass = 1;
  }
  
  arg.nSuccess = -1;
  arg.nCmdShow = nCmdShow;
  arg.asthread = 0;

  #if (CLIENT_OS == OS_WIN32)
  constatics.asthread = arg.asthread = 1;
  if (_beginthread( __win16WinCreateHelper, 512, (void *)&arg  ) == NULL)
  {
    //constatics.errorcode = W16CONS_ERR_CREATETHREAD;
    //arg.nSuccess = 0;
    constatics.asthread = arg.asthread = 0;
  }
  #endif
  if (arg.asthread == 0)
    __win16WinCreateHelper( (void *)&arg );

  while (arg.nSuccess == -1)
    w16Yield();

  if (arg.nSuccess == 0)    
  {
    if (newclass && constatics.szClassName[0])
    {
      if (UnregisterClass( constatics.szClassName, arg.hInstance ) == 0)
      {
        constatics.szClassName[0] = 0;
        if (constatics.hIcon && !constatics.iconisstock)
          DestroyIcon( constatics.hIcon );
        constatics.hIcon = NULL;
      }
    }
    constatics.asthread = 0;
    return 0;
  }

  constatics.hwndList[0] = arg.hwnd;
  return arg.hwnd;
}    

/* ------------------------------------------------ */

int w16ConsoleDestroy(void)
{
  HWND hwnd = constatics.hwndList[0];
  if (hwnd)
  {
    constatics.hwndList[0] = NULL;
    //this way because we can't directly send a WM_DESTROY to another thread
    SendMessage( hwnd, WM_USER_W16CONS, W16CONS_CMD_INDIRDESTROY, 0 );

    #if 0 /* doesn't work. why? */
    if (constatics.szClassName[0])
    {
      if (UnregisterClass( constatics.szClassName, winGetInstanceHandle() ) == 0)
      {
        constatics.szClassName[0] = 0;
        if (constatics.hIcon && !constatics.iconisstock)
          DestroyIcon( constatics.hIcon );
        constatics.hIcon = NULL;
      }
    }
    #endif
    return 1;
  }
  return 0;
}  

/* ------------------------------------------------ */

void w16SetConsoleTitle(const char *name)
{
  w16Yield();
  if (constatics.hwndList[0] == NULL)
    return;
  SetWindowText( constatics.hwndList[0], (LPSTR)name );
}  

/* ------------------------------------------------ */

int w16HaveWindow(void)
{
  return (constatics.hwndList[0] != NULL);
}

/* ------------------------------------------------ */

int w16ConsoleClear(void)
{
  w16Yield();
  if (constatics.hwndList[0] == NULL)
    return -1;
  SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_CLEARSCREEN, 0 );
  return 0;
}

/* ------------------------------------------------ */

int w16ConsolePrint(const char *text)
{
  unsigned int len;
  w16Yield();
  if (constatics.hwndList[0] == NULL)
    return -1;
  if (!text)
    return -1;
  if ((len = strlen(text)) == 0)
    return 0;
  SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_PRINTSTR, (LPARAM)(text) );
  return len;
}  

/* ------------------------------------------------ */

int w16ConSetPos(int col, int row)
{
  w16Yield();
  if (constatics.hwndList[0] == NULL)
    return -1;
  SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_SETPOS, MAKELONG(row, col));
  return 0;
}

/* ------------------------------------------------ */

int w16ConGetPos(int *col, int *row)
{
  w16Yield();
  if (constatics.hwndList[0] == NULL)
    return -1;
  LRESULT cr = SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_GETPOS, 0);
  if (col) *col = HIWORD(cr);
  if (row) *row = LOWORD(cr);
  return 0;
}

/* ------------------------------------------------ */

int w16ConGetSize( int *width, int *height)
{
  if (constatics.hwndList[0] == NULL)
    return -1;
  LRESULT wh = SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_GETSIZE, 0);
  if (width)  *width  = HIWORD(wh);
  if (height) *height = LOWORD(wh);
  return 0;
}  

/* ------------------------------------------------ */

int w16ConsoleKbhit(void)
{
  w16Yield();
  if (constatics.hwndList[0] == NULL)
    return 0;
  return SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_ISKBHIT, 0 );
}

/* ------------------------------------------------ */

int w16ConsoleGetch(void)
{
  LRESULT keyval = 0; 
  while (constatics.hwndList[0])
  {
    if (SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_ISKBHIT, 0 ))
    {
      keyval = SendMessage( constatics.hwndList[0], WM_USER_W16CONS, W16CONS_CMD_GETCH, 0 );
      if (keyval != -1L) /* huh? no key! */
        break;
      keyval = 0;
    }
    w16Yield();
  }
  return (int)keyval;
}  

/* ===================================================== */
/* ************* END OF GUI PRIMITIVES ***************** */  
/* ===================================================== */

#if (CLIENT_OS == OS_WIN32)
static HANDLE __pipe_gethandle(int which)
{
  if (which == STD_INPUT_HANDLE)
  {
    if (constatics.devpipein) /* input end of anon pipe */
      return (HANDLE)constatics.devpipein; 
  }
  return (HANDLE)constatics.devpipe;  /* pipe is r/w named pipe */
}  
static int __pipe_kbhit(void)
{
  char buffer[8];
  DWORD bytesRead, totalBytesAvail, bytesLeftThisMessage;
  if (!PeekNamedPipe(__pipe_gethandle(STD_INPUT_HANDLE),
                       (LPVOID)&buffer[0],
                       sizeof(buffer),
                       &bytesRead,
                       &totalBytesAvail,
                       &bytesLeftThisMessage ))
  {                       
    if (GetLastError() == ERROR_BROKEN_PIPE)
    {
      RaiseExitRequestTrigger(); /* sigpipe */
      return -1;
    }
#ifdef PIPE_DEBUG
__w16showerror("__pipe_kbhit: peekpipe failed");
#endif
  }
  else if (totalBytesAvail)
    return 1;
  return 0;
}
static int __pipe_getchar(int *chP)
{
  char buffer[8];
  DWORD bytesRead;
  int ch = __pipe_kbhit();
  if (ch <= 0)
    return ch;
  if (!ReadFile(__pipe_gethandle(STD_INPUT_HANDLE),
                (LPVOID)&buffer[0], 1, &bytesRead, NULL))
  {                       
    if (GetLastError() == ERROR_BROKEN_PIPE)
    {
      RaiseExitRequestTrigger(); /* sigpipe */
      return -1;
    }
#ifdef PIPE_DEBUG
__w16showerror( "__pipe_getchar: readpipe failed" );
#endif
  }
  ch = (((int)buffer[0]) & 0xff);
#ifdef PIPE_DEBUG
__w16writelog( "__pipe_getchar: %c (%d,0x%02x)", ch, ch, ch );
#endif
  if (chP)
    *chP = ch;
  return +1;
}  
static int __pipe_puts_noclear(const char *msg,unsigned int len)
{
  int totalBytesWritten = 0;
  HANDLE hPipe = __pipe_gethandle(STD_OUTPUT_HANDLE);
  do
  {
    DWORD numberOfBytesWritten = 0;
    if (!WriteFile(hPipe, (LPCVOID)msg, len, &numberOfBytesWritten, NULL))
    {
      // win9x and NT 3.x (ok on 4.x) have a broken pipe implementation 
      // which causes WriteFile to _sometimes_ fail with an invalid file 
      // handle.
      if (GetLastError() == ERROR_BROKEN_PIPE)
      {
        RaiseExitRequestTrigger(); /* sigpipe */
        return -1;
      }
#ifdef PIPE_DEBUG
   //__w16writelog( "__pipe_puts: writepipe failed" );
 __w16showerror("__pipe_puts: writepipe failed");
#endif
      FlushFileBuffers(hPipe); //block
      if (!WriteFile(hPipe, (LPCVOID)msg, len, &numberOfBytesWritten, NULL))
        break;
    }
    totalBytesWritten += numberOfBytesWritten;
    msg += numberOfBytesWritten;
    len -= numberOfBytesWritten;
  } while (len);
  return totalBytesWritten;
}  
static int __pipe_puts(const char *msg,unsigned int len)
{
  int rc = 0;
  if (len) /* avoid overhead */
    rc = __pipe_puts_noclear(msg,len);
  if (rc >= 0)
  {
    while (__pipe_kbhit() > 0)
    {
      if (__pipe_getchar(NULL) < 0)
        break;
    }
  }
  return rc;
}
static int __pipe_putchar(int ch)
{
  char msg;
  msg = (char)ch;
  if (__pipe_puts(&msg,1) <= 0)
    return -1;
  return 1;
}
/*
// position and size is always one based, 
// unless no tty, in which case the pipe server ansi returns 0,0
*/
static int __pipe_isatty_asserted_is = -1; /* not yet asserted */
static int __pipe_getsizeorpos(int assize, int *width, int *height) 
{                                                          /* one based */
  if (__pipe_isatty_asserted_is == 0) /* already determined this */
  {
    if (*width) *width = 0;
    if (*height) *height = 0;
    return 0;
  }
  else
  {
    int which = 0, savex;
    if (!width)
      which = 1;
    for (; which < 2; which++)
    {
      const char *msg;
      while (__pipe_getchar(NULL)>0) /* flush input pipe */
        ;
      if (assize) /* getsize */
        msg = ((which == 0)?("\x1B""[X"):("\x1B""[Y"));
      else /* getpos */
        msg = ((which == 0)?("\x1B""[x"):("\x1B""[y"));
      if (__pipe_puts_noclear(msg,3) != 3)
        return -1; /* broken pipe */
      while (!CheckExitRequestTriggerNoIO())
      {
        int xy, kbstate;
        if ((kbstate = __pipe_getchar(&xy)) < 0)
          return -1; /* broken pipe */
        if (kbstate != 0)
        {
          if (__pipe_isatty_asserted_is < 0) /* haven't determined this yet */
            __pipe_isatty_asserted_is = (xy ? 1 : 0);
          if (which == 0) /* width loop */
          {
            if (xy == 0 && height)
              *height = 0;
            if (xy == 0 || !height)
            {
              if (width) /* should be always true */
                *width = xy;
              return 0; /* we're done */
            }
            savex = xy;
          }
          else           /* height loop */
          {
            if (height)
              *height = xy;
            if (width)
              *width = savex;
            return 0; /* we're done */
          }
          break; /* got an answer, don't wait */
        }
        Sleep(250);
      } /* while (!CheckExitRequestTriggerNoIO()) */
    }
  }
  return -1;
}
static int __pipe_isatty(void) /* < 0 = err, 0=no, >0=yes */
{
  if (__pipe_isatty_asserted_is < 0)
  { int xy;
    __pipe_getsizeorpos(1 /*assize*/, &xy, 0);
  }
  return __pipe_isatty_asserted_is;
}
/* pipe server supports an internal command set similar to ansi:
 * but instead of "esc[num;num'cmd" it uses "esc]cmd'opt...\0"
 * making it possible to send virtually anything
*/
static int __pipe_set_title(const char *title)
{
  char cmdbuffer[128];
  cmdbuffer[0]=((char)0x1B); 
  cmdbuffer[1]=']'; /* note reversed bracket */
  cmdbuffer[2]='1'; /* cmd: setconsoletitle */
  strncpy(&cmdbuffer[3],title,sizeof(cmdbuffer)-3);
  cmdbuffer[sizeof(cmdbuffer)-1] = '\0'; /* also, our command char is '\0' */
  return __pipe_puts(cmdbuffer,2+strlen(&cmdbuffer[1]));
}
static int __pipe_advertise_hwnd(HANDLE hwnd)
{
  char cmdbuffer[128];
  cmdbuffer[0]=((char)0x1B); 
  cmdbuffer[1]=']'; /* note reversed bracket */
  cmdbuffer[2]='2'; /* cmd: advertise handle */
  sprintf(&cmdbuffer[3],"%lu",(unsigned long)hwnd);
  return __pipe_puts(cmdbuffer,2+strlen(&cmdbuffer[1]));
}
static int __pipe_detach(void)
{
  return __pipe_putchar(0x03);
}  
static void __pipe_sleep(unsigned int millisecs)
{
  Sleep(millisecs); /* nothing yet */
}
#endif

/* ===================================================== */
/* ************* END OF PRIMITIVES ********************* */  
/* ===================================================== */
      
int w32DeinitializeConsole(int pauseonclose)
{
  pauseonclose = pauseonclose;
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.hmutex != NULL)
  {
    ReleaseMutex( constatics.hmutex );
    CloseHandle( constatics.hmutex );
    constatics.hmutex = NULL;
  }
  if (constatics.shimwatcher != NULL)
  {                                      // self destroying
    int sleeploops = 0;
    SendMessage( constatics.shimwatcher, WM_USER_W16CONS, W16CONS_CMD_INDIRDESTROY, 0 );
    while ((++sleeploops) < 20 && constatics.shimwatcher)
      Sleep(100);
  }
  if (constatics.devpipe)
  {
    __pipe_set_title(utilGetAppName());
    if (!constatics.devpipein) /* pipe is named pipe */
      CloseHandle(constatics.devpipe);
    else /* pipe is pipe pair of anonpipe */
      constatics.devpipein = NULL;
    constatics.devpipe = NULL;
  }
  else if (constatics.nativecons)
  {
    SetConsoleTitle(utilGetAppName());
    if (constatics.fstdout || constatics.fstdin)
      FreeConsole();
    if (constatics.fstdout)
      fclose(constatics.fstdout);
    constatics.fstdout = NULL;
    if (constatics.fstdin)
      fclose(constatics.fstdin);
    constatics.fstdin = NULL;
  }
  else
  #endif
  {
    if (w16HaveWindow())
    {
      if (pauseonclose)
      {
        int init = 0;
        time_t nowtime = 0, endtime = 0;
        int row = -1, height = 0;
        w16ConGetPos(NULL, &row);
        w16ConGetSize(NULL, &height);
        if (height > 2 && row != -1)
          w16ConSetPos(0, height-((row<(height-2))?(3):(1)));
        do
        {
          int sleeploops;
          nowtime = time(NULL);
          if (endtime == 0)
            endtime = nowtime + 15;
          for (sleeploops = 0;sleeploops < ((!init)?(1):(4));sleeploops++)
          {
            if (sleeploops)
              w16Sleep(250);
            if (w16ConsoleKbhit() || CheckExitRequestTriggerNoIO())
            {
              nowtime = endtime; 
              break;
            }
          }
          if (nowtime < endtime)
          {
            char buffer[80];
            sprintf( buffer, "%sPress any key to continue... %d  ",
                     ((!init)?("\n\n"):("\r")), (int)(endtime-nowtime) );
            init = 1;
            w16ConsolePrint( buffer );
          }
        } while (nowtime < endtime);
      }
      w16ConsoleDestroy();
    }
  }
 
  return 0;
}


/* ---------------------------------------------------- */

#if (CLIENT_OS == OS_WIN32)
#if defined(__WATCOMC__)
static void __w32SigTriggerControl(int sig)
{
  signal(sig,__w32SigTriggerControl);
  RaiseExitRequestTrigger();
  return;
}  
#endif
static BOOL WINAPI __w32NativeTriggerControl(DWORD dwCtrlType)
{
  if (dwCtrlType == CTRL_LOGOFF_EVENT && win32CliServiceRunning())
  {
    //should never happen since we don't open a console if running as a service
    return TRUE;
  }
  else if (dwCtrlType == CTRL_BREAK_EVENT)
  {
    RaiseRestartRequestTrigger();
    return TRUE;
  }
  else if ( dwCtrlType == CTRL_C_EVENT )
  {
    RaiseExitRequestTrigger();
    return TRUE;
  }
  else if ( dwCtrlType == CTRL_CLOSE_EVENT || /* totally fscked on Win9x */
            dwCtrlType == CTRL_SHUTDOWN_EVENT || /* none of these are called */
            dwCtrlType == CTRL_LOGOFF_EVENT ) 
  { 
    /* http://support.microsoft.com/support/kb/articles/q130/7/17.asp */
    //no use calling RaiseExitRequestTrigger() from here. We have to terminate
    //here or win will throw up a message box and then call ExitProcess().
    //we have 5 seconds for CLOSE, and 20 secs for SHUTDOWN/LOGOFF
    RaiseExitRequestTrigger();
    while (constatics.client_run_startstop_level > 0)
      Sleep(500);
    //__w16ClientHardStop();
    ExitProcess(0);
    //return TRUE;
  }
  return FALSE; //DBG_CONTROL_C
}
//#define WIN9X_CLOSE_WATCH 5000 /* poll time in millisecs */
#if defined(WIN9X_CLOSE_WATCH) && (CLIENT_CPU == CPU_X86) /* win9x */
static void __win9xCloseWatchTimerHandler(int state)
{
  char cstate;
  if (state != 0)
  {
    cstate = ((state > 0)?(1):(0));
    printf("timer: hellooooooooooooooooo world %d\n", cstate );
    fflush(stdout);
    _asm mov ax, 168Fh
    _asm mov dh, 0 /* fxn: enable/disable sysmenu close */
    _asm mov dl, cstate /* enable or disable */
    _asm int 2fh
  }
  cstate = 0;
  _asm mov ax, 168Fh
  _asm mov dh, 1 /* fxn: check sysmenu close */
  _asm mov dl, 0
  _asm int 2fh  /* => 0=selected/not ack'd, 1=sel/ack'd, else not selected */
  _asm cmp ax, 2
  _asm sbb dx, dx
  _asm and ax, dx
  _asm xor dl, 2
  _asm and dl, 2
  _asm or  al, dl
  _asm mov cstate, al
  if (cstate < 2)
  {
    RaiseExitRequestTrigger();
    _asm mov ax, 168Fh
    _asm mov dh, 2 /* fxn: ack sysmenu close */
    _asm mov dl, 0 
    _asm int 2fh
  }
  return;
}  
#endif
LRESULT CALLBACK __w32ShimWatcherWProc(HWND hwnd, UINT message, WPARAM wParam, 
                                     LPARAM lParam) 
{
  static UINT dnetc_cmdmsg = 0;
  LRESULT lResult;
  if (dnetc_cmdmsg && message == dnetc_cmdmsg)
    message = WM_COMMAND;

  if (message == WM_CREATE)
    dnetc_cmdmsg = RegisterWindowMessage(W32CLI_CONSOLE_NAME);
  else if (message == WM_CLOSE)
  {
    RaiseExitRequestTrigger();
    return DNETC_WCMD_ACKMAGIC;
  }
  else if (__w16WindowHandle_DNETC_WCMD(hwnd,message,wParam,lParam,&lResult))
    return lResult;
  else if (message == WM_USER_W16CONS && wParam == W16CONS_CMD_INDIRDESTROY)
  {
    //SendMessage(hwnd, WM_DESTROY, 0, 0 );
    DestroyWindow(hwnd);
    PostQuitMessage(0);
  }
  return DefWindowProc(hwnd,message,wParam,lParam);
}
static void __win32ShimWatcher(void *) /* lives as long as the client */
{
  int normalstop = 0;
  HINSTANCE hInstance = winGetInstanceHandle(); /* w32pre.cpp */

  if (hInstance)
  {
    static int classisreg = 0;
    WNDCLASS wcl;
    /* define a window class */
    wcl.hInstance = hInstance;
    wcl.lpszClassName = "DCTICLISTUB";
    wcl.lpfnWndProc = (WNDPROC)__w32ShimWatcherWProc; 
    wcl.style = 0; //CS_HREDRAW | CS_VREDRAW;
    wcl.hIcon = NULL;
    wcl.hCursor = NULL;
    wcl.lpszMenuName = NULL;
    wcl.cbClsExtra = 0;
    wcl.cbWndExtra = 0;
    wcl.hbrBackground = NULL;

    /* register the window class */
    if (RegisterClass(&wcl)) 
      classisreg = 1;
    if (classisreg)
    {
      HWND hwnd = CreateWindow( wcl.lpszClassName, W32CLI_CONSOLE_NAME, 
                            0/*WS_POPUP|WS_CLIPSIBLINGS|WS_OVERLAPPED*/,
                            0, 0, 0, 0, NULL, NULL, wcl.hInstance, NULL );
      if (hwnd)
      {
        MSG msg;
        #if defined(WIN9X_CLOSE_WATCH) && (CLIENT_CPU == CPU_X86)
        UINT win9xclosewatchtimer = 0;
        if (winGetVersion()>=400 && winGetVersion()<2000)
        {
          win9xclosewatchtimer = SetTimer(NULL,0,WIN9X_CLOSE_WATCH,NULL);
          if (win9xclosewatchtimer) __win9xCloseWatchTimerHandler(+1);
        }
        #endif

        //ShowWindow(hwnd, SW_HIDE);
        
        if (constatics.devpipe)
          __pipe_advertise_hwnd(hwnd);

        constatics.shimwatcher = hwnd;
        while (GetMessage(&msg, hwnd, 0, 0)) 
        {
          #if defined(WIN9X_CLOSE_WATCH_ENABLED) && (CLIENT_CPU == CPU_X86)
          if (msg.message == WM_TIMER)
            __win9xCloseWatchTimerHandler(0);
          else
          #endif
          {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
          }
        }
        constatics.shimwatcher = NULL;

        if (constatics.devpipe)
          __pipe_advertise_hwnd(NULL);

        if (IsWindow(hwnd))
          DestroyWindow(hwnd);
        #if defined(WIN9X_CLOSE_WATCH_ENABLED) && (CLIENT_CPU == CPU_X86)
        if (win9xclosewatchtimer)
        {
          KillTimer(NULL,win9xclosewatchtimer);
          __win9xCloseWatchTimerHandler(-1);
        }
        #endif
      }
      if (UnregisterClass( wcl.lpszClassName, wcl.hInstance ))
        classisreg = 0;
    }
  }
  return;
}    
#endif

/* ---------------------------------------------------- */

int w32InitializeConsole(int runhidden, int runmodes)
{
  const char *wintitle = W32CLI_CONSOLE_NAME; 
  int isservicified = 0, retcode = 0;
  char *p; char scratch[256]; /* not smaller! */
  
  constatics.hidden = (!runmodes && runhidden);
  constatics.nativecons = 0;
  constatics.devpipe = 0;

  //quickly change to a normal cursor
  SetCursor(LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW)));

  #if (CLIENT_OS == OS_WIN32)
  if (!constatics.hidden && retcode == 0) 
  {
    if (win32CliServiceRunning())
    {
      isservicified = 1;
      constatics.hidden = 1; 
    }
  }
  #endif

  // ------------------------------------
  // single instance check
  // ------------------------------------

  if (!runmodes && retcode==0 && !isservicified && getenv("dnetc_multiok")==NULL)
  {
    if (w32PostRemoteWCMD(DNETC_WCMD_EXISTCHECK)>=0) /* found */
      retcode = -1;
  }

  #if (CLIENT_OS == OS_WIN32)  
  if (!runmodes && retcode == 0)
  {      
    constatics.hmutex = CreateMutex(NULL, FALSE, W32CLI_MUTEX_NAME);
    if (!constatics.hmutex)
      retcode = -1;
  }
  #endif

  // ----------------------------
  // console as CUI or pipe?
  // ----------------------------

  #if (CLIENT_OS == OS_WIN32)
  if (retcode == 0) 
  {
    #if defined(USE_NATIVE_CONSOLEIO)
    constatics.nativecons = 1;
    #endif
    if (retcode == 0 && !constatics.nativecons)
    {
      STARTUPINFO si; 
      GetStartupInfo( &si );
      if ((si.dwFlags & STARTF_USESTDHANDLES)!=0)
      {
        constatics.nativecons = 1;
        SetStdHandle(STD_OUTPUT_HANDLE,si.hStdOutput);
        SetStdHandle(STD_INPUT_HANDLE,si.hStdInput);
        SetStdHandle(STD_ERROR_HANDLE,si.hStdError);
        SetConsoleTitle(wintitle);
      }
    }
    if (retcode == 0 && !constatics.nativecons)
    {
      DWORD lpMode;
      if (GetConsoleMode(GetStdHandle(STD_OUTPUT_HANDLE),&lpMode) ||
          GetConsoleMode(GetStdHandle(STD_INPUT_HANDLE),&lpMode))
      {
        SetConsoleTitle(wintitle);
        constatics.nativecons = 1;
        //SetStdHandle(STD_OUTPUT_HANDLE, (HANDLE)_get_osfhandle(fileno(stdout)));
        //SetStdHandle(STD_INPUT_HANDLE, (HANDLE)_get_osfhandle(fileno(stdin)));
        //SetStdHandle(STD_ERROR_HANDLE, (HANDLE)_get_osfhandle(fileno(stdout)));
      }
    }
    if (retcode == 0 && !constatics.nativecons)
    {
      if (GetEnvironmentVariable("dnetc.ttyhandles",scratch,sizeof(scratch)))
      {
        unsigned int which;
        HANDLE inouterr[3];
        p = scratch;
        for (which = 0; which < 3; which++)
        {
          HANDLE h = (HANDLE)atol(p);
          if (*p == '-')
            p++;
          if (!h && *p != '0')
            break;
          inouterr[which]=h;
          if (which == 0 || which == 1)
          {
            while (isdigit(*p)) 
              p++;
            while (*p && !isdigit(*p))
              p++;
          }
          else
          {
            if (inouterr[0] != INVALID_HANDLE_VALUE)
              SetStdHandle(STD_INPUT_HANDLE, inouterr[0]);
            if (inouterr[1] != INVALID_HANDLE_VALUE)
              SetStdHandle(STD_OUTPUT_HANDLE, inouterr[1]);
            if (inouterr[2] != INVALID_HANDLE_VALUE)
              SetStdHandle(STD_ERROR_HANDLE, inouterr[2]);
            constatics.nativecons = 1;
            SetConsoleTitle(wintitle);
          }
        }
      }
    }

    if (retcode == 0 )
    {
      HANDLE pipe = INVALID_HANDLE_VALUE;
      HANDLE inpipe = INVALID_HANDLE_VALUE;
      int anonpipe = 0, gotpipeprompt = 0;

      if (winGetVersion() >= 2000 &&
        GetEnvironmentVariable("dnetc.namedpipe",scratch,sizeof(scratch))!=0)
      {
        gotpipeprompt = 1;
        pipe = CreateFile(scratch, GENERIC_READ|GENERIC_WRITE, 0,
                                   NULL, OPEN_EXISTING, 0, 0 );
      }
      if (!gotpipeprompt &&
        GetEnvironmentVariable("dnetc.apipe.out",scratch,sizeof(scratch))!=0)
      {
        gotpipeprompt = anonpipe = 1;
        if (isdigit(scratch[0]) || (scratch[0] == '-' && isdigit(scratch[1])))
        {
          pipe = (HANDLE)atol(scratch);
          if (pipe != INVALID_HANDLE_VALUE &&
              GetEnvironmentVariable("dnetc.apipe.in",scratch,sizeof(scratch)))
          {
            if (isdigit(scratch[0]) || (scratch[0]=='-' && isdigit(scratch[1])))
              inpipe = (HANDLE)atol(scratch);
          }
        }
        if (inpipe == INVALID_HANDLE_VALUE)
          pipe = INVALID_HANDLE_VALUE;
      }
      if (gotpipeprompt)
      {
        if (pipe != INVALID_HANDLE_VALUE)
        {
          DWORD numberOfBytesWritten;
          if (constatics.hidden || constatics.nativecons)
          {
            __pipe_detach(); /* close the pipe == fork() :) */
            p = "\x03"; 
            WriteFile(pipe, (LPCVOID)p, 1, &numberOfBytesWritten, NULL);
            if (!anonpipe)
              CloseHandle(pipe);
          }
          else
          {
            __pipe_set_title(W32CLI_CONSOLE_NAME);
            constatics.devpipe = (void *)pipe;
            if (anonpipe)
              constatics.devpipein = (void *)inpipe;
            else
              inpipe = pipe;
            SetStdHandle(STD_OUTPUT_HANDLE, pipe);
            SetStdHandle(STD_ERROR_HANDLE, pipe);
            SetStdHandle(STD_INPUT_HANDLE, inpipe);
          }
        }
        else if (!constatics.nativecons) /* no error if we already have a con */
        {
          if (!constatics.hidden)
            w32ConOutErr( "Unable to open client end of console pipe" );
          retcode = -1;
        }
      }
    }

    if (retcode == 0 && !constatics.nativecons && 
        !constatics.hidden && !constatics.devpipe )
    {                     //use guicode (don't allocconsole) if we're hidden
      if (winGetMyModuleFilename(scratch,sizeof(scratch)) > 4) /* win32pre.cpp */
      {
        if (strcmpi( &scratch[strlen(scratch)-4], ".com" ) == 0)
        {
          p = "Unable to create console window.";
          if (!AllocConsole())
            retcode = -1;
          else
          {
            FILE *hfin, *hfout;
            HWND hwnd;
            p = "Unable to open console for write.";
            retcode = 0;
            sprintf(scratch,"%s - %08x%08x",
                  wintitle, GetTickCount(), GetModuleHandle(NULL));
            SetConsoleTitle(scratch);
            while ((hwnd = FindWindow( NULL, scratch )) == NULL)
            {
              if ((++retcode) > 25)
                break;
              Sleep(40); //Delay needed for title to update
            }
            SetConsoleTitle(wintitle);
            if ( hwnd == NULL )
              retcode = -1;
            else if ((hfout = fopen("CONOUT$", "w+t")) == NULL)
              retcode = -1;
            else if ((hfin = fopen("CONIN$", "rt")) == NULL)
            {
              p = "Unable to open console for read.";
              fclose( hfout );
              retcode = -1;
            }
            else
            {
              retcode = 0;
              constatics.fstdout = hfout;
              constatics.fstdin = hfin;
              *stdout = *hfout;
              setvbuf(stdout, NULL, _IONBF, 0);
              *stderr = *hfout;
              setvbuf(stderr, NULL, _IONBF, 0);
              *stdin = *hfin;
              setvbuf(stdin, NULL, _IONBF, 0);
              constatics.nativecons = 1;
            }
            if (retcode != 0)
              FreeConsole();
          }
          if (p && retcode != 0 && !constatics.hidden)
            w32ConOutErr( p );
        } 
      }
    }
    
    if (retcode == 0 && constatics.nativecons)
    {
      DWORD dwConMode;
      #if defined(__WATCOMC__)
      int sig;
      for (sig = 0; sig < 255; sig++)
        signal(sig, __w32SigTriggerControl );
      #endif
      dwConMode = ~ENABLE_WINDOW_INPUT;
      //if (GetConsoleMode( GetStdHandle(STD_INPUT_HANDLE),&dwConMode))
      {
        //if ((dwConMode & ENABLE_PROCESSED_INPUT)==0)
        {
          dwConMode |= ENABLE_PROCESSED_INPUT;
          SetConsoleMode( GetStdHandle(STD_INPUT_HANDLE), dwConMode );
        }
      }                                    
      SetProcessShutdownParameters(0x100,SHUTDOWN_NORETRY);
      SetConsoleCtrlHandler((PHANDLER_ROUTINE)__w32NativeTriggerControl,TRUE);
      
      if (constatics.hidden)
        FreeConsole(); //fork() :)
    }
  }
  #endif /* (CLIENT_OS == OS_WIN32) */

  // ---------------------------
  // console as GUI?
  // ---------------------------

  if (retcode == 0 && !constatics.devpipe && !constatics.nativecons)
  {
    int nCmdShow = winGetInstanceShowCmd();
    if (constatics.hidden)
      nCmdShow = SW_HIDE | WS_DISABLED;

    if (w16ConsoleCreate(nCmdShow))
      w16SetConsoleTitle(wintitle);
    else
    {
      if (!constatics.hidden)
      {
        p = NULL;
        if (constatics.errorcode == W16CONS_ERR_CREATETHREAD) 
          p = "create console thread";
        else if (constatics.errorcode == W16CONS_ERR_NOFONT) 
         p = "assign font";
        else if (constatics.errorcode == W16CONS_ERR_NOMEM) 
          p = "create window data area";
        else if (constatics.errorcode == W16CONS_ERR_CREATEWIN) 
          p = "create window client area";
        else if (constatics.errorcode == W16CONS_ERR_NCCREATE) 
          p = "create window non-client area";
        else if (constatics.errorcode == W16CONS_ERR_REGCLASS) 
          p = "register class";
        else if (constatics.errorcode == W16CONS_ERR_GETINST) 
          p = "get instance handle";
        else if (constatics.errorcode == W16CONS_ERR_NOSLOT) 
          p = "find a window slot";
        sprintf(scratch,"Unable to create console window.%s%s)",
              ((!p)?(" (Unknown error"):("\n(Failed to ")),
              ((!p)?(""):(p)) );
        w32ConOutErr(scratch);
      }
      retcode = -1;
    }
  }

  if (retcode == 0)  
  {
    //quickly change to a normal cursor
    SetCursor(LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW)));

    //watch for ClientRun() start and stop events
    ClientEventAddListener( -1, __event_handler );

    #if (CLIENT_OS == OS_WIN32)
    if (constatics.devpipe || constatics.nativecons)
    {
      int havethread = 0;
      if (constatics.shimwatcher)
        havethread = 1;
      else if (_beginthread( __win32ShimWatcher, 512, NULL ))
      {
        while ((++havethread) < 20 && !constatics.shimwatcher)
          Sleep(100);
        if (!constatics.shimwatcher)
          havethread = 0;
      }
      if (havethread) //we don't want the window to be findable
        wintitle = W32CLI_CONSOLE_NAME" ";
      if (constatics.devpipe)
        __pipe_set_title(wintitle);
      else if (constatics.nativecons)
        SetConsoleTitle(wintitle);
    }  
    #endif
  }
  #if (CLIENT_OS == OS_WIN32)
  else if (constatics.hmutex)
  {
    ReleaseMutex( constatics.hmutex );
    CloseHandle( constatics.hmutex );
    constatics.hmutex = NULL;
  }
  #endif

  return (retcode);
}
 
/* ================================================================== */
/* ================================================================== */

int w32ConKbhit(void)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.devpipe)
  {
    if (__pipe_kbhit() <= 0)
      return 0;
    return 1;
  }
  else if (constatics.nativecons)
    return (kbhit());
  #endif
  return w16ConsoleKbhit();
}  

/* ---------------------------------------------------- */

int w32ConGetch(void)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.devpipe)
  {
    static int hibyte = 0;
    int ch;
    if (hibyte != 0)
    {
      ch = hibyte;
      hibyte = 0;
      return ch;
    }
    while (!CheckExitRequestTriggerNoIO())
    {
      int kbstate = __pipe_getchar(&ch);
      if (kbstate < 0) /* broken pipe */
        break;
      if (kbstate != 0)
      {
        if (ch == 0)
        {
          kbstate = __pipe_getchar(&ch);
          if (kbstate < 0) /* broken pipe */
            break;
          hibyte = ch;
        }
        return ch;
      }
      Sleep(100);
    } 
    return 0;
  }
  else if (constatics.nativecons)
  {
    return getch();
  }
  #endif
  return w16ConsoleGetch();
}

/* ---------------------------------------------------- */

static int __w32ConOutX(const char *text, int iserr)
{
  int handled = 0;
  if (win32CliServiceRunning())
  {
    handled = 1;
    if (iserr) /* we don't print anything if !err */
    {
      /* do log stuff for NT here */
      return 0;
    }
    return -1;
  }
  #if (CLIENT_OS == OS_WIN32)
  if (!handled)
  {
    if (constatics.nativecons)
      handled = 1;
    else
    {
      char filename[MAX_PATH+1];
      if (winGetMyModuleFilename(filename, sizeof(filename)) != 0) //w32pre.cpp
      {
        if (winIsGUIExecutable( filename )==0) /*w32util <0=err,0=cui,>0=gui*/
          handled = 1;
      }
    }
    if (handled)
    {
      FILE *file = stdout;
      if (!iserr)
        fprintf( file, "%s\n", text );
      else
      {
        file = stderr;
        fprintf(file,"%s: %s\n", utilGetAppName(), text);
      } 
      fflush(file);
    }
  } 
  if (!handled && (constatics.devpipe || getenv("dnetc.apipe.out")))
  {
    int needclose = 0;
    if (!constatics.devpipe)
    {
      HANDLE h = (HANDLE)atol(getenv("dnetc.apipe.out"));
      if (h && h!=INVALID_HANDLE_VALUE)
      {
        constatics.devpipe = (void *)h;
        needclose = 1;
      }
    }
    if (constatics.devpipe)
    {
      if (iserr)
      { 
        __pipe_puts(utilGetAppName(),strlen(utilGetAppName()));
        __pipe_puts(": ",2);
      }
      __pipe_puts(text,strlen(text));  
      __pipe_puts("\n",1);
      if (needclose)
        constatics.devpipe = NULL;
      handled = 1;
    }
  }
  #endif
  if (!handled)
  {
    /* note the spaces around the caption! Don't let this window be "findable" */
    MessageBox(NULL,text, " "W32CLI_CONSOLE_NAME" ",MB_OK|MB_TASKMODAL
                            |(iserr?MB_ICONHAND:MB_ICONINFORMATION));
  }
  return 0;
}

int w32ConOutErr(const char *text)
{ return __w32ConOutX(text, 1); }
int w32ConOutModal(const char *text)
{ return __w32ConOutX(text, 0); }

/* ---------------------------------------------------- */

int w32ConOut(const char *text)
{
  int len = (int)strlen(text);
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.devpipe)
  {
    return __pipe_puts(text,len);
  }
  else if (constatics.nativecons)
  {
    if (len)
      len = fwrite( text, sizeof(char), len, stdout);
    fflush(stdout);
    return len;
  }
  #endif
  if (len)
    len = w16ConsolePrint(text);
  return len;
}

/* ---------------------------------------------------- */

int w32ConIsScreen(void)
{
  if (!constatics.hidden)
  {
    #if (CLIENT_OS == OS_WIN32)
    if (constatics.devpipe)
    {
      if (__pipe_isatty() <= 0) /* <0=err, 0=no, >0=yes */
        return 0;
      return 1;
    }
    if (constatics.nativecons)
      return isatty(fileno(stdout));
    #endif
    return w16HaveWindow();
  }
  return 0;
}

/* ---------------------------------------------------- */

void w32Sleep(unsigned int millisecs)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.devpipe)
  {
    __pipe_sleep(millisecs);
    return;
  }
  if (constatics.nativecons)
  {
    Sleep(millisecs);
    return;
  }
  #endif
  w16Sleep(millisecs);
  return;
}

/* ---------------------------------------------------- */

void w32Yield(void)
{
  #if (CLIENT_OS == OS_WIN32)
  if (constatics.nativecons || constatics.devpipe)
  {
    w32Sleep(1); /* millisecs */
    return;
  }
  #endif
  w16Yield();
  return;
}  

/* ---------------------------------------------------- */

int w32ConGetSize( int *width, int *height) /* one based */
{
  if (!constatics.hidden)
  {
    #if (CLIENT_OS == OS_WIN32)
    if (constatics.devpipe)
    {
      int w = 1, h = 1;
      if (__pipe_getsizeorpos(1/*assize*/,((!width)?(NULL):(&w)),
                                          ((!height)?(NULL):(&h))) < 0)
        return -1;
      if (w == 0 || h == 0) /* size will be zero only if no tty */
        return -1;
      if (width)  *width = w;
      if (height) *height = h;
      return 0;
    }
    else if (constatics.nativecons)
    {
      HANDLE hStdout;
      CONSOLE_SCREEN_BUFFER_INFO csbiInfo;

      hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
      if (hStdout == INVALID_HANDLE_VALUE) 
        return -1;
      if (! GetConsoleScreenBufferInfo(hStdout, &csbiInfo)) 
        return -1;
      if (height) *height=csbiInfo.srWindow.Bottom - csbiInfo.srWindow.Top + 1;
      if (width) *width = csbiInfo.srWindow.Right - csbiInfo.srWindow.Left + 1;
      return 0;
    }
    #endif
    return w16ConGetSize( width, height );
  }
  return -1;
}

/* ---------------------------------------------------- */

int w32ConClear(void)
{
  if (!constatics.hidden)
  {
    #if (CLIENT_OS == OS_WIN32)
    if (constatics.devpipe)
    {
      if (__pipe_puts(("\x1B""[2J""\x1B""[1;1H"), 10 ) < 0)
        return -1;
      return 0;
    }
    else if (constatics.nativecons)
    {
      CONSOLE_SCREEN_BUFFER_INFO csbi;
      DWORD nLength, nWritten;
      COORD topleft = {0,0};
      HANDLE hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
      if (hStdout == INVALID_HANDLE_VALUE) 
        return -1;
      if (! GetConsoleScreenBufferInfo(hStdout, &csbi)) 
        return -1;
      nLength = csbi.dwSize.X * csbi.dwSize.Y;
      FillConsoleOutputCharacter(hStdout, (TCHAR) ' ', nLength, topleft, &nWritten);
      FillConsoleOutputAttribute(hStdout, csbi.wAttributes, nLength, topleft, &nWritten);
      SetConsoleCursorPosition(hStdout, topleft);
      return 0;
    }
    #endif
    return w16ConsoleClear();
  }
  return -1;
}

/* ---------------------------------------------------- */

int w32ConSetPos(int col, int row) /* zero based */
{
  if (!constatics.hidden)
  {
    #if (CLIENT_OS == OS_WIN32)
    if (constatics.devpipe)
    {
      char buffer[64];
      if (__pipe_puts(buffer, 
          sprintf(buffer,"\x1B""[%d;%dH", row+1, col+1 )) < 0)
        return -1;
      return 0;
    }
    else if (constatics.nativecons)
    {
      HANDLE hStdout;
      COORD pos = {col,row};
      hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
      if (hStdout == INVALID_HANDLE_VALUE) 
        return -1;
      SetConsoleCursorPosition(hStdout, pos);
      return 0;
    }
    #endif
    return w16ConSetPos(col, row);
  }
  return -1;
}  

/* ------------------------------------------------ */

int w32ConGetPos(int *col, int *row) /* zero based */
{
  if (!constatics.hidden)
  {
    #if (CLIENT_OS == OS_WIN32)
    if (constatics.devpipe)
    {
      int c = 1, r = 1;
      if (__pipe_getsizeorpos(0/*as pos*/,((!col)?(NULL):(&c)), /* 1 based */
                                          ((!row)?(NULL):(&r))) < 0)
      if (c == 0 || r == 0) /* pos will be zero only if no tty */
        return -1;
      if (col) *col = --c;
      if (row) *row = --r;
      return 0;
    }
    else if (constatics.nativecons)
    {
      HANDLE hStdout;
      CONSOLE_SCREEN_BUFFER_INFO csbiInfo;

      hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
      if (hStdout == INVALID_HANDLE_VALUE) 
        return -1;
      if (! GetConsoleScreenBufferInfo(hStdout, &csbiInfo)) 
        return -1;
      if (col) *col=(int)csbiInfo.dwCursorPosition.X;
      if (row) *row=(int)csbiInfo.dwCursorPosition.Y;
      return 0;
    }
    #endif
    return w16ConGetPos(col,row);
  }
  return -1;
}

/* ------------------------------------------------ */

int win32ConIsLiteUI(void) /* do we have a light GUI or a full GUI? */
{
  return 1;
}  

/* ------------------------------------------------ */

struct __cbsendcmd
{
  UINT msg;
  WPARAM wParam;
  LPARAM lParam;
  int usepost;
  int foundcount;
  int ackcount;
  UINT dnetc_cmdmsg;
};

static BOOL CALLBACK __SendCmdEnumFunc(HWND hwnd,LPARAM lParam)
{   
  char wintitle[128];
  if (GetWindowText( hwnd, wintitle, sizeof(wintitle) ))
  {
    int isours = 0, knowsdnet_cmdmsg = 0;
    if ( strcmp( wintitle, W32CLI_CONSOLE_NAME ) == 0 )
      isours = knowsdnet_cmdmsg = 1;
    else if ( strcmp( wintitle, W32CLI_OLD_CONSOLE_NAME ) == 0 )
      isours = 1;
    if (isours)
    {
      int iscui = 0;
      long ver = winGetVersion();
      struct __cbsendcmd *cbsc = (struct __cbsendcmd *)lParam;
      cbsc->foundcount++;
      
      if (ver >= 400 && GetClassName(hwnd,wintitle,sizeof(wintitle)))
        iscui = (!strcmp(wintitle,(ver>=2000)?("ConsoleWindowClass"):("tty")));

      if (!iscui)
      {
        int ishandled = 0;
        if (cbsc->msg == WM_COMMAND)
        {
          if (knowsdnet_cmdmsg && cbsc->dnetc_cmdmsg)
          {
            if (DNETC_WCMD_ACKMAGIC == 
              SendMessage(hwnd,cbsc->dnetc_cmdmsg,cbsc->wParam,cbsc->lParam))
            {
              cbsc->ackcount++;
              ishandled = 1;
            }
          }
          else if (cbsc->wParam == DNETC_WCMD_SHUTDOWN)
          {
            cbsc->usepost = 0;
            if (DNETC_WCMD_ACKMAGIC == SendMessage( hwnd, WM_CLOSE, 0, 0 ))
            {
              cbsc->ackcount++;
              ishandled = 1;
            }
          }
        }
        if (!ishandled)
        {  
          if (cbsc->usepost)
            PostMessage( hwnd, cbsc->msg, cbsc->wParam, cbsc->lParam );
          else if (DNETC_WCMD_ACKMAGIC == SendMessage( hwnd, cbsc->msg, 
                                    cbsc->wParam, cbsc->lParam ))
            cbsc->ackcount++;
        }
      }
      #if (CLIENT_OS == OS_WIN32)
      else if (cbsc->msg == WM_COMMAND && 
                (cbsc->wParam == DNETC_WCMD_RESTART || 
                cbsc->wParam == DNETC_WCMD_SHUTDOWN))
      {
        DWORD pid;
        if (GetWindowThreadProcessId(hwnd,&pid) != 0)
        {
          DWORD event = CTRL_BREAK_EVENT; /* restart */
          if (cbsc->msg == WM_CLOSE)
            event = CTRL_C_EVENT; 
          if (GenerateConsoleCtrlEvent(event,pid))
            cbsc->ackcount++; /* assume it so */
        }
      }
      #endif
    }
  }
  return TRUE;
}

int w32PostRemoteWCMD( int cmd ) /* returns <0 if not found, or */
{                                /* >0 = found+msgfailed, 0=found+msgok */
  int rc = -1;

  HWND otherguy = FindWindow( NULL, W32CLI_CONSOLE_NAME );
  if (otherguy == NULL)
    otherguy = FindWindow( NULL, W32CLI_OLD_CONSOLE_NAME );
  if ( otherguy != NULL)
    rc = +1;

  #if (CLIENT_OS == OS_WIN32)
  if (rc < 0)
  {
    HANDLE hmutex;
    SetLastError(0);
    hmutex = CreateMutex(NULL, FALSE, W32CLI_MUTEX_NAME);
    if (hmutex)
    {
      if (GetLastError() != 0)  /* ie, it exists */
        rc = +2;
      ReleaseMutex( hmutex );
      CloseHandle( hmutex );
    }
  }
  #endif
  #if (CLIENT_OS == OS_WIN32)
  /* this next part is a workaround: for some reason the mutex
     check above doesn't work to detect NT service when wanting 
     to -shutdown etc, but does work for single-instance protection
     check when just starting normally. 
     go figure.
     Detection is backwards compatible for NT service, but not for
     for w9x. However, win9x service will have been found by window 
     name, (and the problem is NT only anyway) so its not an issue.
  */
  if (rc < 0 && cmd != DNETC_WCMD_EXISTCHECK) /* we can't test it on ourselves */
  {
    extern int win32CliDetectRunningService(void); 
    if (win32CliDetectRunningService() > 0) /* <0=err, 0=no, >0=yes */
      rc = +2;
  }
  #endif

  if (rc > 0 /* client is running */
     && cmd != DNETC_WCMD_EXISTCHECK) /* not just exist check */ 
  {
    #if (CLIENT_OS == OS_WIN32)
    /* take away focus from all windows - this is particularly critical
       for win9x console sessions since they hog cputime when active */
    SetForegroundWindow(GetDesktopWindow());
    //SetActiveWindow(GetDesktopWindow()); 
    #endif

    #if (CLIENT_OS == OS_WIN32)
    if (winGetVersion()>=2000)  /* NT Only */
    {
      int svccmd = -1;
      if (cmd == DNETC_WCMD_SHUTDOWN)
        svccmd = SERVICE_CONTROL_STOP;
      else if (cmd == DNETC_WCMD_PAUSE)
        svccmd = SERVICE_CONTROL_PAUSE;
      else if (cmd == DNETC_WCMD_UNPAUSE)
        svccmd = SERVICE_CONTROL_CONTINUE;
      else if (cmd == DNETC_WCMD_RESTART)
        svccmd = CLIENT_SERVICE_CONTROL_RESTART; //128 //service control #
      if (svccmd != -1)
      {                                    
        /* <0=err, 0=none running, >0=msg sent */
        if (win32CliSendServiceControlMessage(svccmd) > 0) /* msg sent */
          rc = 0;                   
      }
    }
    #endif
    
    if (otherguy)
    {
      struct __cbsendcmd cbsc;
      cbsc.msg = WM_COMMAND;
      cbsc.wParam = (WPARAM)cmd;
      cbsc.lParam = 0;
      cbsc.usepost = 1;
      cbsc.foundcount = 0;
      cbsc.ackcount = 0;
      cbsc.dnetc_cmdmsg = RegisterWindowMessage(W32CLI_CONSOLE_NAME);

      cbsc.foundcount = 0;
      if ( EnumWindows( (WNDENUMPROC)__SendCmdEnumFunc, (LPARAM)&cbsc ) )
      {
        rc = 0;
        if (cbsc.foundcount == 0)
          otherguy = NULL;
        if ( cmd == DNETC_WCMD_SHUTDOWN && cbsc.foundcount != cbsc.ackcount)
        {
          DWORD elapsedticks = 0, lasttick = 0;
          while (otherguy && elapsedticks < 5000)
          { 
            DWORD nowticks = GetTickCount();
            if (nowticks == 0)
              nowticks++;
            if (lasttick == 0)
              ; 
            else if (nowticks >= lasttick)
              elapsedticks += (nowticks - lasttick);
            else
              elapsedticks += (nowticks + (1+(0xfffffffful - lasttick)));
            lasttick = nowticks;
   
            otherguy = FindWindow( NULL, W32CLI_CONSOLE_NAME );
            if (otherguy == NULL)
              otherguy = FindWindow( NULL, W32CLI_OLD_CONSOLE_NAME );

            if (otherguy)
            {
              #if (CLIENT_OS == OS_WIN32)
              Sleep(500);
              #else
              Yield();
              #endif
            }
          }
          if (otherguy)
            rc = +1;
        }
      }
    }
  }
  return rc;
}  
