
/*  sendpkt.c
 *  by A. Finkel, P. Lindsay, C. Sheppner
 *  returns Res1 of the reply packet
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <exec/types.h>
#include <exec/memory.h>
#include <libraries/dos.h>
#include <libraries/dosextens.h>
#include <proto/exec.h>
#include <proto/dos.h>

struct MsgPort *CreatePort(UBYTE *, long);
void DeletePort(struct MsgPort *);

#ifdef __cplusplus
}
#endif

LONG sendpkt(struct MsgPort *pid, LONG action, LONG *args, LONG nargs);


LONG sendpkt(
          struct MsgPort *pid, /* process identifier (handler message port) */
          LONG action, /* packet type (desired action) */
          LONG *args,  /* a pointer to argument list */
          LONG nargs /* number of arguments in list */
          )
{
  struct MsgPort *replyport;
  struct StandardPacket *packet;
  LONG count, *pargs, res1;

  res1 = 0;
  replyport = CreatePort(NULL,0L);
  if ( replyport )
    {
    packet = (struct StandardPacket *)AllocMem(
            (long)sizeof(struct StandardPacket),MEMF_PUBLIC|MEMF_CLEAR);
    if ( packet )
      {
      packet->sp_Msg.mn_Node.ln_Name  = (char *)&(packet->sp_Pkt);
      packet->sp_Pkt.dp_Link          = &(packet->sp_Msg);
      packet->sp_Pkt.dp_Port          = replyport;
      packet->sp_Pkt.dp_Type          = action;

      /* copy the args into the packet */
      pargs = &(packet->sp_Pkt.dp_Arg1);      /* address of 1st argument */
      for( count=0; count<nargs; count++ )
         pargs[count] = args[count];

      PutMsg(pid,(struct Message *)packet);   /* send packet */
      WaitPort(replyport);
      GetMsg(replyport);

      res1 = packet->sp_Pkt.dp_Res1;
      FreeMem((char *)packet,(long)sizeof(*packet));
      }
    DeletePort(replyport);
    }
  return(res1);
} /* sendpkt() */
