/* Hey, Emacs, this a -*-C++-*- file !
 *
 * Copyright distributed.net 1997-1998 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
 * 
 * Written by Cyrus Patel <cyp@fb14.uni-mainz.de>
 *
 * ------------------------------------------------------------------
 * POSIX gettimeofday() and significantly more accurate than ftime()
 * caveat: the timezone.tz_dsttime member is not accurate. There is no
 * way to translate the ANSI timezone variable to the dsttime DST_* code.
 * ------------------------------------------------------------------
*/
#ifndef __CLIDOS_TIME_H__
#define __CLIDOS_TIME_H__ "@(#)$Id: cdostime.h,v 1.1.2.1 1999/07/14 22:51:44 cyp Exp $"

#pragma pack(1)
struct timeval  { long tv_sec; long tv_usec; }; /* seconds and microsecs */
struct __timezone {int tz_minuteswest, tz_dsttime; };
#pragma pack();

#undef timezone
#define timezone __timezone

#ifdef __cplusplus
extern "C" {
#endif
  
int gettimeofday( struct timeval *, struct timezone * );

#ifdef __cplusplus
}
#endif

#define DST_NONE  0 /* not on dst */
#define DST_USA   1 /* USA style dst */
#define DST_AUST  2 /* Australian style dst */
#define DST_WET   3 /* Western European dst */
#define DST_MET   4 /* Middle European dst */
#define DST_EET   5 /* Eastern European dst */
#define DST_CAN   6 /* Canada */
#define DST_GB    7 /* Great Britain and Eire */
#define DST_RUM   8 /* Rumania */
#define DST_TUR   9 /* Turkey */
#define DST_AUSTALT 10  /* Australian style with shift in 1986 */

#endif //__CLIDOS_TIME_H__
