; PA-RISC optimized version
; Katsuomi Hamajima - hamajima@ydc.co.jp
;    98/2/16  convert C++ to PA-RISC (base rc5ansi2-b2.cpp)
;    98/2/19  ROUND1 0,1 is precomputed, and use all general registers
;    98/5/8   without r2 and r27
;    98/5/12  not use nested macro for A.09.X
;    98/5/14  change base code to rc5ansi2-bo1.cpp

; $Log$
	
	.CODE

; r0  : always zero
; r1  : target for ADDIL instruction
; r2  : return link
; r19 : fourth temporary register
; r20 : third temporary register
; r21 : second temporary register
; r22 : first temporary register
; r23 : argument word 3
; r24 : argument word 2
; r25 : argument word 1
; r26 : argument word 0
; r27 : data pointer
; r28 : return value
; r29 : return value, static link
; r30 : stack pointer
; r31 : millicode return link

; register variable

; work		%r22
; work		%r21

A1	.REG	%r20
A2	.REG	%r19
Lhi1	.REG	%r18
Lhi2	.REG	%r17
Llo1	.REG	%r16
Llo2	.REG	%r15
eA1	.REG	%r14
eA2	.REG	%r13
eB1	.REG	%r12
eB2	.REG	%r11

rc5uw	.REG	%r26	; = argument word 0
S_not	.REG	%r25
S1	.REG	%r24
S2	.REG	%r23
S1_00	.REG	%r10
S2_00	.REG	%r9
S1_01	.REG	%r8
S2_01	.REG	%r7
S1_02	.REG	%r6
S2_02	.REG	%r5
S1_03	.REG	%r4
S2_03	.REG	%r3
S1_04	.REG	%r28
S2_04	.REG	%r29
S1_05	.REG	%r31
S2_05	.REG	%r1

; offset
plain_hi	.EQU	0
plain_lo	.EQU	4
cypher_hi	.EQU	8
cypher_lo	.EQU	12
L0_hi		.EQU	16
L0_lo		.EQU	20

;Llo1 = ROTL(Llo1 + S1[N] + Lhi1, S1[N] + Lhi1)
;Llo2 = ROTL(Llo2 + S2[N] + Lhi2, S2[N] + Lhi2)
ROUNDXEVEN_TAIL	.MACRO	S1_N,S2_N
	ADDL	S1_N,Lhi1,%r21
	ADDL	S2_N,Lhi2,%r22
	ADDL	Llo1,%r21,Llo1
	ADDL	Llo2,%r22,Llo2
	SUB	%r0,%r21,%r21
	SUB	%r0,%r22,%r22
	MTSAR	%r21
	VSHD	Llo1,Llo1,Llo1
	MTSAR	%r22
	VSHD	Llo2,Llo2,Llo2
	.ENDM

;Lhi1 = ROTL(Lhi1 + S1[N] + Llo1, S1[N] + Llo1)
;Lhi2 = ROTL(Lhi2 + S2[N] + Llo2, S2[N] + Llo2)
ROUNDXODD_TAIL	.MACRO	S1_N,S2_N
	ADDL	S1_N,Llo1,%r21
	ADDL	S2_N,Llo2,%r22
	ADDL	Lhi1,%r21,Lhi1
	ADDL	Lhi2,%r22,Lhi2
	SUB	%r0,%r21,%r21
	SUB	%r0,%r22,%r22
	MTSAR	%r21
	VSHD	Lhi1,Lhi1,Lhi1
	MTSAR	%r22
	VSHD	Lhi2,Lhi2,Lhi2
	.ENDM

;S1[N] = ROTL3(S_not(N) + S1[N-1] + Lhi1)
;S2[N] = ROTL3(S_not(N) + S2[N-1] + Lhi2)
ROUND1EVEN_HEAD	.MACRO	SnotN,S1_N0,S2_N0,S1_N1,S2_N1
	ADDL	S1_N0,SnotN,%r21
	ADDL	S2_N0,SnotN,%r22
	ADDL	Lhi1,%r21,S1_N1
	ADDL	Lhi2,%r22,S2_N1
	SHD	S1_N1,S1_N1,29,S1_N1
	SHD	S2_N1,S2_N1,29,S2_N1
	.ENDM

;S1[N] = ROTL3(S_not(N) + S1[N-1] + Llo1)
;S2[N] = ROTL3(S_not(N) + S2[N-1] + Llo2)
ROUND1ODD_HEAD	.MACRO	SnotN,S1_N0,S2_N0,S1_N1,S2_N1
	ADDL	S1_N0,SnotN,%r21
	ADDL	S2_N0,SnotN,%r22
	ADDL	Llo1,%r21,S1_N1
	ADDL	Llo2,%r22,S2_N1
	SHD	S1_N1,S1_N1,29,S1_N1
	SHD	S2_N1,S2_N1,29,S2_N1
	.ENDM

;S1[N] = ROTL3(S1[N] + S1[N-1] + Lhi1)
;S2[N] = ROTL3(S2[N] + S2[N-1] + Lhi2)
ROUND2EVEN_HEAD	.MACRO	S1_N0,S2_N0,S1_N1,S2_N1
	ADDL	S1_N1,S1_N0,%r21
	ADDL	S2_N1,S2_N0,%r22
	ADDL	Lhi1,%r21,S1_N1
	ADDL	Lhi2,%r22,S2_N1
	SHD	S1_N1,S1_N1,29,S1_N1
	SHD	S2_N1,S2_N1,29,S2_N1
	.ENDM

;S1[N] = ROTL3(S1[N] + S1[N-1] + Llo1)
;S2[N] = ROTL3(S2[N] + S2[N-1] + Llo2)
ROUND2ODD_HEAD	.MACRO	S1_N0,S2_N0,S1_N1,S2_N1
	ADDL	S1_N1,S1_N0,%r21
	ADDL	S2_N1,S2_N0,%r22
	ADDL	Llo1,%r21,S1_N1
	ADDL	Llo2,%r22,S2_N1
	SHD	S1_N1,S1_N1,29,S1_N1
	SHD	S2_N1,S2_N1,29,S2_N1
	.ENDM

;eA1 = ROTL(eA1 ^ eB1, eB1) + (A1 = ROTL3(S1[N] + A1 + Lhi1))
;eA2 = ROTL(eA2 ^ eB2, eB2) + (A2 = ROTL3(S2[N] + A2 + Lhi2))
ROUND3EVEN_HEAD	.MACRO	S1_N,S2_N
	ADDL	S1_N,A1,A1
	ADDL	S2_N,A2,A2
	ADDL	A1,Lhi1,A1
	ADDL	A2,Lhi2,A2
	SHD	A1,A1,29,A1
	SHD	A2,A2,29,A2
	XOR	eA1,eB1,eA1
	XOR	eA2,eB2,eA2
	SUB	%r0,eB1,%r21
	SUB	%r0,eB2,%r22
	MTSAR	%r21
	VSHD	eA1,eA1,eA1
	MTSAR	%r22
	VSHD	eA2,eA2,eA2
	ADDL	eA1,A1,eA1
	ADDL	eA2,A2,eA2
	.ENDM

;eB1 = ROTL(eB1 ^ eA1, eA1) + (A1 = ROTL3(S1[N] + A1 + Llo1))
;eB2 = ROTL(eB2 ^ eA2, eA2) + (A2 = ROTL3(S2[N] + A2 + Llo2))
ROUND3ODD_HEAD	.MACRO	S1_N,S2_N
	ADDL	S1_N,A1,A1
	ADDL	S2_N,A2,A2
	ADDL	A1,Llo1,A1
	ADDL	A2,Llo2,A2
	SHD	A1,A1,29,A1
	SHD	A2,A2,29,A2
	XOR	eB1,eA1,eB1
	XOR	eB2,eA2,eB2
	SUB	%r0,eA1,%r21
	SUB	%r0,eA2,%r22
	MTSAR	%r21
	VSHD	eB1,eB1,eB1
	MTSAR	%r22
	VSHD	eB2,eB2,eB2
	ADDL	eB1,A1,eB1
	ADDL	eB2,A2,eB2
	.ENDM


rc5_unit_func__FP11RC5UnitWork
	.PROC
	.CALLINFO	CALLER,ENTRY_GR=18,SAVE_RP
	.ENTER

; set constant register variable
	ADDIL	LR'aS1-$global$,%r27,%r1
	LDO	RR'aS1-$global$(%r1),S1
	ADDIL	LR'aS2-$global$,%r27,%r1
	LDO	RR'aS2-$global$(%r1),S2
	ADDIL	LR'S_not_n-$global$,%r27,%r1
	LDO	RR'S_not_n-$global$(%r1),S_not

;Llo2 = Llo1 = rc5unitwork->L0.lo
	LDW	L0_lo(rc5uw),Llo1
	COPY	Llo1,Llo2

;Lhi2 = (Lhi1 = rc5unitwork->L0.hi) + 0x01000000
	LDW	L0_hi(rc5uw),Lhi1
	ZDEPI	1,7,1,%r22
	ADDL	Lhi1,%r22,Lhi2

; ROUND1EVEN 0
;S2[0] = S1[0] = ROTL3(S_not(0)) (=0xBF0A8B1D)
	LDW	0*4(S_not),S1_00 ; S_not[0] is prestored 0xBF0A8B1D
	COPY	S1_00,S2_00

;Llo2 = Llo1 = LOTL(Llo1 + S1[0], 29) (S1[0]&31=29)
	ADDL	Llo1,S1_00,Llo1
	SHD	Llo1,Llo1,3,Llo1 ; 32-29=3
	COPY	Llo1,Llo2

; ROUND1ODD 1
;S2[1] = S1[1] = ROTL3(S_not(1) + S1[0] + Llo1) (S_not(1)+S1[0]=0x15235639)
	LDW	1*4(S_not),S1_01 ; S_not[1] is prestored 0x15235639
	ADDL	Llo1,S1_01,S1_01
	SHD	S1_01,S1_01,29,S1_01
	COPY	S1_01,S2_01

;Lhi1 = ROTL(Lhi1 + S1[1] + Llo1, S1[1] + Llo1)
;Lhi2 = ROTL(Lhi2 + S1[1] + Llo1, S1[1] + Llo1)
	ADDL	S1_01,Llo1,%r22
	ADDL	Lhi1,%r22,Lhi1
	ADDL	Lhi2,%r22,Lhi2
	SUB	%r0,%r22,%r22
	MTSAR	%r22
	VSHD	Lhi1,Lhi1,Lhi1
	VSHD	Lhi2,Lhi2,Lhi2

; ROUND1EVEN 2
;S1[2] = ROTL3(S_not(2) + S1[1] + Lhi1)
;S2[2] = ROTL3(S_not(2) + S1[1] + Lhi2)
	LDW	2*4(S_not),S1_02
	ADDL	S1_02,S1_01,S2_02
	ADDL	S2_02,Lhi1,S1_02
	ADDL	S2_02,Lhi2,S2_02
	SHD	S1_02,S1_02,29,S1_02
	SHD	S2_02,S2_02,29,S2_02
	ROUNDXEVEN_TAIL	S1_02,S2_02

; ROUND1ODD 3
	LDW	3*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,S1_02,S2_02,S1_03,S2_03
	ROUNDXODD_TAIL	S1_03,S2_03

; ROUND1EVEN 4
	LDW	4*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,S1_03,S2_03,S1_04,S2_04
	ROUNDXEVEN_TAIL	S1_04,S2_04

; ROUND1ODD 5
	LDW	5*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,S1_04,S2_04,S1_05,S2_05
	ROUNDXODD_TAIL	S1_05,S2_05

; ROUND1EVEN 6
	LDW	6*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,S1_05,S2_05,A1,A2
	STW	A1,6*4(S1)
	STW	A2,6*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 7
	LDW	7*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,7*4(S1)
	STW	A2,7*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 8
	LDW	8*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,8*4(S1)
	STW	A2,8*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 9
	LDW	9*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,9*4(S1)
	STW	A2,9*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 10
	LDW	10*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,10*4(S1)
	STW	A2,10*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 11
	LDW	11*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,11*4(S1)
	STW	A2,11*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 12
	LDW	12*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,12*4(S1)
	STW	A2,12*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 13
	LDW	13*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,13*4(S1)
	STW	A2,13*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 14
	LDW	14*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,14*4(S1)
	STW	A2,14*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 15
	LDW	15*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,15*4(S1)
	STW	A2,15*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 16
	LDW	16*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,16*4(S1)
	STW	A2,16*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 17
	LDW	17*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,17*4(S1)
	STW	A2,17*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 18
	LDW	18*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,18*4(S1)
	STW	A2,18*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 19
	LDW	19*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,19*4(S1)
	STW	A2,19*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 20
	LDW	20*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,20*4(S1)
	STW	A2,20*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 21
	LDW	21*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,21*4(S1)
	STW	A2,21*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 22
	LDW	22*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,22*4(S1)
	STW	A2,22*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 23
	LDW	23*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,23*4(S1)
	STW	A2,23*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND1EVEN 24
	LDW	24*4(S_not),%r22
	ROUND1EVEN_HEAD	%r22,A1,A2,A1,A2
	STW	A1,24*4(S1)
	STW	A2,24*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND1ODD 25
	LDW	25*4(S_not),%r22
	ROUND1ODD_HEAD	%r22,A1,A2,A1,A2
	STW	A1,25*4(S1)
	STW	A2,25*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 0
	ROUND2EVEN_HEAD	A1,A2,S1_00,S2_00
	ROUNDXEVEN_TAIL	S1_00,S2_00

; ROUND2ODD 1
	ROUND2ODD_HEAD	S1_00,S2_00,S1_01,S2_01
	ROUNDXODD_TAIL	S1_01,S2_01

; ROUND2EVEN 2
	ROUND2EVEN_HEAD	S1_01,S2_01,S1_02,S2_02
	ROUNDXEVEN_TAIL	S1_02,S2_02

; ROUND2ODD 3
	ROUND2ODD_HEAD	S1_02,S2_02,S1_03,S2_03
	ROUNDXODD_TAIL	S1_03,S2_03

; ROUND2EVEN 4
	ROUND2EVEN_HEAD	S1_03,S2_03,S1_04,S2_04
	ROUNDXEVEN_TAIL	S1_04,S2_04

; ROUND2ODD 5
	ROUND2ODD_HEAD	S1_04,S2_04,S1_05,S2_05
	ROUNDXODD_TAIL	S1_05,S2_05

; ROUND2EVEN 6
	LDW	6*4(S1),A1
	LDW	6*4(S2),A2
	ROUND2EVEN_HEAD	S1_05,S2_05,A1,A2
	STW	A1,6*4(S1)
	STW	A2,6*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 7
	LDW	7*4(S1),%r21
	LDW	7*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,7*4(S1)
	STW	A2,7*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 8
	LDW	8*4(S1),%r21
	LDW	8*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,8*4(S1)
	STW	A2,8*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 9
	LDW	9*4(S1),%r21
	LDW	9*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,9*4(S1)
	STW	A2,9*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 10
	LDW	10*4(S1),%r21
	LDW	10*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,10*4(S1)
	STW	A2,10*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 11
	LDW	11*4(S1),%r21
	LDW	11*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,11*4(S1)
	STW	A2,11*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 12
	LDW	12*4(S1),%r21
	LDW	12*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,12*4(S1)
	STW	A2,12*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 13
	LDW	13*4(S1),%r21
	LDW	13*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,13*4(S1)
	STW	A2,13*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 14
	LDW	14*4(S1),%r21
	LDW	14*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,14*4(S1)
	STW	A2,14*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 15
	LDW	15*4(S1),%r21
	LDW	15*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,15*4(S1)
	STW	A2,15*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 16
	LDW	16*4(S1),%r21
	LDW	16*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,16*4(S1)
	STW	A2,16*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 17
	LDW	17*4(S1),%r21
	LDW	17*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,17*4(S1)
	STW	A2,17*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 18
	LDW	18*4(S1),%r21
	LDW	18*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,18*4(S1)
	STW	A2,18*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 19
	LDW	19*4(S1),%r21
	LDW	19*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,19*4(S1)
	STW	A2,19*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 20
	LDW	20*4(S1),%r21
	LDW	20*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,20*4(S1)
	STW	A2,20*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 21
	LDW	21*4(S1),%r21
	LDW	21*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,21*4(S1)
	STW	A2,21*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 22
	LDW	22*4(S1),%r21
	LDW	22*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,22*4(S1)
	STW	A2,22*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 23
	LDW	23*4(S1),%r21
	LDW	23*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,23*4(S1)
	STW	A2,23*4(S2)
	ROUNDXODD_TAIL	A1,A2

; ROUND2EVEN 24
	LDW	24*4(S1),%r21
	LDW	24*4(S2),%r22
	ROUND2EVEN_HEAD	%r21,%r22,A1,A2
	STW	A1,24*4(S1)
	STW	A2,24*4(S2)
	ROUNDXEVEN_TAIL	A1,A2

; ROUND2ODD 25
	LDW	25*4(S1),%r21
	LDW	25*4(S2),%r22
	ROUND2ODD_HEAD	%r21,%r22,A1,A2
	STW	A1,25*4(S1)
	STW	A2,25*4(S2)
	ROUNDXODD_TAIL	A1,A2

;eA1 = rc5unitwork->plain.lo + (A1 = ROTL3(S1[0] + A1 + Lhi1))
;eA2 = rc5unitwork->plain.lo + (A2 = ROTL3(S2[0] + A2 + Lhi2))
	LDW	plain_lo(rc5uw),%r22
	ADDL	S1_00,A1,A1
	ADDL	S2_00,A2,A2
	ADDL	A1,Lhi1,A1
	ADDL	A2,Lhi2,A2
	SHD	A1,A1,29,A1
	SHD	A2,A2,29,A2
	ADDL	%r22,A1,eA1
	ADDL	%r22,A2,eA2

;Llo1 = ROTL(Llo1 + A1 + Lhi1, A1 + Lhi1)
;Llo2 = ROTL(Llo2 + A2 + Lhi2, A2 + Lhi2)
	ROUNDXEVEN_TAIL	A1,A2

;eB1 = rc5unitwork->plain.hi + (A1 = ROTL3(S1[1] + A1 + Llo1))
;eB2 = rc5unitwork->plain.hi + (A2 = ROTL3(S2[1] + A2 + Llo2))
	LDW	plain_hi(rc5uw),%r22
	ADDL	S1_01,A1,A1
	ADDL	S2_01,A2,A2
	ADDL	A1,Llo1,A1
	ADDL	A2,Llo2,A2
	SHD	A1,A1,29,A1
	SHD	A2,A2,29,A2
	ADDL	%r22,A1,eB1
	ADDL	%r22,A2,eB2

;Lhi1 = ROTL(Lhi1 + A1 + Llo1, A1 + Llo1)
;Lhi2 = ROTL(Lhi2 + A2 + Llo2, A2 + Llo2)
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 2
	ROUND3EVEN_HEAD	S1_02,S2_02
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 3
	ROUND3ODD_HEAD	S1_03,S2_03
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 4
	ROUND3EVEN_HEAD	S1_04,S2_04
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 5
	ROUND3ODD_HEAD	S1_05,S2_05
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 6
	LDW	6*4(S1),%r21
	LDW	6*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 7
	LDW	7*4(S1),%r21
	LDW	7*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 8
	LDW	8*4(S1),%r21
	LDW	8*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 9
	LDW	9*4(S1),%r21
	LDW	9*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 10
	LDW	10*4(S1),%r21
	LDW	10*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 11
	LDW	11*4(S1),%r21
	LDW	11*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 12
	LDW	12*4(S1),%r21
	LDW	12*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 13
	LDW	13*4(S1),%r21
	LDW	13*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 14
	LDW	14*4(S1),%r21
	LDW	14*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 15
	LDW	15*4(S1),%r21
	LDW	15*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 16
	LDW	16*4(S1),%r21
	LDW	16*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 17
	LDW	17*4(S1),%r21
	LDW	17*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 18
	LDW	18*4(S1),%r21
	LDW	18*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 19
	LDW	19*4(S1),%r21
	LDW	19*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 20
	LDW	20*4(S1),%r21
	LDW	20*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 21
	LDW	21*4(S1),%r21
	LDW	21*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

; ROUND3EVEN 22
	LDW	22*4(S1),%r21
	LDW	22*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22
	ROUNDXEVEN_TAIL	A1,A2

; ROUND3ODD 23
	LDW	23*4(S1),%r21
	LDW	23*4(S2),%r22
	ROUND3ODD_HEAD	%r21,%r22
	ROUNDXODD_TAIL	A1,A2

;eA1 = ROTL(eA1 ^ eB1, eB1) + (A1 = ROTL3(S1[24] + A1 + Lhi1))
;eA2 = ROTL(eA2 ^ eB2, eB2) + (A2 = ROTL3(S2[24] + A2 + Lhi2))
	LDW	24*4(S1),%r21
	LDW	24*4(S2),%r22
	ROUND3EVEN_HEAD	%r21,%r22

	LDW	cypher_lo(rc5uw),%r25
	LDW	cypher_hi(rc5uw),%r26
;if (rc5unitwork->cypher.lo == eA1 &&
	COMB,<>,N	%r25,eA1,next_check

;rc5unitwork->cypher.hi == ROTL(eB1 ^ eA1, eA1) +
;ROTL3(S1[25] + A1 + ROTL(Llo1 + A1 + Lhi1, A1 + Lhi1)))	return 1
	XOR	eB1,eA1,eB1
	SUB	%r0,eA1,eA1
	MTSAR	eA1
	VSHD	eB1,eB1,eB1
	ADDL	A1,Lhi1,Lhi1
	ADDL	Llo1,Lhi1,Llo1
	SUB	%r0,Lhi1,Lhi1
	MTSAR	Lhi1
	VSHD	Llo1,Llo1,Llo1
	ADDL	A1,Llo1,Llo1
	LDW	25*4(S1),%r21
	ADDL	%r21,Llo1,Llo1
	SHD	Llo1,Llo1,29,Llo1
	ADDL	eB1,Llo1,eB1
	COMB,<>,N	%r26,eB1,next_check
	B	exit_function
	LDI	1,%r28

next_check
;if (rc5unitwork->cypher.lo == eA2 &&
	COMB,<>,N	%r25,eA2,return_0

;rc5unitwork->cypher.hi == ROTL(eB2 ^ eA2, eA2) +
;ROTL3(S2[25] + A2 + ROTL(Llo2 + A2 + Lhi2, A2 + Lhi2)))	return 2
	XOR	eB2,eA2,eB2
	SUB	%r0,eA2,eA2
	MTSAR	eA2
	VSHD	eB2,eB2,eB2
	ADDL	A2,Lhi2,Lhi2
	ADDL	Llo2,Lhi2,Llo2
	SUB	%r0,Lhi2,Lhi2
	MTSAR	Lhi2
	VSHD	Llo2,Llo2,Llo2
	ADDL	A2,Llo2,Llo2
	LDW	25*4(S2),%r22
	ADDL	%r22,Llo2,Llo2
	SHD	Llo2,Llo2,29,Llo2
	ADDL	eB2,Llo2,eB2
	COMB,<>,N	%r26,eB2,return_0
	B	exit_function
	LDI	2,%r28

return_0
;return 0
	COPY	%r0,%r28

exit_function
	.LEAVE
	.PROCEND
	.EXPORT	rc5_unit_func__FP11RC5UnitWork,ENTRY,ARGW0=GR,RTNVAL=GR


	.DATA
	.IMPORT	$global$,DATA

; extern u32 S_not_n[26];
	.IMPORT	S_not_n,DATA

; static u32 S1[26], S2[26];
aS1	.BLOCK	104
aS2	.BLOCK	104

	.END

