/* Hey, Emacs, this a -*-C++-*- file !
 *
 * Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
 *
 * ******************** THIS IS CONFIDENTIAL SOURCE *******************
*/

#ifndef __PACKETS_H__
#define __PACKETS_H__ "@(#)$Id: packets.h,v 1.24.2.7 1999/12/16 02:15:04 cyp Exp $"

#if (!defined(PROXYTYPE) && !defined(CONFIDENTIAL_SOURCE_OK))
#error packets.h is CONFIDENTIAL SOURCE and can only be included from other confidential source
#endif

#include "ogr.h"

#define PACKET_VERSION  0x03

#ifndef MIPSpro
# pragma pack(1)                   // no padding allowed
#endif /* ! MIPSpro */

typedef enum
{
  OP_REQUEST,                     //     obsolete (use OP_REQUEST_MULTI)
  OP_DATA,                        //     transition (use OP_BIGDATA)
  OP_SUCCESS,                     //     obsolete (use OP_SUCCESS_MULTI)
  OP_DONE,                        //     obsolete (use OP_DONE_MULTI)
  OP_FAIL,                        //     never used
  OP_MAX,                         //     never used
  OP_PERMISSION = 42,             // ==> current: full<>master only
  OP_DONE_NOCLOSE,                //     obsolete (use OP_DONE_MULTI)
  OP_DONE_NOCLOSE_ACK,            //     transition (use OP_BIGDONE_ACK)
  OP_PROXYCHANGE,                 // ==> current: full<>master only
  OP_PERREQUEST = 50,             //     obsolete (use OP_PERREQUEST_MULTI)
  OP_PERDATA,                     //     transition (use OP_BIGDATA)
  OP_SCRAMREQUEST = 69,           // ==> current: client->full only
  OP_SCRAM = 96,                  // ==> current: client<-full only
  OP_SUCCESS_ACK,                 // ==> current
  OP_GETPROXYSTATUS = 100,        // ==> nodezero/master->full/master
  OP_REQUEST_MULTI,               //     obsolete (use OP_BIGREQUEST_MULTI)
  OP_SUCCESS_MULTI,               // ==> current
  OP_DONE_MULTI,                  //     transition (use OP_BIGDONE_MULTI)
  OP_PERREQUEST_MULTI,            //     transition (use OP_BIGPERREQUEST_MULTI)
  OP_BIGREQUEST_MULTI,            // ==> current
  OP_BIGDATA,                     // ==> current
  OP_BIGDONE_MULTI,               // ==> current
  OP_BIGDONE_ACK,                 // ==> current
  OP_BIGPERREQUEST_MULTI          // ==> current
} rc5_op_t;


typedef enum
{
  IDCONTEST_ANY = 0,
  IDCONTEST_DES = 1,        /* obsolete */
  IDCONTEST_RC556,          /* obsolete */
  IDCONTEST_RC564,
  IDCONTEST_DESII,          /* also for DESIII */
  IDCONTEST_OGR,            /* covers all N-mark rulers */
  IDCONTEST_CSC             /* currently 56 bit */
} contest_id_t;


typedef union
{
  struct {
    struct { u32 hi,lo; } key;    /* starting key */
    struct { u32 hi,lo; } iv;       /* initialization vector */
    struct { u32 hi,lo; } plain;    /* plaintext we're searching for */
    struct { u32 hi,lo; } cypher;   /* cyphertext */
    u32  iterations;                /* number of iterations (the low 32bits) */
  } crypto;                         /* RC5, DES, CSC */
  struct {
    Stub stub;                      /* stub to work on */
    struct { u32 hi,lo; } nodes;    /* number of nodes completed */
    u32  iterations;                /* number of iterations */
  } ogr;                            /* OGR */
} workunit_t;

typedef struct
{
  u32  op;          /* operation code                             }--|  */
  workunit_t work;  /* {key,iv,plain,cypher,iter} | {stub,nodes,iter}|  */
  char id[64];      /* identifier (email address)                    |  */
  u32  ip;          /* IP Address (proxy filled)                     |  */
  u32  iterationshi;/* number of iterations (the high 32bits)        |  */
  char other[20];   /* extra space                                   |  */
  u32  rc564closed; /* legacy:htonl(0x1337F00D) if rc564 over        |  */    
  u32  desclosed;   /* legacy:htonl(0xBEEFF00D) if des over          |  */
  u32  contestid;   /* contest identifier                            |  */
  u32  build;       /* client build number                           |  */
  u32  os;          /* client OS - see defines                       |  */
  u32  cpu;         /* client CPU - see defines                      |  */
  u32  version;     /* packet version; PACKET_VERSION             }--|  */
} workpacket_t;

#define PROXYCAPS_NUMCONTESTS     32 /* # of contests in scrampacket_t.caps */
#define PROXYCAPS_SUPPORTED     0x01 /* proxy knows about this contest */
#define PROXYCAPS_CONTESTCLOSED 0x02 /* this contest is closed */
#define PROXYCAPS_NONEAVAILABLE 0x04 /* proxy does not have blocks */

typedef struct
{
  u32  op;           /* OP_SCRAM, OP_SCRAMREQUEST, OP_PERMISSION */
  u32  timefix;      /* proxy's time_t sent to client */
  u32  authkey;      /* key with which we finish communications */
  char reserved[28]; /* pad out the rest of the workunit_t space */
  char id[64];       /* proxy message */
  u32  ip;           /* proxy's IP Address (proxy filled) sent to client */
  u32  schedupdate;  /* time_t (absolute!) the client should do an update */
  char caps[PROXYCAPS_NUMCONTESTS]; /* 1 char per contest  */
  u32  build;        /* to client:proxy build, from client: client build */
  u32  reserved3[2]; /* unused - OS/CPU */
  u32  version;      /* packet version; PACKET_VERSION */
} scrampacket_t;
  
typedef struct      
{                    /* only to/from nodezero or master or localhost */
  u32  op;           /* OP_GETPROXYSTATUS */
  u32  uptime;       /* proxy's uptime */
  u32  currtime;     /* time(NULL) */
  char opername[28]; /* eg "dbaker" [should be a valid @distributed.net addr] */
  char status[64];   /* status string for this contest */
  u32  ip;           /* advertising address */
  u32  contestid;    /* contest the .status is valid for */
  char dnsname[28];  /* eg "proxy1.hou.tx.us" */
  u32  lastcheckin;  /* (full server only) absolute time */
  u32  build;        /* eg 3062 (==306 fullserver) */
  u32  os;           /* proxy OS - see cputypes.h */
  u32  cpu;          /* proxy CPU - see cputypes.h */
  u32  version;      /* packet version; PACKET_VERSION */
} pstatuspacket_t;   

typedef struct
{
  union {
    workpacket_t workdata;
    scrampacket_t scramdata;
    pstatuspacket_t proxystatus;
  } pkt;
  u32  checksum;    /* pre scrambled checksum <--------------|    }--|  */
  u32  scramble;    /* the key we're using to scrambling this <------|  */
} net_packet_t;

#ifndef MIPSpro
# pragma pack()
#endif /* ! MIPSpro */

#endif /* __PACKETS_H__ */

