/*
 * This header file prototypes everything needed by 
 * the macos support specific code. 
 * This stuff is all INTERNAL to platforms:macos.
 *
*/

#include <TextUtils.h>
#include <SIOUX.h>
#include <Devices.h>
#include <Gestalt.h>
#include <LowMem.h>
#include <Sound.h>

#include "client_defs.h" /* functions visible to the ./common/ code */

#include <SIOUXWindows.h>

/* -------------------------------------------------------------- */

#define	HiWrd(aLong)	(((aLong) >> 16) & 0xFFFF)
#define	LoWrd(aLong)	((aLong) & 0xFFFF)
#define  TICKS ((unsigned long *)0x16a)
#define  microuptime ((*TICKS) * (unsigned long long)16667)

enum
{
	kAlertStartupError		= 129  /* DITL plus DLOG resource */
};

enum
{
	kErrorStrings			= 128,		/* Errorstrings -> STR# 128 */
	kWeirdSystemString		= 1,
	kUnsupportedOSString		= 2,
	kResourceMissingString	= 3,
	kMemAllocFailString		= 4
};

enum
{
	rMenuBar				= 128				/* application's menu bar -> MBAR resource*/
};

enum
{
	mApple					= 128,				/* Apple menu -> MENU 128*/
	iAbout					= 1
};

enum
{
	mFile					= 129,				/* File menu -> MENU 129*/
	iPause		   	= 1,
	/* Separator line here */
	iQuit					= 3
};

enum
{
	mClient					= 130,				/* Commands menu  -> MENU 130*/
	iFetch   			= 1,
	iFlush				= 2,
	iUpdate				= 3,
	/* Separator line here */
	/* Benchmark submenu here */
	iTest					= 6,
	/* Separator line here */
	iConfig				= 8
};

enum
{
	mBenchSub					= 150,				/* Benchmark submenu  -> MENU 150*/
	iBenchAll			= 1,
	/* Separator line here */
	iBenchRC5			= 3,
	iBenchDES			= 4,
	iBenchOGR			= 5,
	iBenchCSC			= 6
};
