// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: RC5App.cpp,v $
// Revision 1.29.2.1  1999/05/18 14:50:46  sampo
// sync in changes from Dev branch to eliminate >8.5.1 warning and a compiler warning
//
// Revision 1.29  1999/05/08 01:56:59  dicamillo
// Use new THREADSTARTED event;  Change "keys" to u64 for InitializeThreadProgress
//
// Revision 1.28  1999/04/29 05:57:33  dicamillo
// Update for changes to Problem methods GetKeysDone and GetResultCode.
//
// Revision 1.27  1999/04/10 07:20:41  sampo
// fix comments.  MacCVS shouldn't be breaking this anymore :(
//
// Revision 1.26  1999/04/09 14:23:51  sampo
// partial fix to accomodate changes to problem.h
// To ponder: stuff we need is not public anymore.
//
// Revision 1.25  1999/04/06 23:18:33  sampo
// adapt to changes in structs, removal of RC5Result.  Please check my work here.
//
// Revision 1.24  1999/03/23 06:14:58  dicamillo
// Changed so initial ReadConfig is done by ParseCommandline.
//
// Revision 1.23  1999/01/27 00:22:21  sampo
// Commented out calls to  ValidateConfig() as it no longer exitsts.
//
// Revision 1.22  1999/01/17 23:50:45  dicamillo
// Add comments to indicate ValidateConfig no longer does anything.
//
// Revision 1.21  1999/01/17 18:05:23  sampo
// 3rd round fba changes
//
// Revision 1.20  1999/01/17 09:18:02  dicamillo
// Issue multiple CPU message only when no settings present.
//
// Revision 1.19  1999/01/16 22:42:52  sampo
// 2nd round fba changes, kill call to Debugger(), restore order
//
// Revision 1.18  1999/01/16 19:18:57  sampo
// first round of FBA changes
//
// Revision 1.17  1999/01/10 05:57:33  dicamillo
// Changes in settings processing.  Also, support RestartRequestTrigger.
//
// Revision 1.16  1999/01/09 03:48:10  dicamillo
// Set gHasAppearance101.
//
// Revision 1.15  1999/01/08 03:20:16  dicamillo
// "Use MP Support" is off by default; issue warning on true MP machines.
//
// Revision 1.14  1999/01/07 03:21:29  dicamillo
// Re-init client and re-read .ini file before run; check for "too new" OS.
//
// Revision 1.13  1999/01/06 22:22:14  dicamillo
// Support PPC prototype Macs and ability to abort active socket open.
//
// Revision 1.12  1999/01/06 06:55:16  dicamillo
// Change DES yield routine; fix DES MP task bug.
//
// Revision 1.11  1999/01/03 02:24:33  dicamillo
// Don't update GUI settings before GUI init.  Duh!
//
// Revision 1.10  1999/01/02 22:46:40  dicamillo
// Fix settings bug for numcpu and cputype.
//
// Revision 1.9  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.8  1999/01/01 01:41:21  vetere
// Copyright date is now stored in a resource.
//
// Revision 1.7  1999/01/01 01:22:42  vetere
// About Box modifications.
//
// Revision 1.6  1998/12/31 08:21:20  dicamillo
// Added event support for runs; support use_MP settings variable.
//
// Revision 1.5  1998/12/30 07:38:39  dicamillo
// Added event support for Fetch, Flush, and Test.
//
// Revision 1.4  1998/12/29 09:32:54  dicamillo
// Added macConOut called by ConOut.  Added initial client event support.
//
// Revision 1.3  1998/12/25 02:54:33  vetere
// Compensated for Silby edits on WriteConfig and ValidateConfig functions.
// Remvoed *core_name, which emitted a warning.
//
// Revision 1.2  1998/12/15 07:02:21  dicamillo
// Use "_" instead of "/" in Mac header file names for CVS.
//
// Revision 1.1  1998/12/15 06:15:48  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *RC5App_cpp(void) {
return "@(#)$Id: RC5App.cpp,v 1.29.2.1 1999/05/18 14:50:46 sampo Exp $"; }
#endif

#include "macdefs.h"
#include <sys_time.h>
#include <Power.h>
#include <MP.h>
#include <MixedMode.h>
#include "WASTE.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"
#include "DrawGUI.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WTextView.h"
#include "TextRscView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "ViewWindow.h"
#include "GUIWindow.h"
#include "WTextDisplayWindow.h"
#include "TextRscWindow.h"
#include "client.h"
#include "Mac_Client.h"
#include "RC5Dialogs.h"
#include "settings.h"
#include "my_settings.h"
#include "RC5App.h"
#include "console_api.h"
#include "msgdefs.h"
#include "quitapps.h"
#include "memutil.h"
#include "net.h"
#include "cpucheck.h"
#include "version.h"
#include "triggers.h"
#include "confrwv.h"
#include "clievent.h"
#include "problem.h"
#include "probman.h"
#include "modereq.h"

#include "DrawGUI.h"

//uncomment this to record events from clievent in the log window
//#define CLIENT_EVENT_DEBUG

#define PPC_DES_FACTOR 2.338

#define SHORT_INTERVAL 4
#define LONG_INTERVAL 450

// from client.cpp
void PrintBanner(const char *dnet_id,int level,int restarted);

RC5App *theApp;
FSSpec settingsSpec;				// settings file FSSpec
Boolean have_settings_spec = false;	// true when FSSpec defined
Boolean useCPUdialog;
Boolean pending_console_data = false;
unsigned long *last_event_tick;
Boolean netio_active = false;
FCBPBRec myFCB;
Boolean Mac_PPC_prototype = false;

static char *desc_tab[] = {
	"-test", "Test",
	"-benchmarkRC5", "Benchmark RC5",
	"-benchmarkDES", "Benchmark DES",
	"-fetch", "Fetch",
	"-flush", "Flush",
	"-update", "Update",
	"-help", "",
	"-runoffline", "Run Offline",
	"-runbuffers", "Run Buffers",
	0, 0
	};

unsigned long last_event_yield;			// YieldToMain control data
short MP_active = 0;
volatile s32 ThreadIsDone[2*MAC_MAXCPUS];

PointerList *socket_list;

#ifdef powerc
RoutineDescriptor RC5App::HandleOAPPRD =
	BUILD_ROUTINE_DESCRIPTOR(uppAEEventHandlerProcInfo, HandleOAPP);
RoutineDescriptor RC5App::HandleODOCRD =
	BUILD_ROUTINE_DESCRIPTOR(uppAEEventHandlerProcInfo, HandleODOC);
RoutineDescriptor RC5App::HandlePDOCRD =
	BUILD_ROUTINE_DESCRIPTOR(uppAEEventHandlerProcInfo, HandlePDOC);
RoutineDescriptor RC5App::HandleQUITRD =
	BUILD_ROUTINE_DESCRIPTOR(uppAEEventHandlerProcInfo, HandleQUIT);

RoutineDescriptor RC5App::abouttextRD =
	BUILD_ROUTINE_DESCRIPTOR(uppUserItemProcInfo, about_user_text);

enum {
	GNEProcInfo = kPascalStackBased
					| RESULT_SIZE(kNoByteCode)
	};

#endif

extern Boolean netinit_ok, netinit_done;
extern Boolean gHasAppearance, gHasAppearance101;
extern short gFetchAdjustment;
extern ControlHandle gBuffersGroupBoxControl;
extern Boolean socket_connect_active;


unsigned long last_active_tick = 0;
#define TICKS ((unsigned long *)0x16a)
#define LMGetEventQueue()	( (QHdrPtr) 0x014A)

u32 RC5_timeslice_to_use;
u32 DES_timeslice_to_use;	// Note: for current (Meggs) core, this has no effect
u32 DES_ticks_to_use;
u32 DES_yield_ticks;
Boolean timing_core = false;

Boolean haveMP = 0;				// MP API is present
MPCriticalRegionID MP_count_region = 0;

ClientInfo client_info;
char saved_server_message[256];
char final_test_message[128];
extern short gCurrentBuffersInfo;
Boolean need_completed_message;
unsigned long long thread_finished_totals[MAC_MAXCPUS];
Boolean doing_bench_output = false;

void main(void) {
OSErr rc;
SysEnvRec theWorld;
Boolean has_color;
short i;

// Initialize heap before any allocations
									// check for color QuickDraw
SysEnvirons(1, &theWorld);		
has_color = (theWorld.hasColorQD != 0);
									// make sure the stack is the same size
									// whether or not the Mac has color QD
if (!has_color) {					// add 24K to match Color QD Macs
	SetApplLimit(GetApplLimit() - 24*1024);
	}
MaxApplZone();						// set-up for efficient storage use
for (i=0; i < 7; i++) MoreMasters();

// Create the application
try {
	theApp = new RC5App();
	}
catch (...) {
	ExitToShell();
	}

rc = theApp->InitApp(false);

if (rc == noErr) {
	// Initialize TSM for WText window
	WEInstallTSMHandlers();
	if (cs.resume) {
		waitcursor = ibeamcursor = false;
		mySetCursor(kArrowCursor);
		// Note: InitApp already read current settings
		switch((theApp->theThreadApp)->offlinemode) {
			case 1:
				theApp->run_client("-runoffline", kRunOfflineItem);
				break;
			case 2:
				theApp->run_client("-runbuffers", kRunBuffersItem);
				break;
			default:
				theApp->run_client("", kRunItem);
				break;
			}
		}
	theApp->Run();
	theApp->update_log(true);
	}
theApp->EndApp();
delete theApp;
}

// Initializer
// Note: should not contain any initializations that may fail

RC5App::RC5App(void)
{
theThreadApp = 0;
done_pending = 0;
current_check_item = current_diamond_item = 0;

// Mac settings
ds.resplevel = 2;
ds.customticks = HIGH_TICKS;
ds.console_log_name[0] = 0;  // initialized from resource
ds.writelog = false;
ds.resume = false;
ds.all_fonts = false;
ds.maxcpu = true;
ds.max_cpu_start_time = 1.5;
ds.max_cpu_end_time = 10.0;
calculate_yield_times(&ds);
ds.auto_fg = false;
ds.auto_fg_delay = 15.0;
ds.use_MP = false;

// Mac settings not obtained from dialogs
ds.log_window_h_loc = ds.log_window_v_loc = 0;
ds.log_window_width = ds.log_window_height = 0;
ds.log_window_visible = false;
ds.log_window_info_stored = false;
ds.gui_window_h_loc = ds.gui_window_v_loc = 0;
ds.gui_window_width = ds.gui_window_height = 0;
ds.gui_window_visible = false;
ds.gui_window_info_stored = false;
strcpy(ds.font_name, "Monaco");
ds.font_size = 9;
ds.font_style = normal;
ds.buffers_contest = 0;

did_init_settings = false;
socket_list = 0;
last_event_tick = 0;
mouse_moved_ticks = LMGetTicks();
theWTextDisplayWindow = 0;
#ifdef MAC_GUI
theGUIWindow = 0;
#endif
theHelpWindow = 0;

help_window_info_stored = false;
did_gui_init = false;
saved_server_message[0] = 0;
memset(thread_finished_totals, 0, sizeof(thread_finished_totals));
}

// Destructor
RC5App::~RC5App(void)
{
}

OSErr RC5App::InitApp(Boolean init_heap)
{
Boolean haveSystem7;
short major_version;
OSErr rc;
unsigned long gestalt_flags;
unsigned long aeventflags;
// unsigned long gestalt_sysinfo;
Str255 ResString;
short count;
Rect windowRect;
Handle version, ppcp_handle;
char verskind[16];
short fnum;
//int config_result;
Boolean had_mac_settings;

// Do AppObject initialization
rc = AppObject::InitApp(init_heap);
if (rc != noErr) {
	return(rc);
	}
// check for customized version of client for PPC prototype Macs
// Set Mac_PPC_Prototype true if 'PPCP' 128 resource exists (but don't load it)
SetResLoad(false);
ppcp_handle = Get1Resource('PPCP', 128);
SetResLoad(true);
Mac_PPC_prototype = ppcp_handle != 0;

// allocate console storage now
InstallConsole(0);

// Check we're running in a suitable envioronment

// Copy info for GUI window code
#ifdef MAC_GUI
gHasAppearance = haveAppearance;	// these set by AppObject::InitApp
gHasAppearance101 = haveAppearance101;
#endif

// We need System 7 or later
haveSystem7 = false;
if (gestaltavail) {
	rc = GetSystemVersion(&major_version, system_version);
	if (rc == noErr) {
		haveSystem7 = major_version >= 7;
		}
	}

if (!haveSystem7) {
	#ifdef MAC_GUI
	mySetCursor(kArrowCursor);
	show_error_string(kSysVersError, 0);
	#endif
	return(10);
	}

// Issue warning for post-8.5.1 systems (temporary)
//#ifdef MAC_GUI
//rc = Gestalt(gestaltSystemVersion, (long *)&gestalt_sysinfo);
//if (rc == 0) {
//	if (gestalt_sysinfo > 0x851) {
//		mySetCursor(kArrowCursor);
//		show_error_string(kSysTooNewError, 0);
//		}
//	}
//#endif

#ifdef powerc
	// Check for MP API
	haveMP = MPLibraryIsLoaded();
/*
	#if defined(MULTITHREAD)
	if (!haveMP) {		// mt client on machine without API
		mySetCursor(kArrowCursor);
		show_error_string(kMPError, 0);
		return(12);
		}
	#endif
*/
#else
	haveMP = false;
#endif

if (haveMP) {
	rc = MPCreateCriticalRegion(&MP_count_region);
	if (rc != noErr) {
		#ifdef MAC_GUI
		mySetCursor(kArrowCursor);
		show_error_string(kMPInitError, 0);
		#endif
		return(13);
		}
	}

#ifdef powerc
useCPUdialog = true;
#else
useCPUdialog = false;
#endif

// install Apple Event Handlers
	//determine availability of Apple events
aeventavail = 0;
aeventflags = 0;
if (gestaltavail) {
	rc = Gestalt(gestaltAppleEventsAttr, (long *)&aeventflags);
	aeventavail = (rc == noErr);
	if (!aeventavail) aeventflags = 0;
	}
if (aeventavail) {
#ifdef powerc
	rc = AEInstallEventHandler(kCoreEventClass, kAEOpenApplication,
						&HandleOAPPRD, (long)this, false);
	rc = AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments,
						&HandleODOCRD, (long)this, false);
	rc = AEInstallEventHandler(kCoreEventClass, kAEPrintDocuments,
						&HandlePDOCRD, (long)this, false);
	rc = AEInstallEventHandler(kCoreEventClass, kAEQuitApplication,
						&HandleQUITRD, (long)this, false);
#else
	rc = AEInstallEventHandler(kCoreEventClass, kAEOpenApplication,
						(AEEventHandlerUPP)HandleOAPP, (long)this, false);
	rc = AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments,
						(AEEventHandlerUPP)HandleODOC, (long)this, false);
	rc = AEInstallEventHandler(kCoreEventClass, kAEPrintDocuments,
						(AEEventHandlerUPP)HandlePDOC, (long)this, false);
	rc = AEInstallEventHandler(kCoreEventClass, kAEQuitApplication,
						(AEEventHandlerUPP)HandleQUIT, (long)this, false);
#endif
	}

// Check if we have the Power Manager and the CPU can idle
CPU_can_idle = false;
rc = Gestalt(gestaltPowerMgrAttr, (long *)&gestalt_flags);
if (rc == noErr) {
	CPU_can_idle = (gestalt_flags & (1 << gestaltPMgrCPUIdle)) != 0;
	}

// Install the Gestalt selector for the event watcher
// last_event_tick will be a pointer to the tick count for the last event
rc = Gestalt('RC5m', (long *)(&last_event_tick));
if (rc != noErr) {
	rc = InstallGNEWatcher();
	if (rc == noErr) {
		rc = Gestalt('RC5m', (long *)(&last_event_tick));
		}
	if (rc != noErr) {
		#ifdef MAC_GUI
		mySetCursor(kArrowCursor);
		show_error_string(kGestaltInstallError, 0);
		#endif
		return(14);
		}
	}

// get FCB for this program
memset(&myFCB, 0, sizeof(FCBPBRec));
myFCB.ioRefNum = LMGetCurApRefNum();
rc = PBGetFCBInfo(&myFCB, 0);
if (rc != noErr) {
	#ifdef MAC_GUI
	mySetCursor(kArrowCursor);
	show_error_string(kGetFCBError, 0);
	#endif
	return(15);
	}

// Initialize networking sockets
try {
	socket_list = new PointerList;
	}
catch (...) {
	#ifdef MAC_GUI
	mySetCursor(kArrowCursor);
	show_error_string(kMemInitError, 0);
	#endif
	return(16);
	}

// Initialize memutils for network code
InitMemUtil(40000, 40000);

// Finish initializing Mac default settings
GetRString(ResString, kConsoleLogName);
p2cstr(ResString);
ResString[31] = 0;
strcpy(ds.console_log_name, (char *)ResString);

// Get current Mac settings
rc = find_prefs_file(kSignature, kPrefsSignature, &settingsSpec, &myFCB);
had_mac_settings = rc == noErr;
if (rc == noErr) {
	have_settings_spec = true;
	init_settings(keytab, &settingsSpec);
	rc = get_settings_parse_results(&count, 0, 0, 0);
	if (rc != 0) {
		#ifdef MAC_GUI
		show_settings_error(count);
		#endif
		}
	}
else {
	init_settings(keytab, 0);	// defines current settings from defaults
	}

did_init_settings = true;

// Give warning if should be using multithreaded client
// skip if settings already present
#ifdef powerc
if ((!had_mac_settings) && haveMP) {
	if (MPProcessors() > 1) {
		#ifdef MAC_GUI
		mySetCursor(kArrowCursor);
		show_message_string(kNoMPWarning, 0, NOTE_ALERT_KIND);
		mySetCursor(kWatchCursor);
		#endif
		}
	}
#endif

if (cs.console_log_name[0] == 0) {		// if logname empty, use default
	strcpy(cs.console_log_name, ds.console_log_name);
	}

// validate font name
check_font_info();

// define final fonts menu
c2pstr(cs.font_name);
GetFNum((unsigned char *)cs.font_name, &fnum);
p2cstr((unsigned char *)cs.font_name);
#ifdef MAC_GUI
final_font_menu(fnum);
#endif

// create our console window
check_window_info(&cs.log_window_info_stored, cs.log_window_height,
				  cs.log_window_width, cs.log_window_h_loc, cs.log_window_v_loc);

try {
	theWTextDisplayWindow = new WTextDisplayWindow();
	}
catch (...) {
	#ifdef MAC_GUI	
	mySetCursor(kArrowCursor);
	show_error_string(kMemInitError, 0);
	#endif
	return(18);
	}
// initialize new window
theWTextDisplayWindow->set_initial_window_name("Client Log");
theWTextDisplayWindow->set_initial_font_info(cs.font_name, cs.font_size,
	cs.font_style);
#ifdef MAC_GUI
if (cs.log_window_info_stored) {
	windowRect.top = cs.log_window_v_loc;
	windowRect.left = cs.log_window_h_loc;
	windowRect.bottom = windowRect.top + cs.log_window_height;
	windowRect.right = windowRect.left + cs.log_window_width;
	theWTextDisplayWindow->set_initial_window_rect(&windowRect);
	theWTextDisplayWindow->set_initial_window_visible(cs.log_window_visible);
	}
else {
#endif
	theWTextDisplayWindow->set_initial_window_visible(false);
#ifdef MAC_GUI
	}
#endif

rc = theWTextDisplayWindow->init_ViewWindow(this);
if (rc != noErr) {
	delete theWTextDisplayWindow;
	return(rc);
	}

// add to our window list
rc = add_window(theWTextDisplayWindow);
if (rc != noErr) {
	delete theWTextDisplayWindow;
	return(rc);
	}
	
// start console log
if (cs.writelog) {
	c2pstr(cs.console_log_name);
	theWTextDisplayWindow->begin_log((unsigned char *)cs.console_log_name, true);
	p2cstr((unsigned char *)cs.console_log_name);
	}

// create our client
try {
	theThreadApp = new Mac_Client;
	}
catch (...) {
	#ifdef MAC_GUI
	mySetCursor(kArrowCursor);
	show_error_string(kMemInitError, 0);
	#endif
	return(20);
	}

// copy default settings
copy_settings_from_client(&default_settings, theThreadApp);
// Mac changes to defaults
default_settings.percentprintingoff = 1;	// default is no percent printing

// initialize the client
//config_result = ReadConfig(theThreadApp);
rc = theThreadApp->InitializeClient();
if (rc != 0) {
	#ifdef MAC_GUI
	mySetCursor(kArrowCursor);
	show_error_string(kClientInitError, 0);
	#endif
	return(21);
	}

// Compute number of iterations/tick
RC5_ms_iterations_0 = TimeIterations(0.25, 0);
RC5_ms_iterations_1 = TimeIterations(0.25, 1);

DES_ms_iterations_0 = PPC_DES_FACTOR * RC5_ms_iterations_0;
DES_ms_iterations_1 = PPC_DES_FACTOR * RC5_ms_iterations_1;

// Print banner
PrintBanner(theThreadApp->id, 0, 0);

// Do configuration if couldn't read ini file
if (ModeReqIsSet(MODEREQ_CONFIG)) {
	do_configure(false);
	ModeReqClear(MODEREQ_CONFIG);
	}

// no connection yet
threadActive = false;		
runActive = false;
commandPending = false;
resumePending = false;

// print Mac client banner
version = GetResource(kSignature, 0);
if (version == 0L) {
	memcpy(ResString, "\pUnknown", 8);
	}
else {
	HLock(version);
	pstrcpy(ResString, (unsigned char *)*version);
	HUnlock(version);
	ReleaseResource(version);
	}
p2cstr(ResString);

if (haveMP) {
	strcpy(verskind, "PPC Multithreaded");
	}
else {
	strcpy(verskind, "PPC");
	}

printf("Macintosh %s Version %s.\n", verskind, ResString);

// Select core
theThreadApp->SelectCore(0);

// Register our client event handler for all events
rc = ClientEventAddListener(-1, ClientEventListener);
if (rc <= 0) {
	#ifdef MAC_GUI
	mySetCursor(kArrowCursor);
	show_error_string(kClientInitError, 0);
	#endif
	return(22);
	}

#ifdef MAC_GUI
// create our GUI window
check_window_info(&cs.gui_window_info_stored, cs.gui_window_height,
				  cs.gui_window_width, cs.gui_window_h_loc, cs.gui_window_v_loc);

try {
	theGUIWindow = new GUIWindow();
	}
catch (...) {
	mySetCursor(kArrowCursor);
	show_error_string(kMemInitError, 0);
	return(19);
	}

// initialize new window
theGUIWindow->set_initial_window_name("Client Status");
if (cs.gui_window_info_stored) {
	windowRect.top = cs.gui_window_v_loc;
	windowRect.left = cs.gui_window_h_loc;
	windowRect.bottom = windowRect.top + cs.gui_window_height;
	windowRect.right = windowRect.left + 353;
	theGUIWindow->set_initial_window_rect(&windowRect);
	theGUIWindow->set_initial_window_visible(false);
	// Note: we call ShowWindow later if necessary
	}
else {
	windowRect.top = 71;
	windowRect.left = 45;
	windowRect.bottom = 359;
	windowRect.right = 398;
	theGUIWindow->set_initial_window_rect(&windowRect);
	}
	
rc = theGUIWindow->init_ViewWindow(this);
if (rc != noErr) {
	delete theGUIWindow;
	return(rc);
	}

// add to our window list
rc = add_window(theGUIWindow);
if (rc != noErr) {
	delete theGUIWindow;
	return(rc);
	}
	
// Initialize GUI
InitializeGUIData();
theGUIWindow->set_buffers_contest(cs.buffers_contest);
if (cs.gui_window_visible) {
	theGUIWindow->show();
	}
#endif

return(noErr);
}

#ifdef MAC_GUI
void RC5App::InitializeGUIData(void)
{
memset(&client_info, 0, sizeof(client_info));
theThreadApp->RefreshBufferCounts();
theThreadApp->UpdateFileDates();
UpdateClientInfo(&client_info);
did_gui_init = true;
}
#endif

OSErr RC5App::InstallGNEWatcher(void)
{
Handle res_handle;
Size res_size;
Ptr res_ptr;
pascal void (*event_proc)(void);

res_handle = Get1Resource('proc', 256);
if (res_handle == 0) return(1);
res_size = GetHandleSize(res_handle);

res_ptr = NewPtrSysClear(res_size);
if (res_ptr == 0) {
	ReleaseResource(res_handle);
	return(2);
	}

HLock(res_handle);
BlockMove(*res_handle, res_ptr, res_size);
HUnlock(res_handle);
ReleaseResource(res_handle);

// Make initialization call
event_proc = (pascal void (*)(void))res_ptr;

#ifdef powerc
	CallUniversalProc((UniversalProcPtr)event_proc, GNEProcInfo); 
#else
	(*event_proc)();
#endif

return(noErr);
}

void RC5App::define_font_menu(void)
{
// This is all we do before settings have been read
InsertMenuItem(myMenus[3], "\pMonaco", 1);
font_item = 0;
}

void RC5App::final_font_menu(short init_fontnum)
{
Str255 strtext;
short i, m, fnum;
Boolean did_init;

// Update menu once settings have been read

// Delete monaco that we added
DeleteMenuItem(myMenus[3], 1);

// Add all fonts if requested
if (cs.all_fonts) {
	InsertResMenu(myMenus[3], 'FONT', 1);
	}

// Add fonts listed in resource
else {
	did_init = false;
	i = m = 1;
	GetIndString(strtext, kFontsList, i++);
	while (strtext[0] != 0) {
		GetFNum(strtext, &fnum);
		if (fnum != 0) {
			if (fnum == init_fontnum) {
				did_init = true;
				}
			GetFontName(fnum, strtext);
			InsertMenuItem(myMenus[3], strtext, m++);
			}
		GetIndString(strtext, kFontsList, i++);
		}
	if (!did_init) {
		did_init = true;
		GetFontName(init_fontnum, strtext);
		if (strtext[0] != 0) {
			InsertMenuItem(myMenus[3], strtext, m++);
			}
		}
	}
}

void RC5App::EndApp(void)
{

// delete the event listener, in case in the future that
// frees memory
ClientEventRemoveListener(-1, ClientEventListener);

if (theThreadApp != 0) {
	theThreadApp->DeInitializeClient();
	delete theThreadApp;
	theThreadApp = 0;
	}

if (haveMP) {
	if (MP_count_region != 0) {
		MPDeleteCriticalRegion(MP_count_region);
		MP_count_region = 0;
		}
	}

if (netinit_ok && netinit_done) {
	NetTerm();
	netinit_ok = false;
	netinit_done = false;
	}

if (socket_list != 0) {
	delete socket_list;
	}
	
RemoveConsole();

if (did_init_settings) {
	write_mac_settings();
	}
}

void RC5App::calculate_yield_times(settings_list *sl)
{
register double start, end;

if ((sl->max_cpu_start_time < 0) || (sl->max_cpu_end_time < 0) ||
	(sl->max_cpu_start_time > sl->max_cpu_end_time)) {
	start = ds.max_cpu_start_time;
	end = ds.max_cpu_end_time;
	}
else {
	start = sl->max_cpu_start_time;
	end = sl->max_cpu_end_time;
	}

short_inactive = (start * 3600.0) + 0.5;
long_inactive = (end * 3600.0) + 0.5;

if (short_inactive == long_inactive) {
	limit_adjustment = 0;	// won't be used
	}
else {
	limit_adjustment = LONG_INTERVAL - SHORT_INTERVAL;
	limit_adjustment *= short_inactive;
	limit_adjustment /= long_inactive - short_inactive;
	limit_adjustment -= SHORT_INTERVAL;
	}
}

double RC5App::TimeIterations(double maxtime, short core)
{
unsigned long iterations;
double elapsed;
struct timeval start, stop;
struct timezone tz;
double coretime;

iterations = 64;
elapsed = 0.0;
timing_core = true;
while (elapsed < maxtime) {
	iterations *= 2;
	gettimeofday(&start, &tz);
	coretime = theThreadApp->TimeCore(iterations, core);
	gettimeofday(&stop, &tz);
	elapsed = (stop.tv_sec + stop.tv_usec / 1000000.0) - \
    	(start.tv_sec + start.tv_usec / 1000000.0);
	}
timing_core = false;
return(coretime / 1000.0);
}

void RC5App::write_mac_settings(void)
{
short len;

#ifdef MAC_GUI
upd_log_windpos();						// store current window positions
if (did_gui_init) {
	upd_gui_windpos();
	upd_buffers_contest();					// GUI popup
	}
#endif

if (!have_settings_spec) {
// define settingsSpec to create file in the app's folder
	settingsSpec.vRefNum = myFCB.ioFCBVRefNum;
	settingsSpec.parID = myFCB.ioFCBParID;
	len = strlen(DEFAULT_PREFS_NAME);
	if (len > 63) len = 63;
	(settingsSpec.name)[0] = len;
	BlockMove(DEFAULT_PREFS_NAME, (settingsSpec.name)+1, len);
	have_settings_spec = true;
	}

if (have_settings_spec) {
	save_settings(keytab, kSignature, kPrefsSignature, &settingsSpec,
				  "RC5DES Client", false);
	}
}

Boolean RC5App::get_one_event(EventRecord *myEvent)
{
Boolean wne_result;

do_yield_processing();

if (!threadActive) {	// normal processing unless run active
	return(AppObject::get_one_event(myEvent));
	}

wne_result = WaitNextEvent(everyEvent, myEvent, 0L, 0L);
last_yield = LMGetTicks();
return(wne_result);
}

void RC5App::do_null_event(void)
{
if (netinit_ok && netinit_done) {
	NetIdle();
	}

AppObject::do_null_event();
}

void RC5App::mf_resume(long message)
{
AppObject::mf_resume(message);

if (timing_core) return;

if (theThreadApp->ChangedFileDates()) {
#ifdef MAC_GUI
	theThreadApp->RefreshBufferCounts();
	UpdateClientInfo(&client_info);
#endif
	}
}

void RC5App::mf_suspend(void)
{
AppObject::mf_suspend();

suspend_ticks = LMGetTicks();
did_move_to_fg = false;
}

void RC5App::handle_auto_fg(void)
{
unsigned long background_ticks, active_ticks, interval_ticks;
ProcessSerialNumber my_process;
OSErr rc;

// Check for auto move to foreground
if (runActive && cs.auto_fg && mf_bgrnd && (!did_move_to_fg)) {
	// ticks at last activity
	active_ticks = mouse_moved_ticks;
	if (last_event_tick != 0) {
		if (*last_event_tick > active_ticks) {
			active_ticks = *last_event_tick;
			}
		}
	// how long we've been in the background with no activity	
	if (active_ticks > suspend_ticks) {
		background_ticks = (*TICKS) - active_ticks;
		}
	else {
		background_ticks = (*TICKS) - suspend_ticks;
		}
	// how long to wait
	interval_ticks = (cs.auto_fg_delay * 3600.0) + 0.5;
	if (background_ticks >= interval_ticks) {
		did_move_to_fg = true;	// just try once
		rc = GetCurrentProcess(&my_process);
		if (rc == noErr) {
			SetFrontProcess(&my_process);
			}
		}
	}
}

void RC5App::upd_log_windpos(void)
{
Point p;
GrafPtr gp;
WindowPtr wp;

if (theWTextDisplayWindow == 0) return;
wp = theWTextDisplayWindow->myWindow;
if (wp == 0) return;
p.h = wp->portRect.left;
p.v = wp->portRect.top;
GetPort(&gp);
SetPort(wp);
LocalToGlobal(&p);		/* global current top-left */
SetPort(gp);
cs.log_window_h_loc = p.h;
cs.log_window_v_loc = p.v;
cs.log_window_height = wp->portRect.bottom -
				 	   wp->portRect.top;
cs.log_window_width = wp->portRect.right -
					  wp->portRect.left;
cs.log_window_visible = ((WindowPeek)wp)->visible;
cs.log_window_info_stored = 1;
}

#ifdef MAC_GUI
void RC5App::upd_gui_windpos(void)
{
Point p;
GrafPtr gp;
WindowPtr wp;

if (theGUIWindow == 0) return;
wp = theGUIWindow->myWindow;
if (wp == 0) return;
p.h = wp->portRect.left;
p.v = wp->portRect.top;
GetPort(&gp);
SetPort(wp);
LocalToGlobal(&p);		/* global current top-left */
SetPort(gp);
cs.gui_window_h_loc = p.h;
cs.gui_window_v_loc = p.v;
cs.gui_window_height = wp->portRect.bottom -
				 	   wp->portRect.top;
cs.gui_window_width = wp->portRect.right -
					  wp->portRect.left;
cs.gui_window_visible = ((WindowPeek)wp)->visible;
cs.gui_window_info_stored = 1;
}
#endif

void RC5App::upd_help_windpos(void)
{
Point p;
GrafPtr gp;
WindowPtr wp;

if (theHelpWindow == 0) return;
wp = theHelpWindow->myWindow;
if (wp == 0) return;
p.h = wp->portRect.left;
p.v = wp->portRect.top;
GetPort(&gp);
SetPort(wp);
LocalToGlobal(&p);		/* global current top-left */
SetPort(gp);
help_window_h_loc = p.h;
help_window_v_loc = p.v;
help_window_height = wp->portRect.bottom -
				 	   wp->portRect.top;
help_window_width = wp->portRect.right -
					  wp->portRect.left;
help_window_info_stored = 1;
}

void RC5App::upd_buffers_contest(void)
{
#ifdef MAC_GUI
cs.buffers_contest = GetControlValue(gBuffersGroupBoxControl) - 1;
#endif
}

void RC5App::check_window_info(char *window_info_stored,
							   short window_height,
							   short window_width,
							   short window_h_loc,
							   short window_v_loc)
{
Rect boundsRect;
Point topleft;

if (!(*window_info_stored)) return;

if ((window_height < 0) || (window_height > 4000)) {
	*window_info_stored = false;
	return;	
	}

if ((window_width < 0) || (window_width > 4000)) {
	*window_info_stored = false;
	return;	
	}

boundsRect = (*LMGetGrayRgn())->rgnBBox;
boundsRect.top += 5;
boundsRect.left -= (window_width - 17);
boundsRect.bottom += 17;
boundsRect.right -= 1;
topleft.h = window_h_loc;
topleft.v = window_v_loc;
if (!PtInRect(topleft, &boundsRect)) {
	*window_info_stored = false;
	}
}

void RC5App::check_font_info(void)
{
short fnum;

// check font size
if ((cs.font_size < 1) || (cs.font_size > 255)) {
	cs.font_size = 9;
	}

// check font name
c2pstr(cs.font_name);
GetFNum((unsigned char *)cs.font_name, &fnum);
p2cstr((unsigned char *)cs.font_name);

if (fnum == 0) {
	// if invalid, use Monaco
	strcpy(cs.font_name, "Monaco");
	}
}

// menu_upd and do_command handle the menu items we add

#ifdef MAC_GUI
void RC5App::menu_upd(void)
{
Boolean enable_close;

AppObject::menu_upd();		// update default menus

// remove current item marks
if (current_check_item != 0) {
	SetItemMark(myMenus[1], current_check_item, noMark);
	current_check_item = 0;
	}

if (current_diamond_item != 0) {
	SetItemMark(myMenus[1], current_diamond_item, noMark);
	current_diamond_item = 0;
	}

if (da_menu) {
	DisableItem(myMenus[1], kShowLogItem);
	DisableItem(myMenus[1], kShowStatusItem);
	DisableItem(myMenus[1], kCloseItem);
	DisableItem(myMenus[1], kRunItem);
	DisableItem(myMenus[1], kRunBuffersItem);
	DisableItem(myMenus[1], kRunOfflineItem);
	DisableItem(myMenus[1], kBenchmarkRC5Item);
	DisableItem(myMenus[1], kBenchmarkDESItem);
	DisableItem(myMenus[1], kTestItem);
	DisableItem(myMenus[1], kFetchItem);
	DisableItem(myMenus[1], kFlushItem);
	DisableItem(myMenus[1], kUpdateItem);
	DisableItem(myMenus[1], kQuitAppsItem);
	DisableItem(myMenus[1], kHaltItem);
	}
else {
	EnableItem(myMenus[1], kShowLogItem);
	EnableItem(myMenus[1], kShowStatusItem);
	enable_close = false;
	if (theWTextDisplayWindow != 0) {
		enable_close = enable_close || (theWTextDisplayWindow->is_visible());
		}
	if (theGUIWindow != 0) {
		enable_close = enable_close || (theGUIWindow->is_visible());
		}
	if (theHelpWindow != 0) {
		enable_close = enable_close || (theHelpWindow->is_visible());
		}
	if (enable_close) {
		EnableItem(myMenus[1], kCloseItem);
		}
	else {
		DisableItem(myMenus[1], kCloseItem);
		}
	EnableItem(myMenus[1], kRunItem);
	EnableItem(myMenus[1], kRunBuffersItem);
	EnableItem(myMenus[1], kRunOfflineItem);
	EnableItem(myMenus[1], kBenchmarkRC5Item);
	EnableItem(myMenus[1], kBenchmarkDESItem);
	EnableItem(myMenus[1], kTestItem);
	EnableItem(myMenus[1], kFetchItem);
	EnableItem(myMenus[1], kFlushItem);
	EnableItem(myMenus[1], kUpdateItem);
	if (GetNumProcs() > 1) {		// don't count ourselves!
		EnableItem(myMenus[1], kQuitAppsItem);
		}
	else {
		DisableItem(myMenus[1], kQuitAppsItem);
		}
	if ((threadActive && (!CheckExitRequestTriggerNoIO())) ||
		commandPending || resumePending) {
		EnableItem(myMenus[1], kHaltItem);
		}
	else {
		DisableItem(myMenus[1], kHaltItem);
		}

	// Set item marks
	if (threadActive) {
		SetItemMark(myMenus[1], run_item, checkMark);
		current_check_item = run_item;
		}
	if (commandPending) {
		SetItemMark(myMenus[1], command_pending_item, diamondMark);
		current_diamond_item = command_pending_item;
		}
	else if (resumePending) {
		SetItemMark(myMenus[1], resume_pending_item, diamondMark);
		current_diamond_item = resume_pending_item;
		}
	}
}
#endif

#ifdef MAC_GUI
void RC5App::do_go_away(WindowPtr theWindow, Boolean all_windows)
{
if ((theWindow == theWTextDisplayWindow->myWindow) || all_windows) {
	theWTextDisplayWindow->hide();
	}

if ((theWindow == theGUIWindow->myWindow) || all_windows) {
	theGUIWindow->hide();
	}

if ((theWindow == theHelpWindow->myWindow) || all_windows) {
	upd_help_windpos();
	delete_window(theHelpWindow, true);
	theHelpWindow = 0;
	}
}
#endif

#ifdef MAC_GUI
void RC5App::size_gui_window(short height, Rect *updateRect)
{
short width;
WindowPtr theWindow;
GrafPtr gp;

theWindow = theGUIWindow->myWindow;
width = (theWindow->portRect).right - (theWindow->portRect).left;
//new_rect = theWindow->portRect;
//new_rect.bottom = new_rect.top + height;
//theGUIWindow->resize_scroll_draw(true);
GetPort(&gp);
SetPort(theWindow);
EraseRect(updateRect);
SizeWindow(theWindow, width, height, true);
ClipRect(updateRect);
UpdateMainWindow();
ClipRect(&theWindow->portRect);
SetPort(gp);
theGUIWindow->draw_window_update();
theGUIWindow->update_content_rects(&(theWindow->portRect));
theGUIWindow->update_window_rects(false);
//theGUIWindow->resize_scroll_draw(false);
//do_update(theWindow);		// redraw changes now, before possible scrolling
//							// scrolling code assumes contentsRect is valid
theGUIWindow->adjust_all_scroll_settings(true);
}
#endif

void RC5App::do_often(void)
{
if (pending_console_data) {
	update_log(false);
	pending_console_data = false;
	}

if (theWTextDisplayWindow != 0) {
	if ((!threadActive) && (commandPending || resumePending)) {
		handle_pending();	// thread finished and something is pending
		}
	}
}

void RC5App::update_log(Boolean quitting)
{
#pragma unused(quitting)
long delete_size, textLength, i;
long current_length = 0;
Handle theText;
short threshold;

/*if (quitting) {
	threshold = 0;
	}
else {
	threshold = 1;
	}*/
threshold = 0;

// display new text
if (messages.current_length > threshold) {

	// delete enough lines from the top to make room for the text we're adding
	#ifdef MAC_GUI
	textLength = theWTextDisplayWindow->get_text_size();
	theText = theWTextDisplayWindow->get_text();
	delete_size = textLength + messages.current_length
				  - MAX_TEXT;
	if (delete_size > 0) {
		// delete extra space so every line doesn't cause a deletion
		delete_size += MAX_TEXT / 10;
		current_length = 0;
		for (i = 0; i < textLength; i++) {
			current_length++;
			if ((*theText)[i] == 0x0d) {
				if (current_length >= delete_size) {
					break;
					}
				}
			}
		theWTextDisplayWindow->delete_text(0, current_length);
		}
	#endif
	// add the new text
	theWTextDisplayWindow->disable_int_cutpaste();
	theWTextDisplayWindow->append_text(messages.the_text,
		messages.current_length);
	theWTextDisplayWindow->enable_int_cutpaste();
	messages.current_length = 0;
	}
}

#ifdef MAC_GUI
Boolean RC5App::do_command(short theMenu, short theItem)
{
Boolean did_command;

if ((theMenu == kAppleMenu) && (theItem == kHelpItem)) {
	help_window();
	return(true);
	}

if (theMenu != kFileMenu) {
	did_command = AppObject::do_command(theMenu, theItem);  //handle default commands

	if (did_command) return(did_command);	// it was a default command
	}

switch(theMenu) {
	case kFileMenu:
		switch(theItem) {
			case kShowLogItem:
				theWTextDisplayWindow->show();
				break;
			case kShowStatusItem:
				theGUIWindow->show();
				break;
			case kCloseItem:
				do_go_away(FrontWindow(), false);
				break;
			case kRunItem:
				new_offline_mode(0);
				HiliteMenu(0);
				run_crunch("", theItem);
				break;
			case kRunOfflineItem:
				new_offline_mode(1);
				HiliteMenu(0);
				run_crunch("-runoffline", theItem);
				break;
			case kRunBuffersItem:
				new_offline_mode(2);
				HiliteMenu(0);
				run_crunch("-runbuffers", theItem);
				break;
			case kBenchmarkRC5Item:
				HiliteMenu(0);
				client_command("-benchmarkRC5", theItem);
				break;
			case kBenchmarkDESItem:
				HiliteMenu(0);
				client_command("-benchmarkDES", theItem);
				break;
			case kTestItem:
				HiliteMenu(0);
				client_command("-test", theItem);
				break;
			case kFetchItem:
				HiliteMenu(0);
				client_command("-fetch", theItem);
				break;
			case kFlushItem:
				HiliteMenu(0);
				client_command("-flush", theItem);
				break;
			case kUpdateItem:
				HiliteMenu(0);
				client_command("-update", theItem);
				break;
			case kQuitAppsItem:
				QuitAllApps();
				break;
			case kHaltItem:
				stop_thread();
				commandPending = false;
				resumePending = false;
				break;
			case kFileMSize:
				do_quit();
				break;
			default:
				break;
			}
		break;

	case kEditMenu:
		switch(theItem) {
			case kPreferencesItem:
				HiliteMenu(0);
				if (do_configure(true)) {	// returns true if any changes
					client_command("*configure*", theItem);
					}
			default:
				break;
			}

	default:
		break;
	}

return(did_command);
}
#endif

void RC5App::new_offline_mode(short mode)
{
//theThreadApp->ReadConfig();
if (theThreadApp->offlinemode != mode) {
	theThreadApp->offlinemode = mode;
//	ValidateConfig(theThreadApp);	 at 434 does not exist
	WriteConfig(theThreadApp, 1); 
	}
}

void RC5App::define_new_font(short font_item, short font_number)
{
Str255 font_name;

AppObject::define_new_font(font_item, font_number);

GetFontName(font_number, font_name);
p2cstr(font_name);
strcpy(cs.font_name, (char *)font_name);
}

void RC5App::define_new_pointsize(short size_item, short font_size)
{
AppObject::define_new_pointsize(size_item, font_size);

cs.font_size = font_size;
}

void RC5App::define_new_style(short style_bits, Style new_style)
{
AppObject::define_new_style(style_bits, new_style);

cs.font_style = new_style;
}

Boolean RC5App::do_configure(Boolean ini_file_ok)
{
Boolean log_settings_changed;
Boolean ds_changed, sl_changed;
settings_list ns;
dialog_settings new_settings;
short start_cpus, end_cpus;
OSErr rc;

#ifdef MAC_GUI
menu_upd();
#endif

// Get current client settings
if (ini_file_ok) {
	rc = read_ini_settings(&file_settings);  // reads and validates
	if (rc != noErr) {		// shouldn't fail, but if it does, use defaults
		file_settings = default_settings;
		}
	}
else {		// have no ini file
	file_settings = default_settings;
	}

start_cpus = file_settings.numcpu;

// New settings initialized to current settings
new_settings = file_settings;
ns = cs;

#ifdef MAC_GUI
ConfigureDialog(&default_settings, &new_settings, &ds, &ns);
#else
ExitToShell();
#endif

if (ns.console_log_name[0] == 0) {		// if logname empty, use default
	strcpy(ns.console_log_name, ds.console_log_name);
	}

log_settings_changed = (ns.writelog != cs.writelog) ||
		(strcmp(cs.console_log_name, ns.console_log_name) != 0);

// close log file and re-open with new settings
if (log_settings_changed) {
	theWTextDisplayWindow->end_log();
	if (ns.writelog) {
		c2pstr(ns.console_log_name);
		theWTextDisplayWindow->begin_log((unsigned char *)ns.console_log_name, true);
		p2cstr((unsigned char *)ns.console_log_name);
		}
	}

// Write new Mac settings
sl_changed = compare_settings_list(&ns, &cs);
if (sl_changed) {
	cs = ns;
	write_mac_settings();
	calculate_yield_times(&cs);
	} 

// Write client settings
ds_changed = compare_dialog_settings(&new_settings, &file_settings);
if (ds_changed || (!ini_file_ok)) {
	write_ini_settings(&new_settings);	// validates and writes
	end_cpus = new_settings.numcpu;
	if (did_gui_init) {
		#ifdef MAC_GUI
		theThreadApp->RefreshBufferCounts();
		#endif
		theThreadApp->UpdateFileDates();
		#ifdef MAC_GUI
		UpdateClientInfo(&client_info);
		#endif
		}

	// Give warning if CPU setting was changed and too many CPUs specified 
	if (haveMP && (start_cpus != end_cpus)) {
		if (end_cpus > (short)MPProcessors()) {
			show_message_string(kCPUCfigError, 0, CAUTION_ALERT_KIND);
			theWTextDisplayWindow->draw_window();
			}
		}
	}

return(sl_changed || ds_changed);
}

void RC5App::run_client(char *option, short theItem)
{
long run_ms;
double RC5_ms_iterations, DES_ms_iterations;
Boolean restart = true;

while (restart && (!done)) {
	switch (cs.resplevel) {
		case 0:
				run_ms = LOW_TICKS;
				break;
		case 1:
				run_ms = MEDIUM_TICKS;
				break;
		default:
		case 2:
				run_ms = HIGH_TICKS;
				break;
		case 3:
				run_ms = cs.customticks;
				break;

		}

	// Get current settings
	// needed because client may change other settings besides user ones
	// or the user may have changed the file
	theThreadApp->ReInitializeClient();
	ReadConfig(theThreadApp);

	// get applicable timing constants for this run
	if (theThreadApp->cputype == 0) {
		RC5_ms_iterations = RC5_ms_iterations_0;
		DES_ms_iterations = DES_ms_iterations_0;
		}
	else {
		RC5_ms_iterations = RC5_ms_iterations_1;
		DES_ms_iterations = DES_ms_iterations_1;
		}

	RC5_timeslice_to_use = run_ms * RC5_ms_iterations;
	DES_timeslice_to_use = run_ms * DES_ms_iterations;
	DES_ticks_to_use = (run_ms * 3 + 25) / 50;
	DES_yield_ticks = LMGetTicks() + DES_ticks_to_use;

	//printf("%f\n", RC5_ms_iterations);

	restart = start_thread(option, theItem);
	if (restart && (!done)) printf("Restarting...\n");
	}
}

Boolean RC5App::start_thread(char *option, short theItem)
{
char *argv[2];
long argc;
OSErr rc;
char * thread_desc;
Boolean benchmark_thread;
Boolean restart;

//try {
//	theThreadApp = new Mac_Client;
//	}
//catch (...) {
//	showerr("No memory to create new thread object!");
//	return;
//	}

threadActive = true;

runActive = ((strlen(option) == 0) ||
			 (strcmp(option, "-runbuffers") == 0) ||
			 (strcmp(option, "-runoffline") == 0) ||
			 (strcmp(option, "-benchmarkRC5") == 0) ||
			 (strcmp(option, "-benchmarkDES") == 0));

theThreadApp->nonewblocks = 0;

strcpy(run_option, option);
run_item = theItem;

if (CPU_can_idle) DisableIdle();

argv[0] = "rc5des";
argv[1] = run_option;

if (strlen(argv[1]) > 0) {
	argc = 2;
	}
else {
	argc = 1;
	}

last_yield = LMGetTicks();

thread_desc = get_thread_description(run_option);

benchmark_thread = (strcmp(thread_desc, "Benchmark RC5") == 0) ||
                   (strcmp(thread_desc, "Benchmark DES") == 0);

if (runActive && !benchmark_thread) {
	RestoreProxyMessage();
	}
else if (strcmp(thread_desc, "Test") == 0) {
	// events will generate messages
	}
else {
	sprintf(client_info.lastServerMessage,
		"Doing %s", thread_desc);
	client_info.hasServerMessageChanged = true;
	UpdateClientInfo(&client_info);
	need_completed_message = true;
	}

/******* client runs here  ********/
rc = theThreadApp->Startup(argc, argv);
/******* end of client run ********/

restart = runActive && (CheckRestartRequestTrigger() != 0);

#ifdef MAC_GUI
if (runActive) {			// handle fetch highlight possibly changing
	gFetchAdjustment = 0;	// due to gFetchAdjustment
	theGUIWindow->update_fetch_control(
		&client_info.buffersInfo[gCurrentBuffersInfo].inputBuffer);
	}
#endif

if (strlen(thread_desc) > 0) {
	if (CheckExitRequestTriggerNoIO()) {
		run_option[1] = toupper(run_option[1]);
		printf("\n%s halted.\n", thread_desc);
		run_option[1] = tolower(run_option[1]);

		if ((strcmp(thread_desc, "Test") != 0) &&
		(!benchmark_thread || need_completed_message)) {
			sprintf(client_info.lastServerMessage,
				"%s halted", thread_desc);
			client_info.hasServerMessageChanged = true;
			UpdateClientInfo(&client_info);
			}
		}
	else if (rc >= 0) {
		run_option[1] = toupper(run_option[1]);
		printf("\n%s completed.\n", thread_desc);
		run_option[1] = tolower(run_option[1]);

		if (need_completed_message) {
			sprintf(client_info.lastServerMessage,
				"%s completed", thread_desc);
			client_info.hasServerMessageChanged = true;
			UpdateClientInfo(&client_info);
			}
		}
	else {
		run_option[1] = toupper(run_option[1]);
		printf("\n%s failed.\n", thread_desc);
		run_option[1] = tolower(run_option[1]);
		
		sprintf(client_info.lastServerMessage,
			"%s failed -- see log for details", thread_desc);
		client_info.hasServerMessageChanged = true;
		UpdateClientInfo(&client_info);
		}
	}

threadActive = false;
runActive = false;
theThreadApp->ResetClient();
//if (theThreadApp != 0) {
//	delete theThreadApp;
//	theThreadApp = 0;
//	}

if (theWTextDisplayWindow != 0) {
	(theWTextDisplayWindow)->do_null_event();
	}

if (done_pending) {
	done = 1;
	}

if (CPU_can_idle) EnableIdle();

return(restart);
}

void RC5App::stop_thread(void)
{
RaiseExitRequestTrigger();
}

void RC5App::do_quit(void)
{
if (threadActive) {
	stop_thread();
	commandPending = false;
	resumePending = false;
	done_pending = 1;
	}
else {
	done = 1;
	}
}

void RC5App::client_command(char *option, short theItem)
{
if (threadActive) {
	if (theItem != run_item) {
		stop_thread();
		commandPending = true;
		strcpy(command_pending_option, option);
		command_pending_item = theItem;
		}
	}
else {
	if (strcmp(option, "*configure*") != 0) {
		run_client(option, theItem);
		}
	}
}

void RC5App::handle_pending(void)
{
if (commandPending) {
	commandPending = false;
	// if thread that stopped was a run, set up to resume
	if ((strlen(run_option) == 0) || (strcmp(run_option, "-runbuffers") == 0) ||
    	(strcmp(run_option, "-runoffline") == 0)) {
    	strcpy(resume_pending_option, run_option);
		resume_pending_item = run_item;
		resumePending = true;
		}

	// do command that was pending
	if (strcmp(command_pending_option, "*configure*") == 0) {
		if (resumePending) {
			resumePending = false;
			run_client(resume_pending_option, resume_pending_item);
			}
		}
	else {
		run_client(command_pending_option, command_pending_item);
		}
	}
else if (resumePending) {
	resumePending = false;
	run_client(resume_pending_option, resume_pending_item);
	}
}

void RC5App::run_crunch(char *option, short theItem)
{
if (threadActive) {
	if (theItem != run_item) {
		stop_thread();
		commandPending = false;
		resumePending = true;
		strcpy(resume_pending_option, option);
		resume_pending_item = theItem;
		}
	}
else {
	run_client(option, theItem);
	}
}

void RC5App::update_timestamp(void)
{
unsigned long date_secs;
short date_length;

// Get the date and time
GetDateTime(&date_secs);
IUDateString(date_secs, shortDate, (StringPtr)timestamp);
p2cstr((StringPtr)timestamp);
strcat(timestamp, " ");
date_length = strlen(timestamp);
IUTimeString(date_secs, true, (StringPtr)(timestamp+date_length));
p2cstr((StringPtr)(timestamp+date_length));
}

char * RC5App::get_thread_description(char *option)
{
static char result[64];
short i;
char *optname;

if (strlen(option) == 0) {
	strcpy(result, "Run");
	return(result);
	}

i = 0;
optname = desc_tab[i];
while (optname != 0) {
	if (strcmp(optname, option) == 0) {
		strcpy(result, desc_tab[i+1]);
		return(result);
		}
	i += 2;
	optname = desc_tab[i];
	}

result[0] = 0;
return(result);
}

void RC5App::aboutdlg(void)
{
DialogPtr dlgptr;
short itemHit;
static unsigned char nullstr[1] = {0};
WindowPtr front_window;
short gtype;
Handle gitem;
Rect gbox;

/*  for debugging memory usage
{
Size total, contig;
char msg[256];

PurgeSpace(&total, &contig);
sprintf(msg, "total free = %d, contig = %d", total, contig);
showerr(msg);
}
*/

waitcursor = ibeamcursor = false;
mySetCursor(kArrowCursor);

front_window = FrontWindow();
dlgptr = GetNewDialog(kAboutDialog, (Ptr)0L, (WindowPtr)-1L);
ctrwindow(dlgptr, center_denominator, 20, 0, 0);

// Install user item
GetDialogItem(dlgptr, kAboutUserItem, &gtype, &gitem, &gbox);
#ifdef powerc
SetDialogItem(dlgptr, kAboutUserItem, gtype, (Handle)&abouttextRD, &gbox);
#else
SetDialogItem(dlgptr, kAboutUserItem, gtype, (Handle)about_user_text, &gbox);
#endif
ShowWindow(dlgptr);
deactivate_controls(front_window);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
#if GENERATINGPOWERPC
ModalDialog((ModalFilterUPP)&DlgFilter1RD, &itemHit);
#else
ModalDialog((ModalFilterUPP)DlgFilter1, &itemHit);
#endif
DisposeDialog(dlgptr);
/* activate_controls(); */  /* activate event will do this */
}

void RC5App::help_window(void)
{
OSErr rc;
Rect windowRect;

if (theHelpWindow != 0) {
	theHelpWindow->show();
	return;
	}

try {
	theHelpWindow = new TextRscWindow;
	}
catch (...) {
	mySetCursor(kArrowCursor);
	show_error_string(kMemHelpError, 0);
	return;
	}

// initialize new window
theHelpWindow->set_initial_window_name("Client Help");
if (help_window_info_stored) {
	windowRect.top = help_window_v_loc;
	windowRect.left = help_window_h_loc;
	windowRect.bottom = windowRect.top + help_window_height;
	windowRect.right = windowRect.left + help_window_width;
	theHelpWindow->set_initial_window_rect(&windowRect);
	}
rc = theHelpWindow->init_ViewWindow(this);
if (rc != noErr) {
	delete theHelpWindow;
	return;
	}

// add to our window list
rc = add_window(theHelpWindow);
if (rc != noErr) {
	delete theHelpWindow;
	return;
	}

theHelpWindow->show();
}

pascal void about_user_text(DialogPtr dialog, short itemNo)
{
Handle version;
Str255 rc5version;
GrafPtr gp;
short itemType;
Handle itemHandle;
Rect textrect;
short fontnum;
short lh, v_offset;
short savedFont;
Style savedFace;
short savedMode;
short savedSize;
RGBColor savedForeColor;
Str255 strtext;
short i;
SInt16 inDepth;
Boolean inIsColorDevice;

GetPort(&gp);
SetPort(dialog);

savedFont = ((GrafPtr)dialog)->txFont;
savedFace = ((GrafPtr)dialog)->txFace;
savedMode = ((GrafPtr)dialog)->txMode;
savedSize = ((GrafPtr)dialog)->txSize;
GetForeColor(&savedForeColor);

if (theApp->haveAppearance) {
	get_port_color_info(theApp->colormac, &inDepth, &inIsColorDevice);
	SetThemeTextColor(kThemeActiveDialogTextColor, inDepth,
					  inIsColorDevice);
	}

Handle copyright;
copyright = GetResource(kSignature, 1);

version = GetResource(kSignature, 0);
if (version != 0) {
	HLock(version);
	
	}

sprintf((char *)rc5version, "%s", CLIENT_VERSIONSTRING );
c2pstr((char *)rc5version);

GetDialogItem(dialog, itemNo, &itemType, &itemHandle, &textrect);

/* MoveTo(textrect.left, textrect.top);
LineTo(textrect.right, textrect.top);
LineTo(textrect.right, textrect.bottom);
LineTo(textrect.left, textrect.bottom);
LineTo(textrect.left, textrect.top); */

GetFNum("\pCharcoal", &fontnum);

TextMode(srcOr);
TextFont(fontnum);
TextSize(9);
lh = 12;		// line height
v_offset = 24;	// vertical offset


MoveTo(textrect.left, textrect.top + v_offset);
TextSize(24); 
DrawString("\pMac OS Client");

MoveTo(textrect.left, textrect.top + v_offset + 30 + 2*lh);
GetFNum("\pGeneva", &fontnum);
TextFont(fontnum);
TextSize(9); 

Handle theAboutScroll;
theAboutScroll = GetResource( 'TEXT', 130); 

i = 1;
GetIndString(strtext, kAboutText, i++);
while (strtext[0] != 0) {
	MoveTo(textrect.left, textrect.top + v_offset + (i + 2)*lh);
	DrawString(strtext);
	GetIndString(strtext, kAboutText, i++);
	}
TextSize(9); 

MoveTo(textrect.left, textrect.top + v_offset + (i + 3)*lh);
TextFace(bold);
DrawString("\pMac Client Version: ");
TextFace(0); 
DrawString((unsigned char*)*version); 
MoveTo(textrect.left, textrect.top + v_offset + (i + 4)*lh);
DrawString((unsigned char*)*copyright); 
DrawString("\p - All Rights Reserved");


if (version != 0) {
	HUnlock(version);
	ReleaseResource(version);
	}

RGBForeColor(&savedForeColor);
TextFont(savedFont);
TextFace(savedFace);
TextMode(savedMode);
TextSize(savedSize);

SetPort(gp);
}

void RC5App::do_high_level_event(EventRecord *myEvent)
{
OSErr result;

result = AEProcessAppleEvent(myEvent);
}

pascal OSErr RC5App::HandleOAPP(AppleEvent *theAppleEvent,
									  AppleEvent *reply,
									  long handlerRefCon)
{
#pragma unused (handlerRefCon, reply)

return(GotAllParms(theAppleEvent));
}

pascal OSErr RC5App::HandleODOC(AppleEvent *theAppleEvent,
									  AppleEvent *reply,
									  long handlerRefCon)
{
#pragma unused (handlerRefCon, reply)

return(GotAllParms(theAppleEvent));
}

pascal OSErr RC5App::HandlePDOC(AppleEvent *theAppleEvent,
									  AppleEvent *reply,
									  long handlerRefCon)
{
#pragma unused (handlerRefCon, reply)

return(GotAllParms(theAppleEvent));
}

pascal OSErr RC5App::HandleQUIT(AppleEvent *theAppleEvent,
									  AppleEvent *reply,
									  long handlerRefCon)
{
#pragma unused (reply)
OSErr rc;

rc = GotAllParms(theAppleEvent);
if (rc != noErr) {
	return(rc);
	}


((RC5App *)handlerRefCon)->do_quit();

return(noErr);
}

OSErr GotAllParms(AppleEvent *theAppleEvent)
{
DescType returnedType;
Size actualSize;
OSErr myErr;

myErr = AEGetAttributePtr(theAppleEvent, keyMissedKeywordAttr,
			typeWildCard, &returnedType, 0, 0, &actualSize);
if (myErr == errAEDescNotFound) {
	return(noErr);
	}
else if (myErr == noErr) {
	return(errAEEventNotHandled);
	}
else {
	return(myErr);
	}
}

// routine called by client for low-level console out
void macConOut(char *msg)
{
// During a benchmark, we throw away client % output and
// generate our own from "benching" events
if (doing_bench_output) return;

fwrite( msg, sizeof(char), strlen(msg), stdout);
fflush(stdout);
YieldToMain(0);
}

void YieldToMain(char force_events)
{
theApp->DoYieldToMain(force_events);
}

void DES_YieldToMain(void)
{
if (MP_active == 0) theApp->DoYieldToMain(1);
}

void RC5App::DoYieldToMain(char force_events)
{
unsigned long elapsed;
Boolean do_events;
unsigned long run_ms;
EventRecord theEvent;
unsigned long current_ticks;
unsigned long inactive_duration;
static unsigned long event_limit = 0;
static Point last_mouse = {0, 0};
Point new_mouse;
Boolean mouse_moved;

// don't do anything if still starting up
if (timing_core) return;

// handle pending console data
if (pending_console_data) {
	update_log(false);
	}

// update cursor and handle mouse
// Check mouse location
new_mouse = LMGetMouseLocation();
mouse_moved = (last_mouse.h != new_mouse.h) || (last_mouse.v != new_mouse.v);
if (mouse_moved) {
	last_mouse = new_mouse;
	mouse_moved_ticks = *TICKS;
	update_cursor();
	}

/*
// handle null processing
// the interval can be long becuse the cursor was already updated
// and we don't have a flashing cursor
elapsed = (*TICKS) - last_null;
if (elapsed > LONG_INTERVAL) {
	do_null_event();
	}
*/

// If maxcpu is false, we strictly honor the responsiveness setting
// and forced events, except when network I/O is active
if (cs.maxcpu == 0) {
	// handle events
	do_events = force_events != 0;

	// if event handling not forced, see if it's time for another
	if (!do_events) {
		if (netio_active) {
			run_ms = HIGH_TICKS;
			}
		else {
			switch (cs.resplevel) {
				case 0:
						run_ms = LOW_TICKS;
						break;
				case 1:
						run_ms = MEDIUM_TICKS;
						break;
				default:
				case 2:
						run_ms = HIGH_TICKS;
						break;
				case 3:
						run_ms = cs.customticks;
						break;
				}
			}
		elapsed = (*TICKS) - last_yield;
		do_events = (elapsed > ((run_ms * 3 + 25) / 50));
		last_active_tick = 0; // in case maxcpu setting is changed
		}
	}

else {
	// save current time
	current_ticks = *TICKS;

	// check for any sign of activity on the machine
	if (activeMac(current_ticks, mouse_moved)) {
		do_events = true;
		event_limit = current_ticks + 4;
		}
	else {
		do_events = current_ticks > event_limit;
		if (do_events) {	// we reached the end of the limit without any activity
							// compute a new limit based on inactive time
			inactive_duration = current_ticks - last_active_tick;
			if (inactive_duration < short_inactive) {	// keep short at beginning
				event_limit = current_ticks + SHORT_INTERVAL;	// 4 ticks = 65ms
				}
			else if (inactive_duration >= long_inactive) {	// at end use longest time
				event_limit = current_ticks + LONG_INTERVAL;	// 450 ticks = 7.5 seconds
				}
			else { //  linear increase from 4 to 450 over range
				event_limit = LONG_INTERVAL - SHORT_INTERVAL;
				event_limit *= inactive_duration;
				event_limit /= long_inactive - short_inactive;
				event_limit -= limit_adjustment;
				event_limit += current_ticks;
				}
			}
		}		
	}

if (do_events) {
	if (netio_active && netinit_ok && netinit_done) {
		NetIdle();
		}
	do_yield_processing();
	while (WaitNextEvent(everyEvent, &theEvent, 0L, 0L)) {
		handle_one_event(&theEvent);
		}
// null event handling would go here (but currently not needed)
	last_yield = LMGetTicks();
	}
}

void ClientEventListener(int event_id, long parm)
{
static char *contestnames[2] = {"RC5", "DES"};
static char *thiscontest;
Problem *theProblem;
static unsigned long benchmark_ticks;
double benchrate;
char smsg[128];
char *textparm;
struct Fetch_Flush_Info *ffinfo;
static short start_counts[2];
static short test_contest;
static short test_count[2];
static Boolean test_failed;
Problem *finished_prob;


#if defined(CLIENT_EVENT_DEBUG)
char event_kind[64];

//convert event_id to string
switch(event_id) {
	case CLIEVENT_CLIENT_STARTED:
			strcpy(event_kind, "Client Started");
			break;
	case CLIEVENT_CLIENT_FINISHED:
			strcpy(event_kind, "Client Finished");
			break;
	case CLIEVENT_CLIENT_RUNSTARTED:
			strcpy(event_kind, "Run Started");
			break;
	case CLIEVENT_CLIENT_RUNFINISHED:
			strcpy(event_kind, "Run Finished");
			break;
	case CLIEVENT_CLIENT_THREADSTARTED:
			strcpy(event_kind, "Thread Started");
			break;
	case CLIEVENT_CLIENT_THREADSTOPPED:
			strcpy(event_kind, "Thread Stopped");
			break;
	case CLIEVENT_PROBLEM_STARTED:
			strcpy(event_kind, "Problem Started");
			break;
	case CLIEVENT_PROBLEM_FINISHED:
			strcpy(event_kind, "Problem Finished");
			break;
	case CLIEVENT_PROBLEM_TFILLSTARTED:
			strcpy(event_kind, "Fill Started");
			break;
	case CLIEVENT_PROBLEM_TFILLFINISHED:
			strcpy(event_kind, "Fill Finished");
			break;
	case CLIEVENT_BUFFER_FETCHBEGIN:
			strcpy(event_kind, "Fetch Begin");
			break;
	case CLIEVENT_BUFFER_FETCHFETCHED:
			strcpy(event_kind, "Fetch Fetched");
			break;
	case CLIEVENT_BUFFER_FETCHEND:
			strcpy(event_kind, "Fetch End");
			break;
	case CLIEVENT_BUFFER_FLUSHBEGIN:
			strcpy(event_kind, "Flush Begin");
			break;
	case CLIEVENT_BUFFER_FLUSHFLUSHED:
			strcpy(event_kind, "Flush Flushed");
			break;
	case CLIEVENT_BUFFER_FLUSHEND:
			strcpy(event_kind, "Flush End");
			break;
	case CLIEVENT_SELFTEST_STARTED:
			strcpy(event_kind, "Test Started");
			break;
	case CLIEVENT_SELFTEST_TESTBEGIN:
			strcpy(event_kind, "Test Problem Begin");
			break;
	case CLIEVENT_SELFTEST_TESTEND:
			strcpy(event_kind, "Test Problem End");
			break;
	case CLIEVENT_SELFTEST_FINISHED:
			strcpy(event_kind, "Test Finished");
			break;
	case CLIEVENT_BENCHMARK_STARTED:
			strcpy(event_kind, "Benchmark Started");
			break;
	case CLIEVENT_BENCHMARK_BENCHING:
			strcpy(event_kind, "Benchmark Benching");
			break;
	case CLIEVENT_BENCHMARK_FINISHED:
			strcpy(event_kind, "Benchmark Finished");
			break;
	default:
			strcpy(event_kind, "Unknown Event");
			break;
	}

printf("--> ClientEventListener: %s event with parameter %x (hex)\n",
	event_kind, parm);
#endif

switch(event_id) {
	case CLIEVENT_BENCHMARK_STARTED:
			#ifdef MAC_GUI
			// begin our console output
			macConOut("\n");
			#endif
			// during benchmark, discard normal client output
			// (there is too much of it, and it slows down the benchmark)
			doing_bench_output = true;
			
			// setup for status output
			theProblem = (Problem *)parm;
			thiscontest = contestnames[theProblem->contest];
			benchmark_ticks = 0;

			#ifdef MAC_GUI
			// setup GUI
			MakeGUIThread(theProblem->contest, 0);
			UpdateThreadProgress(0, 0, 0, true );
   			UpdateClientInfo(&client_info);
			#endif
			break;

	case CLIEVENT_BENCHMARK_BENCHING:
			#ifdef MAC_GUI
			theProblem = (Problem *)parm;

// Apparently no longer needed
//			if (theProblem->permille == 1001) {
//				printf("\n*Break*");
//				fflush(stdout);
//				theApp->update_log(false);
//				} else

			if (((*TICKS) - benchmark_ticks) >= 120) {
				theProblem->permille = theProblem->CalcPermille();
				printf("\rBenchmarking %s:%u%% (%u keys)",
					thiscontest, (unsigned int)((theProblem->permille + 5) / 10),
					(unsigned int)theProblem->GetKeysDone().lo);
				fflush(stdout);

      			UpdateThreadProgress(0, (theProblem->permille + 5) / 10,
      								 theProblem->GetKeysDone().lo, true );
      			UpdateClientInfo(&client_info);

				benchmark_ticks = *TICKS;
				}
			#endif
			break;	
	
	case CLIEVENT_BENCHMARK_FINISHED:
			// restore normal console output
			doing_bench_output = false;
			#ifdef MAC_GUI
			macConOut("\r");

			// show result in GUI
			if (parm != 0) {
				benchrate = *((double *)parm);
	    		sprintf(smsg, "%s benchmark: %.0fKkeys/sec", thiscontest, benchrate/1000.0);
	    		SetStatusMessage(smsg);
				}
			#endif
			DestroyGUIThread(0);
			break;

	case CLIEVENT_BUFFER_FETCHBEGIN:
			textparm = (char *)parm;
			NewProxyMessage(textparm);
			start_counts[0] = GetBufferCount(0, true);
			start_counts[1] = GetBufferCount(1, true);
			StartActiveFetch();
			break;
	case CLIEVENT_BUFFER_FETCHFETCHED:
			ffinfo = (struct Fetch_Flush_Info *)parm;
			SetBufferCount(ffinfo->contest, true, 
			  start_counts[ffinfo->contest] + ffinfo->contesttrans);
			break;
	case CLIEVENT_BUFFER_FETCHEND:
			EndActiveFetch();
			break;
	case CLIEVENT_BUFFER_FLUSHBEGIN:
			textparm = (char *)parm;
			NewProxyMessage(textparm);
			start_counts[0] = GetBufferCount(0, false);
			start_counts[1] = GetBufferCount(1, false);
			StartActiveFlush();
			break;
	case CLIEVENT_BUFFER_FLUSHFLUSHED:
			ffinfo = (struct Fetch_Flush_Info *)parm;
			SetBufferCount(ffinfo->contest, false, 
			  start_counts[ffinfo->contest] - ffinfo->contesttrans);
			break;
	case CLIEVENT_BUFFER_FLUSHEND:
			EndActiveFlush();
			break;
	case CLIEVENT_PROBLEM_TFILLFINISHED:
			#ifdef MAC_GUI
			theApp->theThreadApp->RefreshBufferCounts();
			UpdateClientInfo(&client_info);
			SetFetchAdjustment();
			#endif
			break;
	case CLIEVENT_CLIENT_RUNFINISHED:
			#ifdef MAC_GUI
			theApp->theThreadApp->RefreshBufferCounts();
			UpdateClientInfo(&client_info);
			SetFetchAdjustment();
			#endif
			break;
	case CLIEVENT_SELFTEST_STARTED:
			#ifdef MAC_GUI
			test_contest = parm;
			test_count[1] = 0;
			if (test_contest == 0) test_count[0] = 0;
			sprintf(smsg, "Tests Passed: RC5: %d/32, DES: %d/32",
			  test_count[0], test_count[1]);
			  SetStatusMessage(smsg);
			#endif
			break;
	case CLIEVENT_SELFTEST_TESTEND:
			#ifdef MAC_GUI
			test_count[test_contest]++;
			if (parm == 0) {
				sprintf(smsg, "*** %s test %d failed! ***",
					contestnames[test_contest], test_count[test_contest]);
			  	SetStatusMessage(smsg);
				}
			else {
				sprintf(smsg, "Tests Passed: RC5: %d/32, DES: %d/32",
					test_count[0], test_count[1]);
			  	SetStatusMessage(smsg);
				}
			#endif
			break;
	case CLIEVENT_PROBLEM_TFILLSTARTED:
			#ifdef MAC_GUI
			if (theApp->runActive) UpdateRunStatus(parm);
			#endif
			break;
	case CLIEVENT_PROBLEM_FINISHED:
			#ifdef MAC_GUI
			finished_prob = GetProblemPointerFromIndex(parm);
			if (finished_prob != NULL) {
				if (finished_prob->GetResultCode() >= 0) {
					FinishThreadProgress(parm, finished_prob->GetKeysDone());
					}
				}
			#endif
			break;
	case CLIEVENT_CLIENT_THREADSTARTED:
			#ifdef MAC_GUI
			theProblem = GetProblemPointerFromIndex(parm);
			MakeGUIThread(theProblem->contest, parm);
			InitializeThreadProgress(parm, (theProblem->CalcPermille() + 5) / 10,
				theProblem->GetKeysDone());
			UpdateClientInfo(&client_info);
			#endif
			break;
//	case CLIEVENT_CLIENT_THREADSTOPPED:   currently not used
//			break;
	default:
			break;
	}	
}

Boolean activeMac(unsigned long current_ticks, Boolean mouse_moved)
{
EventRecord dummy_event;

// Handle mouse
if (mouse_moved) {
	goto active_return;
	}

// Check if we are doing network I/O
if (netio_active) {
	goto active_return;
	}


// Check for handled events
if (last_event_tick != 0) {
	if (*last_event_tick > last_active_tick) {
		goto active_return;
		}
	}

// Check event queue
if (LMGetEventQueue()->qHead != nil) {
	goto active_return;
	}

// Check for pending window updates
if (CheckUpdate(&dummy_event)) {
	goto active_return;
	}

// nothing at all found
return(false);

// something found
active_return:
	last_active_tick = current_ticks;
	return(true);
}

void do_yield_processing(void)
{
Boolean memOK;
static Boolean haveNotifiedLowMemory = false;

// don't do anything if still starting up
if (timing_core) return;

// processing we want to do whenever we can yield CPU
// normally called before each call to WaitNextEvent

// Check for low memory
if (!(theApp->threadActive)) {
	memOK = RecoverReserveMemory();
	if (memOK) {
		haveNotifiedLowMemory = false;
		} 
	else if (!haveNotifiedLowMemory) {
		mySetCursor(kArrowCursor);
		show_message_string(kMemLowWarning, 0, CAUTION_ALERT_KIND);
		haveNotifiedLowMemory = true;
		}
	}

// Check for auto-foreground
theApp->handle_auto_fg();
}

OSErr GiveTimeDuringNetworkOperation(void)
{
netio_active = true;
YieldToMain(false);
netio_active = false;
if (socket_connect_active) {	// allow connect to be aborted
	return(CheckExitRequestTriggerNoIO() ? abortErr : noErr);
	}
else {
	return(noErr);
	}
}

u32 GetTimesliceToUse(u32 contestid)
{
u32 result;

switch(contestid) {
	case 0:
			result = RC5_timeslice_to_use;
			break;
	case 1:
			result = DES_timeslice_to_use;
			break;
	default:
			result = RC5_timeslice_to_use;
			break;
	}

return(result);
}

char useMP(void)
{
return cs.use_MP;
}

/*
// Check if any windows have non-empty update regions
// The Event Manager will generate an update event for them
Boolean WindowUpdatePending(void)
{
WindowPeek wp;

wp = (WindowPeek)LMGetWindowList();
while (wp != 0) {
	if (!EmptyRgn(wp->updateRgn)) {
		return(true);
		}
	wp = wp->nextWindow;
	}

return(false);
} */

void do_client_command(char *command)
{
if (strcmp(command, "-fetch") == 0) {
	theApp->client_command(command, kFetchItem);
	}
else if (strcmp(command, "-flush") == 0) {
	theApp->client_command(command, kFlushItem);
	}
}

void set_gui_window_height(short height, Rect *updateRect)
{
theApp->size_gui_window(height, updateRect);
}

void NewProxyMessage ( const char *text)
{
short len;

len = strlen(text);
if (len > 255) len = 255;
memcpy(client_info.lastServerMessage, text, len);
client_info.lastServerMessage[len] = 0;
client_info.hasServerMessageChanged = true;
UpdateClientInfo(&client_info);
strcpy(saved_server_message, client_info.lastServerMessage);
need_completed_message = false;
}

void RestoreProxyMessage(void)
{
strcpy(client_info.lastServerMessage, saved_server_message);
UpdateClientInfo(&client_info);
need_completed_message = false;
}

short GetBufferCount(short contest, Boolean input)
{
if (input) {
	return(client_info.buffersInfo[contest].inputBuffer.numBlocks);
	}
else {
	return(client_info.buffersInfo[contest].outputBuffer.numBlocks);
	}
}

void SetBufferCount(short contest, Boolean input, short count)
{
if (count < 0) count = 0;		// be paranoid

if (input) {
	client_info.buffersInfo[contest].inputBuffer.numBlocks = count;
	if (count > theApp->theThreadApp->inthreshold[contest]) {
		client_info.buffersInfo[contest].inputBuffer.totalBlocks = count;
		}
	else {
		client_info.buffersInfo[contest].inputBuffer.totalBlocks =
			theApp->theThreadApp->inthreshold[contest];
		}
	}
else {
	client_info.buffersInfo[contest].outputBuffer.numBlocks = count;
	if (count > theApp->theThreadApp->outthreshold[contest]) {
		client_info.buffersInfo[contest].outputBuffer.totalBlocks = count;
		}
	else {
		client_info.buffersInfo[contest].outputBuffer.totalBlocks =
			theApp->theThreadApp->outthreshold[contest];
		}
	}

#ifdef MAC_GUI
SetFetchAdjustment();
UpdateClientInfo(&client_info);
#endif
theApp->theThreadApp->UpdateFileDates();
}

#ifdef MAC_GUI
void SetFetchAdjustment(void)
{
if (theApp->runActive) {
	if (haveMP && cs.use_MP) {
		gFetchAdjustment = theApp->theThreadApp->numcpu;
		}
	else {
		gFetchAdjustment = 1;
		}
	}
else {
	gFetchAdjustment = 0;
	}
}
#endif

void StartActiveFetch(void)
{
if (!(theApp->runActive)) {
	client_info.buffersInfo[0].inputBuffer.changingRightNow = true;
	client_info.buffersInfo[1].inputBuffer.changingRightNow = true;
	UpdateClientInfo(&client_info);
	theApp->theThreadApp->UpdateFileDates();
	}
}

void StartActiveFlush(void)
{
if (!(theApp->runActive)) {
	client_info.buffersInfo[0].outputBuffer.changingRightNow = true;
	client_info.buffersInfo[1].outputBuffer.changingRightNow = true;
	UpdateClientInfo(&client_info);
	theApp->theThreadApp->UpdateFileDates();
	}
}

void EndActiveFetch(void)
{
if (client_info.buffersInfo[0].inputBuffer.changingRightNow ||
	client_info.buffersInfo[1].inputBuffer.changingRightNow) {
	client_info.buffersInfo[0].inputBuffer.changingRightNow = false;
	client_info.buffersInfo[1].inputBuffer.changingRightNow = false;
	UpdateClientInfo(&client_info);
	theApp->theThreadApp->UpdateFileDates();
	}
}

void EndActiveFlush(void)
{
if (client_info.buffersInfo[0].outputBuffer.changingRightNow ||
    client_info.buffersInfo[1].outputBuffer.changingRightNow) {
	client_info.buffersInfo[0].outputBuffer.changingRightNow = false;
	client_info.buffersInfo[1].outputBuffer.changingRightNow = false;
	UpdateClientInfo(&client_info);
	theApp->theThreadApp->UpdateFileDates();
	}
}

void SetStatusMessage(char *text)
{
strcpy(client_info.lastServerMessage, text);
client_info.hasServerMessageChanged = true;
UpdateClientInfo(&client_info);
need_completed_message = false;
}

void UpdateClientInfo(ClientInfo *theInfo)
{
#ifdef MAC_GUI
GrafPtr gp;

GetPort(&gp);
SetPort(theApp->theGUIWindow->myWindow);
UpdateMainWindowInfo(theInfo);
SetPort(gp);
#endif
}

#ifdef MAC_GUI
void InitializeClientInfo(ClientInfo *theInfo, short cpunum, Boolean update)
{
GrafPtr gp;

GetPort(&gp);
SetPort(theApp->theGUIWindow->myWindow);
InitializeMainWindowInfo(theInfo, cpunum, update);
SetPort(gp);
}
#endif

void MakeGUIThread(short contest, short cpunum)
{
ThreadInfoPtr theThread;

theThread = &(client_info.threadsInfo[cpunum]);
if (!theThread->inUse) {
	client_info.numThreads++;
	}
memset(theThread, 0, sizeof(ThreadInfo));
theThread->inUse = true;
theThread->projectType = contest;
UpdateClientInfo(&client_info);
}

void DestroyGUIThread(short cpunum)
{
ThreadInfoPtr theThread;

theThread = &(client_info.threadsInfo[cpunum]);
if (theThread->inUse && (client_info.numThreads > 0)) {
	client_info.numThreads--;
	}
memset(theThread, 0, sizeof(ThreadInfo));
UpdateClientInfo(&client_info);
}

void DestroyAllGUIThreads(void)
{
short i;

for (i = kMaxNumThreads - 1; i >= 0; i--) {
	DestroyGUIThread(i);
	}
}

#ifdef MAC_GUI
void UpdateRunStatus(unsigned int problem_count)
{
(theApp->theThreadApp)->UpdateProblemStatus(problem_count);
}
#endif

void UpdateThreadProgress(short cpunum, short percent, unsigned long keys,
		Boolean benchmark)
{
ThreadInfoPtr theThread;

theThread = &(client_info.threadsInfo[cpunum]);
if (benchmark && (percent != 0)) {	// 0 resets ticks at start
	if ((percent - theThread->progressPercent) < 3) return;
	}
theThread->progressPercent = percent;
theThread->blockKeysChecked = keys;
if (theThread->projectType == 1) {
	theThread->blockKeysChecked <<= 1;
	}
theThread->totalMillionKeysChecked =
   (((double)keys) + ((double)thread_finished_totals[cpunum])) / 1000000.0;
}

void InitializeThreadProgress(short cpunum, short percent, u64 keys)
{
ThreadInfoPtr theThread;
unsigned long long my_keys;

my_keys = keys.lo + (unsigned long long)(keys.hi << 32);

theThread = &(client_info.threadsInfo[cpunum]);
theThread->progressPercent = percent;
theThread->blockKeysChecked = my_keys;
if (theThread->projectType == 1) {
	theThread->blockKeysChecked <<= 1;
	}
theThread->totalMillionKeysChecked =
   (((double)my_keys) + ((double)thread_finished_totals[cpunum])) / 1000000.0;
InitializeClientInfo(&client_info, cpunum, 
	cpunum == (theApp->theThreadApp->numcpu - 1));
}

void FinishThreadProgress(short cpunum, u64 keys)
{
ThreadInfoPtr theThread;

thread_finished_totals[cpunum] += keys.lo;
thread_finished_totals[cpunum] += (unsigned long long)(keys.hi << 32);

theThread = &(client_info.threadsInfo[cpunum]);
theThread->progressPercent = 0;
theThread->blockKeysChecked = 0;
theThread->totalMillionKeysChecked = ((double)thread_finished_totals[cpunum]) / 1000000.0;
#ifdef MAC_GUI
UpdateClientInfo(&client_info);
#endif
}
