// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: RC5App.h,v $
// Revision 1.12.2.1  1999/07/11 00:29:34  sampo
// simplify general config panel, add ability to set in and out buffers to different sizes.
//
// Revision 1.12  1999/05/08 01:58:01  dicamillo
// "keys" argument of InitializeThreadProgress changed to "u64".
//
// Revision 1.11  1999/03/22 05:52:52  dicamillo
// Update to support client_loadorder instead of preferred_contest
//
// Revision 1.10  1999/01/17 18:21:04  sampo
// 3rd round fba changes
//
// Revision 1.9  1999/01/10 05:58:27  dicamillo
// Changes for settings handling and for restart requests.
//
// Revision 1.8  1999/01/06 06:56:02  dicamillo
// Change DES yield routine.
//
// Revision 1.7  1999/01/06 06:16:49  dicamillo
// Update for one checkpoint file for all contests.
//
// Revision 1.6  1999/01/02 22:47:27  dicamillo
// Add net_is_default_proxy for network settings.
//
// Revision 1.5  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.4  1998/12/31 08:22:03  dicamillo
// Add useMP function.
//
// Revision 1.3  1998/12/30 07:36:47  dicamillo
// Added GetBufferCount; changed SetBufferCount; added SetFetchAdjustment.
//
// Revision 1.2  1998/12/29 09:30:47  dicamillo
// Added macConOut called by ConOut.  Added initial client event support.
//
// Revision 1.1  1998/12/15 06:16:02  dicamillo
// First Checked In.
//

class RC5App : public AppObject
{
public:
	// variables
	char system_version[16];			// version, e.g. "7.1" or "7.5.1"
	WTextDisplayWindow *theWTextDisplayWindow;
	#ifdef MAC_GUI
	GUIWindow *theGUIWindow;
	#endif
	TextRscWindow *theHelpWindow;
	DialogPtr config_dlgptr;
	Boolean aeventavail;
	Mac_Client *theThreadApp;
	Boolean threadActive;
	Boolean runActive;
	Boolean commandPending;
	Boolean resumePending;
	char timestamp[256];
	char run_option[32];
	char command_pending_option[32];
	char resume_pending_option[32];
	short run_item;
	short command_pending_item;
	short resume_pending_item;
	char done_pending;
	dialog_settings default_settings;
	dialog_settings file_settings;
	double RC5_ms_iterations_0;
	double RC5_ms_iterations_1;
	double DES_ms_iterations_0;
	double DES_ms_iterations_1;
	short current_check_item;
	short current_diamond_item;
	Boolean CPU_can_idle;
	Boolean did_init_settings;
	Boolean did_move_to_fg;
	Boolean did_gui_init;
	unsigned long short_inactive;
	unsigned long long_inactive;
	long limit_adjustment;
	unsigned long suspend_ticks;
	unsigned long mouse_moved_ticks;
	short help_window_h_loc;
	short help_window_v_loc;
	short help_window_width;
	short help_window_height;
	char  help_window_info_stored;

 	// methods
	RC5App(void);
	~RC5App(void);
	OSErr InitApp(Boolean init_heap);
	void InitializeGUIData(void);
	OSErr InstallGNEWatcher(void);
	void define_font_menu(void);
	void final_font_menu(short init_fontnum);
	void EndApp(void);
	void calculate_yield_times(settings_list *sl);
	double TimeIterations(double maxtime, short core);
	void write_mac_settings(void);
	Boolean get_one_event(EventRecord *myEvent);
	void do_null_event(void);
	void mf_resume(long message);
	void mf_suspend(void);
	void handle_auto_fg(void);
	void upd_log_windpos(void);
	void upd_gui_windpos(void);
	void upd_help_windpos(void);
	void upd_buffers_contest(void);
	void check_window_info(char *window_info_stored, short window_height,
						   short window_width, short window_h_loc,
						   short window_v_loc);
	void check_font_info(void);
	void do_often(void);
	void size_gui_window(short height, Rect *updateRect);
	void update_log(Boolean quitting);
	#ifdef MAC_GUI
	void menu_upd(void);
	Boolean do_command(short theMenu, short theItem);
	#endif
	void new_offline_mode(short mode);
	void define_new_font(short font_item, short font_number);
	void define_new_pointsize(short size_item, short font_size);
	void define_new_style(short style_bits, Style new_style);
	Boolean do_configure(Boolean ini_file_ok);
	#ifdef MAC_GUI
	void do_go_away(WindowPtr theWindow, Boolean all_windows);
	#endif
	void run_client(char *option, short theItem);
	Boolean start_thread(char *option, short theItem);
	void stop_thread(void);
	void do_quit(void);
	void client_command(char *option, short theItem);
	void handle_pending(void);
	void run_crunch(char *option, short theItem);
	void update_timestamp(void);
	void ConfigureDialog(dialog_settings *default_settings,
								 dialog_settings *new_settings,
								 settings_list *ds,
								 settings_list *ns);
	Boolean trackConfigIcon(WindowPtr dlgptr, short itemHit);
	void newemail(DialogPtr dlgptr, char *email,
						  Boolean *showOK, Boolean doframe);
	void setemail(DialogPtr dlgptr, char *email);
	void GeneralDialog(dialog_settings *default_settings,
							   dialog_settings *new_settings);
	void setgeneral(DialogPtr dlgptr, char *loadorder_map,
					    short preferred_blocksize,
		   				short *inthresholds, short *outthresholds,
		   				short count, long minutes,
		   				short percentprintingoff);
	void NetworkDialog(dialog_settings *default_settings,
							   dialog_settings *new_settings);
	void setnetwork(DialogPtr dlgptr, char firemode, char *keyproxy,
							long keyport, char *httpproxy, long httpport,
							char uuehttpmode, char *use_keyport, char *use_keyproxy,
							char *use_HTTPport, char *use_HTTPproxy, char *httpid,
							Boolean need_enable);
	void disable_network_buttons(DialogPtr dlgptr);
	void set_network_text(DialogPtr dlgptr, char *s, short static_item,
								  short text_item, char use_new, char *use_current,
								  Boolean *did_select_text);
	void define_httpid(char *httpid, char *userid,
							   char *pass, char uuehttpmode);
	char * base64encode(char *username, char *password);
	Boolean IDDialog(char *userid, char *pass);
	Boolean net_is_default_proxy(char *s);
	void MacOSDialog(DialogPtr configdlg, settings_list *ds,
							 settings_list *ns);
	void setmacos(DialogPtr dlgptr, short resplevel, unsigned short customticks,
					  Boolean resume, Boolean maxcpu, Boolean all_fonts,
					  double cpu_start, double cpu_end, Boolean auto_fg,
					  double auto_fg_delay);
	void CPUDialog(dialog_settings *default_settings,
							 dialog_settings *new_settings);
	void setcpu(DialogPtr dlgptr, short cputype, short numcpu,
						Boolean allcpu);
	void EMailDialog(dialog_settings *default_settings,
							 dialog_settings *new_settings);
	void setemail(DialogPtr dlgptr, char *smtpsrvr, long smtpport,
						  long messagelen, char *smtpfrom, char *smtpdest);
	void FilesDialog(dialog_settings *default_settings,
						 dialog_settings *new_settings);
	void setfiles(DialogPtr dlgptr, char *checkpoint, char *logfile);
	Boolean compare_settings_list(settings_list *s1, settings_list *s2);
	OSErr read_ini_settings(dialog_settings *s);
	OSErr write_ini_settings(dialog_settings *s);
	void copy_settings_from_client(dialog_settings *s, Client *theClient);
	void copy_settings_to_client(dialog_settings *s, Client *theClient);
	Boolean compare_dialog_settings(dialog_settings *ds1, dialog_settings *ds2);
	char * get_thread_description(char *option);
	void DoYieldToMain(char force_events);
	void aboutdlg(void);
	void help_window(void);
	void do_high_level_event(EventRecord *myEvent);
	static pascal OSErr HandleOAPP(AppleEvent *theAppleEvent,
								   AppleEvent *reply,
								   long handlerRefCon);
	static pascal OSErr HandleODOC(AppleEvent *theAppleEvent,
								   AppleEvent *reply,
								   long handlerRefCon);
	static pascal OSErr HandlePDOC(AppleEvent *theAppleEvent,
								   AppleEvent *reply,
								   long handlerRefCon);
	static pascal OSErr HandleQUIT(AppleEvent *theAppleEvent,
								   AppleEvent *reply,
								   long handlerRefCon);
#ifdef powerc
	static RoutineDescriptor HandleOAPPRD;
	static RoutineDescriptor HandleODOCRD;
	static RoutineDescriptor HandlePDOCRD;
	static RoutineDescriptor HandleQUITRD;
	static RoutineDescriptor abouttextRD;
#endif
};

pascal void about_user_text(DialogPtr dialog, short itemNo);

OSErr GotAllParms(AppleEvent *theAppleEvent);
pascal void configiconproc(WindowPtr dlgwindow, short item);
void ClientEventListener(int event_id, long parm);
void macConOut(char *msg);
void YieldToMain(char force_events);
void DES_YieldToMain(void);
void do_yield_processing(void);
OSErr GiveTimeDuringNetworkOperation(void);
u32 GetTimesliceToUse(u32 contestid);
char useMP(void);
// Boolean WindowUpdatePending(void);
Boolean activeMac(unsigned long current_ticks, Boolean mouse_moved);
void do_client_command(char *command);
void set_gui_window_height(short height, Rect *updateRect);
void NewProxyMessage ( const char *text);
void RestoreProxyMessage(void);
short GetBufferCount(short contest, Boolean input);
void SetBufferCount(short contest, Boolean input, short count);
void SetFetchAdjustment(void);
void StartActiveFetch(void);
void StartActiveFlush(void);
void EndActiveFetch(void);
void EndActiveFlush(void);
void SetStatusMessage(char *text);
void UpdateClientInfo(ClientInfo *theInfo);
void InitializeClientInfo(ClientInfo *theInfo, short cpunum, Boolean update);
void MakeGUIThread(short contest, short cpunum);
void DestroyGUIThread(short cpunum);
void DestroyAllGUIThreads(void);
void UpdateRunStatus(unsigned int problem_count);
void UpdateThreadProgress(short cpunum, short percent, unsigned long keys,
	Boolean benchmark);
void InitializeThreadProgress(short cpunum, short percent, u64 keys);
void FinishThreadProgress(short cpunum, u64 keys);

Boolean parse_pass(StringPtr dlgtext);
pascal Boolean passDlgFilter(DialogPtr dlg, EventRecord *eventptr,
							 short *itemptr);
void updpass(short start, short end, unsigned char c);
void appendpass(unsigned char *text, unsigned char *s, short len);

#define LOG_FILE_NAME "\prc5des log"
