// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: TextRscView.cpp,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:16:55  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *TextRscView_cpp(void) {
return "@(#)$Id: TextRscView.cpp,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#include "macdefs.h"
#include "apputils.h"
#include "window_info.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "TextRscView.h"
#include "WindowObject.h"

TextRscView::TextRscView(void)
{
// initialize handles and region
text_handle = 0;
style_handle = 0;
text_region = 0;
my_region = 0;
myEditRec = 0;
useUpdateProc = true;
}

TextRscView::~TextRscView(void)
{
// free storage for handles
if (myEditRec != 0) {
	TEDispose(myEditRec);
	text_handle = 0;	// also returns text storage
	style_handle = 0;
	myEditRec = 0;
	}
if (text_handle != 0) {
	DisposeHandle(text_handle);
	text_handle = 0;
	}
if (style_handle != 0) {
	DisposeHandle(style_handle);
	style_handle = 0;
	}
if (text_region != 0) {
	DisposeRgn(text_region);
	text_region = 0;
	}
if (my_region != 0) {
	DisposeRgn(my_region);
	my_region = 0;
	}
}

// define_text_rsc stores the information defining the text to display

void TextRscView::define_text_rsc(Handle theText, Handle theStyle,
								  char *init_window_name)
{
strcpy((char *)myName, init_window_name);
text_handle = theText;
style_handle = theStyle;
}

OSErr TextRscView::init_view(WindowPtr initWindow,
							 window_info_rec *the_window_info)
{
short font_num;
Rect textRect;
OSErr rc;

rc = ViewObject::init_view(initWindow, the_window_info);
if (rc != noErr) {
	return(rc);
	}

text_region = NewRgn();
if (text_region == 0) {
	return(memFullErr);
	}

my_region = NewRgn();
if (my_region == 0) {
	return(memFullErr);
	}

// set initial font and point size
GetFNum("\pGeneva", &font_num);
TextFont(font_num);
TextSize(9);

// define rectangle for text
textRect = the_window_info->initial_rect;
textRect.bottom = textRect.top;			// height will be adjusted

// Create new TextEdit record
// Note: TENew must be called with our window the current GrafPort.
myEditRec = TEStyleNew(&textRect, &textRect);
if (myEditRec == 0) {
	return(memFullErr);
	}

// add our text
HLock(text_handle);
if (style_handle != 0) {
	HLock(style_handle);
	TESetSelect(0, 0, myEditRec);
	TEStyleInsert(*text_handle, GetHandleSize(text_handle),
				 (StScrpHandle)style_handle, myEditRec);
	DisposeHandle(style_handle);
	style_handle = 0;
	}
else {
	TESetText(*text_handle, GetHandleSize(text_handle), myEditRec);
	}
DisposeHandle(text_handle);
text_handle = 0;

// Adjust height of rectangles
textRect.bottom = textRect.top + TEGetHeight((*myEditRec)->nLines, 1, myEditRec);

(*myEditRec)->viewRect = (*myEditRec)->destRect = textRect;
TECalText(myEditRec);
//the_window_info->initial_rect = textRect;

return(noErr);
}

// drawing routines

// update offsets after scrolling
void TextRscView::update_contents(long h_Offset, long v_Offset)
{
h_scrollOffset = h_Offset;
v_scrollOffset = v_Offset;
}

void TextRscView::get_view_size(long *height, long *width)
{
*height = (*myEditRec)->destRect.bottom - (*myEditRec)->destRect.top;
*width = (*myEditRec)->destRect.right - (*myEditRec)->destRect.left;
}

// draw contents
void TextRscView::draw_contents(RgnHandle updateRegion)
{
Point savedOffsets, newOffsets;

// adjust offset for scrolling
savedOffsets.h = myWindow->portRect.left;
savedOffsets.v = myWindow->portRect.top;
newOffsets.h = h_scrollOffset * h_unitsize;
newOffsets.v = v_scrollOffset * v_unitsize;
SetOrigin(newOffsets.h, newOffsets.v);

// draw the text
	// get intersection of text and update region
RectRgn(text_region, &((*myEditRec)->viewRect));
SectRgn(text_region, updateRegion, text_region);
	// call TEUpdate if any of the text needs to be drawn
if (!EmptyRgn(text_region)) { 
	EraseRgn(text_region);	// for picture with no background
	TEUpdate(&((*myEditRec)->viewRect), myEditRec);
	}
	
// draw any parts of myRect not drawn by TextEdit
	// get difference between my region and the text
RectRgn(text_region, &((*myEditRec)->viewRect));
RectRgn(my_region, &myRect);
DiffRgn(my_region, text_region, text_region);
	// now check for any intersection with the update region
SectRgn(updateRegion, text_region, text_region);
	// erase parts picture didn't cover
if (!EmptyRgn(text_region)) {
	EraseRgn(text_region);
	}
	
// reset origin (very important!)
SetOrigin(savedOffsets.h, savedOffsets.v);
}

void TextRscView::adjust_view_rect(Rect *new_content_rect,
								  long new_h_scroll_offset,
								  long new_v_scroll_offset,
								  Boolean init_call,
								  Boolean new_style_call)
{
Rect textRect;

ViewObject::adjust_view_rect(new_content_rect,
	new_h_scroll_offset, new_v_scroll_offset,
	init_call, new_style_call);

textRect = *new_content_rect;
textRect.bottom = textRect.top;			// height will be adjusted
(*myEditRec)->viewRect = (*myEditRec)->destRect = textRect;
TECalText(myEditRec);

textRect.bottom = textRect.top + TEGetHeight((*myEditRec)->nLines, 1, myEditRec);

(*myEditRec)->viewRect = (*myEditRec)->destRect = textRect;
TECalText(myEditRec);
}

// this is used when the view's contents change with the size
// otherwise, should do nothing to avoid flickering
void TextRscView::draw_for_new_view_size(void)
{
	InvalRect(&myRect);
}
