// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: TextView.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:17:28  dicamillo
// First Checked In.
//

class TextView : public ViewObject
{
public:
Handle text_handle;
RgnHandle text_region;
RgnHandle my_region;
Rect old_view_rect;
long view_height;
static RoutineDescriptor text_clickProcRD;
short font_number;
short font_size;
Style font_style;
short line_height;
short font_ascent;
InputProcPtr input_proc;
NewlineProcPtr newline_proc;
Boolean initial_activate;
Boolean read_only;

TextView(void);
virtual ~TextView(void);
virtual void define_text(char *textName, Handle textHandle,
		short fnum, short fsize, Style fstyle, Boolean activate,
		Boolean readonly, short extra_lines);
virtual void define_line_height(void);
virtual OSErr init_view(WindowPtr initWindow,
						window_info_rec *the_window_info);
virtual void adjust_view_rect(Rect *new_content_rect,
							  long new_h_scroll_offset,
							  long new_v_scroll_offset,
							  Boolean init_call,
							  Boolean new_style_call);
virtual void get_view_size(long *height, long *width);
virtual Boolean mouse_in_text(Point mouseloc);
virtual Boolean do_click(Point where, EventRecord *theEvent);
virtual Boolean do_key_down(EventRecord *theEvent);
virtual void set_input_proc(InputProcPtr the_proc);
virtual void set_newline_proc(NewlineProcPtr the_proc);
virtual char process_input_line(void);
virtual void get_new_scroll_offsets(long *new_h_offset,
									long *new_v_offset);
virtual void define_new_font(short app_font_number);
virtual void define_new_pointsize(short app_font_size);
virtual void define_new_style(Style app_font_style);
virtual void show_new_style(void);
virtual Boolean do_TEFunction(short theFunction);
virtual void get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
							Boolean *paste_ok, Boolean *clear_ok);
virtual void append_text(char *new_text, short new_text_length);
virtual void delete_text(short delete_start, short delete_end);
virtual CharsHandle get_text(void);
virtual short get_text_size(void);
virtual short get_linecount(void);
virtual short get_lineheight(void);
virtual void import_scrap(void);
virtual void export_scrap(void);
virtual void draw_contents(RgnHandle updateRegion);
virtual void update_contents(long h_Offset, long v_Offset);
virtual void scroll_contents(long dh, long dv);
static pascal Boolean text_clickProc(void);
};
