// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: WTextView.cpp,v $
// Revision 1.3  1999/01/17 18:33:46  sampo
// 3rd round fba changes
//
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:19:02  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *WTextView_cpp(void) {
return "@(#)$Id: WTextView.cpp,v 1.3 1999/01/17 18:33:46 sampo Exp $"; }
#endif

#include "macdefs.h"
#include "WASTE.h"
#include "WETabs.h"
#include "apputils.h"
#include "resdefs.h"
#include "window_info.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "WTextView.h"
#include "WindowObject.h"

// static data for drawing
RoutineDescriptor WTextView::Wtext_clickProcRD = 
	BUILD_ROUTINE_DESCRIPTOR(uppWEClickLoopProcInfo, Wtext_clickProc);

WTextView::WTextView(void)
{
// initialize variables
text_handle = 0;
myWEditRec = 0;
text_region = 0;
my_region = 0;
old_view_rect.top = old_view_rect.left =
old_view_rect.bottom = old_view_rect.right = 0;
h_offset = v_offset = 4;		// define margins
								// horizontal scrolling
h_scrollsize = 12;				//	use 12 units for continuous scrolling
h_unitsize = 1;					//	scroll units are pixels
								// vertical scrolling
v_scrollsize = 1;				//	use 1 unit (line) for continuous scrolling
v_unitsize = 12;				//	scroll units are lines
useUpdateProc = useScrollProc = true;
initial_activate = true;
read_only = false;
input_proc = 0;					// no input proc
}

WTextView::~WTextView(void)
{
// free storage
if (myWEditRec != 0) {
						// end Inline Input
	WEStopInlineSession(myWEditRec);
	WEDispose(myWEditRec);
	text_handle = 0;	// also returns text storage
	myWEditRec = 0;
	}
if (text_handle != 0) {
	DisposeHandle(text_handle);
	text_handle = 0;
	}
if (text_region != 0) {
	DisposeRgn(text_region);
	text_region = 0;
	}
if (my_region != 0) {
	DisposeRgn(my_region);
	my_region = 0;
	}
if (my_updateRgn != 0) {
	DisposeRgn(my_updateRgn);
	my_updateRgn = 0;
	}
}

// define_text stores the information defining the text to display

void WTextView::define_text(char *textName, Handle textHandle,
	short fnum, short fsize, Style fstyle, Boolean activate,
	Boolean readonly)
{
strcpy((char *)myName, textName);
text_handle = textHandle;
font_number = fnum;
font_size = fsize;
font_style = fstyle;
initial_activate = activate;
read_only = readonly;
}

void WTextView::define_line_height(void)
{
FontInfo info_rec;

GetFontInfo(&info_rec);
line_height = info_rec.ascent + info_rec.descent
			+ info_rec.leading;
font_ascent = info_rec.ascent;
}

// init_view is called after the window for the view is created
OSErr WTextView::init_view(WindowPtr initWindow,
						  window_info_rec *the_window_info)
{
short weflags;
long new_height;
Rect adjRect;
LongRect viewRect, destRect;
OSErr rc;
#if GENERATINGPOWERPC
RoutineDescriptorPtr clickLoop;
#else
WEClickLoopProcPtr clickLoop;
#endif

rc = ViewObject::init_view(initWindow, the_window_info);
if (rc != noErr) {
	return(rc);
	}

text_region = NewRgn();
if (text_region == 0) {
	return(memFullErr);
	}

my_region = NewRgn();
if (my_region == 0) {
	return(memFullErr);
	}

my_updateRgn = NewRgn();
if (my_updateRgn == 0) {
	return(memFullErr);
	}

// save environment information we need
drag_mgr_avail = the_window_info->drag_mgr_avail;

// set initial font and point size
TextFont(font_number);
TextSize(font_size);
define_line_height();

// define initial dest Rect
// This is the rectangle containing all the text, with its top left
// corner offset (by scrolling) so that point (0, 0) in the rectangle
// corresponds to (0, 0) in the window.
// The height of destRect will be adjusted to the amount of text after
// we can get the line count from TextEdit.

// The width is adjusted to equal the maximum allowed width of our window:
destRect.left = h_offset + myRect.left;		// offset by margin
destRect.right = the_window_info->size_rect.right + h_offset - 20 + myRect.left;

// The height is zero for now:
destRect.top = destRect.bottom = v_offset + myRect.top;

// define initial view Rect
// The view rect defines that part of the window's content rect where
// drawing will be done.
viewRect.top = viewRect.bottom = destRect.top;
viewRect.left = viewRect.right = destRect.left;

// Create new TextEdit record
// Note: TENew must be called with our window the current GrafPort.

// set features we want
weflags = 	weDoAutoScroll
			+ weDoOutlineHilite
			+ weDoUndo
			+ weDoIntCutAndPaste
			+ weDoUseTempMem
			+ weDoDrawOffscreen;
if (read_only) {
	weflags += weDoReadOnly;
	}
if (the_window_info->drag_mgr_avail) {
	weflags += 	weDoDragAndDrop;
	}

rc  = WENew(&destRect, &viewRect, weflags, &myWEditRec);
if (rc != noErr) {
	return(rc);
	}

// Set left alignment (for efficiency)
WESetAlignment(weFlushLeft, myWEditRec);

// support tabs
WEInstallTabHooks(myWEditRec);

// add our text
if (text_handle != 0) {
	rc = WEUseText(text_handle, myWEditRec);
	if (rc != noErr) {
		return(rc);
		}
	}
// note: since the height of the dest rectangle is 0,
// adjust_view_rect will call WECalText

// adjust vertical scroll unit size to line height
v_unitsize = line_height;

// adjust rects according to text size
adjRect = the_window_info->initial_rect;
mySetCursor(kWatchCursor);
adjust_view_rect(&adjRect, 0, 0, true, false);
redrawCursor();

// resize the height of our window for the text size
// add space for 2 extra lines
new_height = v_offset
			 + v_unitsize * (WECountLines(myWEditRec) + 2);

// change initial_rect so WindowObject will resize window
the_window_info->initial_rect.bottom =
		the_window_info->initial_rect.top + new_height;

// Install click proc

#if GENERATINGPOWERPC
clickLoop = &Wtext_clickProcRD;
#else
clickLoop = Wtext_clickProc;
#endif

rc = WESetInfo(weClickLoop, &clickLoop, myWEditRec);
if (rc != 0) {
	return(rc);
	}

// Activate the WTextEdit record
if (initial_activate) {
	WEActivate(myWEditRec);
	}
WESetSelection(0, 0, myWEditRec);
ibeamcursor = true;
TEActive = true;

show_new_style();	// not sure why this is necessary- added for WASTE 1.2
return(noErr);
}

void WTextView::adjust_view_rect(Rect *new_view_rect,
								long new_h_scroll_offset,
								long new_v_scroll_offset,
								Boolean init_call,
								Boolean new_style_call)
{
#pragma unused (new_h_scroll_offset, new_v_scroll_offset)
long linecount;
long old_bottom, top, bottom;
LongRect destRect, viewRect;
long h_diff, v_diff;
Rect updateRect;
GrafPtr gp;

// This method adjusts the TE view and dest Rects,
// using new_view_rect as the new size of the contents part of the
// window, and new_scroll_offsets for the current scrolling position.

myRect = *new_view_rect;

// get the current text height with 2 blank lines 
view_height = v_unitsize * (WECountLines(myWEditRec) + 2);

// get the current destination rectangle
WEGetDestRect(&destRect, myWEditRec);

// get the current view rectangle
WEGetViewRect(&viewRect, myWEditRec);

//  for initial call, adjust the height of the destination rectangle
if (init_call) {
	destRect.bottom = destRect.top + view_height;
	WESetDestRect(&destRect, myWEditRec);
	mySetCursor(kWatchCursor);
	WECalText(myWEditRec);
	redrawCursor();
	}

// We're done now unless the view rectangle has changed.  This happens
// only when the window is resized, typically by growing or zooming.

if (!(init_call || new_style_call)) {
	if (EqualRect(&old_view_rect, new_view_rect)) {
		return;
		}
	}

// adjust for new top left coordinates
if (!init_call) {
	h_diff = new_view_rect->left - old_view_rect.left;
	v_diff = new_view_rect->top - old_view_rect.top;
	if ((h_diff != 0) || (v_diff != 0)) {
		destRect.top += v_diff;
		destRect.bottom += v_diff;
		destRect.left += h_diff;
		destRect.right += h_diff;
		WESetDestRect(&destRect, myWEditRec);

		old_view_rect.top += v_diff;
		old_view_rect.bottom += v_diff;
		old_view_rect.left += h_diff;
		old_view_rect.right += h_diff;

		viewRect.top += v_diff;
		viewRect.bottom += v_diff;
		viewRect.left += h_diff;
		viewRect.right += h_diff;
		}
	}

// the height of the view rectangle is adjusted so that it 
// includes only entire lines of text
linecount = (new_view_rect->bottom - new_view_rect->top - v_offset) /
			v_unitsize;
old_bottom = viewRect.bottom;
//viewRect.top = destRect.top - view_top_offset;
viewRect.bottom = viewRect.top + linecount * v_unitsize;

// the view width is adjusted to the contents width
//viewRect.left = destRect.left - view_left_offset;
viewRect.right = viewRect.left +
					new_view_rect->right - new_view_rect->left - h_offset;

// set the new viewRect
WESetViewRect(&viewRect, myWEditRec);

// for initial call, done after saving the view rectangle
if (init_call) {
	old_view_rect = *new_view_rect;
	return;
	}

// Invalidate areas due to changing by line increments.  Because we
// only draw complete lines, the update region invalidated by
// resizing the window must be slightly increased.

if (old_view_rect.bottom == new_view_rect->bottom) {
	old_view_rect = *new_view_rect;
	return;
	}

if (old_view_rect.bottom > new_view_rect->bottom) {
	top = viewRect.bottom;
	bottom = new_view_rect->bottom;
	}
else {	
	top = old_bottom;
	bottom = old_view_rect.bottom; 
	}

if (top != bottom) {
	updateRect.top = top;
	updateRect.left = viewRect.left;
	updateRect.bottom = bottom;
	updateRect.right = viewRect.right;
	GetPort(&gp);
	SetPort(myWindow);
	InvalRect(&updateRect);
	SetPort(gp);
	}

old_view_rect = *new_view_rect;
}

void WTextView::get_view_size(long *height, long *width)
{
LongRect destRect;

WEGetDestRect(&destRect, myWEditRec);
*height = view_height;
*width = destRect.right - destRect.left;
}

void WTextView::set_cursor_state(Boolean *app_TEActive,
								 Boolean *app_waitcursor,
								 Boolean *app_ibeamcursor)
{
*app_TEActive = TEActive;
*app_waitcursor = waitcursor;
*app_ibeamcursor = ibeamcursor;
}

Boolean WTextView::mouse_in_text(Point mouseloc)
{
long selStart, selEnd, mouseOffset;
LongPt thePoint;
signed char edge;

// return true unless the mouse is in the selection range and the
// Drag Manager is in use
if (drag_mgr_avail) {
	WEGetSelection(&selStart, &selEnd, myWEditRec);
	if (selStart == selEnd) return(true);
	thePoint.h = mouseloc.h;
	thePoint.v = mouseloc.v;
	mouseOffset = WEGetOffset(&thePoint, &edge, myWEditRec);
	if ((mouseOffset >= selStart) && (mouseOffset <= selEnd)) {
		return(false);
		}
	}
return(true);
}

Boolean WTextView::do_click(Point where, EventRecord *theEvent)
{
save_view_info();
WEClick(where, theEvent->modifiers, theEvent->when, myWEditRec);
WESelView(myWEditRec);
return(check_view_changed());
}

void WTextView::activate(void)
{
if (TEActive) {
	WEActivate(myWEditRec);
	}
}

void WTextView::deactivate(void)
{
if (TEActive) {
	WEDeactivate(myWEditRec);
	}
}

Boolean WTextView::do_key_down(EventRecord *theEvent)
{
if (read_only) {
	SysBeep(1);
	return(false);
	}

if (input_proc != 0) {
	if ((theEvent->message  & charCodeMask) == 0x0d) {
		process_input_line();
		}
	}

save_view_info();
WEKey(theEvent->message & 0xff, theEvent->modifiers, myWEditRec);
WESelView(myWEditRec);
return(check_view_changed());
}

void WTextView::set_input_proc(InputProcPtr the_proc)
{
input_proc = the_proc;
}

void WTextView::process_input_line(void)
{
char testline[] = "this is a test line\r";

(*input_proc)(testline, strlen(testline));

}

OSErr WTextView::TrackDrag(DragTrackingMessage theMessage,
							DragReference theDrag)
{
if (read_only) {
	return(noErr);
	}

return(WETrackDrag(theMessage, theDrag, myWEditRec));
}

OSErr WTextView::ReceiveDrag(DragReference theDrag,
							  Boolean *view_changed)
{
OSErr rc;

if (read_only) {
	*view_changed = false;
	return(dragNotAcceptedErr);
	}

save_view_info();
rc = WEReceiveDrag(theDrag, myWEditRec);
WESelView(myWEditRec);
*view_changed = check_view_changed();
return(rc);
}

void WTextView::get_new_scroll_offsets(long *new_h_offset,
									  long *new_v_offset)
{
LongRect destRect;
long adj;

// this method is called when TextEdit has changed the destination rect,
// and we need to update the scroll offsets to match
WEGetDestRect(&destRect, myWEditRec);

// Check if the top of the destination rectangle does not correspond
// to the top of a line.  If not, scroll so it does.
// This is necessary due to WASTE's attempt to center selections in
// the destRect.

adj = ((destRect.top - myRect.top - v_offset) / v_unitsize) * v_unitsize;
adj = destRect.top - myRect.top - v_offset - adj;
if (adj != 0) {
	WEScroll(0, -adj, myWEditRec);
	}

h_scrollOffset = (h_offset - destRect.left + myRect.left) / h_unitsize;
v_scrollOffset = (v_offset - destRect.top + myRect.top) / v_unitsize;
if (new_h_offset != 0) {
	*new_h_offset = h_scrollOffset;
	}
if (new_v_offset != 0) {
	*new_v_offset = v_scrollOffset;
	}
}

TEHandle WTextView::get_TEEditRec(void)
{
return((TEHandle)myWEditRec);
}

void WTextView::define_new_font(short app_font_number)
{
font_number = app_font_number;
TextFont(font_number);
show_new_style();
}

void WTextView::define_new_pointsize(short app_font_size)
{
font_size = app_font_size;
TextSize(font_size);
show_new_style();
}

void WTextView::define_new_style(Style app_font_style)
{
font_style = app_font_style;
TextFace(font_style);
show_new_style();
}

void WTextView::show_new_style(void)
{
long selStart, selEnd;
TextStyle ts;
RgnHandle saved_vis;
Boolean active_rec;

// prevent any screen drawing during changes
saved_vis = myWindow->visRgn;
EmptyRgn(my_updateRgn);
myWindow->visRgn = my_updateRgn;

// make WASTE changes

active_rec = WEIsActive(myWEditRec);
if (active_rec) {
	WEDeactivate(myWEditRec);
	}

if (read_only) {
	WEFeatureFlag(weFReadOnly, weBitClear, myWEditRec);
	}
WEGetSelection(&selStart, &selEnd, myWEditRec);
WEFeatureFlag(weFAutoScroll, weBitClear, myWEditRec);
WESetSelection(0, 0x7fffffff, myWEditRec);
ts.tsFont = font_number;
ts.tsFace = font_style;
ts.tsSize = font_size;
WESetStyle(weDoFont + weDoFace + weDoSize + weDoReplaceFace,
		   &ts, myWEditRec);
WEFeatureFlag(weFAutoScroll, weBitSet, myWEditRec);
WESetSelection(selStart, selEnd, myWEditRec);
if (read_only) {
	WEFeatureFlag(weFReadOnly, weBitSet, myWEditRec);
	}
if (active_rec) {
	WEActivate(myWEditRec);
	}

// make our changes
define_line_height();
v_unitsize = line_height;
get_new_scroll_offsets(0, 0);
update_contents(h_scrollOffset, v_scrollOffset);
adjust_view_rect(&old_view_rect, h_scrollOffset, v_scrollOffset,
				 false, true);

// reset visRgn; window object will erase & redraw contentRect
myWindow->visRgn = saved_vis;
}

Boolean WTextView::do_TEFunction(short theFunction)
{
save_view_info();
switch (theFunction) {
	case idle_function:
			WEIdle(0, myWEditRec);
			break;
	case undo_function:
			WEUndo(myWEditRec);
			break;
	case cut_function:
			if (read_only) {
				SysBeep(1);
				}
			else {
				WECut(myWEditRec);
				}
			break;
	case copy_function:
			WECopy(myWEditRec);
			break;
	case paste_function:
			if (read_only) {
				SysBeep(1);
				}
			else {
				WEPaste(myWEditRec);
				}
			break;
	case delete_function:
			if (read_only) {
				SysBeep(1);
				}
			else {
				WEDelete(myWEditRec);
				}
			break;
	case select_all_function:
			WEFeatureFlag(weFAutoScroll, weBitClear, myWEditRec);
			WESetSelection(0, 0x7fffffff, myWEditRec);
			WEFeatureFlag(weFAutoScroll, weBitSet, myWEditRec);
			break;
	default:
			break;
	}
return(check_view_changed());
}

void WTextView::get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
							  Boolean *paste_ok, Boolean *clear_ok)
{
long start, end;
long offset;

*cut_ok = *copy_ok = *paste_ok = *clear_ok = false;

if (myWEditRec == 0) return;

WEGetSelection(&start, &end, myWEditRec);
*copy_ok = (end - start) > 0;

if (read_only) {
	return;
	}

*cut_ok = *clear_ok = *copy_ok;
*paste_ok = GetScrap(0, 'TEXT', &offset) > 0;
}

void WTextView::get_undo_status(Boolean *undo_ok, char *undo_text)
{
WEActionKind action;
Boolean redo;

action = WEGetUndoInfo(&redo, myWEditRec);
if (action == weAKNone) {
	*undo_ok = false;
	strcpy(undo_text, "Can't Undo");
	return;
	}
*undo_ok = true;
if (redo) {
	strcpy(undo_text, "Redo");
	}
else {
	strcpy(undo_text, "Undo");
	}
switch(action) {
	case weAKTyping:
			strcat(undo_text, " Typing");
			break;
	case weAKCut:
			strcat(undo_text, " Cut");
			break;
	case weAKPaste:
			strcat(undo_text, " Paste");
			break;
	case weAKClear:
			strcat(undo_text, " Clear");
			break;
	case weAKDrag:
			strcat(undo_text, " Drag");
			break;
	case weAKSetStyle:
			strcat(undo_text, " Set Style");
			break;
	default:
			break;
	}
}

void WTextView::scroll_contents(long dh, long dv)
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
WEScroll(dh, dv, myWEditRec);
SetPort(gp);
}

void WTextView::update_contents(long h_Offset, long v_Offset)
{
long rect_size;
LongRect destRect;

// adjust destRect from the new scrollOffsets
WEGetDestRect(&destRect, myWEditRec);

rect_size = destRect.bottom - destRect.top;
destRect.top = -(v_Offset * v_unitsize) + v_offset + myRect.top;
destRect.bottom = destRect.top + rect_size;

rect_size = destRect.right - destRect.left;
destRect.left = -(h_Offset * h_unitsize) + h_offset + myRect.left;
destRect.right = destRect.left + rect_size;

WESetDestRect(&destRect, myWEditRec);
}

void WTextView::draw_contents(RgnHandle updateRegion)
{
LongRect l_viewRect;
Rect viewRect;
LongRect destRect;
Rect drawnRect;
long dest_end;
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);

	// get intersection of text and update region
WEGetViewRect(&l_viewRect, myWEditRec);
viewRect.top = l_viewRect.top;
viewRect.left = l_viewRect.left;
viewRect.bottom = l_viewRect.bottom;
viewRect.right = l_viewRect.right;
RectRgn(text_region, &viewRect);
SectRgn(text_region, updateRegion, text_region);
	// call WEUpdate if any of the text need to be drawn
if (!EmptyRgn(text_region)) { 
	EraseRgn(text_region);
	WEUpdate(text_region, myWEditRec);
	}

// draw any parts of myRect not drawn by WEUpdate
	// get in drawnRect the area actually drawn
drawnRect = viewRect;
	// get the logical end of the dest Rect based on the actual number
	// of lines of text
WEGetDestRect(&destRect, myWEditRec);
dest_end = destRect.top
		   + WECountLines(myWEditRec) * v_unitsize;
	// shorten drawnRect to not includes space at the end after last line
if (drawnRect.bottom > dest_end) {
	drawnRect.bottom = dest_end;
	}
	// get difference between my region and the amount drawn
RectRgn(text_region, &drawnRect);
RectRgn(my_region, &myRect);
DiffRgn(my_region, text_region, text_region);
	// now check for any intersection with the update region
SectRgn(updateRegion, text_region, text_region);
	// erase parts TEUpdate didn't cover
if (!EmptyRgn(text_region)) {
	EraseRgn(text_region);
	}

SetPort(gp);
}

// The next two routines are used together to determine if an update
// of some sort requires repositioning the scroll controls

void WTextView::save_view_info(void)
{
WEGetDestRect(&saved_dest, myWEditRec);
saved_lines = WECountLines(myWEditRec);
}

Boolean WTextView::check_view_changed(void)
{
LongRect new_dest;

// Return true if view changed
if (saved_lines != WECountLines(myWEditRec)) {
	return true;
	}
WEGetDestRect(&new_dest, myWEditRec);
if (saved_dest.top != new_dest.top) return(true);
if (saved_dest.left != new_dest.left) return(true);
if (saved_dest.bottom != new_dest.bottom) return(true);
if (saved_dest.right != new_dest.right) return(true);
return(false);
}

void WTextView::append_text(char *new_text, short new_text_length)
{
static long last_cr = 0;
short i;
short next_start_offset;


next_start_offset = 0;
for (i = 0; i < new_text_length; i++) {
	switch(new_text[i]) {
		case '\r':
					last_cr = 0;
					break;
					
		case '\n':
					// output preceding text
					if (i > 0) {
					#ifdef MAC_GUI
						modify_text(0, 0, new_text + next_start_offset,
									i - next_start_offset);
					#endif
						}
					next_start_offset = i + 1;
					// delete text or save starting point
					if (last_cr == 0) {
						last_cr = WEGetTextLength(myWEditRec);
						}
					else {
					#ifdef MAC_GUI
						modify_text(last_cr, WEGetTextLength(myWEditRec),
									0, 0);
					#endif
						}
					
					break;
					
		default:
					break;
		}
	}


if ((new_text_length - next_start_offset) > 0) {
	#ifdef MAC_GUI
	modify_text(0, 0, new_text + next_start_offset,
				new_text_length - next_start_offset);
	#endif
	}
}

void WTextView::modify_text(long delete_start, long delete_end,
							char *new_text, short new_text_length)
{
long text_length, start, end;
Boolean active_rec;
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);

active_rec = WEIsActive(myWEditRec);
if (active_rec) {
	WEDeactivate(myWEditRec);
	}
text_length = WEGetTextLength(myWEditRec);
WEGetSelection(&start, &end, myWEditRec);
if (read_only) {
	WEFeatureFlag(weFReadOnly, weBitClear, myWEditRec);
	}

// delete text if requested
if ((delete_start != 0) || (delete_end != 0)) {
	WEFeatureFlag(weFAutoScroll, weBitClear, myWEditRec);
	WESetSelection(delete_start, delete_end, myWEditRec);
	WEDelete(myWEditRec);
	WEFeatureFlag(weFAutoScroll, weBitSet, myWEditRec);
	}

// add new text
if (new_text_length > 0) {
	WESetSelection(text_length, text_length, myWEditRec);
	WEInsert(new_text, new_text_length, 0, 0, myWEditRec);
	}

if (read_only) {
	WEFeatureFlag(weFReadOnly, weBitSet, myWEditRec);
	}
if (start == end) {
	text_length = WEGetTextLength(myWEditRec);
	WESetSelection(text_length, text_length, myWEditRec);
	}
else {
	WESetSelection(start, end, myWEditRec);
	}
if (active_rec) {
	WEActivate(myWEditRec);
	}

SetPort(gp);
}

Handle WTextView::get_text(void)
{
return(WEGetText(myWEditRec));
}

long WTextView::get_text_size(void)
{
return(WEGetTextLength(myWEditRec));
}

void WTextView::disable_int_cutpaste(void)
{
WEFeatureFlag(weFIntCutAndPaste, weBitClear, myWEditRec);
}

void WTextView::enable_int_cutpaste(void)
{
WEFeatureFlag(weFIntCutAndPaste, weBitSet, myWEditRec);
}

// This routine is called as a clickProc by WEClick
pascal Boolean WTextView::Wtext_clickProc(WEHandle theWEditRec)
{
#pragma unused (theWEditRec)
Point where;
ControlHandle theControl;
short partCode, idx;

GetMouse(&where);

idx = WindowObject::current_WindowObject->click_idx;
theControl = WindowObject::current_WindowObject->scroll_list[idx].v_Handle;
if (theControl != 0) {
	if (where.v > WindowObject::current_WindowObject->content_list[idx].bottom) {
		partCode = kControlDownButtonPart;
		WindowObject::current_WindowObject->
			window_scrollProc(theControl, partCode);
		}
	else if (where.v < WindowObject::current_WindowObject->content_list[idx].top) {
		partCode = kControlUpButtonPart;
		WindowObject::current_WindowObject->
			window_scrollProc(theControl, partCode);
		}
	}
theControl = WindowObject::current_WindowObject->scroll_list[idx].h_Handle;
if (theControl != 0) {
	if (where.h > WindowObject::current_WindowObject->content_list[idx].right) {
		partCode = kControlDownButtonPart;
		WindowObject::current_WindowObject->
			window_scrollProc(theControl, partCode);
		}
	else if (where.h < WindowObject::current_WindowObject->content_list[idx].left) {
		partCode = kControlUpButtonPart;
		WindowObject::current_WindowObject->
			window_scrollProc(theControl, partCode);
		}
	}
return(true);
}
