// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: mac_extras.c,v $
// Revision 1.4  1999/05/08 06:42:40  dicamillo
// Change my_stat so it fails if the filename is an empty string.
//
// Revision 1.3  1999/01/10 08:27:54  dicamillo
// Ignore srand calls so that random numbers don't restart.
//
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 05:36:45  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *mac_extras_c(void) {
return "@(#)$Id: mac_extras.c,v 1.4 1999/05/08 06:42:40 dicamillo Exp $"; }
#endif

#include "stat.h"
#include "stat.mac.h"
#include "mac_extras.h"
#include <string.h>
#include <stat.h>
#include <unistd.mac.h>
#include <time.mac.h>

extern "C" void srand(unsigned int seed);

static int my_stat(short vrefnum, long dirid, Str255 pname, struct stat *buf);
extern FCBPBRec myFCB;

// Compare lexigraphically two strings

int stricmp(const char *s1, const char *s2)
{
    char c1, c2;
    while (1)
    {
    	c1 = tolower(*s1++);
    	c2 = tolower(*s2++);
        if (c1 < c2) return -1;
        if (c1 > c2) return 1;
        if (c1 == 0) return 0;
    }
}

// Compare lexigraphically two strings up to a max length

int strnicmp(const char *s1, const char *s2, int n)
{
    int i;
    char c1, c2;
    for (i=0; i<n; i++)
    {
        c1 = tolower(*s1++);
        c2 = tolower(*s2++);
        if (c1 < c2) return -1;
        if (c1 > c2) return 1;
        if (!c1) return 0;
    }
    return 0;
}

// Simulate access function
int access(const char *pathname, int mode)
{
#pragma unused(mode)
struct stat statbuf;

return(stat(pathname, &statbuf));
}

// Simulate chmod function
int chmod(const char *pathname, mode_t mode)
{
#pragma unused(mode)
struct stat statbuf;

return(stat(pathname, &statbuf));
}

/*
 *	int stat(char *path, struct stat *buf)
 *
 *		Returns information about a file.
 */
int stat(const char *path, struct stat *buf)
{
	int len, result;
	Str255 ppath;
	
	len = strlen(path);
	if (len > 255) return -1;
	ppath[0] = len;
	memcpy(ppath+1, path, len);
	result = my_stat(myFCB.ioFCBVRefNum, myFCB.ioFCBParID, ppath, buf);
	return(result);
}

unsigned int my_getopenfilelength(int filedes)
{
	FCBPBRec fcbrec;
	OSErr rc;
	
	memset(&fcbrec, 0, sizeof(FCBPBRec));
	fcbrec.ioRefNum = filedes;
	rc = PBGetFCBInfoSync(&fcbrec);
	if (rc == noErr) {
		return(fcbrec.ioFCBEOF);
		}
	else {
		return(0);
		}
}

static int my_stat(short vrefnum, long dirid, Str255 pname, struct stat *buf)
{
	HFileInfo		fpb;
	HVolumeParam	vpb;
	OSErr			err;
	Str255			name;

	if (pname[0] == 0) return -1;

	fpb.ioNamePtr = pname;
	fpb.ioFDirIndex = 0;
	fpb.ioVRefNum = vrefnum;
	fpb.ioDirID = dirid;

	/* get the file's catalog info */
	err = PBGetCatInfoSync((CInfoPBPtr)&fpb);
	if (err == noErr) {
		/* get the volume's info */
		vpb.ioVolIndex = 0;
		vpb.ioNamePtr = name;
		vpb.ioVRefNum = vrefnum;
		err = PBHGetVInfoSync((HParmBlkPtr)&vpb);
		if (err == noErr && buf != NULL) {
			/* fill in the data */
			if (fpb.ioFlAttrib & 0x10)
			{
				buf->st_mode = S_IFDIR;
				buf->st_nlink = 2;
			}				
			else
			{
				buf->st_nlink = 1;
				if (fpb.ioFlFndrInfo.fdFlags & 0x8000)
					buf->st_mode = S_IFLNK;
				else
					buf->st_mode = S_IFREG;
			}
			buf->st_ino = fpb.ioDirID;
			buf->st_dev = fpb.ioVRefNum;
			buf->st_uid = getuid();
			buf->st_gid = getgid();
			buf->st_rdev = 0;
			buf->st_size = fpb.ioFlLgLen;
			buf->st_atime = buf->st_mtime = fpb.ioFlMdDat + _mac_unix_epoch_offset_;       /*mm 970514*/
			buf->st_ctime = fpb.ioFlCrDat + _mac_unix_epoch_offset_;                       /*mm 970514*/
			buf->st_blksize = vpb.ioVAlBlkSiz;
			buf->st_blocks = (buf->st_size + buf->st_blksize - 1) / buf->st_blksize;
		}
	}

	if (err != noErr)
		errno = err;
	return (err == noErr ? 0 : -1);
}

void srand(unsigned int seed)
{
#pragma unused(seed)
// MSL has seed initialized to 1
}

