// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: my_settings.h,v $
// Revision 1.3  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/31 08:18:43  dicamillo
// Add use_MP settings variable.
//
// Revision 1.1  1998/12/15 05:38:49  dicamillo
// First Checked In.
//

typedef struct {
	char			font_name[256];			// font name
	char 			console_log_name[32];	// window log file name
	double			max_cpu_start_time;		// wait time before using more CPU
	double			max_cpu_end_time;		// time until maximum CPU usage
	double			auto_fg_delay;			// delay before moving to foreground
	unsigned short	customticks;			// custom tick count
	short			log_window_h_loc;		// log window top-left h-coord
	short 			log_window_v_loc;		// log window top-left v-cood
	short			log_window_width;		// log window width
	short 			log_window_height;		// log window height
	short			gui_window_h_loc;		// gui window top-left h-coord
	short 			gui_window_v_loc;		// gui window top-left v-cood
	short			gui_window_width;		// gui window width
	short 			gui_window_height;		// gui window height
	short			font_size;				// font size
	short			buffers_contest;		// contest for buffers popup control
	char			resplevel;				// response level setting
	char			writelog;				// true to write log file
	char			log_window_info_stored;	// true if log window info is available
	char 			log_window_visible;		// true if log window is visible
	char			gui_window_info_stored;	// true if gui window info is available
	char 			gui_window_visible;		// true if gui window is visible
	char 			resume;					// true to resume at launch
	char			all_fonts;				// include all fonts in menu
	char			maxcpu;					// try to use all CPU time
	char			auto_fg;				// auto move to foreground
	char			use_MP;					// use MP support when available
	Style			font_style;				// font style to use (unsigned char)
	} settings_list;
	
// *** be sure to update compare_settings_list after adding new settings ***
extern settings_list ds;
extern settings_list cs;
extern settings_list fs;

extern keyinfo keytab[];

short respproc(void *resultptr);
short tickproc(void *resultptr);
