// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: quitapps.c,v $
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 05:40:29  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *quitapps_c(void) {
return "@(#)$Id: quitapps.c,v 1.2 1999/01/01 02:45:18 cramer Exp $"; }
#endif

/**********************************

	QuitApps
	DTS Code Snippet to quit all running applications (except yourself)
	
	note: to work properly, the calling application must have a standard
	event loop with menus (to support puppet string quits for apps that
	don't support core appleevents.
	
	note#2: remember to set the applevent aware flag in your app if you use
	this code
	
	written by Steven Falkenburg 9/4/91

**********************************/

#include <Processes.h>
#include <AppleEvents.h>
#include "quitapps.h"


/* protos */
void QuitAllApps(void);
OSErr QuitAnApp(ProcessSerialNumber *proc);
short GetNumProcs(void);


/* this is the entry procedure.  call this to start things going */

void QuitAllApps(void)
{
	ProcessSerialNumber ourProc,curProc,*quitApps;
	OSErr err;
	Boolean same;
	short numApps,curAppIndex;
	
	numApps = GetNumProcs() - 1; /* don't count ourselves */
	quitApps = (ProcessSerialNumber *)NewPtr(numApps*sizeof(ProcessSerialNumber));
	if (MemError()!=noErr)
		return;
		
	err = GetCurrentProcess(&ourProc);
	if (err!=noErr)
		return;
	
	curProc.highLongOfPSN = 0;
	curProc.lowLongOfPSN = kNoProcess;
	curAppIndex = 0;
	
	while (GetNextProcess(&curProc)==noErr && curAppIndex<numApps) {
		err = SameProcess(&ourProc,&curProc,&same);
		if (err==noErr && !same) {
			BlockMove(&curProc,&quitApps[curAppIndex++],sizeof(ProcessSerialNumber));
		}
	}
	
	for (curAppIndex=0; curAppIndex<numApps; curAppIndex++)
		QuitAnApp(&quitApps[curAppIndex]);
	
	DisposePtr((Ptr)quitApps);
}


/* gets the number of current processes */

short GetNumProcs(void)
{
	ProcessSerialNumber curProc;
	short numProcs;
	
	numProcs = 0;
	curProc.highLongOfPSN = 0;
	curProc.lowLongOfPSN = kNoProcess;
	
	while (GetNextProcess(&curProc)==noErr)
		numProcs++;
	
	return numProcs;
}


/* quits an app of the given process id */

OSErr QuitAnApp(ProcessSerialNumber *proc)
{
	OSErr err;
	AEAddressDesc target;
	AppleEvent theAE,aeReply;
	
	theAE.dataHandle = aeReply.dataHandle = target.dataHandle = nil;
	
	err = AECreateDesc(typeProcessSerialNumber,(Ptr)proc,sizeof(ProcessSerialNumber),&target);
	if (err!=noErr)
		return err;

	err = AECreateAppleEvent(kCoreEventClass,kAEQuitApplication,&target,
					kAutoGenerateReturnID,kAnyTransactionID,&theAE);
	if (err!=noErr) {
		AEDisposeDesc(&target);
		return err;
	}
	 
	err = AESend(&theAE,&aeReply,kAENoReply,kAENormalPriority,kNoTimeOut,nil,nil);
		
	AEDisposeDesc(&target);
	AEDisposeDesc(&theAE);
	
	return err;
}
