// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: settings.h,v $
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 05:41:03  dicamillo
// First Checked In.
//

typedef struct {
	char * name;			// name of this setting
	unsigned char type;		// type of this setting:
							/*  a = string of arbitrary length, not null terminated (size = 1)
								b = binary flag (size = 1)
							 	c = unsigned char (size = 1), decimal
								d = double (size = sizeof(double))
								i = (signed) short int (size = 2)
								l = list of hex bytes (size = no. of bytes)
								o = OSType (4 bytes, unterminated)
								r = RGBColor: 3 unsigned short ints (size = sizeof(RGBColor))
								s = null-terminated string (size = max. length. wo/null, <= 255)
								u = unsigned short (size = 2) 
								x = unsigned char (size = 1), hex
								* = not used (accepted in file for compatibility only) */
	unsigned char size;
	void *default_value;	// default value of setting
	void *current_value;	// current value of setting
	void *file_value;		// value in settings file
	char *description;
	short (*procptr)(void *resptr);		// custom validation procedure
	unsigned char flags;		// flag byte (see below)
	} keyinfo;

/* flags for flag byte in struct keyinfo */
#define PRESENT_IN_FILE		0x01

// Routines

/* init_settings

   This routine sets the current value of each setting to its default value,
   and resets the PRESENT_IN_FILE flag for each setting.  If an FSSpec is
   specified, it then attempts to update the current values from the file
   contents.  Init_settings will return noErr unless a File Manager error occurs
   accessing the file.  To obtain information about possible parsing errors, call
   the routine "get_settings_parse_results".
   
   For each setting that can be parsed, its value is stored as the current
   value and the file value, and the PRESENT_IN_FILE flag is set.  Parsing
   stops at the first error.
*/   

OSErr init_settings(keyinfo *k, FSSpec *theFile);

/* get_settings_parse_results

   This routine returns the results from the last time a settings file
   was processed.  It returns 0 if there were no errors, or an integer
   indicating the type of error that occurred.  If an error occurred,
   three lines of message text are returned.  The lines are text are
   either used for a ParamText call if the parameters are null, or 
   return in the storage provided.  The number of defined messages is
   returned in "count".  It will be 0 if no errors, 2 for a File Manager
   error, or 3 for a parsing error.  Each line returned will be no longer
   than 255 characters and is null-terminated.
*/

short get_settings_parse_results(short *count, char *msg1, char *msg2, char *msg3);

/* find_prefs_file

   Given a creator and type, this routine will attempt to locate a matching
   file in the Preferences file.  It returns noErr if the file is found, or
   returns a File Manager error.  If the file is found, its FSSpec is
   returned.  If myFCB is provided, the preferences file is search for in
   the program's directory before searching in the Preferences folder.
*/

OSErr find_prefs_file(OSType creator, OSType type, FSSpec *theFile,
					  FCBPBRec *myFCB);

/* search_folder_for_prefs

   This routine is called by find_prefs_file to search a specified folder
   for a preferences folder.  The FSSpec is returned if a file is found
   in the specified directory with a matching creator and type.
*/

OSErr search_folder_for_prefs(OSType creator, OSType type,
							  short theVol, long theDir,
							  FSSpec *theFile);

/* define_prefs_file

   This routine will create an FSSpec for a file in the Preferences folder
   with the specified name.  Typically, it is used before a call to
   save_settings.
*/
   
OSErr define_prefs_file(char *theName, FSSpec *theFile);


/* new_settings

   This routine compares the values of all current settings to those
   stored in the settings file.  It returns true unless all the settings
   are stored in the settings file and have matching values.
*/

Boolean new_settings(keyinfo *k);


/* save_settings

   This routine writes the current values of all settings into a new settings
   file.  No file will be written if all the current values match the values
   last read from a file.  However, the "force" flag can be used to force a
   file to always be written.  An error result will be returned if a File Manager
   error occurs.
*/

OSErr save_settings(keyinfo *k, OSType creator, OSType type, FSSpec *theFile,
					char *appname, Boolean force);


/* show_settings_error

*/

void show_settings_error(short count);
