// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: socket_glue.c,v $
// Revision 1.4  1999/01/06 22:23:18  dicamillo
// Support allowing active open to be aborted.
//
// Revision 1.3  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/24 05:15:47  dicamillo
// Add support for ioctl and for specifying the connection timeout.
//
// Revision 1.1  1998/12/15 05:58:01  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *socket_glue_c(void) {
return "@(#)$Id: socket_glue.c,v 1.4 1999/01/06 22:23:18 dicamillo Exp $"; }
#endif

#include <socket_glue.h>
#include <string.h>
#include <net.h>
#include "PointerList.h"
#include "macdefs.h"
#include "apputils.h"
#include "resdefs.h"
#include "client.h"

//#define NET_DEBUG

// From RC5App.h
OSErr GiveTimeDuringNetworkOperation(void);

// From OpenTptInternet.h
#define kMaxHostAddrs 10		

extern PointerList *socket_list;
extern void YieldToMain(char force_events);

Boolean netinit_ok = false;
Boolean netinit_done = false;
Boolean socket_connect_active = false;

Boolean myNetInit(void)
{
OSErr rc;

#ifdef NET_DEBUG
printf("Doing myNetInit\n");
#endif

if (netinit_done) {
	return(netinit_ok == true);
	}

netinit_done = true;

// Initialize net code
rc = NetInit(GiveTimeDuringNetworkOperation, 0, 2);
if (rc != noErr) {
	mySetCursor(kArrowCursor);
	show_error_string(kNetInitError, 0);
	netinit_ok = false;
	}
else {
	netinit_ok = true;
	}
	
return(netinit_ok == true);
}

struct in_addr inet_addr(char *address)
{
static struct in_addr result;
short i, len, count;
int a0, a1, a2, a3;
union {
	unsigned char s[4];
	unsigned long a;
	} address_convert;

#ifdef NET_DEBUG
printf("Doing inet_addr\n");
#endif

// default result is -1
result.s_addr = 0xffffffff;

// validate string
len = strlen(address);
if (len < 7) return(result);
for (i = 0; i < len; i++) {
	if (address[i] == '.') continue;
	if ((address[i] >= '0') && (address[i] <= '9')) continue;
	return(result);
	}

count = sscanf(address, "%u.%u.%u.%u", &a0, &a1, &a2, &a3);
if (count != 4) return(result);

address_convert.s[0] = a0;
address_convert.s[1] = a1;
address_convert.s[2] = a2;
address_convert.s[3] = a3;

result.s_addr = address_convert.a;

return(result);
}

char * inet_ntoa(struct in_addr inaddr)
{
static char result[20];
int a0, a1, a2, a3;
union {
	unsigned char s[4];
	unsigned long a;
	} address_convert;

#ifdef NET_DEBUG
printf("Doing inet_ntoa\n");
#endif

address_convert.a = inaddr.s_addr;
a0 = address_convert.s[0];
a1 = address_convert.s[1];
a2 = address_convert.s[2];
a3 = address_convert.s[3];
sprintf(result, "%d.%d.%d.%d", a0, a1, a2, a3);

return(result);
}

int gethostname(char *name, int namelen)
{
char result[256];
unsigned long addr;
union {
	unsigned long addr;
	unsigned char str[4];
	} addr_cvt;
OSErr rc;
short len;

#ifdef NET_DEBUG
printf("Doing gethostname\n");
#endif

rc = 1;
if (netinit_ok && netinit_done) {
	rc = NetGetMyAddr(&addr);
	}
if (rc != noErr) {
	strcpy(result, "localhost");
	}
else {
	rc = NetAddrToName(addr, result);
	if (rc != noErr) {
		addr_cvt.addr = addr;
		sprintf(result, "[%d.%d.%d.%d]", addr_cvt.str[0],
			addr_cvt.str[1], addr_cvt.str[2], addr_cvt.str[3]);
		}
	}

// remove any trailing period
len = strlen(result);
if (len > 0) {
	if (result[len - 1] == '.') {
		result[len - 1] = 0;
		}
	}

if (namelen <= 0) return(-1);

len = strlen(result);
if (len > (namelen - 1)) len = namelen - 1;
memcpy(name, result, len);
name[len] = 0;

return(0);
}

struct hostent *gethostbyname(char *name)
{
// this version returns only address information
static struct hostent result;
static struct in_addr addr_structs[kMaxHostAddrs];
static struct in_addr *ptrs[kMaxHostAddrs + 1];
OSErr rc;
unsigned long addresses[kMaxHostAddrs];
short i;

#ifdef NET_DEBUG
printf("Doing gethostbyname\n");
#endif

if (!myNetInit()) return(0);

rc = NetNameToAddresses(name, addresses);
if (rc != noErr) {
	return(0);
	}
	
memset(&result, 0, sizeof(struct hostent));
result.h_addrtype = AF_INET;
result.h_length = 4;
for (i = 0; i < kMaxHostAddrs; i++) {
	addr_structs[i].s_addr = addresses[i];
	if (addresses[i] != 0) {
		ptrs[i] = addr_structs + i;
		}
	else {
		ptrs[i] = 0;
		}
	}

ptrs[kMaxHostAddrs] = 0;

result.h_addr_list = (char **)ptrs;
return(&result);
}

int socket(int domain, int type, int protocol)
{
OSErr rc;
NetStreamRef sr;

#ifdef NET_DEBUG
printf("Doing socket\n");
#endif

if (!myNetInit()) return(-1);

rc = NetNewStream(&sr);
if (rc == noErr) {
	NetSetBlocking(sr, true);	// default for new socket is blocking
	socket_list->AddPointer(sr);
	return((int)sr);
	}
else {
	return(-1);
	}
}

int connect(int sockfd, const struct sockaddr *serv_addr, int addrlen )
{
OSErr rc;
unsigned long addr;
unsigned short port;
struct sockaddr_in *sin;

#ifdef NET_DEBUG
printf("Doing connect\n");
#endif

if (!myNetInit()) return(-1);

if (!valid_socket(sockfd)) {
	return(-1);
	}

sin = (struct sockaddr_in *)serv_addr;
port = sin->sin_port;
addr = sin->sin_addr.s_addr;
socket_connect_active = true;
rc = NetOpenStream((NetStreamRef)sockfd, addr, port);
socket_connect_active = false;
if (rc != noErr) {
#ifdef NET_DEBUG
printf("Connect failed\n");
#endif
// NetOpenStream deletes streams that cannot be opened
	socket_list->DeletePointer((void *)sockfd);
	return(-1);
	}
else {
#ifdef NET_DEBUG
printf("Connect worked\n");
#endif
	return(0);
	}
}

long socket_read(int sockfd, void *buf, unsigned long count)
{
OSErr rc;
unsigned short read_count;
unsigned short total_count;
void * ptr;
unsigned long tick_limit;

#ifdef NET_DEBUG
printf("Doing socket_read\n");
#endif

if (!myNetInit()) return(-1);

if (!valid_socket(sockfd)) {
	return(-1);
	}

if (count == 0) {
	return(0);
	}

// Current client seems to use blocking for mail but still expects non-blocking
// if (!NetGetBlocking((NetStreamRef)sockfd)) {
if (true) {
	read_count = count;
	rc = NetRcv((NetStreamRef)sockfd, (char *)buf, &read_count);
	if ((rc == noErr) && (read_count > 0)) {
		return(read_count);
		}
	else {
		return(-1);
		}
	}
else {
	total_count = 0;
	ptr = buf;
	read_count = count;
	tick_limit = LMGetTicks() + 7200;	// block for two minutes
	while (total_count < count) {
		if (LMGetTicks() > tick_limit) return(total_count);
		rc = NetRcv((NetStreamRef)sockfd, (char *)ptr, &read_count);
		if (rc != noErr) return(total_count);
		(char *)ptr += read_count;
		total_count += read_count;
		read_count = count - total_count;		
		YieldToMain(false);	
		}
	}
}

long socket_write(int sockfd, const void *buf, unsigned long count)
{
OSErr rc;

#ifdef NET_DEBUG
printf("Doing socket_write\n");
#endif

if (!myNetInit()) return(-1);

if (!valid_socket(sockfd)) {
	return(-1);
	}
rc = NetSend((NetStreamRef)sockfd, (char *)buf, count, true);
if (rc == noErr) {
	return(count);
	}
else {
	return(-1);
	}
}

int socket_close(int sock)
{
#ifdef NET_DEBUG
printf("Doing socket_close\n");
#endif

if (!myNetInit()) return(-1);

if (valid_socket(sock)) {
	socket_list->DeletePointer((void *)sock);
	NetCloseStream((NetStreamRef)sock);
	return(0);
	}
else {
	return(-1);
	}
}

int socket_ioctl(int sock, unsigned long request, char *arg)
{
if (!valid_socket(sock)) {
	return(-1);
	}

switch(request) {
	case FIONBIO:
					// Note: blocking must be implemented here in socket_glue.c,
					// but currently is not used.
					NetSetBlocking((NetStreamRef)sock, *arg == 0);
					return(0);
	default:
					return(-1);
	}
}

int socket_set_conn_timeout(int sock, int iotimeout)
{
if (!valid_socket(sock)) {
	return(-1);
	}
NetSetConnTimeout((NetStreamRef)sock, iotimeout);
}

int shutdown(int sock, int how)
{
#pragma unused(how)
return(socket_close(sock));
}

int setsockopt(int s, int level, int optname,  const  void
       *optval, int optlen)
{
#ifdef NET_DEBUG
printf("Doing setsockopt\n");
#endif

if (!myNetInit()) return(-1);

return(0);
}

Boolean valid_socket(int socket)
{
int next_socket;

next_socket = (int)(socket_list->GetFirstPointer());
while(next_socket != 0) {
	if (next_socket == socket) return(true);
	next_socket = (int)(socket_list->GetNextPointer());
	}
return(false);
}
