// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: AppObject.cpp,v $
// Revision 1.4.2.2  1999/07/24 01:18:45  sampo
// fix resolution switching bug cleanly
//
// Revision 1.4.2.1  1999/07/12 03:11:30  sampo
// fix resolution switching bug
//
// Revision 1.4  1999/01/17 18:11:20  sampo
// 3rd round fba changes
//
// Revision 1.3  1999/01/09 03:41:38  dicamillo
// Define haveAppearance101.
//
// Revision 1.2  1999/01/01 02:45:16  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:13:18  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *AppObject_cpp(void) {
return "@(#)$Id: AppObject.cpp,v 1.4.2.2 1999/07/24 01:18:45 sampo Exp $"; }
#endif

// Generic application object

// Our includes
#include "macdefs.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "WindowObject.h"
#include "AppObject.h"

// Routine descriptors for Drag Manager
RoutineDescriptor AppObject::my_TrackingHandlerRD =
	BUILD_ROUTINE_DESCRIPTOR(uppDragTrackingHandlerProcInfo, appTrackingHandler);
RoutineDescriptor AppObject::my_ReceiveHandlerRD =
	BUILD_ROUTINE_DESCRIPTOR(uppDragReceiveHandlerProcInfo, appReceiveHandler);


// Initializer
// Note: should not contain any initializations that may fail

AppObject::AppObject(void) {
// create list object to hold window object pointers
window_list = new PointerList;

// initialize window pointer for suspend/resume
suspend_window = 0;

// initialize variables used by destructor
drag_mgr_avail = false;

// initialize for main loop
done = false;

// invalidate_for_grow defaults to off
invalidate_for_grow = false;

// null events no more often than every 4 ticks
null_interval = 4;

// default times for WaitNextEvent
foreground_time = background_time = 12;	// shortest carettime

// scheduling control
last_null = last_yield = 0;
}

AppObject::~AppObject(void)
{
// remove drag handlers
if (drag_mgr_avail) {
#if GENERATINGPOWERPC
	RemoveTrackingHandler(&my_TrackingHandlerRD, 0);
	RemoveReceiveHandler(&my_ReceiveHandlerRD, 0);
#else
	RemoveTrackingHandler((DragTrackingHandlerUPP)appTrackingHandler, 0);
	RemoveReceiveHandler((DragReceiveHandlerUPP)appReceiveHandler, 0);
#endif
	}

// delete any windows we still have
delete_all_windows();

// delete window object list
delete window_list;

// end TSM
if (TSMVersion > 0) {
	CloseTSMAwareApplication();
	TSMVersion = 0;
	}
}

OSErr AppObject::InitApp(Boolean init_heap)
{
short i;
OSErr rc;
SysEnvRec theWorld;
unsigned long gestalt_flags;
Str255 scratch;

			// set-up general Macintosh environment

									// check for "new" ROMs
rc = SysEnvirons(1, &theWorld);		
newroms = (theWorld.machineType >= 0);
									// get system volume
systemvol = theWorld.sysVRefNum;
									// check for color QuickDraw
colormac = (theWorld.hasColorQD != 0);
									// make sure the stack is the same size
									// whether or not the Mac has color QD
if (init_heap) {
	if (!colormac) {
		SetApplLimit(GetApplLimit() - 24*1024);		/* add 24K to match Color QD Macs */
		}

	MaxApplZone();				// set-up for efficient storage use
	for (i=0; i < 4; i++) MoreMasters();
	}
	
myZone = GetZone();			// save my heap zone

sweeticons = 0;						/* System 7 color icon plotting */
if (colormac) {
	sweeticons = NGetTrapAddress(SweetIconsTrapNum, ToolTrap) !=
				 NGetTrapAddress(UnImplTrapNum, ToolTrap);
	}

									/* check for Gestalt */
gestaltavail = 0;
if (newroms) {	   /* compare Gestalt OS trap to Unimplemented Toolbox trap */
	gestaltavail = NGetTrapAddress(0xAD, 0) !=
				   NGetTrapAddress(0x9F, 1);
	}

									/* check for Text Service Manager */
TSMVersion = 0;
if (gestaltavail) {
	rc = Gestalt(gestaltTSMgrVersion, (long *)&gestalt_flags);
	if (rc == noErr) {
		TSMVersion = gestalt_flags;
		}
	}


// Check for the Appearance Manager, and register if it is present
haveAppearance = false;
haveAppearance101 = false;
appearance_version = 0;
rc = Gestalt(gestaltAppearanceAttr, (long *)&gestalt_flags);
if (rc == noErr) {
	haveAppearance = (gestalt_flags & (1 << gestaltAppearanceExists)) != 0;
	rc = Gestalt(gestaltAppearanceVersion, (long *)&appearance_version);
	if (rc != noErr) {
		appearance_version = 0;
		}
	}

if (haveAppearance) {
	rc = Gestalt(gestaltAppearanceVersion, (long *)&gestalt_flags);
	if (rc == noErr) {	// have 1.0.1 if selector exists at all
		haveAppearance101 = true;
		}

	RegisterAppearanceClient();
	}

							// initialize toolbox
#ifdef MAC_GUI
InitGraf(&qd.thePort);
#endif
FlushEvents(everyEvent, 0);
#ifdef MAC_GUI
InitFonts();
InitWindows();
InitMenus();
#endif
TEInit();
#ifdef MAC_GUI
InitDialogs(0L);
InitCursor();
#endif
if (TSMVersion > 0) {
	rc = InitTSMAwareApplication();
	if (rc != noErr) {
		TSMVersion = 0;
		}
	}

			// initialize cursors
mySetCursor(kInitCursor);
TSMcursor = false;

			// set-up menus
i = 0;
#ifdef MAC_GUI
myMenus[i++] = GetMenu(kAppleMenu);
myMenus[i++] = GetMenu(kFileMenu);
myMenus[i++] = GetMenu(kEditMenu);
if (kFontMenu > 0) {
	myMenus[i++] = GetMenu(kFontMenu);
	}
if (kSizeMenu > 0) {
	myMenus[i++] = GetMenu(kSizeMenu);
	}
if (kStyleMenu > 0) {
	myMenus[i++] = GetMenu(kStyleMenu);
	}

for (i=0; i < kNMenus; i++) {
	InsertMenu(myMenus[i], 0);
	}

			// define Apple Menu
GetRString(scratch, kAboutItemName);
SetMenuItemText(myMenus[0], 1, scratch);
AppendResMenu(myMenus[0], 'DRVR');


font_item = size_item = style_bits = 0;

			// define Font menu
if (kFontMenu > 0) {
	define_font_menu();
	}

			// define Size menu
if (kSizeMenu > 0) {
	define_size_menu();
	}
	
			// define Style menu
if (kStyleMenu > 0) {
	define_style_menu();
	}

da_menu = false;
appl_menu();
#endif
									/* initialize the TextEdit scrap */
TEFromScrap();

									/* check for notification manager */
notifyavail = 0;
if (gestaltavail) {
	rc = Gestalt(gestaltNotificationMgrAttr, (long *)&gestalt_flags);
	if (rc == noErr) {
		notifyavail = (gestalt_flags & 0x1) != 0;
		}
	}

									/* check for new standard file calls */
sf58 = 0;
if (gestaltavail) {
	rc = Gestalt(gestaltStandardFileAttr, (long *)&gestalt_flags);
	if (rc == noErr) {
		sf58 = (gestalt_flags & 0x1) != 0;
		}
	}

									/* check for enhanced TextEdit */
TEVersion = 0;
if (gestaltavail) {
	rc = Gestalt(gestaltTextEditVersion, (long *)&gestalt_flags);
	if (rc == noErr) {
		TEVersion = gestalt_flags;
		}
	}

// determine availability of the Drag Manager
drag_mgr_avail = 0;
if (gestaltavail) {
	rc = Gestalt(gestaltDragMgrAttr, (long *)&dragflags);
	drag_mgr_avail = (rc == noErr);
	if (!drag_mgr_avail) dragflags = 0;
	}

// if Drag Manager is available, install our handlers
if (drag_mgr_avail) {
#if GENERATINGPOWERPC
	rc = InstallTrackingHandler(&my_TrackingHandlerRD, 0, 0);
#else
	rc = InstallTrackingHandler((DragTrackingHandlerUPP)appTrackingHandler, 0, 0);
#endif
	if (rc == noErr) {
#if GENERATINGPOWERPC
		rc = InstallReceiveHandler(&my_ReceiveHandlerRD, 0, 0);
#else
		rc = InstallReceiveHandler((DragReceiveHandlerUPP)appReceiveHandler, 0, 0);
#endif
		}
	}

dlgborderheight = kdBoxProcHeight;				/* assume dBoxProc */
center_denominator = kCenterDefault; 	/* default for centering things */

#ifdef MAC_GUI
mbar_adj = get_mbar_height() - 1;		/* used for window positioning */
#endif
				/* read alerts into memory and make unpurgeable */
				/* Note: CouldAlert is a no-op in System 7.
				    	 However, our resources are preloaded
						 and not purgeable.  These calls are just
						 a precaution for old system software.	*/

#if !GENERATINGPOWERPC
CouldAlert(kShowerrAlert);
#endif

				// calculate some useful Rects
screenRect = qd.screenBits.bounds;

smallscreen = (screenRect.bottom - screenRect.top) <= 342;

SetRect(&dragRect, 0, 24, screenRect.right-4, screenRect.bottom-4);
SetRect(&sizeRect, 64, 64, screenRect.right - screenRect.left - 5, 
		screenRect.bottom - screenRect.top - 44);
SetRect(&classicRect, 0, 0, 482, 276);


TEActive = false;			// TextEdit not active
mf_bgrnd = 0;				// not in background
nmrec_installed = 0;		// haven't installed a notification record

return(noErr);
}

void AppObject::EndApp(void)
{
}

void AppObject::Run(void)
{
								// arrow cursor after init
waitcursor = ibeamcursor = false;
mySetCursor(kArrowCursor);
								// loop to process events
while (!done) {
	do_often();					// for things like frequent polling
	handle_events();
	}
}

void AppObject::do_often(void)
{
}

void AppObject::handle_events(void)
{
EventRecord myEvent;
OSErr rc;

rc = get_one_event(&myEvent);
if (rc == 0) {		// false for null event
	handle_null_event();
	}
else {
	handle_one_event(&myEvent);
	}
}

Boolean AppObject::get_one_event(EventRecord *myEvent)
{
Boolean wne_result;

if (mf_bgrnd) {
	wne_result = WaitNextEvent(everyEvent, myEvent, background_time, 0L);
	}
else {
	wne_result = WaitNextEvent(everyEvent, myEvent, foreground_time, 0L);
	}

last_yield = LMGetTicks();

return(wne_result);
}

void AppObject::handle_null_event(void)
{
Boolean use_null;

// Use null event if first, all wanted, or in background
if ((null_interval <= 0) || (last_null == 0) || mf_bgrnd) {
	use_null = true;
	}
// Skip null event if more often than wanted when in foreground
// (allows more time for background tasks)
else {
	use_null = LMGetTicks() > (last_null + null_interval);
	}

if (use_null) {
	last_null = LMGetTicks();
	do_null_event();
	}
}

void AppObject::handle_one_event(EventRecord *myEvent)
{
short code;
GrafPtr gp;
WindowPtr whichWindow;
long mResult;
Point dipoint;

							// handle Text Services if present
if (TSMVersion > 0) {
	if (TSMEvent(myEvent)) {		// true- handle as null event
		handle_null_event();
		return;
		}
	}

switch(myEvent->what) {	// assumes true from WNE (null events handled separately)
	case mouseDown:
		code = FindWindow(myEvent->where, &whichWindow);
		switch (code) {
			case inMenuBar:
				menu_upd();			// update menus before user selection
									// user selection
				mResult = MenuSelect(myEvent->where);
				do_command(mResult >> 16, mResult & 0xff);
				HiliteMenu(0);		// unhighlight menu
				appl_menu();		// update which menus are enabled
				break;
			case inSysWindow:
				SystemClick(myEvent, whichWindow);
				break;
			case inDrag:
				if (whichWindow != FrontWindow()) {
					if ((myEvent->modifiers & cmdKey) == 0) {
						SelectWindow(whichWindow);
						}
					}
				drag_window(whichWindow, myEvent->where);
				break;
			case inGoAway:
				if (TrackGoAway(whichWindow, myEvent->where)) {
					do_go_away(whichWindow,
							   (myEvent->modifiers & optionKey) != 0);
					}
				break;
			case inGrow:
				if (whichWindow == FrontWindow()) {
					GetPort(&gp);
					SetPort((GrafPtr)whichWindow);
					grow_window(whichWindow, myEvent->where);
					SetPort(gp);
					}
				break;

		case inContent:
			if (whichWindow != FrontWindow()) {
				SelectWindow(whichWindow);
				break;
				}
			content_click(whichWindow, myEvent);
			break;

		case inZoomIn:
		case inZoomOut:
			if (TrackBox(whichWindow, myEvent->where, code)) {
				if (((WindowPeek)whichWindow)->dataHandle == 0) break;
				GetPort(&gp);
				SetPort((GrafPtr)whichWindow);
				zoom_window(whichWindow, code, 0);
				SetPort(gp);
				}
			break;

		default:
			break;
			}
		break;
		
	case mouseUp:
		break;

	case keyDown:
	case autoKey:
		do_key_down(myEvent);
		break;

	case activateEvt:
		if (myEvent->modifiers & activeFlag) {	// activate event
			do_activate((GrafPtr)myEvent->message);
			}
		else {							// deactivate event
			do_deactivate((GrafPtr)myEvent->message);
			}
		break;

	case updateEvt:
		do_update((GrafPtr)myEvent->message);
		break;

	case diskEvt:	// if mount failed, put up disk init dialog
		if ((myEvent->message & 0xffff0000) != 0) {
			deactivate_controls(FrontWindow());
			dipoint.h = kDILeft;
			dipoint.v = kDITop;
			DIBadMount(dipoint, myEvent->message);
			}
		break;

	case osEvt:		// probably MF or Switcher
		if ((myEvent->message & osEvtMessageMask) != (suspendResumeMessage << 24)) {
			break;	// not MF/Switcher
			}
		else if (myEvent->message & resumeFlag) {
			mf_resume(myEvent->message);
			}
		else {
			mf_suspend();
			}
		break;

	case kHighLevelEvent:		/* provision for handling Apple events */
		do_high_level_event(myEvent);
		break;

	default:	break;
	}
}

void AppObject::do_null_event(void)
{
WindowRecord *fw;
Boolean frontda;
WindowObject *wptr;

// check for active desk accessory
#ifdef MAC_GUI
fw = (WindowRecord *)FrontWindow();
if (fw == 0) {
	frontda = 0;
	}
else {
	frontda = fw->windowKind < 0;
	}
if (frontda) {
	if (!da_menu) {
		da_menu = 1;
		SetMenuItemText(myMenus[1], kFileMSize, "\pClose");
		appl_menu();
		}
	}
else {
	if (da_menu) {
		da_menu = 0;
		SetMenuItemText(myMenus[1], kFileMSize, "\pQuit");
		appl_menu();
		}
	}
// handle TextEdit cursor
if (TEActive) {
	do_TEFunction(idle_function);
	update_cursor();
	}

// run DAs etc.
//SystemTask();  not needed when we call WaitNextEvent

// update animated cursor
if (!mf_bgrnd) {
	mySetCursor(kNextCursor);
	}

// give each window a chance to execute
wptr = (WindowObject *)(window_list->GetFirstPointer());
while (wptr != 0) {
	wptr->do_null_event();
	wptr = (WindowObject *)(window_list->GetNextPointer());
	}
#endif
}
	
void AppObject::do_key_down(EventRecord *theEvent)
{
WindowObject *wptr;
GrafPtr gp;
if (!do_menu_key(theEvent)) {
	wptr = find_my_window(FrontWindow());
	if (wptr == 0) {
		SysBeep(1);
		}
	else {
		if ((theEvent->modifiers & cmdKey) != 0) {
			if ((theEvent->message & charCodeMask) == 'w') {
				do_cmd_w(wptr);
				}
			}
		else {
			GetPort(&gp);
			SetPort(wptr->myWindow);
			wptr->do_key_down(theEvent);
			SetPort(gp);
			}
		}
	}
}
	
void AppObject::do_cmd_w(WindowObject *wptr)
{
do_go_away(wptr->myWindow, false);
}

Boolean AppObject::do_menu_key(EventRecord *theEvent)
{
long mResult;
short theMenu;
unsigned long tickCount, tickLimit;

if ((theEvent->modifiers & cmdKey) == 0) {
	return(false);		// need command key
	}

if (theEvent->what == autoKey) {
	return(true);		// command keys don't repeat
	}

menu_upd();				// need proper items enabled for MenuKey
mResult = MenuKey(theEvent->message & 0xff);
theMenu = mResult >> 16;
if (theMenu != 0) {
	tickCount = LMGetTicks();
	do_command(theMenu, mResult & 0xff);
	tickLimit = tickCount + 4;	// make sure menu is highlighted briefly
#pragma warn_possunwant off
	while (tickLimit > LMGetTicks());
#pragma warn_possunwant reset
	HiliteMenu(0);		// unhighlight menu
	appl_menu();		// update which menus are enabled
	return(true);
	}
else {
	return(false);
	}
}

void AppObject::mf_suspend(void)
{
mf_bgrnd = 1;
suspend_window = FrontWindow();
export_scrap(suspend_window);
do_deactivate(suspend_window);
}
	
void AppObject::mf_resume(long message)
{
if (message & convertClipboardFlag) {
	import_scrap(suspend_window);
	}
if (nmrec_installed) {
	NMRemove(&my_notify_record);
	nmrec_installed = 0;
	}
mf_bgrnd = 0;
do_activate(suspend_window);
}

void AppObject::do_high_level_event(EventRecord *myEvent)
{
#pragma unused (myEvent)
// placeholder for apps that handle Apple events
}

void AppObject::update_cursor(void)
{
#ifdef MAC_GUI
Boolean old_TSMcursor;
Point mouseloc;

if (TSMVersion > 0) {
	old_TSMcursor = TSMcursor;
	GetMouse(&mouseloc);
	LocalToGlobal(&mouseloc);
	TSMcursor = SetTSMCursor(mouseloc);
	if (TSMcursor) {
		return;
		}
	if (old_TSMcursor) {
		redrawCursor();
		}
	}

if (!waitcursor) {
	if (mouse_in_text()) {
		if (!ibeamcursor) {
			mySetCursor(kIbeamCursor);
			ibeamcursor = 1;
			}
		}
	else {
		if (ibeamcursor) {
			mySetCursor(kArrowCursor);
			ibeamcursor = 0;
			}
		}
	}
#endif
}

void AppObject::define_font_menu(void)
{
AppendResMenu(myMenus[3], 'FONT');
font_item = 0;
}

void AppObject::define_size_menu(void)
{
short sizelist[] = {7, 9, 10, 12, 14, 18, 24, 36, 48, 60, 72};
short i;
char itemname[32];

for (i=0; i < sizeof(sizelist)/sizeof(short); i++) {
	sprintf(itemname, "%d", sizelist[i]);
	c2pstr(itemname);
	AppendMenu(myMenus[4], (StringPtr)itemname);
	}
size_item = 0;
}

void AppObject::define_style_menu(void)
{
style_bits = 0;
}

void AppObject::menu_upd(void)
{
Boolean undo_ok, cut_ok, copy_ok, paste_ok, clear_ok;
char undo_text[64];

/* file menu */

if (da_menu) {
	CheckItem(myMenus[1], kFileMSize, 0);
	}
else {
	CheckItem(myMenus[1], kFileMSize, done);
	}

/* edit menu */

if (da_menu) {
	EnableItem(myMenus[2], 1);
	EnableItem(myMenus[2], 3);
	EnableItem(myMenus[2], 4);
	EnableItem(myMenus[2], 5);
	EnableItem(myMenus[2], 6);
	DisableItem(myMenus[2], 8);
	}
else {
	if (!TEActive) {
		DisableItem(myMenus[2], 1);
		DisableItem(myMenus[2], 3);
		DisableItem(myMenus[2], 4);
		DisableItem(myMenus[2], 5);
		DisableItem(myMenus[2], 6);
		DisableItem(myMenus[2], 8);
		}
	else {
		get_undo_status(&undo_ok, undo_text);
		c2pstr(undo_text);
		SetMenuItemText(myMenus[2], 1, (StringPtr)undo_text);
		get_edit_flags(&cut_ok, &copy_ok, &paste_ok, &clear_ok);
		enable_menu_item(myMenus[2], 1, undo_ok);			// Undo
		enable_menu_item(myMenus[2], 3, cut_ok);			// Cut
		enable_menu_item(myMenus[2], 4, copy_ok);			// Copy
		enable_menu_item(myMenus[2], 5, paste_ok);			// Paste
		enable_menu_item(myMenus[2], 6, clear_ok);			// Clear
		EnableItem(myMenus[2], 8);							// Select All
		}
	}
	
/* Font menu */
if (kFontMenu > 0) {
	}

/* Size menu */
if (kSizeMenu > 0) {
	}

/* Style menu */
if (kStyleMenu > 0) {
	}
}

Boolean AppObject::do_command(short theMenu, short theItem)
{
unsigned char name[256];
WindowRecord * fw;
short i;
Boolean did_command, have_mark;
short mark_char, fnum, fsize;
Style new_style;
 
did_command = false;
switch(theMenu) {
	case kAppleMenu:
		did_command = true;
		if (theItem == 2) break;
		if (theItem == 1) {
			aboutdlg();
			break;
			}
		GetMenuItemText(myMenus[0], theItem, name);
		if (TEGetScrapLength() > 0) {		// export scrap
			ZeroScrap();
			TEToScrap();
			}
		OpenDeskAcc(name);
		TEFromScrap();					// import scrap
		break;
	case kFileMenu:
		switch (theItem) {
			case kFileMSize:			// last item
				did_command = true;
				if (!da_menu) {
					done ^= 1;
					break;
					}
				else {
					fw = (WindowRecord *)FrontWindow();
					i = fw->windowKind;
					if (i<0) CloseDeskAcc(i);
					}
			default:
				break;
			}
		break;
	case kEditMenu:
		if (da_menu) {
			did_command = true;
			SystemEdit(theItem-1);
			}
		else if (TEActive) {
			switch(theItem) {
				case 1:
					did_command = true;
					do_TEFunction(undo_function);
					break;
				case 3:
					did_command = true;
					do_TEFunction(cut_function);
					break;
				case 4:
					did_command = true;
					do_TEFunction(copy_function);
					break;
				case 5:
					did_command = true;
					do_TEFunction(paste_function);
					break;
				case 6:
					did_command = true;
					do_TEFunction(delete_function);
					break;
				case 8:
					did_command = true;
					do_TEFunction(select_all_function);
					break;
				default:
					break;
				}
			}
		break;
	default:
		if (theMenu == 0) {
			break;
			}
		if (theMenu == kFontMenu) {
			if (theItem == font_item) {
				break;
				}
			if (font_item > 0) {
				CheckItem(myMenus[3], font_item, false);
				}
			font_item = theItem;
			CheckItem(myMenus[3], font_item, true);
			GetMenuItemText(myMenus[3], font_item, name);
			GetFNum(name, &fnum);
			define_new_font(font_item, fnum);
			}
		else if (theMenu == kSizeMenu) {
			if (size_item > 0) {
				CheckItem(myMenus[4], size_item, false);
				}
			size_item = theItem;
			CheckItem(myMenus[4], size_item, true);
			GetMenuItemText(myMenus[4], size_item, name);
			p2cstr(name);
			fsize = strtol((char *)name, 0, 0);
			define_new_pointsize(size_item, fsize);
			}
		else if (theMenu == kStyleMenu) {
			if (theItem == 1) {
				CheckItem(myMenus[5], 1, true);
				for (i = 2; i <= 8; i++) {
					CheckItem(myMenus[5], i, false);
					}
				style_bits = 1;
				new_style = 0;
				}
			else {
				GetItemMark(myMenus[5], theItem, &mark_char);
				if (mark_char == 0) {
					CheckItem(myMenus[5], 1, false);
					CheckItem(myMenus[5], theItem, true);
					}
				else {
					CheckItem(myMenus[5], theItem, false);
					have_mark = false;
					for (i = 2; i <= 8; i++) {
						GetItemMark(myMenus[5], i, &mark_char);
						if (mark_char != 0) {
							have_mark = true;
							break;
							}
						}
					if (!have_mark) {
						CheckItem(myMenus[5], 1, true);
						}
					}
				GetItemMark(myMenus[5], 1, &mark_char);
				if (mark_char != 0) {
					style_bits = 1;
					new_style = 0;
					}
				else {
					style_bits = 0;
					for (i = 1; i < 8; i++) {
						GetItemMark(myMenus[5], i + 1, &mark_char);
						if (mark_char != 0) {
							style_bits += (1 << i);
							}
						}
					new_style = (Style)style_bits >> 1;
					}
				}
			define_new_style(style_bits, new_style);
			}
		break;
	}
return(did_command);
}

void AppObject::appl_menu()
{
static short last_edit = -1;	// init to invalid value
short new_edit;

new_edit = get_menu_state();

// skip drawing menu if no changes from last time
if (last_edit == new_edit) return;

// save value for next time
last_edit = new_edit;

// update menu bar
update_menu_bar();

DrawMenuBar();
}

short AppObject::get_menu_state(void)
{
						// set state used by update_menu_bar; must be >= 0
short result;

result = 0;
if (da_menu) result += 1;
if (font_item != 0) result += 2;
if (size_item != 0) result += 4;
if (style_bits != 0) result += 8;
return(result);
}

void AppObject::update_menu_bar(void)
{
						// App just does Edit menu
						// enable Edit menu for use by the DA
if (da_menu) {
	EnableItem(myMenus[2], 0);
	if (kFontMenu > 0) {
		DisableItem(myMenus[3], 0);
		}
	if (kSizeMenu > 0) {
		DisableItem(myMenus[4], 0);
		}
	if (kStyleMenu > 0) {
		DisableItem(myMenus[4], 0);
		}
	}
else {
	EnableItem(myMenus[2], 0);
	if (kFontMenu > 0) {
		if (font_item == 0) {
			DisableItem(myMenus[3], 0);
			}
		else {
			EnableItem(myMenus[3], 0);
			}
		}
	if (kSizeMenu > 0) {
		if (size_item == 0) {
			DisableItem(myMenus[4], 0);
			}
		else {
			EnableItem(myMenus[4], 0);
			}
		}
	if (kStyleMenu > 0) {
		if (style_bits == 0) {
			DisableItem(myMenus[5], 0);
			}
		else {
			EnableItem(myMenus[5], 0);
			}
		}
	}
}

void AppObject::do_update(GrafPtr thePort)
{
GrafPtr gp;

GetPort(&gp);
SetPort(thePort);
BeginUpdate(thePort);
update_window(thePort);
EndUpdate(thePort);
SetPort(gp);
}

void AppObject::aboutdlg(void)
{
DialogPtr dlgptr;
short itemHit;
unsigned char **version;
static unsigned char nullstr[1] = {0};
Str255 scratch;
WindowPtr front_window;

version = (unsigned char **)GetResource(kSignature, 0);
if (version == 0L) {
	return;
	}

waitcursor = ibeamcursor = false;
mySetCursor(kArrowCursor);

front_window = FrontWindow();
dlgptr = GetNewDialog(kAboutDialog, (Ptr)0L, (WindowPtr)-1L);
ctrwindow(dlgptr, center_denominator, 20, 0, 0);
GetRString(scratch, kAboutProgramName);
ParamText((*version), scratch, nullstr, nullstr);
ShowWindow(dlgptr);
deactivate_controls(front_window);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
#if GENERATINGPOWERPC
ModalDialog((ModalFilterUPP)&DlgFilter0RD, &itemHit);
#else
ModalDialog((ModalFilterUPP)DlgFilter0, &itemHit);
#endif
DisposeDialog(dlgptr);
ParamText(nullstr, nullstr, nullstr, nullstr);
/* activate_controls(); */  /* activate event will do this */
}

void AppObject::do_activate(WindowPtr theWindow)
{
short i;

appl_menu();
activate_controls(theWindow);
restore_cursor_state(theWindow);

// set actual cursor to match variables
redrawCursor();

// update ibeam cursor for current mouse position
if (TEActive) {
	update_cursor();
	}

restore_menu_state(theWindow);
if (font_item > 0) {
	CheckItem(myMenus[3], font_item, true);
	}
if (size_item > 0) {
	CheckItem(myMenus[4], size_item, true);
	}
if (style_bits > 0) {
	for (i = 0; i < 8; i++) {
		CheckItem(myMenus[5], i + 1,
			(style_bits & (1 << i)) != 0);
		}
	}
appl_menu();
}
	
void AppObject::do_deactivate(WindowPtr theWindow)
{
#ifdef MAC_GUI
save_cursor_state(theWindow);
save_menu_state(theWindow);
deactivate_controls(theWindow);
reset_window_state();
#endif
}

void AppObject::reset_window_state(void)
{
#ifdef MAC_GUI
short i;

mySetCursor(kArrowCursor);
waitcursor = ibeamcursor = TEActive = false;
if (font_item > 0) {
	CheckItem(myMenus[3], font_item, false);
	font_item = 0;
	}
if (size_item > 0) {
	CheckItem(myMenus[4], size_item, false);
	size_item = 0;
	}
if (style_bits > 0) {
	for (i = 0; i < 8; i++) {
		CheckItem(myMenus[5], i + 1, false);
		}
	style_bits = 0;
	}
appl_menu();
#endif
}
	
void AppObject::import_scrap(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->import_scrap();
SetPort(gp);
}

void AppObject::export_scrap(WindowPtr theWindow)
{
#ifdef MAC_GUI
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->export_scrap();
SetPort(gp);
#endif
}

void AppObject::showerr(char *s)
{
#ifdef MAC_GUI
WindowPtr front_window;

front_window = FrontWindow();
if (!myWindow(front_window)) {
	front_window = 0;
	}
if (front_window != 0) {
	do_update(front_window);
	deactivate_controls(front_window);
	}
mySetCursor(kArrowCursor);
waitcursor = ibeamcursor = 0;
std_showerr(s, front_window);
#endif
}

// mouse_in_text is called when TEActive is true.  It's result indicates
// whether the mouse is within the active TextEdit record.
Boolean AppObject::mouse_in_text(void)
{
WindowObject *wptr;
WindowPtr front_window;
GrafPtr gp;
Point mouseloc;
Boolean result;

front_window = FrontWindow();
wptr = find_my_window(front_window);
if (wptr == 0) {
	return(false);
	}
else {
	GetPort(&gp);
	SetPort((GrafPtr)front_window);
	GetMouse(&mouseloc);
	result = wptr->mouse_in_text(mouseloc);
	SetPort(gp);
	return(result);
	}
}

// drag_window calls DragWindow, providing the appropriate drag rectangle
void AppObject::drag_window(WindowPtr theWindow, Point startPt)
{
DragWindow(theWindow, startPt, &qd.screenBits.bounds);
//	Commenting this out...the system will take care of this if we pass
//	&qd.screenBits.bounds, or so claims david christie.  it works here
//	on my PowerBook G3 running 8.6.
/*
WindowObject *wptr;
wptr = find_my_window(theWindow);

if (wptr == 0) {
	// use default rect in App
	DragWindow(theWindow, startPt, &dragRect);
	}
else {
	DragWindow(theWindow, startPt, &(wptr->dragRect));
	}
*/
}

// grow_window calls GrowWindow, providing the appropriate size rectangle
void AppObject::grow_window(WindowPtr theWindow, Point startPt)
{
WindowObject *wptr;
unsigned short h, w;
long l;

wptr = find_my_window(theWindow);
if (wptr == 0) {
	// use default resizing
	l = GrowWindow(theWindow, startPt, &sizeRect);
	}
else {
	if (!wptr->grow_window) return;
	l = GrowWindow(theWindow, startPt, &(wptr->sizeRect));
	}

if (l == 0) {	// return if no change in size
	return;
	}
h = l >> 16;
w = l & 0x0000ffffL;

if (wptr == 0) {
	SizeWindow(theWindow, w, h, true);
	}
else {
	wptr->resize_scroll_draw(true);
	SizeWindow(theWindow, w, h, true);
	wptr->update_content_rects(&(theWindow->portRect));
	wptr->update_window_rects(false);
	wptr->resize_scroll_draw(false);
	if (invalidate_for_grow) {
		InvalRect(&(theWindow->portRect));
		}
	do_update(theWindow);		// redraw changes now, before possible scrolling
								// scrolling code assumes contentsRect is valid
	wptr->adjust_all_scroll_settings(true);
	}
}

void AppObject::zoom_window(WindowPtr theWindow, short partCode, Boolean front)
{
WindowObject *wptr;

wptr = find_my_window(theWindow);
if (wptr == 0) {
	EraseRect(&theWindow->portRect);
	ZoomWindow(theWindow, partCode, front);
	}
else {
	EraseRect(&theWindow->portRect);
	ZoomWindow(theWindow, partCode, front);
	wptr->update_content_rects(&(theWindow->portRect));
	wptr->update_window_rects(false);	// redraw changes before scrolling
	do_update(theWindow);
	wptr->update_window_rects(true);	// handle possible scrolling
	}
}

// myWindow returns true if its argument is one of our windows
Boolean AppObject::myWindow(WindowPtr theWindow)
{
WindowObject *wptr;

wptr = find_my_window(theWindow);
return(wptr != 0);
}

// update_window does the drawing necessary to respond to an
// update event for a window
void AppObject::update_window(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

wptr = find_my_window(theWindow);
if (wptr == 0) return;
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->draw_window();
SetPort(gp);
}
	
// content_click handles a mouse down event in the content area of a window
void AppObject::content_click(WindowPtr theWindow, EventRecord *theEvent)
{
WindowObject *wptr;
GrafPtr gp;
Point localPoint;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
localPoint = theEvent->where;
GlobalToLocal(&localPoint);
wptr->do_click(localPoint, theEvent);
SetPort(gp);
}
	
// deactivate_controls deactivates the controls in the front window,
// in preparation for the window no longer being active
void AppObject::deactivate_controls(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->deactivate_controls();
SetPort(gp);
}
	
// activate_controls activates controls in the front window
void AppObject::activate_controls(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->activate_controls();
SetPort(gp);
}

// save_cursor_state allows a window to save the values of TEActive,
// waitcursor, and ibeamcursor when a deactivate event occurs.  The
// window will have to restore them for a subsequent activate event.
void AppObject::save_cursor_state(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->save_cursor_state();
SetPort(gp);
}

// Similar routine for menu status
void AppObject::save_menu_state(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->save_menu_state();
SetPort(gp);
}

// When an activate event occurs, restore_cursor_state is used to
// restore the values of TEActive, waitcursor, and ibeamcursor.
void AppObject::restore_cursor_state(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->restore_cursor_state(&TEActive, &waitcursor, &ibeamcursor);
SetPort(gp);
}

// Similar routine for menu status
void AppObject::restore_menu_state(WindowPtr theWindow)
{
WindowObject *wptr;
GrafPtr gp;

GetPort(&gp);
wptr = find_my_window(theWindow);
if (wptr == 0) return;
SetPort(wptr->myWindow);
wptr->restore_menu_state(&font_item, &size_item, &style_bits);
SetPort(gp);
}

// do_go_away is called for a mouse click in the go away box
void AppObject::do_go_away(WindowPtr theWindow, Boolean all_windows)
{
WindowObject *wptr;

wptr = find_my_window(theWindow);
if (wptr == 0) return;

TEActive = waitcursor = ibeamcursor = false;

if (all_windows) {
	delete_all_windows();
	}
else {
	delete_window(wptr, true);
	}
}

// Window management methods

WindowObject * AppObject::find_my_window(WindowPtr wp)
{
if (wp == 0) return(0);
return((WindowObject *)(((WindowPeek)wp)->refCon));
}

// The caller creates a window object, then calls add_window
// to have the window displayed and added to our window list.

OSErr AppObject::add_window(WindowObject *theWindowObject)
{
// add window object to pointer list
return(window_list->AddPointer((void *)theWindowObject));
}

void AppObject::delete_window(WindowObject *theWindowObject, Boolean reset)
{
window_list->DeletePointer((void *)theWindowObject);
delete theWindowObject;
if (reset) {
	reset_window_state();
	}
}

void AppObject::delete_all_windows(void)
{
WindowObject *wptr;

wptr = (WindowObject *)(window_list->GetFirstPointer());
while (wptr != 0) {
	delete_window(wptr, false);
	wptr = (WindowObject *)(window_list->GetFirstPointer());
	}
reset_window_state();
}

void AppObject::define_new_font(short font_item, short font_number)
{
WindowObject *wptr;
GrafPtr gp;

wptr = find_my_window(FrontWindow());
if (wptr == 0) return;
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->define_new_font(font_item, font_number);
SetPort(gp);
}

void AppObject::define_new_pointsize(short size_item, short font_size)
{
WindowObject *wptr;
GrafPtr gp;

wptr = find_my_window(FrontWindow());
if (wptr == 0) return;
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->define_new_pointsize(size_item, font_size);
SetPort(gp);
}

void AppObject::define_new_style(short style_bits, Style new_style)
{
WindowObject *wptr;
GrafPtr gp;

wptr = find_my_window(FrontWindow());
if (wptr == 0) return;
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->define_new_style(style_bits, new_style);
SetPort(gp);
}

// The following routines do TextEdit processing for the active text edit
// record.  They are not called unless TEActive is true.  
void AppObject::do_TEFunction(short theFunction)
{
WindowObject *wptr;
GrafPtr gp;

wptr = find_my_window(FrontWindow());
if (wptr == 0) return;
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->do_TEFunction(theFunction);
SetPort(gp);
}

// get_edit_flags returns the flags used for enabling the Cut, Copy,
// Paste, and Clear items in the Edit menu.
void AppObject::get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
							   Boolean *paste_ok, Boolean *clear_ok)
{
WindowObject *wptr;
GrafPtr gp;

*cut_ok = *copy_ok = *paste_ok = *clear_ok = false;
wptr = find_my_window(FrontWindow());
if (wptr == 0) return;
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->get_edit_flags(cut_ok, copy_ok, paste_ok, clear_ok);
SetPort(gp);
}

// get_undo_status provides the information necessary to update
// the "Undo" menu item 
void AppObject::get_undo_status(Boolean *undo_ok, char *undo_text)
{
WindowObject *wptr;
GrafPtr gp;

wptr = find_my_window(FrontWindow());
if (wptr == 0) {
	*undo_ok = false;
	strcpy(undo_text, "Undo");
	return;
	}
GetPort(&gp);
SetPort(wptr->myWindow);
wptr->get_undo_status(undo_ok, undo_text);
SetPort(gp);
}

// callback for event handling
// A window or view calls this routine when something has
// happened the App must act on
void AppObject::handle_event(short eventCode)
{
#pragma unused (eventCode)
}

// static DragManager routines

pascal OSErr AppObject::appTrackingHandler(DragTrackingMessage theMessage,
										   WindowPtr theWindow,
										   void *handlerRefCon,
										   DragReference theDrag)
{
#pragma unused (handlerRefCon)
OSErr rc;
static 	WindowObject *dragWindow;	// window object for drag we're tracking

switch (theMessage) {
	case kDragTrackingEnterHandler:
	case kDragTrackingLeaveHandler:
			return(noErr);
			break;
	case kDragTrackingEnterWindow:
			dragWindow = (WindowObject *)((WindowPeek)theWindow)->refCon;
			break;
	case kDragTrackingInWindow:
	case kDragTrackingLeaveWindow:
	default:
			break;
	}

if (dragWindow == 0) {
	return(noErr);
	}
else {
	rc = dragWindow->TrackDrag(theMessage, theDrag);
	if (theMessage == kDragTrackingLeaveWindow) {
		dragWindow = 0;
		}
	return(rc);
	}
}

pascal OSErr AppObject::appReceiveHandler(WindowPtr theWindow,
					   					  void *handlerRefCon,
					  					  DragReference theDrag)
{
#pragma unused (handlerRefCon)
WindowObject *theWindowObject;

theWindowObject = (WindowObject *)((WindowPeek)theWindow)->refCon;
// reject if no object pointer
if (theWindowObject == 0) {
	return(dragNotAcceptedErr);
	}
// pass call along to the window object
return(theWindowObject->ReceiveDrag(theDrag));
}
