// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: AppObject.h,v $
// Revision 1.3  1999/01/09 03:42:18  dicamillo
// Add haveAppearance101.
//
// Revision 1.2  1999/01/01 02:45:16  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:13:29  dicamillo
// First Checked In.
//

// Definitions for generic application object

// data structure definitions

// global variables and methods

class AppObject {

public:
	// machine info
	short systemvol;				// boot volume
	short TEVersion;				// 0 or TextEdit version number
	short TSMVersion;				// 0 or Text Service Manager version
	unsigned long dragflags;		// drag manager flags
	unsigned long appearance_version;  // Appearanace Manager version or 0
	Boolean drag_mgr_avail;			// Drag Manager is present
	Boolean newroms;				// has new ROMs
	Boolean colormac;				// has Color QD
	Boolean gestaltavail;			// has Gestalt
	Boolean notifyavail;			// has Notification Manager
	Boolean sf58;					// has new Standard File calls
	Boolean sweeticons;				// has "sweet icons"
	Boolean haveAppearance;			// has Appearance Manager
	Boolean haveAppearance101;		// has Appearance Manager 1.0.1 or newer

	// useful for creating windows
	short dlgborderheight;			// height of top of dialog border
	short center_denominator;		// n = center things 1 nth of the way from top
	short mbar_adj;					// window adjustment for menu bar height
	Rect screenRect;				// rectangle defining screen
	Rect dragRect;					// rectangle defining bounds for dragging
	Rect sizeRect;					// rectangle for resizing windows
	Rect classicRect;				// rectangle that fills classic Mac screen
	char smallscreen;				// screen height is 342 or less
	// window management
	PointerList *window_list;		// list of window objects
	WindowPtr suspend_window;		// active window when we were suspended
	Boolean invalidate_for_grow;	// invalidate port rect for size change
	// menus
	MenuHandle myMenus[kNMenus];	// our menus
	char da_menu;					// desk accessory menu mode
	short font_item;				// selected font item no. or 0
	short size_item;				// selected size item no. or 0
	short style_bits;				// selected styles or 0
	// program status
	Boolean TEActive;				// true if a TextEdit record is active
	Boolean mf_bgrnd;				// true if in MultiFinder background
	Boolean done;					// true to exit program
	Boolean TSMcursor;				// cursor set by TSM
	THz myZone;						// my heap zone
	short null_interval;			// interval for handling null events
	unsigned long background_time;	// times for WaitNextEvent
	unsigned long foreground_time;
	unsigned long last_null;		// ticks for last null processing
	unsigned long last_yield;		// last time we yielded CPU
	// error handling
	NMRec my_notify_record;			// record for notification manager
	Boolean nmrec_installed;		// my_notify_record is currently installed
									// routine descriptions for Drag Manager
	static RoutineDescriptor my_TrackingHandlerRD;
	static RoutineDescriptor my_ReceiveHandlerRD;
	
public:
								// main app routines
	AppObject(void);
	virtual ~AppObject(void);
	virtual OSErr InitApp(Boolean init_heap);
	virtual void EndApp(void);
	virtual void Run(void);
								// event handling
	virtual void do_often(void);
	virtual void handle_events(void);
	virtual Boolean get_one_event(EventRecord *myEvent);
	virtual void handle_null_event(void);
	virtual void handle_one_event(EventRecord *myEvent);
	virtual void do_null_event(void);	
	virtual void do_key_down(EventRecord *theEvent);
	virtual void do_cmd_w(WindowObject *wptr);
	Boolean do_menu_key(EventRecord *theEvent);
	virtual void mf_suspend(void);
	virtual void mf_resume(long message);
	virtual void do_high_level_event(EventRecord *myEvent);
								// menu handling
	virtual void define_font_menu(void);
	virtual void define_size_menu(void);
	virtual void define_style_menu(void);
	virtual void menu_upd(void);
	virtual void appl_menu(void);
	virtual Boolean do_command(short theMenu, short theItem);
	virtual short get_menu_state(void);
	virtual void update_menu_bar(void);
	virtual void define_new_font(short font_item, short font_number);
	virtual void define_new_pointsize(short size_item, short font_size);
	virtual void define_new_style(short style_bits, Style new_style);
	virtual void do_TEFunction(short theFunction);
	virtual void get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
								Boolean *paste_ok, Boolean *clear_ok);
	virtual void get_undo_status(Boolean *undo_ok, char *undo_text);
								// window handling
	virtual void do_update(GrafPtr thePort);
	virtual Boolean myWindow(WindowPtr theWindow);
	virtual void drag_window(WindowPtr theWindow, Point startPt);
	virtual void grow_window(WindowPtr theWindow, Point startPt);
	virtual void zoom_window(WindowPtr theWindow, short partCode, Boolean front);
	virtual void update_window(WindowPtr theWindow);
	virtual void content_click(WindowPtr theWindow, EventRecord *theEvent);
	virtual void do_activate(WindowPtr theWindow);
	virtual void do_deactivate(WindowPtr theWindow);
	virtual void reset_window_state(void);
	virtual void deactivate_controls(WindowPtr theWindow);
	virtual void activate_controls(WindowPtr theWindow);
	virtual void save_cursor_state(WindowPtr theWindow);
	virtual void save_menu_state(WindowPtr theWindow);
	virtual void restore_cursor_state(WindowPtr theWindow);
	virtual void restore_menu_state(WindowPtr theWindow);
	virtual void import_scrap(WindowPtr theWindow);
	virtual void export_scrap(WindowPtr theWindow);
	virtual void do_go_away(WindowPtr theWindow, Boolean all_windows);
								// window management
	virtual WindowObject *find_my_window(WindowPtr wp);
	virtual OSErr add_window(WindowObject *theWindowObject);
	virtual void delete_window(WindowObject *theWindowObject, Boolean reset);
	virtual void delete_all_windows(void);
								// cursor handling
	virtual void update_cursor(void);
	virtual Boolean mouse_in_text(void);
								// about box
	virtual void aboutdlg(void);
								// error handling
	virtual void showerr(char *s);
								// callback for event handling
	virtual void handle_event(short eventCode);
								// static drag routines
	static pascal OSErr appTrackingHandler(DragTrackingMessage theMessage,
										   WindowPtr theWindow,
										   void *handlerRefCon,
										   DragReference theDrag);
	static pascal OSErr appReceiveHandler(WindowPtr theWindow,
					   					  void *handlerRefCon,
					   					  DragReference theDrag);

protected:
	// protected methods
};

// Constants for InitApp
#define SweetIconsTrapNum	0x3c9
#define UnImplTrapNum		0x9f

// Various constants for LApp methods

	// Disk Initialization Package dialog
const short kDITop = 80;
const short kDILeft = 112;

// Codes for handle_event
#define continue_event	1
#define cancel_event	2
