// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: DrawGUI.c,v $
// Revision 1.3  1999/01/09 03:46:00  dicamillo
// Change default for gHasAppearance and gHasAppearance101 to false.
//
// Revision 1.2  1999/01/01 02:45:16  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:14:13  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *DrawGUI_c(void) {
return "@(#)$Id: DrawGUI.c,v 1.3 1999/01/09 03:46:00 dicamillo Exp $"; }
#endif

#include "DrawGUI.h"

#include <Palettes.h>
#include <String.h>

#ifdef powerc
RoutineDescriptor gDrawThemePrimaryGroupLoopUPP
			= BUILD_ROUTINE_DESCRIPTOR(uppDeviceLoopDrawingProcInfo, DrawThemePrimaryGroupLoop);
RoutineDescriptor gBufferProgressLoopUPP
			= BUILD_ROUTINE_DESCRIPTOR(uppDeviceLoopDrawingProcInfo, DrawBufferProgressLoop);
RoutineDescriptor gDrawThemePlacardLoopUPP
			= BUILD_ROUTINE_DESCRIPTOR(uppDeviceLoopDrawingProcInfo, DrawThemePlacardLoop);
RoutineDescriptor gUpdateMainWindowLoopUPP
			= BUILD_ROUTINE_DESCRIPTOR(uppDeviceLoopDrawingProcInfo, UpdateMainWindowLoop);
RoutineDescriptor gUpdateMainWindowInfoOnlyLoopUPP
			= BUILD_ROUTINE_DESCRIPTOR(uppDeviceLoopDrawingProcInfo, UpdateMainWindowInfoOnlyLoop);
#endif

enum {
	kOutputIndex = 0,
	kInputIndex
};

WindowPtr		gMainWindow = nil;
Boolean			gIsMainWindowActive;
Boolean			gIsFirstActivate = false;

ControlHandle	gBuffersGroupBoxControl = nil;
ControlHandle	gStatusGroupBoxControl = nil;
ControlHandle	gFlushFetchControls[2];

// these are set appropriately by the main program at startup, but default
// to false as a precaution (against crashing)
Boolean			gHasAppearance = false, gHasAppearance101 = false;

Rect			gBuffersPrimaryRect = { 10, 14, 86, 338 };
Rect			gStatusPrimaryRect = { 96, 14, 160, 338 };
Rect			gInBufferRect = { 37, 66, 49, 152 };
Rect			gOutBufferRect = { 61, 66, 73, 152 };
Rect			gInBufferLabelRect = { 37, 0, 49, 60 };
Rect			gOutBufferLabelRect = { 61, 0, 73, 60 };
Rect			gInBufferTextRect = { 37, 159, 49, 267 };
Rect			gOutBufferTextRect = { 61, 159, 73, 267 };


Rect			gProgressBarRect = { 20, 99, 35, 300 };
Rect			gCheckingTextDisplayRect = { 20, 5, 31, 96 };
Rect			gThreadIDTextRect = { 2, 5, 14, 96 };
Rect			gTotalRateTextRect = { 2, 100, 14, kThreadRectRight - kThreadRectLeft };

ClientInfo		gBufferClientInfo;
PrivateThreadInfo	gThreadInfo[kMaxNumThreads];

short			gCurrentBuffersInfo;

Str63			gOutOfString;
Str63			gNotAvailableString;
Str32			gFlushFetchStrings[2];

Str32			gThreadString;
Str32			gProjectNameStrings[2];
Str63			gMillionKeysString;
Str32			gKKeysString;

short 			gFetchAdjustment = 0;

//Updating Info Flags Global Variables
Boolean			gHasAnyInfoChanged;
Boolean			gUpdateServerMessage;
Boolean			gUpdateInputOutputBufferText[2];
short			gNumThreadsToUpdate;

void set_gui_window_height(short height, Rect *updateRect);	// added

void InitializeMainWindow(void)
{
	gBufferClientInfo.buffersInfo[0].inputBuffer.totalBlocks = -1;
	gBufferClientInfo.buffersInfo[0].outputBuffer.totalBlocks = -1;
	
	gBufferClientInfo.buffersInfo[1].inputBuffer.totalBlocks = -1;
	gBufferClientInfo.buffersInfo[1].outputBuffer.totalBlocks = -1;
	
	gBufferClientInfo.numThreads = 0;
	gBufferClientInfo.hasServerMessageChanged = false;
	gBufferClientInfo.lastServerMessage[0] = 0;
	
	GetIndString(gOutOfString, kMiscStringsID, kOutOfString);
	GetIndString(gNotAvailableString, kMiscStringsID, kNotAvailableString);
	GetIndString(gFlushFetchStrings[kInputIndex], kMiscStringsID, kFetchString);
	GetIndString(gFlushFetchStrings[kOutputIndex], kMiscStringsID, kFlushString);
	
	GetIndString(gThreadString, kMiscStringsID, kThreadString);
	GetIndString(gProjectNameStrings[kRC5ProjectType], kMiscStringsID, kRC5String);
	GetIndString(gProjectNameStrings[kDESProjectType], kMiscStringsID, kDESString);
	GetIndString(gMillionKeysString, kMiscStringsID, kMillionKeysCheckedString);
	GetIndString(gKKeysString, kMiscStringsID, kKKeysSecString);
	
	gCurrentBuffersInfo = 0;
	
	gUpdateInputOutputBufferText[kOutputIndex] = false;
	gUpdateInputOutputBufferText[kInputIndex] = false;
	
	//Remove Test Values
	/*
	gBufferClientInfo.buffersInfo[0].inputBuffer.totalBlocks = 5000;
	gBufferClientInfo.buffersInfo[0].inputBuffer.numBlocks = 1280;
	gBufferClientInfo.buffersInfo[0].inputBuffer.changingRightNow = false;
	gBufferClientInfo.buffersInfo[0].outputBuffer.totalBlocks = 30;
	gBufferClientInfo.buffersInfo[0].outputBuffer.numBlocks = 0;
	gBufferClientInfo.buffersInfo[0].outputBuffer.changingRightNow = false;
	
	gBufferClientInfo.buffersInfo[1].inputBuffer.totalBlocks = 60;
	gBufferClientInfo.buffersInfo[1].inputBuffer.numBlocks = 30;
	gBufferClientInfo.buffersInfo[1].inputBuffer.changingRightNow = true;
	
	gBufferClientInfo.numThreads = 1;
	gBufferClientInfo.threadsInfo[0].projectType = kRC5ProjectType;
	gBufferClientInfo.threadsInfo[0].blockKeysChecked = 64000000;
	gBufferClientInfo.threadsInfo[0].progressPercent = 32;
	
	gBufferClientInfo.threadsInfo[1].projectType = kDESProjectType;
	gBufferClientInfo.threadsInfo[1].totalBlockKeysChecked = 37;
	gBufferClientInfo.threadsInfo[1].progressPercent = 64;
	BlockMove("Hello", gBufferClientInfo.lastServerMessage, 10); */
}


void DefineMainWindow(WindowPtr theWindow)
{
	ControlFontStyleRec	style;
	ControlHandle		control;
	short				counter;
	
	gMainWindow = theWindow;
	SetPort(gMainWindow);
	TextFont(kFontIDGeneva);
	TextSize(9);
	gIsMainWindowActive = true;
	
	if (gHasAppearance)
		CreateRootControl(gMainWindow, &control);
	
	gFlushFetchControls[kInputIndex] = GetNewControl(131, gMainWindow);
	gFlushFetchControls[kOutputIndex] = GetNewControl(132, gMainWindow);
	
	if (gHasAppearance)
	{
		style.flags = kControlUseFontMask;
		style.font = kControlFontSmallSystemFont;
		
		/*
		style.flags = kControlUseFontMask + kControlUseFaceMask + kControlUseSizeMask;
		style.font = kFontIDGeneva;
		style.style = bold;
		style.size = 9;
		*/
		
		gBuffersGroupBoxControl = GetNewControl(128, gMainWindow);
		SetControlFontStyle(gBuffersGroupBoxControl, &style);
		EmbedControl(gBuffersGroupBoxControl, control);
		
		gStatusGroupBoxControl = GetNewControl(129, gMainWindow);
		SetControlFontStyle(gStatusGroupBoxControl, &style);
		EmbedControl(gStatusGroupBoxControl, control);
		
		SetControlFontStyle(gFlushFetchControls[kInputIndex], &style);
		SetControlFontStyle(gFlushFetchControls[kOutputIndex], &style);
		EmbedControl(gFlushFetchControls[kInputIndex], gBuffersGroupBoxControl);
		EmbedControl(gFlushFetchControls[kOutputIndex], gBuffersGroupBoxControl);
		
		SetThemeWindowBackground(gMainWindow, kThemeActiveDialogBackgroundBrush, false);
	}
	else
	{
		gBuffersGroupBoxControl = GetNewControl(130, gMainWindow);
	}
	
	SetFlushFetchControlsHilite(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer, true);
	SetFlushFetchControlsHilite(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer, false);
	
	for (counter = 0; counter < gBufferClientInfo.numThreads; counter++)
	{
		CreateGUIThread(counter);
	}
	
//	SetWindowCorrectSize(); moved
	
//	ShowWindow(gMainWindow);
	gIsFirstActivate = true;
}


void UpdateMainWindow(void)
{
	Str255			string;
	Rect			tempRect;
	GroupBoxData	data;
	tempRect = gMainWindow->portRect;
	InsetRect(&tempRect, -1, -1);
	tempRect.bottom -= kServerMessageHeight;
	MyDrawThemePlacard(&tempRect, gIsMainWindowActive);
	tempRect.bottom = gMainWindow->portRect.bottom + 1;
	tempRect.top = tempRect.bottom - kServerMessageHeight - 1;
	MyDrawThemePlacard(&tempRect, gIsMainWindowActive);
	
	TextSize(10);
	UpdateControls(gMainWindow, gMainWindow->visRgn);
	
	if (gHasAppearance == false)
	{
		data.useText = false;
		data.control = gBuffersGroupBoxControl;
#ifdef powerc
		CallPrimitiveDrawProc(&gBuffersPrimaryRect, gIsMainWindowActive, &data, &gDrawThemePrimaryGroupLoopUPP);
#else
		CallPrimitiveDrawProc(&gBuffersPrimaryRect, gIsMainWindowActive, &data, (DeviceLoopDrawingUPP) DrawThemePrimaryGroupLoop);
#endif
		data.useText = true;
		data.text = string;
		GetIndString(string, kMiscStringsID, kStatusString);
#ifdef powerc
		CallPrimitiveDrawProc(&gStatusPrimaryRect, gIsMainWindowActive, &data, &gDrawThemePrimaryGroupLoopUPP);
#else
		CallPrimitiveDrawProc(&gStatusPrimaryRect, gIsMainWindowActive, &data, (DeviceLoopDrawingUPP) DrawThemePrimaryGroupLoop);
#endif
	}
	
	TextSize(9);
	
	DrawBufferProgress(&gInBufferRect, false, gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer.numBlocks, gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer.totalBlocks);
	DrawBufferProgress(&gOutBufferRect, false, gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer.numBlocks, gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer.totalBlocks);
	
#ifdef powerc
	DeviceLoop(gMainWindow->visRgn, &gUpdateMainWindowLoopUPP, 0, 0);
#else
	DeviceLoop(gMainWindow->visRgn,
			(DeviceLoopDrawingUPP)UpdateMainWindowLoop, 0, 0);
#endif
}


/*
void ActivateMainWindow(Boolean activating)
{
	ControlHandle	control, root;
	short			newValue;
	
	if (gHasAppearance)
		SetThemeWindowBackground(gMainWindow, activating ? kThemeActiveDialogBackgroundBrush : kThemeInactiveDialogBackgroundBrush, false);
//	InvalRect(&gMainWindow->portRect);

	if (gIsFirstActivate)
	{
		gIsFirstActivate = false;
		return ;
	}
	
	if (gMainWindow)
	{
		
		/*
		if (gHasAppearance)
		{
			if (GetRootControl(gMainWindow, &control) == noErr)
			{
				if (activating)
					ActivateControl(control);
				else
					DeactivateControl(control);
			}
		}
		else
		{
		*/ /*
			control = (ControlHandle) ((WindowPeek) gMainWindow)->controlList;
			if (gHasAppearance) {
				GetRootControl(gMainWindow, &root);
			}
			while (control)
			{
{
char msg[256];

if (control == gFlushFetchControls[1]) {
	sprintf(msg, "Saving hilite of %d", (**control).contrlHilite);
	DebugStr(c2pstr(msg));
	}
}
				if (gHasAppearance) {
					if (control == root) {
						control = (**control).nextControl;
						continue;
					}
					SetControlVisibility(control, false, false);
				}
				else
					(**control).contrlVis = 0;

				if (activating == false)
				{
					(**control).contrlRfCon = (**control).contrlHilite;
					newValue = !activating * 255;
				}
				else
				{
					newValue = (**control).contrlRfCon;
				}
				HiliteControl(control, newValue);

				if (gHasAppearance)
					SetControlVisibility(control, true, false);
				else
					(**control).contrlVis = 255;

				control = (**control).nextControl;
			}
		//}
	}
	
	gIsMainWindowActive = activating;
} */


void ActivateMainWindow(Boolean activating)
{
	ControlHandle	control, root;
	short			newValue;
 
	if (gMainWindow == nil)
	return ;
 
	if (gHasAppearance)
		SetThemeWindowBackground(gMainWindow, activating ?
			kThemeActiveDialogBackgroundBrush : kThemeInactiveDialogBackgroundBrush,
			false);
 
	if (gIsFirstActivate)
	{
		gIsFirstActivate = false;
		return ;
	}
 	
 	if (gHasAppearance)
 	{
 		TextSize(10);
 		
 		GetRootControl(gMainWindow, &root);
 		SetControlVisibility(root, false, false);
 		if (activating)
 			ActivateControl(root);
 		else
 			DeactivateControl(root);
 		SetControlVisibility(root, true, false);
 		
 		TextSize(9);
 	}
 	else
 	{
		control = (ControlHandle) ((WindowPeek) gMainWindow)->controlList;
		while (control)
		{
			if (activating == false)
			{
				(**control).contrlRfCon = (**control).contrlHilite;
				newValue = !activating * 255;
			}
			else
			{
				newValue = (**control).contrlRfCon;
			}
 			
			(**control).contrlHilite = newValue;

			control = (**control).nextControl;
	 	}
	}
 	
	gIsMainWindowActive = activating;
}

ControlHandle ClickMainWindow(Point localMouse)
//void ClickMainWindow(Point localMouse)
{
	ControlHandle	whichCtl, clickedCtl = 0;
	short			part = kControlNoPart, tempPart;
	short			oldInfoValue;
	short			value;
	
	TextSize(10);
	

	if (gHasAppearance)
	{
		whichCtl = FindControlUnderMouse(localMouse, gMainWindow, &tempPart);
//		if (whichCtl && (**whichCtl).contrlHilite == 0)
//			part = HandleControlClick(whichCtl, localMouse, 0, (ControlActionUPP) -1);
		if (whichCtl) {
			if ((**whichCtl).contrlHilite == 0) {
				part = HandleControlClick(whichCtl, localMouse, 0, (ControlActionUPP) -1);
			}
		}
	}
	else
	{
//		if (FindControl(localMouse, gMainWindow, &whichCtl) && (**whichCtl).contrlHilite == 0)
//			part = TrackControl(whichCtl, localMouse, (ControlActionUPP) -1);
		if (FindControl(localMouse, gMainWindow, &whichCtl)) {
			if ((**whichCtl).contrlHilite == 0) {
				part = TrackControl(whichCtl, localMouse, (ControlActionUPP) -1);
			}
		}
	}
	
	TextSize(9);
	
	if (part != kControlNoPart)
	{
		clickedCtl = whichCtl;
		value = GetControlValue(whichCtl);
		
		if ((whichCtl == gBuffersGroupBoxControl) && value - 1 != gCurrentBuffersInfo)
		{
			oldInfoValue = gCurrentBuffersInfo;
			gCurrentBuffersInfo = value - 1;
			CheckForBufferChanges(&gBufferClientInfo.buffersInfo[oldInfoValue].inputBuffer, &gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer, true);
			CheckForBufferChanges(&gBufferClientInfo.buffersInfo[oldInfoValue].outputBuffer, &gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer, false);
			gNumThreadsToUpdate = 0;
			UpdateMainWindowInfoOnly();
		}
		else
		{
			//Remove Test Values
			/*
			BlockMoveData(&gBufferClientInfo, &temp, sizeof(temp));
			
			temp.buffersInfo[0].inputBuffer.totalBlocks = 5000;
			temp.buffersInfo[0].inputBuffer.numBlocks = 1280;
			temp.buffersInfo[0].inputBuffer.changingRightNow = false;
			temp.buffersInfo[0].outputBuffer.totalBlocks = 30;
			temp.buffersInfo[0].outputBuffer.numBlocks = 0;
			temp.buffersInfo[0].outputBuffer.changingRightNow = false;
			
			temp.buffersInfo[1].inputBuffer.totalBlocks = 60;
			temp.buffersInfo[1].inputBuffer.numBlocks = 30;
			temp.buffersInfo[1].inputBuffer.changingRightNow = true;
			
			temp.numThreads = 1;
			temp.threadsInfo[0].projectType = kRC5ProjectType;
			temp.threadsInfo[0].blockKeysChecked = 64000000;
			temp.threadsInfo[0].progressPercent = 32;
			
			temp.threadsInfo[1].projectType = kDESProjectType;
			temp.threadsInfo[1].blockKeysChecked = 37000000;
			temp.threadsInfo[1].progressPercent = 64;
			
			UpdateMainWindowInfo(&temp);
			*/
		}
	}
	else
	{
		//Remove Test Values
		/*BlockMoveData(&gBufferClientInfo, &temp, sizeof(temp));
		
		temp.buffersInfo[0].inputBuffer.totalBlocks = 200;
		temp.buffersInfo[0].inputBuffer.numBlocks = 140;
		temp.buffersInfo[0].inputBuffer.changingRightNow = true;
		temp.buffersInfo[0].outputBuffer.totalBlocks = 30;
		temp.buffersInfo[0].outputBuffer.numBlocks = 22;
		temp.buffersInfo[0].outputBuffer.changingRightNow = false;
		
		temp.threadsInfo[0].projectType = kDESProjectType;
		temp.threadsInfo[0].blockKeysChecked = 33000000;
		temp.threadsInfo[0].progressPercent = 78;
		
		temp.hasServerMessageChanged = true;
		BlockMove("Second Test", temp.lastServerMessage, 20);
		
		temp.numThreads++;
		UpdateMainWindowInfo(&temp);*/
		
		/*
		BlockMoveData(&gBufferClientInfo, &temp, sizeof(temp));
		
		temp.numThreads++;
		temp.threadsInfo[0].blockKeysChecked += 10000000;
		UpdateMainWindowInfo(&temp);
		*/
	}

	return(clickedCtl);
}

// Added by Peter
void SetCurrentBuffersContest(short contest)
{
	short	oldInfoValue;

	if (contest == gCurrentBuffersInfo) return;

	oldInfoValue = gCurrentBuffersInfo;
	gCurrentBuffersInfo = contest;
	CheckForBufferChanges(&gBufferClientInfo.buffersInfo[oldInfoValue].inputBuffer, &gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer, true);
	CheckForBufferChanges(&gBufferClientInfo.buffersInfo[oldInfoValue].outputBuffer, &gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer, false);
	gNumThreadsToUpdate = 0;
	SetControlValue(gBuffersGroupBoxControl, gCurrentBuffersInfo + 1);
	UpdateMainWindowInfoOnly();
}

void InitializeMainWindowInfo(ClientInfoPtr newInfo, short threadnum, Boolean update)
{
	ThreadInfoPtr			oldThreadInfo, newThreadInfo;

	oldThreadInfo = &gBufferClientInfo.threadsInfo[threadnum];
	newThreadInfo = &newInfo->threadsInfo[threadnum];

	oldThreadInfo->blockKeysChecked = newThreadInfo->blockKeysChecked;
	
	if (update) UpdateMainWindowInfo(newInfo);
}

void UpdateMainWindowInfo(ClientInfoPtr newInfo)
{
	short					leastNumThreads, counter;
	short					oldNumThreads;
	ThreadInfoPtr			oldThreadInfo, newThreadInfo;
	PrivateThreadInfoPtr	privateInfo;
	unsigned long			ticks = LMGetTicks();
	long					newRate;
	Rect					tempRect;
	short 					newHeight;
	
	gHasAnyInfoChanged = false;
	CheckForBufferChanges(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer, &newInfo->buffersInfo[gCurrentBuffersInfo].inputBuffer, true);
	CheckForBufferChanges(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer, &newInfo->buffersInfo[gCurrentBuffersInfo].outputBuffer, false);
	
	oldNumThreads = gBufferClientInfo.numThreads;
	leastNumThreads = oldNumThreads;
	if (newInfo->numThreads < oldNumThreads)
		leastNumThreads = newInfo->numThreads;
	
	if (newInfo->hasServerMessageChanged)
	{
		gHasAnyInfoChanged = true;
		gUpdateServerMessage = true;

		newInfo->hasServerMessageChanged = false;
	}
	
	gNumThreadsToUpdate = leastNumThreads;
	for (counter = 0; counter < leastNumThreads; counter++)
	{
		oldThreadInfo = &gBufferClientInfo.threadsInfo[counter];
		newThreadInfo = &newInfo->threadsInfo[counter];
		privateInfo = &gThreadInfo[counter];
		
		if (newThreadInfo->projectType != oldThreadInfo->projectType)
		{
			privateInfo->updateAnyInfo = true;
			gHasAnyInfoChanged = true;
			privateInfo->updateProjectNameString = true;
		}
		
		if (newThreadInfo->blockKeysChecked != oldThreadInfo->blockKeysChecked)
		{
			if (newThreadInfo->blockKeysChecked == 0)
			{
				newRate = -1;
			}
			else
			{
				if ((ticks - privateInfo->lastCheckRateTicks) >= 30)
				{									// get keys per second
					newRate = ((newThreadInfo->blockKeysChecked - oldThreadInfo->blockKeysChecked) * 60) / (ticks - privateInfo->lastCheckRateTicks);
					newRate = (newRate + 500) / 1000;	// Kkeys per second
				}
				else
				{
					newRate = privateInfo->lastRate;
				}
			} 
			if ( (newRate != privateInfo->lastRate) /*|| ((newThreadInfo->blockKeysChecked / 1000000) != (oldThreadInfo->blockKeysChecked / 1000000))*/ )
			{
				privateInfo->updateAnyInfo = true;
				gHasAnyInfoChanged = true;
				privateInfo->updateTotalRateString = true;
			}
			privateInfo->lastRate = newRate;
			privateInfo->lastCheckRateTicks = ticks;
		}
		else	// reset ticks to get correct timing at start
		{
			if (newThreadInfo->blockKeysChecked == 0)
			{
				privateInfo->lastRate = -1;
				privateInfo->lastCheckRateTicks = ticks;
			}
		}
				
		if (newThreadInfo->totalMillionKeysChecked != oldThreadInfo->totalMillionKeysChecked)
		{
			privateInfo->updateAnyInfo = true;
			gHasAnyInfoChanged = true;
			privateInfo->updateTotalRateString = true;
		}

		if (newThreadInfo->progressPercent != oldThreadInfo->progressPercent)
		{
			if (gHasAppearance)
				SetControlValue(privateInfo->progressBar, newThreadInfo->progressPercent);
			else
			{
				privateInfo->updateAnyInfo = true;
				gHasAnyInfoChanged = true;
				privateInfo->updateProgressBar = true;
			}
		}
	}
	
	BlockMoveData(newInfo, &gBufferClientInfo, sizeof(gBufferClientInfo));
	
	if (oldNumThreads != gBufferClientInfo.numThreads)
	{
		if (gBufferClientInfo.numThreads > oldNumThreads)
		{
			for (counter = oldNumThreads; counter < gBufferClientInfo.numThreads; counter++)
			{
				CreateGUIThread(counter);
			}
		}
		else
		{
			for (counter = gBufferClientInfo.numThreads; counter < oldNumThreads; counter++)
			{
				RemoveGUIThread(counter);
			}
		}
		
//		SetWindowCorrectSize();
		newHeight = SetWindowCorrectSize(&tempRect);
		ChangeWindowHeight(newHeight, &tempRect);
	}
	
	if (gHasAnyInfoChanged)
		UpdateMainWindowInfoOnly();
}


Boolean IsMainWindow(WindowPtr window)
{
	return (window == gMainWindow);
}


#pragma mark Stuff as of 7/1/98 


// void SetWindowCorrectSize(void)
short SetWindowCorrectSize(Rect *updateRect)
{
	short	newHeight, oldTop;
	Rect	tempRect;
	
	newHeight = kBaseWindowHeight + (gBufferClientInfo.numThreads * kThreadRectHeight);
	oldTop = gStatusPrimaryRect.bottom;
	gStatusPrimaryRect.bottom = newHeight - 29;
	if (gStatusGroupBoxControl)
	{
		tempRect = (**gStatusGroupBoxControl).contrlRect;
		tempRect.bottom = gStatusPrimaryRect.bottom;
		SetControlVisibility(gStatusGroupBoxControl, false, false);
		SizeControl(gStatusGroupBoxControl, tempRect.right - tempRect.left, tempRect.bottom - tempRect.top);
		SetControlVisibility(gStatusGroupBoxControl, true, false);
	}
	
	*updateRect = gMainWindow->portRect;
	if (oldTop < gStatusPrimaryRect.bottom)
		updateRect->top = oldTop - 4;
	else
		updateRect->top = gStatusPrimaryRect.bottom - 4;
//	EraseRect(&tempRect);
//	InvalRect(&tempRect);
//	SizeWindow(gMainWindow, gMainWindow->portRect.right, newHeight, true);
	return(newHeight);
}

void ChangeWindowHeight(short newHeight, Rect *updateRect)
{
set_gui_window_height(newHeight, updateRect);
}

void GetThreadRect(short threadID, RectPtr rect)
{
	short	amount = threadID * kThreadRectHeight;
	
	rect->top = kFirstThreadRectTop + amount;
	rect->bottom = kFirstThreadRectTop + amount + kThreadRectHeight;
	rect->left = kThreadRectLeft;
	rect->right = kThreadRectRight;
}

void CreateGUIThread(short threadID)
{
	Rect	threadRect, progressBarRect;
	
	gThreadInfo[threadID].updateProjectNameString = false;
	gThreadInfo[threadID].updateTotalRateString = false;
	gThreadInfo[threadID].lastRate = -1;
	gThreadInfo[threadID].lastCheckRateTicks = TickCount();
	
	if (gHasAppearance)
	{
		GetThreadRect(threadID, &threadRect);
		progressBarRect = gProgressBarRect;
		OffsetRect(&progressBarRect, threadRect.left, threadRect.top);
		gThreadInfo[threadID].progressBar = NewControl(gMainWindow, &progressBarRect, "\p", true, gBufferClientInfo.threadsInfo[threadID].progressPercent, 0, 100, kControlProgressBarProc, 0);
		EmbedControl(gThreadInfo[threadID].progressBar, gStatusGroupBoxControl);
	}
	else
	{
		gThreadInfo[threadID].progressBar = nil;
		gThreadInfo[threadID].updateProgressBar = false;
	}
	
	//Remove Test Values
	//gThreadInfo[threadID].lastRate = 576;
}


void RemoveGUIThread(short threadID)
{
	if (gThreadInfo[threadID].progressBar)
		DisposeControl(gThreadInfo[threadID].progressBar);
}


void UpdateThreadNumTypeDisplay(short threadID, RectPtr textRect)
{
	Str255			string;
	unsigned char	tempString[12];
	StringPtr		stringPtr;
	
	BlockMoveData(gThreadString, string, gThreadString[0] + 1);
	NumToString(threadID + 1, tempString);
	BlockMoveData(&tempString[1], &string[string[0] + 1], tempString[0]);
	string[0] += tempString[0] + 2;
	string[string[0] - 1] = ':';
	string[string[0]] = ' ';
	stringPtr = gProjectNameStrings[gBufferClientInfo.threadsInfo[threadID].projectType];
	BlockMoveData(&stringPtr[1], &string[string[0] + 1], stringPtr[0]);
	string[0] += stringPtr[0];
	
	TextFace(bold);
	MyTextBox(string, textRect, teForceLeft);
	TextFace(0);
}


void UpdateTotalRateDisplay(short threadID, RectPtr textRect)
{
	Str255			string;
	unsigned char	tempString[12];
	
    TotalKeysToString(gBufferClientInfo.threadsInfo[threadID].totalMillionKeysChecked, string);
	
	BlockMoveData(&gMillionKeysString[1], &string[string[0] + 1], gMillionKeysString[0]);
	string[0] += gMillionKeysString[0];
	
	if (gThreadInfo[threadID].lastRate == -1)
	{
		string[0] -= 4;
	}
	else
	{
		NumToString(gThreadInfo[threadID].lastRate, tempString);
		BlockMoveData(&tempString[1], &string[string[0] + 1], tempString[0]);
		string[0] += tempString[0];
		BlockMoveData(&gKKeysString[1], &string[string[0] + 1], gKKeysString[0]);
		string[0] += gKKeysString[0];
	}
	
	MyTextBox(string, textRect, teForceLeft);
}

void TotalKeysToString(double d_keys, StringPtr theString)
{
char *result_string;

result_string = (char *)theString;

if (d_keys >= 100.0) {
	sprintf(result_string, "%.0f", d_keys);
	}
else if (d_keys >= 10.0) {
	sprintf(result_string, "%.1f", d_keys);
	}
else if (d_keys >= 1.0) {
	sprintf(result_string, "%.2f", d_keys);
	}
else if (d_keys > 0) {
	sprintf(result_string, "%.3f", d_keys);
	}
else {
	strcpy(result_string, "0");
	}

c2pstr(result_string);
}


#pragma mark Stuff as of 6/30/98 


void UpdateMainWindowInfoOnly(void)
{
#ifdef powerc
	DeviceLoop(gMainWindow->visRgn, &gUpdateMainWindowInfoOnlyLoopUPP, 0, 0);
#else
	DeviceLoop(gMainWindow->visRgn,
			(DeviceLoopDrawingUPP)UpdateMainWindowInfoOnlyLoop, 0, 0);
#endif
}


pascal void UpdateMainWindowInfoOnlyLoop(SInt16 depth, SInt16 flags, GDHandle device, long refCon)
{
	#pragma unused (refCon)
	
	short					counter;
	Rect					threadRect, tempRect;
	RGBColor				color;
	PrivateThreadInfoPtr	privateInfo;
	
	SetAppropriateTextColor(device, depth, flags, gIsMainWindowActive);
	
	if (gUpdateInputOutputBufferText[kInputIndex])
	{
		EraseRect(&gInBufferTextRect);
		UpdateNumBlocksDisplay(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer, &gInBufferTextRect, true);
		gUpdateInputOutputBufferText[kInputIndex] = false;
	}
	
	if (gUpdateInputOutputBufferText[kOutputIndex])
	{
		EraseRect(&gOutBufferTextRect);
		UpdateNumBlocksDisplay(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer, &gOutBufferTextRect, false);
		gUpdateInputOutputBufferText[kOutputIndex] = false;
	}
	
	if (gUpdateServerMessage)
	{
		tempRect = gMainWindow->portRect;
		InsetRect(&tempRect, 1, 2);
		tempRect.top = tempRect.bottom - kServerMessageHeight + 4;
		EraseRect(&tempRect);
		tempRect.top--;
		if (gBufferClientInfo.lastServerMessage[0] != 0)
			MyTextPtrBox((Ptr) gBufferClientInfo.lastServerMessage, strlen(gBufferClientInfo.lastServerMessage), &tempRect, teCenter);
	}
	
	for (counter = 0; counter < gNumThreadsToUpdate; counter++)
	{
		privateInfo = &gThreadInfo[counter];
		if (privateInfo->updateAnyInfo)
		{
			GetThreadRect(counter, &threadRect);
			
			if (privateInfo->updateProjectNameString)
			{
				tempRect = gThreadIDTextRect;
				OffsetRect(&tempRect, threadRect.left, threadRect.top);
				EraseRect(&tempRect);
				UpdateThreadNumTypeDisplay(counter, &tempRect);
				privateInfo->updateProjectNameString = false;
			}
			
			if (privateInfo->updateTotalRateString)
			{
				tempRect = gTotalRateTextRect;
				OffsetRect(&tempRect, threadRect.left, threadRect.top);
				EraseRect(&tempRect);
				UpdateTotalRateDisplay(counter, &tempRect);
				privateInfo->updateTotalRateString = false;
			}
			
			if (privateInfo->updateProgressBar)
			{
				GetForeColor(&color);
				tempRect = gProgressBarRect;
				tempRect.bottom++;
				OffsetRect(&tempRect, threadRect.left, threadRect.top);
				DrawProgressBar(&tempRect, false, gBufferClientInfo.threadsInfo[counter].progressPercent, 100, depth);
				RGBForeColor(&color);
				privateInfo->updateProgressBar = false;
			}
		}
	}
}


void UpdateNumBlocksDisplay(BufferInfoPtr bufferInfo, RectPtr rect, Boolean input)
{
	Str255			string;
	unsigned char	tempString[12];
	StringPtr		useThisString;
	
	if (bufferInfo->totalBlocks == -1)
	{
		useThisString = gNotAvailableString;
	}
	else
	{
		NumToString(bufferInfo->numBlocks, string);
		BlockMoveData(&gOutOfString[1], &string[string[0] + 1], gOutOfString[0]);
		string[0] += gOutOfString[0];
		NumToString(bufferInfo->totalBlocks, tempString);
		BlockMoveData(&tempString[1], &string[string[0] + 1], tempString[0]);
		string[0] += tempString[0];
		if (bufferInfo->changingRightNow)
		{
			string[0]++;
			string[string[0]] = '/';
			BlockMoveData(&(gFlushFetchStrings[input])[1], &string[string[0] + 1], (gFlushFetchStrings[input])[0]);
			string[0] += (gFlushFetchStrings[input])[0];
		}
		useThisString = string;
	}
	
	MyTextBox(useThisString, rect, teForceLeft);
}


void CheckForBufferChanges(BufferInfoPtr oldBufferInfo, BufferInfoPtr newBufferInfo, Boolean input)
{
	Boolean			changeText = false;
	RectPtr			rect;
	
	if (oldBufferInfo->numBlocks != newBufferInfo->numBlocks ||
			oldBufferInfo->totalBlocks != newBufferInfo->totalBlocks)
	{
		changeText = true;
		
		if (input)
			rect = &gInBufferRect;
		else
			rect = &gOutBufferRect;
		DrawBufferProgress(rect, true, newBufferInfo->numBlocks, newBufferInfo->totalBlocks);
	}
	else if (oldBufferInfo->changingRightNow != newBufferInfo->changingRightNow)
	{
		changeText = true;
	}
	
	if (changeText)
	{
		gUpdateInputOutputBufferText[input] = true;
		gHasAnyInfoChanged = true;
		SetFlushFetchControlsHilite(newBufferInfo, input);
	}
}


void SetFlushFetchControlsHilite(BufferInfoPtr newBufferInfo, Boolean input)
{
	short			hilite;
	
	if (input)
		hilite = 255 * (newBufferInfo->changingRightNow || newBufferInfo->numBlocks >= (newBufferInfo->totalBlocks - gFetchAdjustment) || newBufferInfo->totalBlocks == -1);
	else
		hilite = 255 * (newBufferInfo->changingRightNow || newBufferInfo->numBlocks == 0 || newBufferInfo->totalBlocks == -1);
	
	
	if ((**gFlushFetchControls[input]).contrlHilite != hilite)
	{
		TextSize(10);
		HiliteControl(gFlushFetchControls[input], hilite);
		TextSize(9);
	}
	
	(**gFlushFetchControls[input]).contrlRfCon = hilite;

}


#pragma mark  End MainWindow API 

pascal void UpdateMainWindowLoop(SInt16 depth, SInt16 flags, GDHandle device, long refCon)
{
	#pragma unused (refCon)
	
	short		counter;
	Rect		threadRect, tempRect;
	RGBColor	color;
	
	SetAppropriateTextColor(device, depth, flags, gIsMainWindowActive);
	
	MyResTextBox(kMiscStringsID, kInputString, &gInBufferLabelRect, teJustRight);
	MyResTextBox(kMiscStringsID, kOutputString, &gOutBufferLabelRect, teJustRight);
	
	UpdateNumBlocksDisplay(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].inputBuffer, &gInBufferTextRect, true);
	UpdateNumBlocksDisplay(&gBufferClientInfo.buffersInfo[gCurrentBuffersInfo].outputBuffer, &gOutBufferTextRect, false);
	
	if (gBufferClientInfo.lastServerMessage[0] != 0)
	{
		tempRect = gMainWindow->portRect;
		InsetRect(&tempRect, 1, 2);
		tempRect.top = tempRect.bottom - kServerMessageHeight + 3;
		MyTextPtrBox((Ptr) gBufferClientInfo.lastServerMessage, strlen(gBufferClientInfo.lastServerMessage), &tempRect, teCenter);
	}
	
	for (counter = 0; counter < gBufferClientInfo.numThreads; counter++)
	{
		GetThreadRect(counter, &threadRect);
		
		tempRect = gCheckingTextDisplayRect;
		OffsetRect(&tempRect, threadRect.left, threadRect.top);
		MyResTextBox(kMiscStringsID, kCheckingKeyBlockString, &tempRect, teJustLeft);
		
		tempRect = gThreadIDTextRect;
		OffsetRect(&tempRect, threadRect.left, threadRect.top);
		UpdateThreadNumTypeDisplay(counter, &tempRect);
		
		tempRect = gTotalRateTextRect;
		OffsetRect(&tempRect, threadRect.left, threadRect.top);
		UpdateTotalRateDisplay(counter, &tempRect);
		
		if (gHasAppearance == false)
		{
			GetForeColor(&color);
			tempRect = gProgressBarRect;
			tempRect.bottom++;
			OffsetRect(&tempRect, threadRect.left, threadRect.top);
			DrawProgressBar(&tempRect, false, gBufferClientInfo.threadsInfo[counter].progressPercent, 100, depth);
			RGBForeColor(&color);
		}
	}
}


void SetGray(short gray)
{
	RGBColor	rgb;
	rgb.red = gray;	rgb.green = gray;	rgb.blue = gray;
	RGBForeColor(&rgb);
}


void SetAppropriateColor(GDHandle device, short red, short green, short blue, Boolean activated)
{
	RGBColor	rgb, background;
	
	rgb.red = red;
	rgb.green = green;
	rgb.blue = blue;
	
	GetBackColor(&background);
	
	if (activated == false)
		GetGray(device, &background, &rgb);
	
	RGBForeColor(&rgb);
}


void SetAppropriateTextColor(GDHandle device, short depth, SInt16 flags, Boolean activated)
{
	ThemeTextColor	whichTextColor = kThemeActiveDialogTextColor;
	
	if (activated == false)
		whichTextColor = kThemeInactiveDialogTextColor;
	
	if (gHasAppearance)
	{
		SetThemeTextColor(whichTextColor, depth, (flags & gdDevType) != 0);
	}
	else
	{
		SetAppropriateColor(device, 0, 0, 0, activated);
	}
}


short CalcTextBaseLineOffset(RectPtr theRect)
{
	FontInfo	fontInfo;
	
	GetFontInfo(&fontInfo);
	return (theRect->top + fontInfo.ascent + (((theRect->bottom - theRect->top) - (fontInfo.ascent + fontInfo.descent)) / 2));
}


void MyResTextBox(short strID, short strIndex, RectPtr theRect, short justMode)
{
	Str255	string;
	
	GetIndString(string, strID, strIndex);
	MyTextBox(string, theRect, justMode);
}


void MyTextBox(StringPtr theString, RectPtr theRect, short justMode)
{
	MyTextPtrBox((Ptr) &theString[1], theString[0], theRect, justMode);
}


void MyTextPtrBox(Ptr string, short len, RectPtr theRect, short justMode)
{
	short	baseLine;
	short	leftPos;
	
	baseLine = CalcTextBaseLineOffset(theRect);
	switch (justMode)
	{
		case teJustLeft:
		case teForceLeft:
			leftPos = theRect->left;
			break;
		case teJustRight:
			leftPos = theRect->right - TextWidth(string, 0, len);
			break;
		case teJustCenter:
			leftPos = theRect->left + ((theRect->right - theRect->left) - TextWidth(string, 0, len)) / 2;
			break;
	}
	
	MoveTo(leftPos, baseLine);
	DrawText(string, 0, len);
}


void MyDrawThemePlacard(Rect *inRect, ThemeDrawState inState)
{
	if (gHasAppearance101)
	{
		DrawThemeModelessDialogFrame(inRect, inState);
	}
	/*
	else if (gHasAppearance)
	{
		
	}
	*/
	else
	{
#ifdef powerc
		CallPrimitiveDrawProc(inRect, inState, nil, &gDrawThemePlacardLoopUPP);
#else
		CallPrimitiveDrawProc(inRect, inState, nil, (DeviceLoopDrawingUPP)DrawThemePlacardLoop);
#endif
	}
}


void CallPrimitiveDrawProc(RectPtr inRect, ThemeDrawState inState, void *extraData, DeviceLoopDrawingUPP proc)
{
	RgnHandle				theRgn;
	PrimitiveDrawingData	data;
	RGBColor				oldColor;
	GrafPtr					port;
	
	theRgn = NewRgn();
	if (theRgn)
	{
		GetForeColor(&oldColor);
		
		RectRgn(theRgn, inRect);
		GetPort(&port);
		SectRgn(theRgn, port->visRgn, theRgn);
		
		data.inState = inState;
		data.inRect = inRect;
		data.data = extraData;
		
		DeviceLoop(theRgn, proc, (long) &data, 0);
		
		DisposeRgn(theRgn);
		
		RGBForeColor(&oldColor);
	}
}


pascal void DrawThemePlacardLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo)
{
	#pragma unused (device)
	Rect	rect;
	Boolean	isColor = depth > 4 || (depth == 4 && (flags & gdDevType) == 0);
	
	rect = *drawingInfo->inRect;
	if (drawingInfo->inState == kThemeStateActive || isColor == false)
		SetGray(0);
	else
		SetGray(21845);
	FrameRect(&rect);
	
	InsetRect(&rect, 1, 1);
	
	if (drawingInfo->inState == kThemeStateActive && isColor)
	{
		SetGray(65535);
	}
	else
	{
		RGBColor	back;
		GetBackColor(&back);
		RGBForeColor(&back);
	}
	MoveTo(rect.right - 1, rect.top);
	LineTo(rect.left, rect.top);
	LineTo(rect.left, rect.bottom - 1);
	
	if (drawingInfo->inState == kThemeStateActive && isColor)
		SetGray(43690);
	LineTo(rect.right - 1, rect.bottom - 1);
	LineTo(rect.right - 1, rect.top + 1);
}


pascal void DrawThemePrimaryGroupLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo)
{
	Rect				rect, textRect;
	Boolean				isColor = (flags & gdDevType) != 0;
	GroupBoxDataPtr		data;
	RgnHandle			oldClip = nil, newClip;
	
	data = (GroupBoxDataPtr) drawingInfo->data;
	if (data->useText)
	{
		textRect = *drawingInfo->inRect;
		textRect.top -= 3;
		textRect.bottom = textRect.top + 18;
		textRect.left += 9;
		textRect.right = textRect.left + 8 + StringWidth(data->text);
	}
	else
	{
		textRect = (**data->control).contrlRect;
		InsetRect(&textRect, -4, 0);
	}
	
	oldClip = NewRgn();
	if (oldClip)
	{
		newClip = NewRgn();
		if (newClip)
		{
			RectRgn(newClip, &gMainWindow->portRect);
			RectRgn(oldClip, &textRect);
			DiffRgn(newClip, oldClip, newClip);
			SectRgn(newClip, gMainWindow->visRgn, newClip);
			GetClip(oldClip);
			SetClip(newClip);
			DisposeRgn(newClip);
		}
	}
	
	rect = *drawingInfo->inRect;
	rect.top += 9;
	if (depth > 4 || (depth == 4 && isColor == false))
	{
		if (drawingInfo->inState == kThemeStateActive)
			SetGray(65535);
		else
			SetGray(56797);
		
		rect.left++;
		rect.top++;
		FrameRect(&rect);
		
		if (drawingInfo->inState == kThemeStateActive)
			SetGray(34952);
		else
			SetGray(48059);
		
		OffsetRect(&rect, -1, -1);
	}
	else
	{
		SetGray(0);
	}
	
	FrameRect(&rect);
	
	if (oldClip)
	{
		SetClip(oldClip);
		DisposeRgn(oldClip);
	}
	
	if (data->useText)
	{
		//TextFace(bold);
		SetAppropriateTextColor(device, depth, flags, gIsMainWindowActive);
		MyTextBox(data->text, &textRect, teCenter);
		//TextFace(0);
	}
}


pascal void DrawThemeEditTextFrameLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo)
{
	#pragma unused (device)
	
	Rect	rect;
	Boolean	isColor = depth > 4 || (depth == 4 && (flags & gdDevType) == 0);
	
	rect = *drawingInfo->inRect;
	InsetRect(&rect, -1, -1);
	if (drawingInfo->inState == kThemeStateActive || isColor == false)
		SetGray(0);
	else
		SetGray(21845);
	
	FrameRect(&rect);
	
	if (isColor == false)
		PenPat(&qd.white);
	else
	{
		if (drawingInfo->inState == kThemeStateDisabled)
		{
			RGBColor	back;
			GetBackColor(&back);
			RGBForeColor(&back);
		}
		else
		{
			SetGray(34952);
		}
	}
	
	InsetRect(&rect, -1, -1);
	MoveTo(rect.right - 2, rect.top);
	LineTo(rect.left, rect.top);
	LineTo(rect.left, rect.bottom - 2);
	if (isColor && drawingInfo->inState != kThemeStateDisabled)
		SetGray(65535);
	MoveTo(rect.left + 1, rect.bottom - 1);
	LineTo(rect.right - 1, rect.bottom - 1);
	LineTo(rect.right - 1, rect.top + 1);
	
	if (isColor == false)
		PenPat(&qd.black);
}


pascal void DrawBufferProgressLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo)
{
	Rect				rect;
	Boolean				isColor = depth > 4 || (depth == 4 && (flags & gdDevType) == 0);
	short				patID, tempTotal, tempAmountFull;
	PixPatHandle		hPixPat;
	Pattern				pattern;
	BufferProgressPtr	data;
	Handle				resHndl;
	RGBColor			color, background;
	
	data = (BufferProgressPtr) drawingInfo->data;
	
	if (gHasAppearance == false && data->drawInsidesOnly == false)
	{
		InsetRect(drawingInfo->inRect, 1, 1);
		DrawThemeEditTextFrameLoop(depth, flags, device, drawingInfo);
		InsetRect(drawingInfo->inRect, -1, -1);
	}
	
	rect = *drawingInfo->inRect;
	InsetRect(&rect, 1, 1);
	
	if (data->total > 0 && data->amountFull > 0)
	{
		tempTotal = (rect.right - rect.left + (kPixelsToCutOffFromLeft * 2) + 1) / kPixelsForEachValue;
		tempAmountFull = (tempTotal * data->amountFull) / data->total;
		rect.right = rect.left + (tempAmountFull * kPixelsForEachValue) - kPixelsToCutOffFromLeft;
		if (rect.right > drawingInfo->inRect->right - 1)
			rect.right = drawingInfo->inRect->right - 1;
		
		if (isColor)
		{
			patID = kProgressBufferPatID;
			if (gIsMainWindowActive == false)
				patID += kAddForDisabled;
			
			if (gHasAppearance)
			{
				//We won't release this, since GetPixPat should handle it.
				resHndl = GetResource('ppat', patID);
				if (resHndl)
				{
					SetThemePen(kThemeDragHiliteBrush, depth, (flags & gdDevType) != 0);
					GetForeColor(&color);
					if (gIsMainWindowActive == false)
					{
						GetBackColor(&background);
						GetGray(device, &background, &color);
					}
					*((RGBColor*) (*resHndl + GetHandleSize(resHndl) - sizeof(RGBColor))) = color;
				}
			}
			
			hPixPat = GetPixPat(patID);
			if (hPixPat)
			{
				FillCRect(&rect, hPixPat);
				DisposePixPat(hPixPat);
			}
		}
		else
		{
			EraseRect(&rect);
		}
		
		if (rect.right > rect.left)
		{
			rect.left = rect.right;
		}
		rect.right = drawingInfo->inRect->right - 1;
	}
	
	if (isColor)
	{
		patID = kBackgroundBufferPatID;
		if (gIsMainWindowActive == false)
			patID += kAddForDisabled;
		
		hPixPat = GetPixPat(patID);
		if (hPixPat)
		{
			FillCRect(&rect, hPixPat);
			DisposePixPat(hPixPat);
		}
	}
	else
	{
		GetIndPattern(&pattern, 128, 1);
		FillRect(&rect, &pattern);
	}
}


void DrawBufferProgress(RectPtr rect, Boolean drawInsidesOnly, short amountFull, short total)
{
	Rect				tempRect;
	BufferProgressData	data;
	
	if (gHasAppearance && drawInsidesOnly == false)
	{
		tempRect = *rect;
		InsetRect(&tempRect, 1, 1);
		DrawThemeEditTextFrame(&tempRect, gIsMainWindowActive);
	}
	
	data.amountFull = amountFull;
	data.total = total;
	data.drawInsidesOnly = drawInsidesOnly;
	
#ifdef powerc
	CallPrimitiveDrawProc(rect, gIsMainWindowActive, &data, &gBufferProgressLoopUPP);
#else
	CallPrimitiveDrawProc(rect, gIsMainWindowActive, &data, (DeviceLoopDrawingUPP)DrawBufferProgressLoop);
#endif
}


void DrawProgressBar(RectPtr rect, Boolean drawInsidesOnly, short amountFull, short total, short depth)
{
	Rect		tempRect, oldRect;
	RGBColor	rgb;
	short		barWidth;
	
	tempRect = *rect;
	if (drawInsidesOnly == false)
	{
		SetGray(0);
		FrameRect(&tempRect);
	}
	
	InsetRect(&tempRect, 1, 1);
	if (amountFull > 0 && total > 0)
	{
		oldRect = tempRect;
		barWidth = tempRect.right - tempRect.left;
		barWidth = (amountFull * barWidth) / total;
		
		tempRect.right = tempRect.left + barWidth;
		if (tempRect.right > oldRect.right)
			tempRect.right = oldRect.right;
		if (depth >= 4)
			SetGray(17476);
		PaintRect(&tempRect);
		tempRect.left = tempRect.right;
		tempRect.right = oldRect.right;
	}
	
	if (amountFull < total)
	{
		if (depth >= 4)
		{
			rgb.red = 52428;	rgb.green = 52428;	rgb.blue = 65535;
			RGBForeColor(&rgb);
			PaintRect(&tempRect);
		}
		else
		{
			EraseRect(&tempRect);
		}
	}
}
