// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: GUIView.cpp,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:14:40  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *GUIView_cpp(void) {
return "@(#)$Id: GUIView.cpp,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#include "macdefs.h"
#include "apputils.h"
#include "window_info.h"
#include "DrawGUI.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WindowObject.h"

#include "DrawGUI.h"

extern ControlHandle gFlushFetchControls[2];

enum {
	kOutputIndex = 0,
	kInputIndex
};

void do_client_command(char *command);

GUIView::GUIView(void)
{
InitializeMainWindow();
}

GUIView::~GUIView(void)
{
}

// define_pict stores the information defining the pict to display

void GUIView::define_gui(char *initName)
{
strcpy((char *)myName, initName);
}

OSErr GUIView::init_view(WindowPtr initWindow,
						  window_info_rec *the_window_info)
{
Rect newRect, tempRect;
short window_height;
GrafPtr gp;

// copy variable we need
myWindow = initWindow;
myRect = the_window_info->initial_rect;

GetPort(&gp);
SetPort(myWindow);
window_height = SetWindowCorrectSize(&tempRect);
SetPort(gp);
newRect = myWindow->portRect;
newRect.bottom = newRect.top + window_height;
the_window_info->initial_rect = newRect;

return(noErr);
}

Boolean GUIView::do_click(Point where, EventRecord *theEvent)
{
#pragma unused (theEvent)
ControlHandle clickedControl;
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
clickedControl = ClickMainWindow(where);
SetPort(gp);

if (clickedControl == gFlushFetchControls[kInputIndex]) {
    do_client_command("-fetch");
	}
else if (clickedControl == gFlushFetchControls[kOutputIndex]) {
    do_client_command("-flush");
	}

return(true);
}

void GUIView::activate()
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
ActivateMainWindow(true);
SetPort(gp);
draw_gui();
}

void GUIView::deactivate()
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
ActivateMainWindow(false);
SetPort(gp);
draw_gui();
}

// drawing routines

// update offsets after scrolling
void GUIView::update_contents(long h_Offset, long v_Offset)
{
h_scrollOffset = h_Offset;
v_scrollOffset = v_Offset;
}

// draw contents
void GUIView::draw_contents(RgnHandle updateRegion)
{
#pragma unused (updateRegion)

draw_gui();
}

void GUIView::draw_gui(void)
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
UpdateMainWindow();
BeginUpdate(myWindow);	// clear any update region 
EndUpdate(myWindow);
SetPort(gp);
}

void GUIView::draw_window_update(void)
{
GrafPtr gp;

if (!EmptyRgn(((WindowPeek)myWindow)->updateRgn)) {
	GetPort(&gp);
	SetPort(myWindow);
	BeginUpdate(myWindow);
	UpdateMainWindow();
	EndUpdate(myWindow);
	SetPort(gp);
	}
}

OSErr GUIView::create_controls(WindowPtr myWindow)
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
DefineMainWindow(myWindow);
SetPort(gp);
return(noErr);
}

void GUIView::update_fetch_control(BufferInfoPtr newBufferInfo)
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
SetFlushFetchControlsHilite(newBufferInfo, true);
SetPort(gp);
}

void GUIView::set_buffers_contest(short contest)
{
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);
SetCurrentBuffersContest(contest);
SetPort(gp);
}
