// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: GUIWindow.cpp,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:15:03  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *GUIWindow_cpp(void) {
return "@(#)$Id: GUIWindow.cpp,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#include "macdefs.h"
#include "resdefs.h"
#include "window_info.h"
#include "apputils.h"
#include "DrawGUI.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "GUIWindow.h"

OSErr GUIWindow::init_ViewWindow(void *objectPtr)
{
OSErr rc;
window_info_rec window_info;
short window_count;
GUIView *myGUIView;

rc = WindowObject::init_ViewWindow(objectPtr);
if (rc != noErr) {
	return(rc);
	}

// allocate new view object
try {
	myGUIView = new GUIView;
	}
catch (...) {
	return(memFullErr);
	}
view_list[0] = myGUIView;
myGUIView->define_gui(init_window_name);

// fill-in info init_window needs
window_count = (((AppObject *)myApp)->window_list)->CountPointers();
strcpy(window_info.window_name, (char *)view_list[0]->myName);
if (have_initial_window_rect) {
	window_info.initial_rect = initial_window_rect;
	window_info.keep_initial_rect = true;
	}
else {
	window_info.initial_rect = ((AppObject *)myApp)->classicRect;
	window_info.keep_initial_rect = false;
	}
if (have_initial_window_visible) {
	window_info.hide_window = !initial_window_visible;
	}
else {
	window_info.hide_window = false;
	}
window_info.size_rect = ((AppObject *)myApp)->sizeRect;
window_info.drag_rect = ((AppObject *)myApp)->dragRect;
window_info.color_window = ((AppObject *)myApp)->colormac;
window_info.offset_window = true;
window_info.offsets.h = -24 + 8*window_count;
window_info.offsets.v = window_info.offsets.h;
window_info.center_denominator = ((AppObject *)myApp)->center_denominator;
window_info.procID = noGrowDocProc;
window_info.grow_window = false;
window_info.TEVersion = ((AppObject *)myApp)->TEVersion;
window_info.drag_mgr_avail = ((AppObject *)myApp)->drag_mgr_avail;

// initialize our window
view_count = 1;
do_h_scroll_list[0] = false;
do_v_scroll_list[0] = false;
update_content_rects(&window_info.initial_rect);

rc = init_window(&window_info);
if (rc != noErr) {
	delete view_list[0];
	view_list[0] = 0;
	view_count = 0;
	return(rc);
	}

// prevent zooming past picture size
set_initial_zoom(myWindow);

return(noErr);
}

OSErr GUIWindow::create_controls(void)
{
return (((GUIView *)(view_list[0]))->create_controls(myWindow));
}

Boolean GUIWindow::do_click(Point where, EventRecord *theEvent)
{
Boolean view_changed;

view_changed = view_list[0]->do_click(where, theEvent);
if (view_changed) {
	handle_view_changed(0);
	}
return(true);
}

WindowPtr GUIWindow::create_window(WindowPeek wp, Rect *initial_rect,
								   StringPtr window_name, short procID)
{
#pragma unused(procID)

WindowPtr theWindow;

theWindow = GetNewCWindow(128, wp, (WindowPtr) -1);
if (theWindow != 0) {
	SetWTitle(theWindow, window_name);
	SizeWindow(theWindow, initial_rect->right - initial_rect->left,
						  initial_rect->bottom - initial_rect->top, true);
	MoveWindow(theWindow, initial_rect->left, initial_rect->top, false);
	}

return(theWindow);
}

// draw_window is called between BeginUpdate and EndUpdate to
// respond to an update event for the window.  
void GUIWindow::draw_window(void)
{
((GUIView *)(view_list[0]))->draw_gui();
}

void GUIWindow::draw_window_update(void)
{
((GUIView *)(view_list[0]))->draw_window_update();
}

void GUIWindow::update_fetch_control(BufferInfoPtr newBufferInfo)
{
((GUIView *)(view_list[0]))->update_fetch_control(newBufferInfo);
}

void GUIWindow::set_buffers_contest(short contest)
{
((GUIView *)(view_list[0]))->set_buffers_contest(contest);
}
