// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: ViewObject.cpp,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:17:35  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *ViewObject_cpp(void) {
return "@(#)$Id: ViewObject.cpp,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#include "macdefs.h"
#include "apputils.h"
#include "window_info.h"

#include "ViewObject.h"

ViewObject::ViewObject(void)
{
myRect.top = myRect.bottom =
	myRect.left = myRect.right = 0;
strcpy((char *)myName, "");
TEActive = waitcursor = ibeamcursor = false;
myEditRec = 0;
h_scrollOffset = v_scrollOffset = 0;
h_offset = v_offset = 0;				// no margins
h_scrollsize = v_scrollsize = 12;		// use 12 units for continuous scrolling
h_unitsize = v_unitsize = 1;			// scroll units are pixels
useUpdateProc = useScrollProc = false;	// not used by default
}

ViewObject::~ViewObject(void)
{
}

OSErr ViewObject::init_view(WindowPtr initWindow,
							window_info_rec *the_window_info)
{
myWindow = initWindow;
myRect = the_window_info->initial_rect;
return(noErr);
}


void ViewObject::adjust_view_rect(Rect *new_content_rect,
								  long new_h_scroll_offset,
								  long new_v_scroll_offset,
								  Boolean init_call,
								  Boolean new_style_call)
{
#pragma unused (init_call, new_style_call)
myRect = *new_content_rect;
h_scrollOffset = new_h_scroll_offset;
v_scrollOffset = new_v_scroll_offset;
}

void ViewObject::get_view_size(long *height, long *width)
{
*height = myRect.bottom - myRect.top;
*width = myRect.right - myRect.left;
}

// this is used when the view's contents change with the size
// otherwise, should do nothing to avoid flickering
void ViewObject::draw_for_new_view_size(void)
{
}

void ViewObject::get_minimum_size(short *height, short *width)
{
*height = v_scrollsize * v_unitsize;
*width = h_scrollsize * h_unitsize;
}

void ViewObject::set_cursor_state(Boolean *app_TEActive,
								  Boolean *app_waitcursor,
								  Boolean *app_ibeamcursor)
{
*app_TEActive = TEActive;
*app_waitcursor = waitcursor;
*app_ibeamcursor = ibeamcursor;
}

Boolean ViewObject::mouse_in_text(Point mouseloc)
{
#pragma unused (mouseloc)
return(false);
}

Boolean ViewObject::do_click(Point where, EventRecord *theEvent)
{
#pragma unused (where, theEvent)
return(false);
}

void ViewObject::activate()
{
if (TEActive) {
	import_scrap();		
	TEActivate(myEditRec);
	}
}

void ViewObject::deactivate()
{
if (TEActive) {
	export_scrap();
	TEDeactivate(myEditRec);
	}
}

Boolean ViewObject::do_key_down(EventRecord *theEvent)
{
#pragma unused (theEvent)
SysBeep(1);
return(false);
}

OSErr ViewObject::TrackDrag(DragTrackingMessage theMessage,
							DragReference theDrag)
{
#pragma unused (theMessage, theDrag)
return(noErr);
}

OSErr ViewObject::ReceiveDrag(DragReference theDrag,
							  Boolean *view_changed)
{
#pragma unused (theDrag)
*view_changed = false;
return(dragNotAcceptedErr);
}

void ViewObject::get_new_scroll_offsets(long *new_h_offset,
										long *new_v_offset)
{
*new_h_offset = h_scrollOffset;
*new_v_offset = v_scrollOffset;
}

TEHandle ViewObject::get_TEEditRec(void)
{
return(myEditRec);
}

void ViewObject::define_new_font(short font_number)
{
#pragma unused(font_number)
}

void ViewObject::define_new_pointsize(short font_size)
{
#pragma unused(font_size)
}

void ViewObject::define_new_style(Style new_style)
{
#pragma unused(new_style)
}

Boolean ViewObject::do_TEFunction(short theFunction)
{
#pragma unused (theFunction)
return(false);
}

void ViewObject::get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
								Boolean *paste_ok, Boolean *clear_ok)
{
*cut_ok = *copy_ok = *paste_ok = *clear_ok = false;
}

// scrap methods
// These are used by views which maintain private scraps, like TextEdit.

void ViewObject::import_scrap(void)
{
}

void ViewObject::export_scrap(void)
{
}

void ViewObject::get_undo_status(Boolean *undo_ok, char *undo_text)
{
*undo_ok = false;
strcpy(undo_text, "Undo");
}

// drawing routines

void ViewObject::draw_contents(RgnHandle updateRegion)
{
#pragma unused (updateRegion)
FillRect(&myRect, &qd.gray);
}

void ViewObject::update_contents(long h_Offset, long v_Offset)
{
#pragma unused (h_Offset, v_Offset)
}

void ViewObject::scroll_contents(long dh, long dv)
{
#pragma unused (dh, dv)
}

void ViewObject::set_input_proc(InputProcPtr the_proc)
{
#pragma unused (the_proc)
}

void ViewObject::set_newline_proc(NewlineProcPtr the_proc)
{
#pragma unused (the_proc)
}
