// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: ViewObject.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:17:52  dicamillo
// First Checked In.
//

class ViewObject
{
public:
Rect myRect;					// rect containing entire view
								// (not used by some view types)
unsigned char myName[256];		// name (for window title, etc.)
WindowPtr myWindow;				// window the view belongs to
TEHandle myEditRec;				// TEHandle for views that need it
Boolean TEActive;				// true if view has active TERecord
Boolean waitcursor;				// true for watch cursor
Boolean ibeamcursor;			// true for ibeam cursor
Boolean useUpdateProc;			// true if update proc should be used
Boolean useScrollProc;			// true if scroll proc should be used
long  h_scrollOffset;			// unit offsets for scrolling
long  v_scrollOffset;
short h_offset;					// drawing offset from left of window
short v_offset;					// drawing offset from top of window
short h_scrollsize;				// units to scroll horizontally
short v_scrollsize;				// units to scroll vertically
short h_unitsize;				// size in pixels of one horizontal unit
short v_unitsize;				// size in pixels of one vertical unit
short extra_lines;				// count of lines to leave at bottom of view

ViewObject(void);
virtual ~ViewObject(void);
virtual OSErr init_view(WindowPtr initWindow,
						window_info_rec *the_window_info);
virtual void adjust_view_rect(Rect *new_content_rect,
							  long new_h_scroll_offset,
							  long new_v_scroll_offset,
							  Boolean init_call,
							  Boolean new_style_call);
virtual void draw_for_new_view_size(void);
virtual void get_view_size(long *height, long *width);
virtual void get_minimum_size(short *height, short *width);
virtual void set_cursor_state(Boolean *app_TEActive,
							  Boolean *app_waitcursor,
							  Boolean *app_ibeamcursor);
virtual Boolean mouse_in_text(Point mouseloc);
virtual Boolean do_click(Point where, EventRecord *theEvent);
virtual void activate();
virtual void deactivate();
virtual Boolean do_key_down(EventRecord *theEvent);
virtual OSErr TrackDrag(DragTrackingMessage theMessage,
						DragReference theDrag);
virtual OSErr ReceiveDrag(DragReference theDrag, Boolean *view_changed);
virtual void get_new_scroll_offsets(long *new_h_offset, long *new_v_offset);
virtual TEHandle get_TEEditRec(void);
virtual void define_new_font(short font_number);
virtual void define_new_pointsize(short font_size);
virtual void define_new_style(Style new_style);
virtual Boolean do_TEFunction(short theFunction);
virtual void get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
							Boolean *paste_ok, Boolean *clear_ok);
virtual void import_scrap(void);
virtual void export_scrap(void);
virtual void get_undo_status(Boolean *undo_ok, char *undo_text);
virtual void draw_contents(RgnHandle updateRegion);
virtual void update_contents(long h_Offset, long v_Offset);
virtual void scroll_contents(long dh, long dv);
virtual void set_input_proc(InputProcPtr the_proc);
virtual void set_newline_proc(NewlineProcPtr the_proc);
};
