// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: WTextDisplayWindow.cpp,v $
// Revision 1.3  1999/01/17 18:33:40  sampo
// 3rd round fba changes
//
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:18:48  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *WTextDisplayWindow_cpp(void) {
return "@(#)$Id: WTextDisplayWindow.cpp,v 1.3 1999/01/17 18:33:40 sampo Exp $"; }
#endif

#include "macdefs.h"
#include "resdefs.h"
#include "window_info.h"
#include "apputils.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "TextView.h"
#include "WTextView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "WTextDisplayWindow.h"

WTextDisplayWindow::WTextDisplayWindow(void)
{
log_fref = 0;
strcpy(init_window_name, "Text Display Window");
strcpy(init_font_name, "Monaco");
init_font_size = 9;
init_font_style = 0;
}

WTextDisplayWindow::~WTextDisplayWindow(void)
{
end_log();
}


OSErr WTextDisplayWindow::init_ViewWindow(void *objectPtr)
{
OSErr rc;
window_info_rec window_info;
short window_count;
WTextView *myWTextView;
short fnum;

rc = WindowObject::init_ViewWindow(objectPtr);
if (rc != noErr) {
	return(rc);
	}

// allocate new view object
try {
	myWTextView = new WTextView;
	}
catch (...) {
	return(memFullErr);
	}
view_list[0] = myWTextView;

// define text
c2pstr(init_font_name);
GetFNum((unsigned char *)init_font_name, &fnum);
p2cstr((unsigned char *)init_font_name);
myWTextView->define_text(init_window_name, 0, fnum, init_font_size,
						init_font_style, true, true);
#ifdef MAC_GUI
// init. font style menus
font_item = font_name_to_item(((AppObject *)myApp)->myMenus[3],
							  init_font_name);
size_item = font_size_to_item(((AppObject *)myApp)->myMenus[4], init_font_size);
if (init_font_style == 0) {
	style_bits = 1; // plain text
	}
else {
	style_bits = init_font_style << 1;
	}
#endif

// fill-in info init_window needs
window_count = (((AppObject *)myApp)->window_list)->CountPointers();
strcpy(window_info.window_name, (char *)view_list[0]->myName);
if (have_initial_window_rect) {
	window_info.initial_rect = initial_window_rect;
	window_info.keep_initial_rect = true;
	}
else {
	window_info.initial_rect = ((AppObject *)myApp)->classicRect;
	window_info.keep_initial_rect = false;
	}
if (have_initial_window_visible) {
	window_info.hide_window = !initial_window_visible;
	}
else {
	window_info.hide_window = false;
	}
window_info.size_rect = ((AppObject *)myApp)->sizeRect;
window_info.drag_rect = ((AppObject *)myApp)->dragRect;
window_info.color_window = ((AppObject *)myApp)->colormac;
window_info.offset_window = true;
window_info.offsets.h = -24 + 8*window_count;
window_info.offsets.v = window_info.offsets.h;
window_info.center_denominator = ((AppObject *)myApp)->center_denominator;
window_info.procID = zoomDocProc;
window_info.grow_window = true;
window_info.TEVersion = ((AppObject *)myApp)->TEVersion;
window_info.drag_mgr_avail = ((AppObject *)myApp)->drag_mgr_avail;

#ifdef MAC_GUI
// initialize our window
view_count = 1;
do_h_scroll_list[0] = true;
do_v_scroll_list[0] = true;
update_content_rects(&window_info.initial_rect);

rc = init_window(&window_info);
if (rc != noErr) {
	delete view_list[0];
	view_list[0] = 0;
	view_count = 0;
	return(rc);
	}
#endif

// update app vars for new text window
restore_cursor_state(&(((AppObject *)myApp)->TEActive),
					 &waitcursor,
					 &ibeamcursor);

return(noErr);
}

OSErr WTextDisplayWindow::do_init_view(window_info_rec *the_window_info,
									   ViewObject *theView)
{
OSErr rc;
Rect initial_rect;

initial_rect = the_window_info->initial_rect;
rc = theView->init_view(myWindow, the_window_info);
the_window_info->initial_rect = initial_rect;
return(rc);
}

void WTextDisplayWindow::append_text(char *new_text, short new_text_length)
{
long writecount;
OSErr rc;
short i;

((WTextView *)view_list[0])->append_text(new_text, new_text_length);
//InvalRect(&content_list[0]);
handle_view_changed(0);

if (log_fref != 0) {
	for (i = 0; i < new_text_length; i++) {
		if (new_text[i] == '\n') new_text[i] = '\r';
		}
	if (new_text_length > 0) {
		writecount = new_text_length;
		rc = FSWrite(log_fref, &writecount, new_text);
		if (rc != noErr) {
			if (rc == fnOpnErr) {	// happens after attempt to write log from another program
				rc = begin_log(NULL, false);
				if (log_fref != 0) {
					writecount = new_text_length;
					rc = FSWrite(log_fref, &writecount, new_text);					
					}			
				}
			if (rc != noErr) {
				printf("***** FSWrite error %d writing log file *****\r", rc);
				FSClose(log_fref);
				log_fref = 0;
				}
			}
		}
	}

}

void WTextDisplayWindow::modify_text(long delete_start, long delete_end,
									 char *new_text, short new_text_length)
{
((WTextView *)view_list[0])->
	modify_text(delete_start, delete_end, new_text, new_text_length);
InvalRect(&content_list[0]);
handle_view_changed(0);
}

void WTextDisplayWindow::delete_text(short delete_start, short delete_end)
{
((WTextView *)view_list[0])->modify_text(delete_start, delete_end, 0, 0);
//InvalRect(&content_list[0]);
handle_view_changed(0);
}

Handle WTextDisplayWindow::get_text(void)
{
return(((WTextView *)view_list[0])->get_text());
}

long WTextDisplayWindow::get_text_size(void)
{
return(((WTextView *)view_list[0])->get_text_size());
}

OSErr WTextDisplayWindow::begin_log(StringPtr logname, Boolean new_session)
{
HParamBlockRec hpb;
OSErr rc;
char separator[128];
long writecount;
unsigned long date_secs;
short date_length;
char timestamp[256];

// save name
if (logname != NULL) {		// NULL to use name from previous call
	logfile_name[0] = logname[0];
	memcpy(logfile_name + 1, logname + 1, logname[0]);
	}

// attempt to open existing log file
memset(&hpb, 0, sizeof(HParamBlockRec));
hpb.ioParam.ioNamePtr = logfile_name;
hpb.ioParam.ioPermssn = fsRdWrPerm;
rc = PBHOpenSync(&hpb);
if (rc == noErr) {
	log_fref = hpb.ioParam.ioRefNum;
	// Set file position to end-of-file
	rc = SetFPos(log_fref, fsFromLEOF, 0);
	if (rc != noErr) {
		FSClose(log_fref);
		log_fref = 0;
		return(rc);
		}
	// write separator to log
	if (new_session) {
		// Get the date and time
		GetDateTime(&date_secs);
		IUDateString(date_secs, shortDate, (StringPtr)timestamp);
		p2cstr((StringPtr)timestamp);
		strcat(timestamp, " ");
		date_length = strlen(timestamp);
		IUTimeString(date_secs, true, (StringPtr)(timestamp+date_length));
		p2cstr((StringPtr)(timestamp+date_length));

		sprintf(separator, "\r-----> New Session: %s <-----\r\r", timestamp);
		writecount = strlen(separator);
		FSWrite(log_fref, &writecount, separator);
		}
	// Don't bother checking for errors- if there is
	// a problem, it will be reported for the first line of
	// the new session.
	}
else {
	// Open failed, try to create a new file
	memset(&hpb, 0, sizeof(HParamBlockRec));
	hpb.ioParam.ioNamePtr = logfile_name;
	rc = PBHCreateSync(&hpb);	
	if (rc != noErr) {
		return(rc);
		}
	// Set creator and type of the new file
	memset(&hpb, 0, sizeof(HParamBlockRec));
	hpb.ioParam.ioNamePtr = logfile_name;
	rc = PBHGetFInfoSync(&hpb);
	if (rc != noErr) {
		return(rc);
		}	
	hpb.ioParam.ioNamePtr = logfile_name;
	hpb.ioParam.ioVRefNum = 0;
	hpb.fileParam.ioDirID = 0;
	hpb.fileParam.ioFlFndrInfo.fdType = 'TEXT';
	hpb.fileParam.ioFlFndrInfo.fdCreator = LOG_FILE_CREATOR;
	rc = PBHSetFInfoSync(&hpb);
	if (rc != noErr) {
		return(rc);
		}
	// Open the newly-created file
	memset(&hpb, 0, sizeof(HParamBlockRec));
	hpb.ioParam.ioNamePtr = logfile_name;
	hpb.ioParam.ioPermssn = fsRdWrPerm;
	rc = PBHOpenSync(&hpb);
	if (rc == noErr) {
		log_fref = hpb.ioParam.ioRefNum;
		}
	else {
		return(rc);
		}
	}
return(noErr);
}

void WTextDisplayWindow::end_log(void)
{
if (log_fref != 0) {
	FSClose(log_fref);
	log_fref = 0;
	}
}

Boolean WTextDisplayWindow::active_log(void)
{
return(log_fref != 0);
}

void WTextDisplayWindow::disable_int_cutpaste(void)
{
((WTextView *)view_list[0])->disable_int_cutpaste();
}

void WTextDisplayWindow::enable_int_cutpaste(void)
{
((WTextView *)view_list[0])->enable_int_cutpaste();
}

