// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: WTextView.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:19:11  dicamillo
// First Checked In.
//

class WTextView : public ViewObject
{
public:
WEHandle myWEditRec;		// Handle to WASTE edit record
Handle text_handle;
RgnHandle text_region;
RgnHandle my_region;
RgnHandle my_updateRgn;
Rect old_view_rect;
long view_height;
Boolean drag_mgr_avail;		// Drag Manager present
LongRect saved_dest;		// Saved view info for check_view_changed
long saved_lines;
static RoutineDescriptor Wtext_clickProcRD; 
short font_number;
short font_size;
Style font_style;
short line_height;
short font_ascent;
InputProcPtr input_proc;
Boolean initial_activate;
Boolean read_only;

WTextView(void);
 ~WTextView(void);
 void define_text(char *textName, Handle textHandle,
		short fnum, short fsize, Style fstyle, Boolean activate,
		Boolean readonly);
 void define_line_height(void);
 OSErr init_view(WindowPtr initWindow,
						window_info_rec *the_window_info);
 void adjust_view_rect(Rect *new_content_rect,
							  long new_h_scroll_offset,
							  long new_v_scroll_offset,
							  Boolean init_call,
							  Boolean new_style_call);
 void get_view_size(long *height, long *width);
 void set_cursor_state(Boolean *app_TEActive,
							  Boolean *app_waitcursor,
							  Boolean *app_ibeamcursor);
 Boolean mouse_in_text(Point mouseloc);
 void activate(void);
 void deactivate(void);
 Boolean do_click(Point where, EventRecord *theEvent);
 Boolean do_key_down(EventRecord *theEvent);
 void set_input_proc(InputProcPtr the_proc);
 void process_input_line(void);
 OSErr TrackDrag(DragTrackingMessage theMessage,
						DragReference theDrag);
 OSErr ReceiveDrag(DragReference theDrag, Boolean *view_changed);
 void get_new_scroll_offsets(long *new_h_offset,
									long *new_v_offset);
 TEHandle get_TEEditRec(void);
 void define_new_font(short app_font_number);
 void define_new_pointsize(short app_font_size);
 void define_new_style(Style app_font_style);
 void show_new_style(void);
 Boolean do_TEFunction(short theFunction);
 void get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
							Boolean *paste_ok, Boolean *clear_ok);
 void get_undo_status(Boolean *undo_ok, char *undo_text);
 void draw_contents(RgnHandle updateRegion);
 void update_contents(long h_Offset, long v_Offset);
 void scroll_contents(long dh, long dv);
 void save_view_info(void);
 Boolean check_view_changed(void);
 void append_text(char *new_text, short new_text_length);
 void modify_text(long delete_start, long delete_end,
						 char *new_text, short new_text_length);
 Handle get_text(void);
 long get_text_size(void);
 void disable_int_cutpaste(void);
 void enable_int_cutpaste(void);
static pascal Boolean Wtext_clickProc(WEHandle theWEditRec);
};
