// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: WindowObject.cpp,v $
// Revision 1.3  1999/01/17 18:33:25  sampo
// 3rd round fba changes
//
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:18:22  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *WindowObject_cpp(void) {
return "@(#)$Id: WindowObject.cpp,v 1.3 1999/01/17 18:33:25 sampo Exp $"; }
#endif

#include "macdefs.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "WindowObject.h"
#include "AppObject.h"

// static drawing data
WindowObject *WindowObject::current_WindowObject;
RoutineDescriptor WindowObject::my_scrollProcRD =
	BUILD_ROUTINE_DESCRIPTOR(uppControlActionProcInfo, my_scrollProc);

WindowObject::WindowObject(void)
{
short i;

view_count = 0;
for (i=0; i < MAX_VIEWS; i++) {
	view_list[i] = 0;
	scroll_list[i].drawRgn = 0;
	}
myWindow = 0;
workRgn = workRgn2 = workRgn3 = 0;
font_item = 0;
size_item = 0;
style_bits = 0;
TE_view = Drag_view = 0;
last_copy_idx = 0;
control_list = 0;

strcpy(init_window_name, "The Window");
have_initial_window_rect = false;
have_initial_window_visible = false;
strcpy(init_font_name, "Geneva");
init_font_size = 9;
init_font_style = 0;

controls_activated = true;
}

WindowObject::~WindowObject(void)
{
short i;

if (view_count > 0) {
	for (i=0; i < view_count; i++) {
		if (view_list[i] != 0) {
			delete view_list[i];
			}
		if (scroll_list[i].drawRgn != 0) {
			DisposeRgn(scroll_list[i].drawRgn);
			}
		}
	}
view_count = 0;
if (myWindow != 0) {
	CloseWindow(myWindow);
	myWindow = 0;
	}
if (backgroundRgn != 0) {
	DisposeRgn(backgroundRgn);
	workRgn = 0;
	}
if (workRgn != 0) {
	DisposeRgn(workRgn);
	workRgn = 0;
	}
if (workRgn2 != 0) {
	DisposeRgn(workRgn2);
	workRgn2 = 0;
	}
if (workRgn3 != 0) {
	DisposeRgn(workRgn3);
	workRgn3 = 0;
	}
delete_my_control_recs();
}

// This method is used to initialize specific types of window
// sub-classed from us.
// init_ViewWindow for a particular window type must create
// views, and define view_list, view_count, content_list,
// do_h_scroll_list, and do_v_scroll_list.
// NOTE: Rects in content_list do not include scroll bars
OSErr WindowObject::init_ViewWindow(void *theAppObject)
{
myApp = theAppObject;
return(noErr);
}

void WindowObject::set_initial_window_name(char *name)
{
short len;

len = strlen(name);
if (len > 255) len = 255;
memcpy(init_window_name, name, len);
init_window_name[len] = 0;
}

void WindowObject::set_initial_window_rect(Rect *r)
{
initial_window_rect = *r;
have_initial_window_rect = true;
}

void WindowObject::set_initial_window_visible(Boolean visible)
{
initial_window_visible = visible;
have_initial_window_visible = true;
}

void WindowObject::set_initial_font_info(char *name,
	short size, Style style)
{
strcpy(init_font_name, name);
init_font_size = size;
init_font_style = style;
}

// This method updates content_list when the window size has
// changed.  
void WindowObject::update_content_rects(Rect *portRect)
{
// default for one view filling window
content_list[0] = *portRect;
if (grow_window) {
	content_list[0].bottom -= 15;
	content_list[0].right -= 15;
	}
}

OSErr WindowObject::init_window(window_info_rec *the_window_info)
{
Rect control_rect;
OSErr rc;
short old_height, new_height, old_width, new_width;
short i;

// define our window info
strcpy(window_name, the_window_info->window_name);
dragRect = the_window_info->drag_rect;
sizeRect = the_window_info->size_rect;
color_window = the_window_info->color_window;
grow_window = the_window_info->grow_window;

// check we have some views (required)
if (view_count <= 0) {
	return(1);
	}

// allocate regions
for (i=0; i < view_count; i++) {
	scroll_list[i].drawRgn = NewRgn();
	if (scroll_list[i].drawRgn == 0) {
		return(memFullErr);
		}
	}

workRgn = NewRgn();
if (workRgn == 0) {
	return(memFullErr);
	}
workRgn2 = NewRgn();
if (workRgn2 == 0) {
	return(memFullErr);
	}
workRgn3 = NewRgn();
if (workRgn3 == 0) {
	return(memFullErr);
	}
backgroundRgn = NewRgn();
if (backgroundRgn == 0) {
	return(memFullErr);
	}

// create the screen window
c2pstr(window_name);
myWindow = create_window(&myWindowRecord, &(the_window_info->initial_rect),
						 (StringPtr)window_name, the_window_info->procID);
p2cstr((StringPtr)window_name);

// check for errors
if (myWindow == 0) {
	return(memFullErr);
	}

// save object pointer in window
((WindowPeek)myWindow)->refCon = (long)this;

// initialization to use the new window
SetPort(myWindow);
TextFont(0);		// make system font the default

// Now that window exists, add any controls seprate from views
rc = create_controls();
if (rc != noErr) {
	return(rc);
	}

// Give views a chance to do window-dependent initialization.
// The first view is special, because it is allowed to specify
// a new size for the window.
the_window_info->initial_rect = content_list[0];
old_height = the_window_info->initial_rect.bottom
				- the_window_info->initial_rect.top;
old_width = the_window_info->initial_rect.right
				- the_window_info->initial_rect.left;
rc = do_init_view(the_window_info, view_list[0]);
if (rc != noErr) {
	return(rc);
	}

// resize window if view changed initial_rect
new_height = the_window_info->initial_rect.bottom
				- the_window_info->initial_rect.top;
if (new_height < the_window_info->size_rect.top) {
	new_height = the_window_info->size_rect.top;
	}
if (new_height > the_window_info->size_rect.bottom) {
	new_height = the_window_info->size_rect.bottom;
	}

new_width = the_window_info->initial_rect.right
				- the_window_info->initial_rect.left;
if (new_width < the_window_info->size_rect.left) {
	new_width = the_window_info->size_rect.left;
	}
if (new_width > the_window_info->size_rect.right) {
	new_width = the_window_info->size_rect.right;
	}

if ((old_height != new_height) || (old_width != new_width)) {
	SizeWindow(myWindow, new_width, new_height, true);
	}

// re-compute content rects
update_content_rects(&(myWindow->portRect));
adjust_view_rect(0);

// initialize remaining views
if (view_count > 1) {
	for (i = 1; i < view_count; i++) {
		the_window_info->initial_rect = content_list[i];
		rc = do_init_view(the_window_info, view_list[i]);
		if (rc != noErr) {
			return(rc);
			}
		}
	}

// initialize scrolling
// (prevents update_window_rects from also updating scroll bars)
for (i = 0; i < view_count; i++) {
	scroll_list[i].h_Handle = scroll_list[i].v_Handle = 0;
	scroll_list[i].h_Offset = scroll_list[i].v_Offset = 0;
	}

// define rectangles for update management
update_window_rects(true);

// center window
if (!the_window_info->keep_initial_rect) {
	if (the_window_info->offset_window) {
		ctrwindow(myWindow, the_window_info->center_denominator, 20,
			 	 the_window_info->offsets.h, the_window_info->offsets.v);
		}
	else {
		ctrwindow(myWindow, the_window_info->center_denominator, 20, 0, 0);
		}
	}

if (!the_window_info->hide_window) {
	ShowWindow(myWindow);
	}

// add scroll bars as requested
for (i = 0; i < view_count; i++) {
	if (do_h_scroll_list[i]) {
		control_rect = scroll_list[i].h_Rect;
		control_rect.top -= 1;
		control_rect.bottom += 1;		// control needs 16 pixels
		control_rect.left -= 1;
		control_rect.right += 1;
		scroll_list[i].h_Handle = NewControl(myWindow, &control_rect, "\p",
											 false, 0, 0, 0, scrollBarProc, i+1);
		if (scroll_list[i].h_Handle == 0) {
			return(memFullErr);
			}
		}

	if (do_v_scroll_list[i]) {
		control_rect = scroll_list[i].v_Rect;
		control_rect.left -= 1;
		control_rect.right += 1;		// control needs 16 pixels
		control_rect.top -= 1;
		control_rect.bottom += 1;
		scroll_list[i].v_Handle = NewControl(myWindow, &control_rect, "\p",
											 false, 0, 0, 0, scrollBarProc, i+1);
		if (scroll_list[i].v_Handle == 0) {
			return(memFullErr);
			}
		}

	adjust_scroll_bars(true, i);
	}

// show the scroll bars
for (i = 0; i < view_count; i++) {
	if (scroll_list[i].h_Handle != 0) {
		if (!the_window_info->hide_window) {
			ShowControl(scroll_list[i].h_Handle);
			}
		}
	if (scroll_list[i].v_Handle != 0) {
		if (!the_window_info->hide_window) {
			ShowControl(scroll_list[i].v_Handle);
			}
		}
	}

return(noErr);
}

WindowPtr WindowObject::create_window(WindowPeek wp, Rect *initial_rect,
									  StringPtr window_name, short procID)
{
if (color_window) {
	return(NewCWindow(wp, initial_rect, window_name, false,
					  procID, (WindowPtr)-1L, true, 0L));
	}
else {
	return(NewWindow(wp, initial_rect, window_name, false,
					 procID, (WindowPtr)-1L, true, 0L));
	}
}

OSErr WindowObject::do_init_view(window_info_rec *the_window_info,
								 ViewObject *theView)
{
return(theView->init_view(myWindow, the_window_info));
}

// Windows use create_controls to add controls not in any views
// Typically, create_controls will call add_control for each control
OSErr WindowObject::create_controls(void)
{
return(noErr);
}

OSErr WindowObject::add_control(ControlHandle theHandle, long reference,
								short hilite_value, control_info **info_ptr)
{
control_info *cptr;
OSErr rc;

// create control list if we don't have one yet
if (control_list == 0) {
	try {
		control_list = new PointerList;
		}
	catch (...) {
		return(memFullErr);
		}
	}

// allocate new control_info structure
cptr = (control_info *)NewPtr(sizeof(control_info));
if (cptr == 0) {
	return(memFullErr);
	}

// fill-in new structure
cptr->handle = theHandle;
cptr->reference = reference;
cptr->hilite_value = hilite_value;

// add new structure to list
rc = control_list->AddPointer(cptr);
if (rc != noErr) {
	DisposePtr((Ptr)cptr);
	return(rc);
	}

// return info pointer if wanted
if (info_ptr != 0) {
	*info_ptr = cptr;
	}

return(noErr);
}

void WindowObject::delete_my_control_recs(void)
{
control_info *cptr;

if (control_list == 0) {
	return;
	}

cptr = (control_info *)(control_list->GetFirstPointer());
while (cptr != 0) {
	DisposePtr((Ptr)cptr);
	cptr = (control_info *)(control_list->GetNextPointer());
	}
delete control_list;
}

void WindowObject::do_added_control_click(control_info *cptr, Point where)
{
#pragma unused(cptr, where)
}

Boolean WindowObject::mouse_in_text(Point mouseloc)
{
short i;

for (i = 0; i < view_count; i++) {
	if (PtInRect(mouseloc, &content_list[i])) {
		return(view_list[i]->mouse_in_text(mouseloc));
		}
	}

return(false);
}

// draw_window is called between BeginUpdate and EndUpdate to
// respond to an update event for the window.  
void WindowObject::draw_window(void)
{
RgnHandle saved_rgn;
short i;
GrafPtr gp;

GetPort(&gp);
SetPort(myWindow);

	// Draw any visible controls
DrawControls(myWindow);

	// draw backgound
SectRgn(backgroundRgn, myWindow->visRgn, workRgn);
if (!EmptyRgn(workRgn)) {
	draw_background(workRgn);
	}
	
	// just contents left if we have no scroll bars
if (!grow_window) {
	for (i = 0; i < view_count; i++) {
		draw_contents(myWindow->visRgn, view_list[i]);
		}
	}
	// handle scroll bar areas and grow icon, in addition to contents
else {
	for (i = 0; i < view_count; i++) {
		// draw scroll bar regions if necessary
		SectRgn(scroll_list[i].drawRgn, myWindow->visRgn, workRgn);
		if (!EmptyRgn(workRgn)) {
			saved_rgn = myWindow->visRgn;
			myWindow->visRgn = workRgn;
			draw_scroll_area(i);
			myWindow->visRgn = saved_rgn;
			}
		// draw contents if necessary
		if (RectInRgn(&content_list[i], myWindow->visRgn)) {
			// remove scroll bar from visRgn
			saved_rgn = myWindow->visRgn;
			CopyRgn(myWindow->visRgn, workRgn);
			DiffRgn(workRgn, scroll_list[i].drawRgn, workRgn);
			// draw content area only
			myWindow->visRgn = workRgn;
			draw_contents(myWindow->visRgn, view_list[i]);
			// restore original visRgn
			myWindow->visRgn = saved_rgn;
			}
		}
	// draw grow icon if necessary
	if (RectInRgn(&h_growRect, myWindow->visRgn) ||
		RectInRgn(&v_growRect, myWindow->visRgn)) {
		DrawGrowIcon(myWindow);
		}	
	}

SetPort(gp);
}

// draw the background (provided to allow sub-classes to override)
void WindowObject::draw_background(RgnHandle background_region)
{
EraseRgn(background_region);
}

// draw_contents draws the window-specific contents.  Drawing
// need only be done within "updateRegion".
void WindowObject::draw_contents(RgnHandle updateRegion,
								 ViewObject *theView)
{
theView->draw_contents(updateRegion);
}

// draw_scroll draws the bar areas.  Drawing
// need only be done within "updateRegion".
void WindowObject::draw_scroll_area(short idx)
{
if (scroll_list[idx].h_Handle == 0) {
	EraseRect(&scroll_list[idx].h_Rect);
	}
if (scroll_list[idx].v_Handle == 0) {
	EraseRect(&scroll_list[idx].v_Rect);
	}
}

void WindowObject::do_null_event(void)
{
// placeholder for specialized windows
}

Boolean WindowObject::do_click(Point where, EventRecord *theEvent)
{
short part_code;
ControlHandle theControl;
Boolean view_changed, click_handled;
short i, idx;
control_info *cptr;

// save pointer static click procs may need
current_WindowObject = this;

// handle certains controls
part_code = FindControl(where, myWindow, &theControl);
if (theControl != 0) {
	// Check for added controls
	if (control_list != 0) {
		cptr = (control_info *)(control_list->GetFirstPointer());
		while (cptr != 0) {
			if (theControl == cptr->handle) {
				do_added_control_click(cptr, where);
				return(true);
				}
			cptr = (control_info *)(control_list->GetNextPointer());
			}
		}

	// Check for our controls
	idx = GetControlReference(theControl);
	if (idx > 0) {
		return(do_control_click(where, part_code, theControl, idx - 1));
		}
	else {
		return(false);
		}
	}

// if not in control, find the view
idx = -1;
for (i = 0; i < view_count; i++) {
	if (PtInRect(where, &content_list[i])) {
		idx = i;
		break;
		}
	}
if (idx < 0) {
	return(false);
	}

// if in a content area, pass to view

// allow specific window type to interpret click
click_handled = handle_click_on_view(idx);
if (click_handled) {
	return(true);
	}

click_idx = idx;
view_changed = view_list[idx]->do_click(where, theEvent);
if (view_changed) {
	handle_view_changed(idx);
	}
return(true);
}

Boolean WindowObject::handle_click_on_view(short idx)
{
#pragma unused (idx)

return(false);
}

Boolean WindowObject::do_control_click(Point where, short part_code,
								 	   ControlHandle theControl, short idx)
{
short i;

// handle scroll bar clicks
for (i = 0; i < view_count; i++) {
	if ((theControl == scroll_list[idx].h_Handle) || 
		(theControl == scroll_list[idx].v_Handle)) {	
		do_scroll_click(where, part_code, theControl, idx);
		return(true);
		}
	}

// else return false
return(false);
} 

void WindowObject::do_scroll_click(Point where, short part_code,
							  ControlHandle theControl, short idx)
{
short old_value, new_value;

switch (part_code) {
	case kControlIndicatorPart:
		old_value = GetControlValue(theControl);
		TrackControl(theControl, where, 0);
		new_value = GetControlValue(theControl);
		if (new_value != old_value) {
			scroll_draw(new_value, theControl == scroll_list[idx].h_Handle, idx);
			}
		break;

	case kControlUpButtonPart:
	case kControlDownButtonPart:
	case kControlPageUpPart:
	case kControlPageDownPart:
							// setup so scrollProc can access objects
		click_idx = idx;
#if GENERATINGPOWERPC
		TrackControl(theControl, where, (ControlActionUPP)&my_scrollProcRD);
#else
		TrackControl(theControl, where, (ControlActionUPP)my_scrollProc);
#endif
		break;

	default:
		break;
	}
}

void WindowObject::deactivate_controls(void)
{
short i;
control_info *cptr;

controls_activated = false;

for (i = 0; i < view_count; i++) {
	if (scroll_list[i].h_Handle != 0) {
//		HiliteControl(scroll_list[i].h_Handle, 255);
		HideControl(scroll_list[i].h_Handle);
		}
	if (scroll_list[i].v_Handle != 0) {
//		HiliteControl(scroll_list[i].v_Handle, 255);
		HideControl(scroll_list[i].v_Handle);
		}
	view_list[i]->deactivate();
	}

if (grow_window) {
	DrawGrowIcon(myWindow);
	}

if (control_list != 0) {
	cptr = (control_info *)(control_list->GetFirstPointer());
	while (cptr != 0) {
		HiliteControl(cptr->handle, 255);
		cptr = (control_info *)(control_list->GetNextPointer());
		}
	}
}

void WindowObject::activate_controls(void)
{
short i;
control_info *cptr;

controls_activated = true;

for (i = 0; i < view_count; i++) {
	if (scroll_list[i].h_Handle != 0) {
//		HiliteControl(scroll_list[i].h_Handle, 0);
		ShowControl(scroll_list[i].h_Handle);
		}
	if (scroll_list[i].v_Handle != 0) {
//		HiliteControl(scroll_list[i].v_Handle, 0);
		ShowControl(scroll_list[i].v_Handle);
		}
	view_list[i]->activate();
	}

if (grow_window) {
	DrawGrowIcon(myWindow);
	}

if (control_list != 0) {
	cptr = (control_info *)(control_list->GetFirstPointer());
	while (cptr != 0) {
		HiliteControl(cptr->handle, cptr->hilite_value);
		cptr = (control_info *)(control_list->GetNextPointer());
		}
	}
}

void WindowObject::change_control_hilite(control_info *cptr, short new_value)
{
short current_value;

// ignore undefined control
if (cptr == 0) {
	return;
	}

// save value for activate
cptr->hilite_value = new_value;

// get current value
current_value = (*(cptr->handle))->contrlHilite;

// don't change if deactivated
if (current_value == 255) {
	return;
	}

// hilite with new value
if (current_value != new_value) {
	HiliteControl(cptr->handle, new_value);
	}
}

void WindowObject::save_cursor_state(void)
{
}

void WindowObject::restore_cursor_state(Boolean *app_TEActive, 
										Boolean *app_waitcursor,
										Boolean *app_ibeamcursor)
{
view_list[0]->set_cursor_state(app_TEActive, app_waitcursor,
							   app_ibeamcursor);
}

void WindowObject::save_menu_state(void)
{
}

void WindowObject::restore_menu_state(short *app_font_item, 
									  short *app_size_item,
									  short *app_style_bits)
{
*app_font_item = font_item;
*app_size_item = size_item;
*app_style_bits = style_bits;
}

void WindowObject::import_scrap(void)
{
short i;

for (i = 0; i < view_count; i++) {
	view_list[i]->import_scrap();
	}
}

void WindowObject::export_scrap(void)
{
view_list[last_copy_idx]->export_scrap();
}

void WindowObject::update_window_rects(Boolean autoScroll)
{
short i;
Rect r;
control_info *cptr;

		// as we define rects, we will delete them from
		// backgroundRgn
RectRgn(backgroundRgn, &myWindow->portRect);

		// define grow rects
if (grow_window) {
	h_growRect = myWindow->portRect;
	h_growRect.top = h_growRect.bottom - 15;
	v_growRect = myWindow->portRect;
	v_growRect.left = v_growRect.right - 15;
	r = h_growRect;
	r.left = r.right - 15;
	delete_rect_from_rgn(&r, backgroundRgn, workRgn);
	}
	
		// define scroll rects and drawRgn
for (i = 0; i < view_count; i++) {
	if (do_h_scroll_list[i]) {
		scroll_list[i].h_Rect.top = content_list[i].bottom;
		scroll_list[i].h_Rect.bottom  = scroll_list[i].h_Rect.top + 15;
		scroll_list[i].h_Rect.left = content_list[i].left;
		scroll_list[i].h_Rect.right = content_list[i].right;
		scroll_list[i].h_Rect.top  -= 1;
		scroll_list[i].h_Rect.bottom  += 1;
		delete_rect_from_rgn(&scroll_list[i].h_Rect, backgroundRgn, workRgn);
		scroll_list[i].h_Rect.top  += 1;
		scroll_list[i].h_Rect.bottom  -= 1;
		}
	else {
		scroll_list[i].h_Rect.top = 0;
		scroll_list[i].h_Rect.bottom  = 0;
		scroll_list[i].h_Rect.left = 0;
		scroll_list[i].h_Rect.right = 0;
		}

	if (do_v_scroll_list[i]) {
		scroll_list[i].v_Rect.top = content_list[i].top;
		scroll_list[i].v_Rect.bottom  = content_list[i].bottom;
		scroll_list[i].v_Rect.left = content_list[i].right;
		scroll_list[i].v_Rect.right = scroll_list[i].v_Rect.left + 15;
		scroll_list[i].v_Rect.top  -= 1;
		scroll_list[i].v_Rect.bottom  += 1;
		delete_rect_from_rgn(&scroll_list[i].v_Rect, backgroundRgn, workRgn);
		scroll_list[i].v_Rect.top  += 1;
		scroll_list[i].v_Rect.bottom  -= 1;
		}
	else {
		scroll_list[i].v_Rect.top = 0;
		scroll_list[i].v_Rect.bottom  = 0;
		scroll_list[i].v_Rect.left = 0;
		scroll_list[i].v_Rect.right = 0;
		}
	
	RectRgn(scroll_list[i].drawRgn, &scroll_list[i].h_Rect);
	RectRgn(workRgn, &scroll_list[i].v_Rect);
	UnionRgn(scroll_list[i].drawRgn, workRgn, scroll_list[i].drawRgn);
	
		// adjust rects for actual scroll bars
	if (do_h_scroll_list[i]) {
		scroll_list[i].h_Rect.top += 1;
			}
	if (do_v_scroll_list[i]) {
		scroll_list[i].v_Rect.left += 1;
		}

		// adjust scroll bars
	if ((scroll_list[i].h_Handle != 0) || (scroll_list[i].v_Handle != 0)) {
		adjust_scroll_bars(autoScroll, i);
		}

		// tell the view where it will be drawing now
	adjust_view_rect(i);
		// this is used when the view's contents change with the size
		// otherwise, should do nothing to avoid flickering
	view_list[i]->draw_for_new_view_size();


		// delete contents rect from background
	delete_rect_from_rgn(&content_list[i], backgroundRgn, workRgn);
	}

	// delete control rects from background
if (control_list != 0) {
	cptr = (control_info *)(control_list->GetFirstPointer());
	while (cptr != 0) {
		delete_rect_from_rgn(&(*(cptr->handle))->contrlRect, backgroundRgn,
							 workRgn);
		cptr = (control_info *)(control_list->GetNextPointer());
		}
	}
}

void WindowObject::adjust_scroll_bars(Boolean autoScroll, short idx)
{
Rect control_rect;

// change control size and location
if (scroll_list[idx].h_Handle != 0) {
	control_rect = scroll_list[idx].h_Rect;
	control_rect.top -= 1;
	control_rect.bottom += 1;		// control needs 16 pixels
	control_rect.left -= 1;
	control_rect.right += 1;
	HideControl(scroll_list[idx].h_Handle);
	MoveControl(scroll_list[idx].h_Handle, control_rect.left, control_rect.top);
	SizeControl(scroll_list[idx].h_Handle, control_rect.right - control_rect.left,
				control_rect.bottom - control_rect.top);
	}

if (scroll_list[idx].v_Handle != 0) {
	control_rect = scroll_list[idx].v_Rect;
	control_rect.left -= 1;
	control_rect.right += 1;		// control needs 16 pixels
	control_rect.top -= 1;
	control_rect.bottom += 1;
	HideControl(scroll_list[idx].v_Handle);
	MoveControl(scroll_list[idx].v_Handle, control_rect.left, control_rect.top);
	SizeControl(scroll_list[idx].v_Handle, control_rect.right - control_rect.left,
				control_rect.bottom - control_rect.top);
	}

// continue by adjusting control settings
adjust_scroll_settings(autoScroll, idx);
}

void WindowObject::adjust_all_scroll_settings(Boolean autoScroll)
{
short i;

for (i = 0; i < view_count; i++) {
	adjust_scroll_settings(autoScroll, i);
	}
}

void WindowObject::adjust_scroll_settings(Boolean autoScroll, short idx)
{
LongRect scroll_rect;
long content_width, content_height;
long white_space, adj;
long scroll_width, scroll_height;
long top_offset, left_offset;
ViewObject *theView;

theView = view_list[idx];

// adjust control settings
get_content_size(&content_height, &content_width, view_list[idx]);

if ((content_height == 0) && (content_width == 0)) {
	if (scroll_list[idx].h_Handle != 0) {
		if (controls_activated) {
			ShowControl(scroll_list[idx].h_Handle);
			}
		}
	if (scroll_list[idx].v_Handle != 0) {
		if (controls_activated) {
			ShowControl(scroll_list[idx].v_Handle);
			}
		}
	return;
	}

// calculate scroll rect
top_offset = content_list[idx].top;
left_offset = content_list[idx].left;

scroll_rect.top = scroll_list[idx].v_Offset * theView->v_unitsize + top_offset;
scroll_height = content_list[idx].bottom - content_list[idx].top - theView->v_offset;
scroll_height = (scroll_height / theView->v_unitsize) * theView->v_unitsize;
scroll_rect.bottom = scroll_rect.top + scroll_height;

scroll_rect.left = scroll_list[idx].h_Offset * theView->h_unitsize + left_offset;
scroll_width = content_list[idx].right - content_list[idx].left - theView->h_offset;
scroll_width = (scroll_width / theView->h_unitsize) * theView->h_unitsize;
scroll_rect.right = scroll_rect.left + scroll_width;

if (scroll_list[idx].h_Handle != 0) {
	// check if we can show more now
	if (autoScroll) {
		white_space = scroll_rect.right - left_offset - content_width;
		}
	else {
		white_space = 0;
		}
	if ((white_space > 0) && (scroll_rect.left - left_offset > 0)) {
		adj = scroll_rect.left - left_offset;
		if (adj > white_space) {
			adj = white_space;
			}		
		// convert adj to scroll units
		adj = adj / theView->h_unitsize;
		// update values for adj
		scroll_draw(scroll_list[idx].h_Offset - adj, true, idx);
		adjust_view_rect(idx);
		adj *= theView->h_unitsize;
		scroll_rect.left -= adj;
		scroll_rect.right -= adj;
		}

	// set new control values
	if ((scroll_rect.left - left_offset == 0) &&
		(scroll_rect.right - left_offset >= content_width)) {
		SetControlMaximum(scroll_list[idx].h_Handle, 0);
		}
	else {
		SetControlMaximum(scroll_list[idx].h_Handle,
			(content_width - scroll_rect.right + scroll_rect.left)
			 / theView->h_unitsize);
		SetControlValue(scroll_list[idx].h_Handle, (scroll_rect.left - left_offset)  /
																	theView->h_unitsize);
		}
	if (controls_activated) {
		ShowControl(scroll_list[idx].h_Handle);
		}
	}

if (scroll_list[idx].v_Handle != 0) {
	// check if we can show more now
	if (autoScroll) {
		white_space = scroll_rect.bottom - top_offset - content_height;
		}
	else {
		white_space = 0;
		}
	if ((white_space > 0) && (scroll_rect.top - top_offset > 0)) {
		adj = scroll_rect.top - top_offset;
		if (adj > white_space) {
			adj = white_space;
			}		
		// convert adj to scroll units
		adj = adj / theView->v_unitsize;
		// update values for adj
		scroll_draw(scroll_list[idx].v_Offset - adj, false, idx);
		adjust_view_rect(idx);
		adj *= theView->v_unitsize;
		scroll_rect.top -= adj;
		scroll_rect.bottom -= adj;
		}

	// set new control values
	if ((scroll_rect.top - top_offset == 0) &&
		(scroll_rect.bottom - top_offset >= content_height)) {
		SetControlMaximum(scroll_list[idx].v_Handle, 0);
		}
	else {
		SetControlMaximum(scroll_list[idx].v_Handle,
			(content_height - scroll_rect.bottom + scroll_rect.top)
			 / theView->v_unitsize);
		SetControlValue(scroll_list[idx].v_Handle, (scroll_rect.top - top_offset)
														 / theView->v_unitsize);
		}
	if (controls_activated) {
		ShowControl(scroll_list[idx].v_Handle);
		}
	}
}

void WindowObject::get_content_size(long *height, long *width,
									ViewObject *theView)
{
if (theView == 0) {
	*height = *width = 0;
	}
else {
	theView->get_view_size(height, width);
	}
}

void WindowObject::resize_scroll_draw(Boolean before_resize)
{
if (grow_window) {
	InvalRect(&h_growRect);
	InvalRect(&v_growRect);
	if (before_resize) {
		EraseRect(&h_growRect);
		EraseRect(&v_growRect);
		}
	}
}

void WindowObject::adjust_view_rect(short idx)
{
view_list[idx]->adjust_view_rect(&content_list[idx], scroll_list[idx].h_Offset,
								 scroll_list[idx].v_Offset, false, false);
}

void WindowObject::define_new_font(short app_font_item, short font_number)
{
short i;

font_item = app_font_item;
for (i = 0; i < view_count; i++) {
	view_list[i]->define_new_font(font_number);
	handle_style_changed(i);
	}
}

void WindowObject::define_new_pointsize(short app_size_item, short font_size)
{
short i;

size_item = app_size_item;
for (i = 0; i < view_count; i++) {
	view_list[i]->define_new_pointsize(font_size);
	handle_style_changed(i);
	}
}

void WindowObject::define_new_style(short app_style_bits, Style new_style)
{
short i;

style_bits = app_style_bits;
for (i = 0; i < view_count; i++) {
	view_list[i]->define_new_style(new_style);
	handle_style_changed(i);
	}
}

void WindowObject::do_TEFunction(short theFunction)
{
Boolean view_changed;

if ((theFunction == cut_function) || (theFunction == copy_function)) {
	last_copy_idx = TE_view;
	}
view_changed = view_list[TE_view]->do_TEFunction(theFunction);
if (view_changed) {
	handle_view_changed(TE_view);
	}
}

void WindowObject::get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
								  Boolean *paste_ok, Boolean *clear_ok)
{
view_list[TE_view]->get_edit_flags(cut_ok, copy_ok, paste_ok, clear_ok);
}

void WindowObject::get_undo_status(Boolean *undo_ok, char *undo_text)
{
view_list[TE_view]->get_undo_status(undo_ok, undo_text);
}

void WindowObject::do_key_down(EventRecord *theEvent)
{
Boolean view_changed;

view_changed = view_list[TE_view]->do_key_down(theEvent);
if (view_changed) {
	handle_view_changed(TE_view);
	}
}

void WindowObject::hide(void)
{
HideWindow(myWindow);
}

void WindowObject::show(void)
{
ShowWindow(myWindow);
SelectWindow(myWindow);
}

Boolean WindowObject::is_visible(void)
{
return(((WindowPeek)myWindow)->visible != 0);
}

OSErr WindowObject::TrackDrag(DragTrackingMessage theMessage,
							  DragReference theDrag)
{
current_WindowObject = this;
click_idx = Drag_view;
return(view_list[Drag_view]->TrackDrag(theMessage, theDrag));
}

OSErr WindowObject::ReceiveDrag(DragReference theDrag)
{
OSErr rc;

Boolean view_changed;
current_WindowObject = this;
click_idx = Drag_view;
rc = view_list[Drag_view]->ReceiveDrag(theDrag, &view_changed);
if (view_changed) {
	handle_view_changed(Drag_view);
	}
return(rc);
}

void WindowObject::handle_view_changed(short idx)
{
#ifdef MAC_GUI
// update our view
view_list[idx]->get_new_scroll_offsets(&scroll_list[idx].h_Offset,
									   &scroll_list[idx].v_Offset);
adjust_view_rect(idx);
// adjust scroll bars
adjust_scroll_settings(true, idx);
#endif
}

void WindowObject::handle_style_changed(short idx)
{
// update scroll offsets
view_list[idx]->get_new_scroll_offsets(&scroll_list[idx].h_Offset,
									   &scroll_list[idx].v_Offset);
// adjust scroll bars
adjust_scroll_settings(true, idx);
// redraw
EraseRect(&content_list[idx]);
InvalRect(&content_list[idx]);
}

void WindowObject::scroll_draw(short new_value, Boolean hScroll, short idx)
{
Boolean do_scroll;
short dh, dv;
RgnHandle saved_vis;
ViewObject *theView;

theView = view_list[idx];

// Given a new control value, calculate the scrollRect to use.
// scrollRect is computed so that drawing could be done by setting the
// window origin to the top left point of scrollRect, and drawing
// within the rect.  (This is not possible for views which use long
// coordinates, but scrollRect is still computed in the same way.)

scrollRect.left = scroll_list[idx].h_Offset
				  * theView->h_unitsize;
scrollRect.top = scroll_list[idx].v_Offset
				 * theView->v_unitsize;
adjust_scroll_rect(idx);

old_scrollRect = scrollRect;

if (hScroll) {
	scrollRect.left = new_value * theView->h_unitsize;
	scroll_list[idx].h_Offset = new_value;
	adjust_scroll_rect(idx);
	}
else {
	scrollRect.top = new_value * theView->v_unitsize;
	scroll_list[idx].v_Offset = new_value;
	adjust_scroll_rect(idx);
	}

// just return if the new scroll rect is the same as the old one

if ((old_scrollRect.top == scrollRect.top) &&
    (old_scrollRect.bottom == scrollRect.bottom) &&
    (old_scrollRect.left == scrollRect.left) &&
    (old_scrollRect.right == scrollRect.right)){
    	return;
	}

// update the view for the new scrollRect
// if we have a scroll proc, and we will scroll, we assume the scroll
// proc will handle this
do_scroll =
	longSectRect(&old_scrollRect, &scrollRect);

if (theView->useUpdateProc) {
	if (!theView->useScrollProc || !do_scroll) {
		theView->update_contents(scroll_list[idx].h_Offset,
								 scroll_list[idx].v_Offset);
		}
	}

// Use scrolling for the update if it applies

if (do_scroll) {
	// calculate distance to scroll
	// since the rects overlap and are the size of contentRect, the
	// scrolling distances must fit into shorts
	dv = (short)(old_scrollRect.top - scrollRect.top);
	dh = (short)(old_scrollRect.left- scrollRect.left);
	if (theView->useScrollProc) {
		theView->scroll_contents(dh, dv);
		adjust_view_rect(idx);
		return;		// assume proc handles all updating
		}
	// calculate rect for scroll rect: it contains that portion of
	// the window that includes the all the contents to be moved,
	// and the destination
	validRect.top = theView->v_offset + content_list[idx].top;
	validRect.left = theView->h_offset + content_list[idx].left;
	validRect.bottom = old_scrollRect.bottom 
						- old_scrollRect.top
						+ content_list[idx].top;
	validRect.right = old_scrollRect.right 
						- old_scrollRect.left
						+ content_list[idx].left;

	// do the scroll
	ScrollRect(&validRect, dh, dv, workRgn);

	// calculate the region that remains to be updated
			// get entire region in workRgn
	RectRgn(workRgn, &content_list[idx]);
			// get part that was written in workRgn2
	if (dh > 0) {
		validRect.left += dh;
		}
	else {
		validRect.right += dh;
		}
	if (dv > 0) {
		validRect.top += dv;
		}
	else {
		validRect.bottom += dv;
		}
	RectRgn(workRgn2, &validRect);
			// no need to redraw valid part
	ValidRgn(workRgn2);
			// result is entire region - written region
	DiffRgn(workRgn, workRgn2, workRgn);
	}
else {		// here we set the update region to the entire contentRect
	RectRgn(workRgn, &content_list[idx]);
	}

// redraw the update region
saved_vis = myWindow->visRgn;
myWindow->visRgn = workRgn;
theView->draw_contents(myWindow->visRgn);
myWindow->visRgn = saved_vis;
adjust_view_rect(idx);
}

void WindowObject::adjust_scroll_rect(short idx)
{
short new_units;
ViewObject *theView;

theView = view_list[idx];

scrollRect.top = (scrollRect.top / theView->v_unitsize)
					* theView->v_unitsize;
scrollRect.left = (scrollRect.left / theView->h_unitsize)
					* theView->h_unitsize;
scrollRect.bottom = scrollRect.top + content_list[idx].bottom
						- content_list[idx].top;
scrollRect.right = scrollRect.left + content_list[idx].right
						- content_list[idx].left;
new_units = (scrollRect.bottom - theView->v_offset
			- scrollRect.top) / theView->v_unitsize;
scrollRect.bottom = scrollRect.top + theView->v_offset +
			new_units * theView->v_unitsize;
new_units = (scrollRect.right - theView->h_offset
			- scrollRect.left) / theView->h_unitsize;
scrollRect.right = scrollRect.left + theView->h_offset +
			new_units * theView->h_unitsize;
}

void WindowObject::window_scrollProc(ControlHandle theControl,
									short partCode)
{
short scrollDistance, new_value;
Boolean changed;
static Rect clip_rect = {-32767, -32767, 32767, 32767};
RgnHandle savedRgn;
short idx;
ViewObject *theView;

idx = click_idx;
theView = view_list[idx];

switch (partCode) {
	case kControlUpButtonPart:
	case kControlDownButtonPart:
			if (theControl == scroll_list[idx].h_Handle) {
				scrollDistance = theView->h_scrollsize;
				}
			else {
				scrollDistance = theView->v_scrollsize;
				}
			break;
	case kControlPageUpPart:
	case kControlPageDownPart:
			if (theControl == scroll_list[idx].h_Handle) {
				scrollDistance = (content_list[idx].right -
								  content_list[idx].left)
							 	  / theView->h_unitsize;
				}
			else {
				scrollDistance = (content_list[idx].bottom -
								  content_list[idx].top)
							 	  / theView->v_unitsize;
				}
			scrollDistance -= 1;	// show last line or column
			break;
	default:
			return;
	}

// adjust sign for direction
if ((partCode == kControlDownButtonPart) || (partCode == kControlPageDownPart)) {
	scrollDistance = -scrollDistance;
	}
calc_scroll_value(theControl, scrollDistance, &new_value, &changed);
if (changed) {
	scroll_draw(new_value, theControl == scroll_list[idx].h_Handle, idx);
									// looks better to move control last
	RectRgn(workRgn3, &clip_rect);
	savedRgn = myWindow->clipRgn;
	myWindow->clipRgn = workRgn3;
	SetControlValue(theControl, new_value);
	myWindow->clipRgn = savedRgn;
	}
}

void WindowObject::calc_scroll_value(ControlHandle theControl, short scrollDistance,
				 short *new_value, Boolean *changed)
{
short old_setting, setting, max_setting;

old_setting = GetControlValue(theControl);
max_setting = GetControlMaximum(theControl);
setting = old_setting - scrollDistance;
if (setting < 0) {
	setting = 0;
	}
if (setting > max_setting) {
	setting = max_setting;
	}
*new_value = setting;
if (setting != old_setting) {
	*changed = true;
	}
else {
	*changed = false;
	}
}

// static click proc

pascal void WindowObject::my_scrollProc(ControlHandle theControl,
											short partCode)
{
current_WindowObject->window_scrollProc(theControl, partCode);
}
