// $Log: WEUtilities.c,v $
// Revision 1.1  1998/12/15 04:59:01  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *WEUtilities_c(void) {
return "@(#)$Id: WEUtilities.c,v 1.1 1998/12/15 04:59:01 dicamillo Exp $"; }
#endif

/*
 *	WEUtilities.c
 *
 *	WASTE PROJECT
 *  Miscellaneous General-Purpose Utilities
 *
 *  Copyright (c) 1993-1996 Marco Piovanelli
 *	All Rights Reserved
 *
 *  C port by Dan Crevier
 *
 */


#include "WASTEIntf.h"

pascal Boolean _WEBlockCmp(const void *block1, const void *block2, register Size blockSize)
{
	register const char *p1 = (const char *) block1;
	register const char *p2 = (const char *) block2;

	while ( --blockSize >= 0 )
		if ( *p1++ != *p2++ )
			return false;

	return true;
}

pascal void _WEBlockClr(void *block, register Size blockSize)
{
	register char *p = (char *) block;

	while ( --blockSize >= 0 )
		*p++ = 0;
}

pascal void _WEForgetHandle(Handle *h)
{
	Handle theHandle;

	if ((theHandle = *h) != nil)
	{
		*h = nil;
		DisposeHandle(theHandle);
	}
}

pascal Boolean _WESetHandleLock(Handle h, Boolean lock)
{
	Boolean oldLock = (HGetState(h) & (1 << 7)) != 0;

	if (lock != oldLock)
		if (lock)
			HLock(h);
		else
			HUnlock(h);

	return oldLock;
}

pascal void _WEReorder(SInt32 *a, SInt32 *b)
{
	if (*a > *b)
	{
		SInt32 temp = *a;
		*a = *b;
		*b = temp;
	}
}

pascal OSErr _WEAllocate(Size blockSize, UInt32 allocFlags, Handle *h)
{
	// Allocate a new relocatable block.
	// AllocFlags may specify whether the block should be cleared and whether
	// temporary memory should be used.

	Handle theHandle = nil;
	OSErr err;

	// if kAllocTemp is specified, try tapping temporary memory
	if (allocFlags & kAllocTemp)
	{
		theHandle = TempNewHandle(blockSize, &err);
	}

	// if kAllocTemp isn't specified, or TempNewHandle failed, try with current heap
	if (theHandle == nil)
	{
		theHandle = NewHandle(blockSize);
		err = MemError();
	}

	// if kAllocClear is specified, zero the block
	if ((allocFlags & kAllocClear) && (theHandle != nil))
	{
		_WEBlockClr(*theHandle, blockSize);
	}

	*h = theHandle;
	return err;
}
