// $Log: def.h,v $
// Revision 1.1  1998/12/15 05:48:08  dicamillo
// First Checked In.
//

/*----------------------------------------------------------------------------

	def.h

	This file contains reusable constant and type definitions.
	
	Copyright  1994-1995, Northwestern University.

----------------------------------------------------------------------------*/

#ifndef __DEF__
#define __DEF__


/* Macros */

#define isLWSP(a) ((a) == ' ' || (a) == '\t')
#define isLWSPorCR(a) (isLWSP(a) || (a) == CR)
#define isPrintable(a) ((a) >= ' ' && (a) != 0x7f)
#define isoctal(a) ((a) >= '0' && (a) <= '7')
#define isCRorLF(a) ((a) == CR || (a) == LF)



/* Constants. */

#define kMaxLong	0x7fffffff
#define kMaxShort	0x7fff

#define kFTPPort	21
#define kSMTPPort	25
#define kNNTPPort	119

#define CR			'\r'
#define LF			'\n'
#define BS			0x08
#define FF			0x0C
#define	CRSTR		"\r"
#define	LFSTR		"\n"
#define CRLF		"\r\n"
#define CRCR 		"\r\r"

#define homeKey				0x01		/* ascii code for home key */
#define enterKey			0x03		/* ascii code for enter key */
#define endKey				0x04		/* ascii code for end key */
#define helpKey				0x05		/* ascii code for help key */
#define deleteKey			0x08		/* ascii code for delete/backspace */
#define tabKey				0x09		/* ascii code for tab key */
#define pageUpKey			0x0B		/* ascii code for page up key */
#define pageDownKey			0x0C		/* ascii code for page down key */
#define returnKey			0x0D		/* ascii code for return key */
#define leftArrow			0x1C		/* ascii code for left arrow key */
#define rightArrow			0x1D		/* ascii code for right arrow key */
#define upArrow				0x1E		/* ascii code for up arrow key */
#define downArrow			0x1F		/* ascii code for down arrow key */
#define forwardDelKey		0x7F		/* ascii code for forward delete key */

#define escapeKeyCode		0x35		/* key code for escape key */
#define clearKeyCode		0x47		/* key code for clear key */

#define kScrollToHome		24			/* pseudo part code for scrolling to home */
#define kScrollToEnd		25			/* pseudo part code for scrolling to end */



/* Types. */

typedef char CStr255[256];		/* like Str255, except for C-format strings. */



/* This is the private data for a popup menu control using CDEF 63.
   It's documented in IM6:Compatibility, and in NIM:Toolbox Essentials. */
   
typedef struct {
	MenuHandle mHandle;		/* Handle to menu */
	short mID;				/* Menu ID */
	char mPrivate;			/* Private data of varying length */
} popupPrivateData;

#endif
